/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.item;

import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.research.ResearchNode;
import com.hexvane.strangematter.research.ResearchNodeRegistry;
import com.hexvane.strangematter.research.ResearchType;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ResearchNoteItem
extends Item {
    public ResearchNoteItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("research_id")) {
            String researchId = tag.m_128461_("research_id");
            ResearchNode node = ResearchNodeRegistry.getNode(researchId);
            if (node != null) {
                tooltip.add((Component)node.getDisplayName().m_6881_().m_130938_(style -> style.m_178520_(65280)));
            } else {
                tooltip.add((Component)Component.m_237110_((String)"item.strangematter.research_note.for_research", (Object[])new Object[]{researchId}));
            }
        }
        super.m_7373_(stack, level, tooltip, flag);
    }

    public static ItemStack createResearchNote(Map<ResearchType, Integer> researchCosts, String researchId) {
        ItemStack stack = new ItemStack((ItemLike)StrangeMatterMod.RESEARCH_NOTES.get());
        CompoundTag tag = stack.m_41784_();
        ListTag typesList = new ListTag();
        for (ResearchType type : researchCosts.keySet()) {
            typesList.add((Object)StringTag.m_129297_((String)type.name()));
        }
        tag.m_128365_("research_types", (Tag)typesList);
        CompoundTag costsTag = new CompoundTag();
        for (Map.Entry<ResearchType, Integer> entry : researchCosts.entrySet()) {
            costsTag.m_128405_(entry.getKey().name(), entry.getValue().intValue());
        }
        tag.m_128365_("research_costs", (Tag)costsTag);
        tag.m_128359_("research_id", researchId);
        return stack;
    }

    public static Set<ResearchType> getResearchTypes(ItemStack stack) {
        HashSet<ResearchType> types = new HashSet<ResearchType>();
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("research_types")) {
            ListTag typesList = tag.m_128437_("research_types", 8);
            for (Tag typeTag : typesList) {
                types.add(ResearchType.valueOf(typeTag.m_7916_()));
            }
        }
        return types;
    }

    public static String getResearchId(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("research_id")) {
            return tag.m_128461_("research_id");
        }
        return "";
    }

    public static boolean isValidResearchNote(ItemStack stack) {
        if (!(stack.m_41720_() instanceof ResearchNoteItem)) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_("research_types") && tag.m_128441_("research_costs") && tag.m_128441_("research_id");
    }
}

