/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.item;

import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.entity.HoverboardEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HoverboardItem
extends Item {
    private static final float PARTIAL_TICK = 1.0f;
    private static final int REQUIRED_CLEAR_SPACE = 2;

    public HoverboardItem() {
        super(new Item.Properties());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        BlockState targetBlock;
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        double reachDistance = player.getBlockReach();
        HitResult hitResult = player.m_19907_(reachDistance, 1.0f, false);
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            this.sendErrorMessage(player, "No suitable surface found within reach");
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        BlockHitResult blockHit = (BlockHitResult)hitResult;
        if (blockHit.m_82450_().m_82554_(player.m_20182_()) > reachDistance) {
            this.sendErrorMessage(player, "Target surface is too far away");
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        BlockPos targetPos = blockHit.m_82425_();
        if (!this.isValidSupportBlock(level, targetPos, targetBlock = level.m_8055_(targetPos))) {
            this.sendErrorMessage(player, "Cannot deploy hoverboard on " + this.getBlockName(targetBlock) + " - surface not solid enough");
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!this.hasClearSpaceAbove(level, targetPos)) {
            this.sendErrorMessage(player, "Not enough space above the surface to deploy hoverboard");
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        Vec3 placementPos = new Vec3((double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 1.0, (double)targetPos.m_123343_() + 0.5);
        this.spawnHoverboard(level, placementPos, player);
        level.m_6263_(null, placementPos.f_82479_, placementPos.f_82480_, placementPos.f_82481_, SoundEvents.f_11796_, SoundSource.PLAYERS, 0.8f, 1.4f);
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    private boolean isValidSupportBlock(Level level, BlockPos pos, BlockState blockState) {
        if (blockState.m_60795_()) {
            return false;
        }
        VoxelShape shape = blockState.m_60812_((BlockGetter)level, pos);
        return !shape.m_83281_() && !shape.equals(Shapes.m_83040_());
    }

    private boolean hasClearSpaceAbove(Level level, BlockPos supportBlock) {
        for (int i = 1; i <= 2; ++i) {
            BlockPos checkPos = supportBlock.m_6630_(i);
            BlockState checkState = level.m_8055_(checkPos);
            if (checkState.m_60795_() || checkState.m_247087_()) continue;
            return false;
        }
        return true;
    }

    private void spawnHoverboard(Level level, Vec3 position, Player player) {
        HoverboardEntity hoverboard = new HoverboardEntity((EntityType)StrangeMatterMod.HOVERBOARD_ENTITY.get(), level);
        double spawnX = position.f_82479_;
        double spawnY = position.f_82480_ + 0.1;
        double spawnZ = position.f_82481_;
        hoverboard.m_7678_(spawnX, spawnY, spawnZ, player.m_146908_(), 0.0f);
        level.m_7967_((Entity)hoverboard);
    }

    private void sendSuccessMessage(Player player, String message) {
        player.m_5661_((Component)Component.m_237113_((String)("\u00a7a" + message)), true);
    }

    private void sendErrorMessage(Player player, String message) {
        player.m_5661_((Component)Component.m_237113_((String)("\u00a7c" + message)), true);
    }

    private String getBlockName(BlockState blockState) {
        return blockState.m_60734_().m_49954_().getString();
    }
}

