/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.item;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.client.GravitonHammerRenderer;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class GravitonHammerItem
extends Item {
    private static final String CHARGING_TAG = "charging";
    private static final String CHARGE_LEVEL_TAG = "charge_level";
    private static final String CHARGE_TIME_TAG = "charge_time";
    private static final ThreadLocal<Boolean> INTERNAL_MINING = ThreadLocal.withInitial(() -> false);

    private static int getChargeLevel1Time() {
        return Config.gravitonHammerChargeLevel1Time;
    }

    private static int getChargeLevel2Time() {
        return Config.gravitonHammerChargeLevel2Time;
    }

    private static int getChargeLevel3Time() {
        return Config.gravitonHammerChargeLevel3Time;
    }

    private static int getTunnelDepthLevel1() {
        return Config.gravitonHammerTunnelDepthLevel1;
    }

    private static int getTunnelDepthLevel2() {
        return Config.gravitonHammerTunnelDepthLevel2;
    }

    private static int getTunnelDepthLevel3() {
        return Config.gravitonHammerTunnelDepthLevel3;
    }

    public GravitonHammerItem() {
        super(new Item.Properties().m_41487_(1).m_41503_(0));
    }

    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.isCharging(stack)) {
            this.startCharging(stack);
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_5929_(@Nonnull Level level, @Nonnull LivingEntity livingEntity, @Nonnull ItemStack stack, int remainingUseDuration) {
        if (level.f_46443_ || !(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!this.isCharging(stack)) {
            return;
        }
        int chargeTime = this.getChargeTime(stack);
        this.setChargeTime(stack, ++chargeTime);
        int previousLevel = this.getChargeLevel(stack);
        int newLevel = this.calculateChargeLevel(chargeTime);
        if (newLevel > previousLevel) {
            this.setChargeLevel(stack, newLevel);
            this.playChargeLevelSound(level, player, newLevel);
        }
    }

    public void m_5551_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull LivingEntity livingEntity, int timeCharged) {
        if (level.f_46443_ || !(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (this.isCharging(stack)) {
            int chargeLevel = this.getChargeLevel(stack);
            if (chargeLevel > 0) {
                this.performTunnelMining(level, player, stack, chargeLevel);
            }
            this.stopCharging(stack);
        }
    }

    public int m_8105_(@Nonnull ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(@Nonnull ItemStack stack) {
        return UseAnim.NONE;
    }

    public boolean m_6777_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player) {
        return !player.m_7500_();
    }

    public boolean m_6813_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity miningEntity) {
        if (!level.f_46443_ && miningEntity instanceof Player) {
            Player player = (Player)miningEntity;
            if (Boolean.TRUE.equals(INTERNAL_MINING.get())) {
                return true;
            }
            if (!player.m_6047_()) {
                this.performAreaMining(level, player, pos, state);
            }
        }
        return true;
    }

    public float m_8102_(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        return 6.0f;
    }

    public boolean m_8096_(@Nonnull BlockState block) {
        return block.m_60834_();
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(@Nonnull ItemStack stack) {
        return false;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltipComponents, @Nonnull TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237113_((String)"\u00a77Left click: 3x3 area mining"));
        tooltipComponents.add((Component)Component.m_237113_((String)"\u00a77Left click + Crouch: Single block mining"));
        tooltipComponents.add((Component)Component.m_237113_((String)"\u00a77Right click hold: Charged tunnel mining"));
    }

    private void startCharging(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_(CHARGING_TAG, true);
        tag.m_128405_(CHARGE_LEVEL_TAG, 0);
        tag.m_128405_(CHARGE_TIME_TAG, 0);
    }

    private void stopCharging(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            tag.m_128379_(CHARGING_TAG, false);
            tag.m_128405_(CHARGE_LEVEL_TAG, 0);
            tag.m_128405_(CHARGE_TIME_TAG, 0);
        }
    }

    private boolean isCharging(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_(CHARGING_TAG);
    }

    private int getChargeLevel(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_(CHARGE_LEVEL_TAG) : 0;
    }

    private void setChargeLevel(ItemStack stack, int level) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(CHARGE_LEVEL_TAG, level);
    }

    private int getChargeTime(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_(CHARGE_TIME_TAG) : 0;
    }

    private void setChargeTime(ItemStack stack, int time) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(CHARGE_TIME_TAG, time);
    }

    private int calculateChargeLevel(int chargeTime) {
        if (chargeTime >= GravitonHammerItem.getChargeLevel3Time()) {
            return 3;
        }
        if (chargeTime >= GravitonHammerItem.getChargeLevel2Time()) {
            return 2;
        }
        if (chargeTime >= GravitonHammerItem.getChargeLevel1Time()) {
            return 1;
        }
        return 0;
    }

    private void playChargeLevelSound(Level level, Player player, int chargeLevel) {
        switch (chargeLevel) {
            case 1: {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)StrangeMatterSounds.GRAVITON_CHARGEUP.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
                break;
            }
            case 2: {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)StrangeMatterSounds.GRAVITON_CHARGEUP.get(), SoundSource.PLAYERS, 0.7f, 1.2f);
                break;
            }
            case 3: {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)StrangeMatterSounds.GRAVITON_CHARGEUP.get(), SoundSource.PLAYERS, 1.0f, 1.5f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performAreaMining(Level level, Player player, BlockPos centerPos, BlockState centerState) {
        if (level.f_46443_) {
            return;
        }
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        HitResult hitResult = player.m_19907_(5.0, 0.0f, false);
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult blockHit = (BlockHitResult)hitResult;
        Direction face = blockHit.m_82434_();
        List<BlockPos> blocksToMine = this.getAreaMiningPositions(centerPos, face);
        boolean brokeAny = false;
        INTERNAL_MINING.set(true);
        try {
            for (BlockPos pos : blocksToMine) {
                BlockState state = level.m_8055_(pos);
                if (state.m_60795_()) continue;
                if (!this.canAttemptBreak(state, level, pos, player)) {
                    break;
                }
                boolean broke = serverPlayer.f_8941_.m_9280_(pos);
                if (!broke) {
                    break;
                }
                brokeAny = true;
            }
        }
        finally {
            INTERNAL_MINING.set(false);
        }
        if (brokeAny) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12442_, SoundSource.PLAYERS, 0.35f, 1.0f);
        }
    }

    private void performTunnelMining(Level level, Player player, ItemStack stack, int chargeLevel) {
        if (level.f_46443_) {
            return;
        }
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        HitResult hitResult = player.m_19907_(5.0, 0.0f, false);
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            Direction face = player.m_6350_();
            BlockPos startPos = player.m_20183_().m_121945_(face);
            this.performSimpleTunnelMining(level, serverPlayer, startPos, face, chargeLevel);
            return;
        }
        BlockHitResult blockHit = (BlockHitResult)hitResult;
        Direction face = blockHit.m_82434_();
        BlockPos hitBlockPos = blockHit.m_82425_();
        Direction tunnelDirection = face.m_122424_();
        BlockPos startPos = hitBlockPos;
        this.performSimpleTunnelMining(level, serverPlayer, startPos, tunnelDirection, chargeLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSimpleTunnelMining(Level level, ServerPlayer player, BlockPos startPos, Direction face, int chargeLevel) {
        int tunnelDepth = this.getTunnelDepth(chargeLevel);
        boolean brokeAny = false;
        INTERNAL_MINING.set(true);
        try {
            for (int i = 0; i < tunnelDepth; ++i) {
                BlockPos layerOrigin = startPos.m_5484_(face, i);
                List<BlockPos> layerPositions = this.getTunnelLayerPositions(layerOrigin, face.m_122434_());
                for (BlockPos pos : layerPositions) {
                    BlockState state = level.m_8055_(pos);
                    if (state.m_60795_()) continue;
                    if (!this.canAttemptBreak(state, level, pos, (Player)player)) {
                        return;
                    }
                    boolean broke = player.f_8941_.m_9280_(pos);
                    if (!broke) {
                        return;
                    }
                    brokeAny = true;
                }
            }
        }
        finally {
            INTERNAL_MINING.set(false);
        }
        if (brokeAny) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)StrangeMatterSounds.GRAVITON_CHARGEUP.get(), SoundSource.PLAYERS, 1.0f, 0.8f);
        }
    }

    private List<BlockPos> getAreaMiningPositions(BlockPos center, Direction face) {
        ArrayList<BlockPos> positions;
        block7: {
            Direction.Axis axis;
            block8: {
                block6: {
                    positions = new ArrayList<BlockPos>();
                    if (face != Direction.UP && face != Direction.DOWN) break block6;
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            positions.add(center.m_7918_(x, 0, z));
                        }
                    }
                    break block7;
                }
                axis = face.m_122434_();
                if (axis != Direction.Axis.X) break block8;
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        positions.add(center.m_7918_(0, y, z));
                    }
                }
                break block7;
            }
            if (axis != Direction.Axis.Z) break block7;
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    positions.add(center.m_7918_(x, y, 0));
                }
            }
        }
        return positions;
    }

    private int getTunnelDepth(int chargeLevel) {
        switch (chargeLevel) {
            case 1: {
                return GravitonHammerItem.getTunnelDepthLevel1();
            }
            case 2: {
                return GravitonHammerItem.getTunnelDepthLevel2();
            }
            case 3: {
                return GravitonHammerItem.getTunnelDepthLevel3();
            }
        }
        return 0;
    }

    private boolean canAttemptBreak(BlockState state, Level level, BlockPos pos, Player player) {
        if (state.m_60795_()) {
            return false;
        }
        float destroySpeed = state.m_60800_((BlockGetter)level, pos);
        if (destroySpeed < 0.0f) {
            return false;
        }
        if (!level.m_7966_(player, pos)) {
            return false;
        }
        return !state.m_60834_() || state.m_204336_(BlockTags.f_144282_);
    }

    private List<BlockPos> getTunnelLayerPositions(BlockPos origin, Direction.Axis axis) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>(9);
        if (axis == Direction.Axis.X) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    positions.add(origin.m_7918_(0, y, z));
                }
            }
        } else if (axis == Direction.Axis.Y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    positions.add(origin.m_7918_(x, 0, z));
                }
            }
        } else {
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    positions.add(origin.m_7918_(x, y, 0));
                }
            }
        }
        return positions;
    }

    public void initializeClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new GravitonHammerRenderer());
    }
}

