/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.item;

import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.client.FieldScannerRenderer;
import com.hexvane.strangematter.entity.BaseAnomalyEntity;
import com.hexvane.strangematter.network.NetworkHandler;
import com.hexvane.strangematter.network.ResearchGainPacket;
import com.hexvane.strangematter.research.ResearchData;
import com.hexvane.strangematter.research.ResearchType;
import com.hexvane.strangematter.research.ScannableObject;
import com.hexvane.strangematter.research.ScannableObjectRegistry;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.network.PacketDistributor;

public class FieldScannerItem
extends Item {
    private static final int SCAN_DURATION = 40;
    private static final String SCANNING_TAG = "scanning";
    private static final String SCAN_TARGET_TAG = "scan_target";
    private static final String SCAN_PROGRESS_TAG = "scan_progress";
    private static final String SCAN_ENTITY_TAG = "scan_entity";

    public FieldScannerItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new FieldScannerRenderer());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        this.validateAndCleanScanningState(stack);
        if (this.isScanning(stack)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void onInteractWithEntity(ItemStack stack, Player player, Entity entity, InteractionHand hand) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        this.validateAndCleanScanningState(stack);
        if (ScannableObjectRegistry.isEntityScannable(entity)) {
            BaseAnomalyEntity anomaly;
            if (entity instanceof BaseAnomalyEntity && (anomaly = (BaseAnomalyEntity)entity).isSpawnedFromCapsule()) {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7cThis anomaly was spawned from a containment capsule and cannot be scanned for research."));
                return;
            }
            Optional<ScannableObject> scannable = ScannableObjectRegistry.getScannableForEntity(entity);
            if (scannable.isPresent()) {
                String objectId = scannable.get().generateObjectId(entity);
                ResearchData researchData = ResearchData.get(player);
                if (!researchData.hasScanned(objectId)) {
                    if (!this.isScanning(stack)) {
                        this.startScanning(stack, objectId, scannable.get(), entity);
                        player.m_213846_((Component)Component.m_237113_((String)("\u00a7eScanning " + entity.m_5446_().getString() + "...")));
                        player.m_6672_(hand);
                    }
                } else if (!this.isScanning(stack) && !this.isOnCooldown(stack)) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7cThis anomaly has already been scanned."));
                    this.setCooldown(stack, 1000L);
                }
            }
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7cNo research data available from this entity."));
        }
    }

    public void onInteractWithBlock(ItemStack stack, Player player, BlockPos pos, BlockState blockState, ScannableObject scannable, InteractionHand hand) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        this.validateAndCleanScanningState(stack);
        String objectId = scannable.generateObjectId(pos);
        ResearchData researchData = ResearchData.get(player);
        if (!researchData.hasScanned(objectId)) {
            if (!this.isScanning(stack)) {
                this.startScanning(stack, objectId, scannable);
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7eScanning " + blockState.m_60734_().m_49954_().getString() + "...")));
                player.m_6672_(hand);
            }
        } else if (!this.isScanning(stack) && !this.isOnCooldown(stack)) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7cThis anomaly has already been scanned."));
            this.setCooldown(stack, 1000L);
        }
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (level.f_46443_ || !(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!this.isScanning(stack) || !this.isValidScanningState(stack)) {
            this.stopScanning(stack);
            return;
        }
        int progress = this.getScanProgress(stack);
        this.setScanProgress(stack, ++progress);
        if (progress % 10 == 0) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)StrangeMatterSounds.FIELD_SCANNER_SCAN.get(), SoundSource.PLAYERS, 0.3f, 1.2f);
        }
        if (progress >= 40) {
            this.completeScan(level, player, stack);
            player.m_5810_();
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        if (level.f_46443_ || !(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (this.isScanning(stack)) {
            this.stopScanning(stack);
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7cScan cancelled."));
        } else {
            this.validateAndCleanScanningState(stack);
        }
    }

    public int m_8105_(ItemStack stack) {
        return this.isScanning(stack) ? 40 : 0;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        if (!oldStack.equals(newStack) && this.isScanning(newStack) && !this.isValidScanningState(newStack)) {
            this.stopScanning(newStack);
            return false;
        }
        return this.isScanning(oldStack) && this.isScanning(newStack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return this.isScanning(stack) ? UseAnim.SPYGLASS : UseAnim.NONE;
    }

    private void startScanning(ItemStack stack, String objectId, ScannableObject scannable) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_(SCANNING_TAG, true);
        tag.m_128359_(SCAN_TARGET_TAG, objectId);
        tag.m_128359_("scan_type", scannable.getResearchType().getName());
        tag.m_128405_("scan_amount", scannable.getResearchAmount());
        tag.m_128405_(SCAN_PROGRESS_TAG, 0);
    }

    private void startScanning(ItemStack stack, String objectId, ScannableObject scannable, Entity entity) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_(SCANNING_TAG, true);
        tag.m_128359_(SCAN_TARGET_TAG, objectId);
        tag.m_128359_("scan_type", scannable.getResearchType().getName());
        tag.m_128405_("scan_amount", scannable.getResearchAmount());
        tag.m_128405_(SCAN_PROGRESS_TAG, 0);
        tag.m_128359_(SCAN_ENTITY_TAG, entity.m_6095_().toString());
    }

    private void stopScanning(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_(SCANNING_TAG, false);
        tag.m_128473_(SCAN_TARGET_TAG);
        tag.m_128473_("scan_type");
        tag.m_128473_("scan_amount");
        tag.m_128473_(SCAN_PROGRESS_TAG);
        tag.m_128473_(SCAN_ENTITY_TAG);
        tag.m_128356_("scan_cooldown", System.currentTimeMillis() + 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeScan(Level level, Player player, ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            this.stopScanning(stack);
            return;
        }
        try {
            String objectId = tag.m_128461_(SCAN_TARGET_TAG);
            ResearchType researchType = ResearchType.fromName(tag.m_128461_("scan_type"));
            int amount = tag.m_128451_("scan_amount");
            if (researchType != null && !objectId.isEmpty()) {
                ResearchData researchData = ResearchData.get(player);
                researchData.addResearchPoints(researchType, amount);
                researchData.markAsScanned(objectId);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    researchData.syncToClient(serverPlayer);
                    NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ResearchGainPacket(researchType, amount));
                    String entityType = tag.m_128461_(SCAN_ENTITY_TAG);
                    if (!entityType.isEmpty()) {
                        level.m_45976_(Entity.class, player.m_20191_().m_82400_(10.0)).stream().filter(entity -> entity.m_6095_().toString().equals(entityType)).findFirst().ifPresent(entity -> StrangeMatterMod.SCAN_ANOMALY_TRIGGER.trigger(serverPlayer, (Entity)entity));
                    }
                }
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.5f);
            }
        }
        catch (Exception e) {
            StrangeMatterMod.LOGGER.error("Error completing scan: ", (Throwable)e);
        }
        finally {
            this.stopScanning(stack);
        }
    }

    public boolean isScanning(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return false;
        }
        boolean scanning = tag.m_128471_(SCANNING_TAG);
        if (scanning && !this.isValidScanningState(stack)) {
            this.stopScanning(stack);
            return false;
        }
        return scanning;
    }

    private boolean isValidScanningState(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return false;
        }
        if (!tag.m_128441_(SCAN_TARGET_TAG) || tag.m_128461_(SCAN_TARGET_TAG).isEmpty()) {
            return false;
        }
        if (!tag.m_128441_("scan_type") || tag.m_128461_("scan_type").isEmpty()) {
            return false;
        }
        if (!tag.m_128441_("scan_amount")) {
            return false;
        }
        return tag.m_128441_(SCAN_PROGRESS_TAG);
    }

    private void validateAndCleanScanningState(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        if (tag.m_128471_(SCANNING_TAG)) {
            if (!this.isValidScanningState(stack)) {
                this.stopScanning(stack);
            }
        } else if (tag.m_128441_(SCAN_TARGET_TAG) || tag.m_128441_("scan_type") || tag.m_128441_("scan_amount") || tag.m_128441_(SCAN_PROGRESS_TAG) || tag.m_128441_(SCAN_ENTITY_TAG)) {
            tag.m_128473_(SCAN_TARGET_TAG);
            tag.m_128473_("scan_type");
            tag.m_128473_("scan_amount");
            tag.m_128473_(SCAN_PROGRESS_TAG);
            tag.m_128473_(SCAN_ENTITY_TAG);
        }
    }

    public boolean isOnCooldown(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return false;
        }
        long cooldown = tag.m_128454_("scan_cooldown");
        return System.currentTimeMillis() < cooldown;
    }

    private void setCooldown(ItemStack stack, long durationMs) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128356_("scan_cooldown", System.currentTimeMillis() + durationMs);
    }

    private int getScanProgress(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_(SCAN_PROGRESS_TAG) : 0;
    }

    private void setScanProgress(ItemStack stack, int progress) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(SCAN_PROGRESS_TAG, progress);
    }
}

