/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.item;

import com.hexvane.strangematter.client.PlayerMorphRenderer;
import com.hexvane.strangematter.morph.PlayerMorphData;
import com.hexvane.strangematter.network.NetworkHandler;
import com.hexvane.strangematter.network.PlayerMorphSyncPacket;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class EchoformImprinterItem
extends Item {
    private static final int SCAN_DURATION = 20;
    private static final String SCANNING_TAG = "scanning";
    private static final String SCAN_TARGET_TAG = "scan_target";
    private static final String SCAN_PROGRESS_TAG = "scan_progress";
    private static final String MORPHED_ENTITY_TAG = "morphed_entity";
    private static final String MORPHED_TAG = "is_morphed";
    private static final double SCAN_RANGE = 5.0;

    public EchoformImprinterItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.isScanning(stack)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (player.m_6144_()) {
            if (this.isMorphed(stack)) {
                this.morphBack(level, player, stack);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            if (!level.f_46443_) {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7cYou are not currently morphed."));
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!level.f_46443_) {
            Mob targetMob;
            Player targetPlayer;
            Vec3 playerPos = player.m_20182_();
            AABB searchBox = new AABB(playerPos.f_82479_ - 5.0, playerPos.f_82480_ - 5.0, playerPos.f_82481_ - 5.0, playerPos.f_82479_ + 5.0, playerPos.f_82480_ + 5.0, playerPos.f_82481_ + 5.0);
            List nearbyPlayers = level.m_6443_(Player.class, searchBox, otherPlayer -> otherPlayer != player && otherPlayer.m_6084_() && player.m_142582_((Entity)otherPlayer));
            if (!nearbyPlayers.isEmpty() && (targetPlayer = this.getTargetPlayer(player, nearbyPlayers)) != null) {
                this.startScanningPlayer(stack, targetPlayer, player);
                player.m_6672_(hand);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            List nearbyMobs = level.m_6443_(Mob.class, searchBox, mob -> mob.m_6084_() && player.m_142582_((Entity)mob));
            if (!nearbyMobs.isEmpty() && (targetMob = this.getTargetMob(player, nearbyMobs)) != null) {
                this.startScanning(stack, targetMob, player);
                player.m_6672_(hand);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7cNo valid target in range to scan."));
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private Mob getTargetMob(Player player, List<Mob> mobs) {
        Vec3 lookVec = player.m_20154_();
        Vec3 playerEye = player.m_146892_();
        Mob closestMob = null;
        double closestDot = 0.85;
        for (Mob mob : mobs) {
            Vec3 toMob = mob.m_20182_().m_82546_(playerEye).m_82541_();
            double dot = lookVec.m_82526_(toMob);
            if (!(dot > closestDot)) continue;
            closestDot = dot;
            closestMob = mob;
        }
        return closestMob;
    }

    private Player getTargetPlayer(Player player, List<Player> players) {
        Vec3 lookVec = player.m_20154_();
        Vec3 playerEye = player.m_146892_();
        Player closestPlayer = null;
        double closestDot = 0.85;
        for (Player targetPlayer : players) {
            Vec3 toPlayer = targetPlayer.m_20182_().m_82546_(playerEye).m_82541_();
            double dot = lookVec.m_82526_(toPlayer);
            if (!(dot > closestDot)) continue;
            closestDot = dot;
            closestPlayer = targetPlayer;
        }
        return closestPlayer;
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        Entity target;
        UUID targetUUID;
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!this.isScanning(stack)) {
            return;
        }
        int progress = this.getScanProgress(stack);
        this.setScanProgress(stack, ++progress);
        if (progress % 5 == 0) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)StrangeMatterSounds.FIELD_SCANNER_SCAN.get(), SoundSource.PLAYERS, 0.4f, 1.4f);
        }
        if (level.f_46443_ && (targetUUID = this.getTargetUUID(stack)) != null && (target = this.findEntityByUUID(level, targetUUID)) != null) {
            this.spawnScanParticles(level, player, target);
        }
        if (progress >= 20) {
            if (!level.f_46443_) {
                this.completeScan(level, player, stack);
            }
            player.m_5810_();
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        if (level.f_46443_ || !(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (this.isScanning(stack)) {
            this.stopScanning(stack);
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7cScan cancelled."));
        }
    }

    public int m_8105_(ItemStack stack) {
        return this.isScanning(stack) ? 20 : 0;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return this.isScanning(stack) ? UseAnim.BOW : UseAnim.NONE;
    }

    private void startScanning(ItemStack stack, Mob target, Player player) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128473_(MORPHED_ENTITY_TAG);
        tag.m_128473_("target_type");
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_());
        String entityTypeString = entityId != null ? entityId.toString() : target.m_6095_().toString();
        tag.m_128379_(SCANNING_TAG, true);
        tag.m_128362_(SCAN_TARGET_TAG, target.m_20148_());
        tag.m_128359_("target_type", entityTypeString);
        tag.m_128405_(SCAN_PROGRESS_TAG, 0);
        player.m_213846_((Component)Component.m_237113_((String)("\u00a7eScanning " + target.m_5446_().getString() + "...")));
    }

    private void startScanningPlayer(ItemStack stack, Player target, Player player) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128473_(MORPHED_ENTITY_TAG);
        tag.m_128473_("target_type");
        tag.m_128473_("target_player_uuid");
        tag.m_128473_("target_player_name");
        String entityTypeString = "minecraft:player";
        tag.m_128379_(SCANNING_TAG, true);
        tag.m_128362_(SCAN_TARGET_TAG, target.m_20148_());
        tag.m_128359_("target_type", entityTypeString);
        tag.m_128362_("target_player_uuid", target.m_20148_());
        tag.m_128359_("target_player_name", target.m_7755_().getString());
        tag.m_128405_(SCAN_PROGRESS_TAG, 0);
        player.m_213846_((Component)Component.m_237113_((String)("\u00a7eScanning " + target.m_7755_().getString() + "...")));
    }

    private void stopScanning(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_(SCANNING_TAG, false);
        tag.m_128473_(SCAN_TARGET_TAG);
        tag.m_128473_("target_type");
        tag.m_128473_(SCAN_PROGRESS_TAG);
    }

    private void completeScan(Level level, Player player, ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        String targetType = tag.m_128461_("target_type");
        if (targetType != null && !targetType.isEmpty()) {
            String oldMorph = PlayerMorphData.getMorphEntityType(player.m_20148_());
            if (oldMorph != null) {
                PlayerMorphData.clearMorph(player.m_20148_());
                UUID finalPlayerUUID = player.m_20148_();
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> PlayerMorphRenderer.cleanupMorphEntity(finalPlayerUUID));
            }
            tag.m_128359_(MORPHED_ENTITY_TAG, targetType);
            tag.m_128379_(MORPHED_TAG, true);
            UUID targetPlayerUUID = null;
            if (targetType.equals("minecraft:player") && tag.m_128403_("target_player_uuid")) {
                targetPlayerUUID = tag.m_128342_("target_player_uuid");
            }
            PlayerMorphData.setMorph(player.m_20148_(), targetType, targetPlayerUUID);
            if (!level.f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PlayerMorphSyncPacket packet = new PlayerMorphSyncPacket(player.m_20148_(), targetType, targetPlayerUUID, false);
                NetworkHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)packet);
                System.out.println("DEBUG: Sent morph sync to ALL players");
            }
            if (!level.f_46443_) {
                System.out.println("DEBUG: Completed scan - Setting morph to: " + targetType);
                System.out.println("DEBUG: Old morph was: " + oldMorph);
                System.out.println("DEBUG: Target player UUID: " + targetPlayerUUID);
                System.out.println("DEBUG: Stored in item NBT: " + tag.m_128461_(MORPHED_ENTITY_TAG));
                System.out.println("DEBUG: Actual morph data: " + PlayerMorphData.getMorphEntityType(player.m_20148_()));
            }
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.5f);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 20; ++i) {
                    double offsetX = (level.f_46441_.m_188500_() - 0.5) * 1.5;
                    double offsetY = level.f_46441_.m_188500_() * 2.0;
                    double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 1.5;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123810_, player.m_20185_() + offsetX, player.m_20186_() + offsetY, player.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.05);
                }
            }
            String displayName = targetType.equals("minecraft:player") && tag.m_128441_("target_player_name") ? tag.m_128461_("target_player_name") : this.getEntityDisplayName(targetType);
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7aScan complete! You have morphed into " + displayName + ".")));
        }
        this.stopScanning(stack);
    }

    private void morphBack(Level level, Player player, ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        tag.m_128379_(MORPHED_TAG, false);
        tag.m_128473_(MORPHED_ENTITY_TAG);
        PlayerMorphData.clearMorph(player.m_20148_());
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerMorphSyncPacket packet = new PlayerMorphSyncPacket(player.m_20148_(), null, null, true);
            NetworkHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)packet);
        }
        if (level.f_46443_) {
            UUID finalPlayerUUID = player.m_20148_();
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> PlayerMorphRenderer.cleanupMorphEntity(finalPlayerUUID));
        }
        if (!level.f_46443_) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11897_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 15; ++i) {
                    double offsetX = (level.f_46441_.m_188500_() - 0.5) * 1.5;
                    double offsetY = level.f_46441_.m_188500_() * 2.0;
                    double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 1.5;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123789_, player.m_20185_() + offsetX, player.m_20186_() + offsetY, player.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.05);
                }
            }
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7aYou have morphed back to your normal form."));
        }
    }

    private void spawnScanParticles(Level level, Player player, Entity target) {
        int i;
        Vec3 playerPos = player.m_146892_();
        Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
        Vec3 direction = targetPos.m_82546_(playerPos).m_82541_();
        double distance = playerPos.m_82554_(targetPos);
        int particleCount = (int)(distance * 3.0);
        for (i = 0; i < particleCount; ++i) {
            double t = (double)i / (double)particleCount;
            Vec3 particlePos = playerPos.m_82549_(direction.m_82490_(t * distance));
            level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, particlePos.f_82479_ + (level.f_46441_.m_188500_() - 0.5) * 0.2, particlePos.f_82480_ + (level.f_46441_.m_188500_() - 0.5) * 0.2, particlePos.f_82481_ + (level.f_46441_.m_188500_() - 0.5) * 0.2, 0.0, 0.0, 0.0);
        }
        for (i = 0; i < 3; ++i) {
            double offsetX = (level.f_46441_.m_188500_() - 0.5) * (double)target.m_20205_();
            double offsetY = level.f_46441_.m_188500_() * (double)target.m_20206_();
            double offsetZ = (level.f_46441_.m_188500_() - 0.5) * (double)target.m_20205_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123809_, target.m_20185_() + offsetX, target.m_20186_() + offsetY, target.m_20189_() + offsetZ, 0.0, 0.1, 0.0);
        }
    }

    private Entity findEntityByUUID(Level level, UUID uuid) {
        AABB searchBox = new AABB(-3.0E7, -64.0, -3.0E7, 3.0E7, 320.0, 3.0E7);
        List entities = level.m_6249_((Entity)null, searchBox, entity -> entity.m_20148_().equals(uuid));
        return entities.isEmpty() ? null : (Entity)entities.get(0);
    }

    private String getEntityDisplayName(String entityTypeId) {
        try {
            ResourceLocation resourceLocation = ResourceLocation.parse((String)entityTypeId);
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(resourceLocation);
            if (entityType != null) {
                return entityType.m_20676_().getString();
            }
        }
        catch (Exception resourceLocation) {
            // empty catch block
        }
        String simpleName = entityTypeId.contains(":") ? entityTypeId.split(":")[1] : entityTypeId;
        return simpleName.replace("_", " ");
    }

    public boolean isScanning(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_(SCANNING_TAG);
    }

    public boolean isMorphed(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_(MORPHED_TAG);
    }

    private UUID getTargetUUID(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128403_(SCAN_TARGET_TAG)) {
            return tag.m_128342_(SCAN_TARGET_TAG);
        }
        return null;
    }

    private int getScanProgress(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_(SCAN_PROGRESS_TAG) : 0;
    }

    private void setScanProgress(ItemStack stack, int progress) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(SCAN_PROGRESS_TAG, progress);
    }
}

