/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.item;

import com.hexvane.strangematter.entity.BaseAnomalyEntity;
import com.hexvane.strangematter.entity.EchoingShadowEntity;
import com.hexvane.strangematter.entity.EnergeticRiftEntity;
import com.hexvane.strangematter.entity.GravityAnomalyEntity;
import com.hexvane.strangematter.entity.TemporalBloomEntity;
import com.hexvane.strangematter.entity.ThoughtwellEntity;
import com.hexvane.strangematter.entity.WarpGateAnomalyEntity;
import com.hexvane.strangematter.item.ContainmentCapsuleItem;
import com.hexvane.strangematter.network.EchoVacuumBeamPacket;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EchoVacuumItem
extends Item {
    private static final double BEAM_RANGE = 8.0;
    private static final double BEAM_WIDTH = 2.0;
    private static final int SUCTION_TIME = 40;
    private static final double SUCTION_SPEED = 0.1;
    private static final Map<BaseAnomalyEntity, Vec3> originalPositions = new HashMap<BaseAnomalyEntity, Vec3>();
    private static final Map<BaseAnomalyEntity, Float> originalScales = new HashMap<BaseAnomalyEntity, Float>();
    private static final Set<Player> playersUsingBeam = new HashSet<Player>();
    private static final Map<BaseAnomalyEntity, Player> targetedAnomalies = new HashMap<BaseAnomalyEntity, Player>();

    public EchoVacuumItem() {
        super(new Item.Properties().m_41487_(1).m_41503_(200));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.hasEmptyCapsule(player)) {
            player.m_5661_((Component)Component.m_237115_((String)"item.strangematter.echo_vacuum.no_capsule"), true);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)StrangeMatterSounds.ECHO_VACUUM_CHARGE_UP.get(), SoundSource.PLAYERS, 0.7f, 1.0f);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    private static void returnAnomaliesToOriginalState(Level level) {
        Iterator<Map.Entry<BaseAnomalyEntity, Vec3>> posIter = originalPositions.entrySet().iterator();
        while (posIter.hasNext()) {
            Map.Entry<BaseAnomalyEntity, Vec3> entry = posIter.next();
            BaseAnomalyEntity anomaly = entry.getKey();
            if (anomaly.m_213877_() || !anomaly.m_9236_().equals(level)) {
                posIter.remove();
                originalScales.remove((Object)anomaly);
                targetedAnomalies.remove((Object)anomaly);
                continue;
            }
            Vec3 originalPos = entry.getValue();
            Float originalScale = originalScales.get((Object)anomaly);
            if (originalScale == null) continue;
            Vec3 currentPos = anomaly.m_20182_();
            Vec3 direction = originalPos.m_82546_(currentPos).m_82541_();
            double distance = currentPos.m_82554_(originalPos);
            if (distance > 0.1) {
                Vec3 newPos = currentPos.m_82549_(direction.m_82490_(0.1));
                anomaly.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
                anomaly.setScale(originalScale.floatValue());
                continue;
            }
            posIter.remove();
            originalScales.remove((Object)anomaly);
        }
    }

    public static void handlePlayerTick(Player player, Level level) {
        boolean currentlyUsingBeam = player.m_6117_() && player.m_21211_().m_41720_() instanceof EchoVacuumItem;
        boolean wasUsingBeam = playersUsingBeam.contains(player);
        if (currentlyUsingBeam) {
            if (!wasUsingBeam) {
                playersUsingBeam.add(player);
                EchoVacuumBeamPacket.sendToNearbyPlayers(player, true);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)StrangeMatterSounds.ECHO_VACUUM_CHARGE_UP.get(), SoundSource.PLAYERS, 0.7f, 1.0f);
            }
            EchoVacuumItem.handleVacuumBeam(player, level);
        } else if (wasUsingBeam) {
            playersUsingBeam.remove(player);
            EchoVacuumBeamPacket.sendToNearbyPlayers(player, false);
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)StrangeMatterSounds.ECHO_VACUUM_CHARGE_DOWN.get(), SoundSource.PLAYERS, 0.6f, 1.0f);
            EchoVacuumItem.cleanupPlayerTargeting(player);
        }
    }

    private boolean hasEmptyCapsule(Player player) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!(stack.m_41720_() instanceof ContainmentCapsuleItem) || ((ContainmentCapsuleItem)stack.m_41720_()).hasAnomaly()) continue;
            return true;
        }
        return false;
    }

    private void startVacuumBeam(Player player, Level level) {
        player.m_6672_(player.m_7655_());
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)StrangeMatterSounds.ECHO_VACUUM_CHARGE_UP.get(), SoundSource.PLAYERS, 0.7f, 1.0f);
    }

    private static void handleVacuumBeam(Player player, Level level) {
        Vec3 startPos = player.m_146892_();
        Vec3 lookDirection = player.m_20154_();
        Vec3 endPos = startPos.m_82549_(lookDirection.m_82490_(8.0));
        AABB beamBox = new AABB(startPos, endPos).m_82400_(2.0);
        List entities = level.m_45933_((Entity)player, beamBox);
        BaseAnomalyEntity targetAnomaly = null;
        double closestDistance = Double.MAX_VALUE;
        for (Entity entity : entities) {
            Player currentTargeter;
            BaseAnomalyEntity anomaly;
            if (!(entity instanceof BaseAnomalyEntity) || (anomaly = (BaseAnomalyEntity)entity).isContained() || (currentTargeter = targetedAnomalies.get((Object)anomaly)) != null && currentTargeter != player) continue;
            double distance = entity.m_20270_((Entity)player);
            Vec3 entityPos = entity.m_20182_();
            Vec3 toEntity = entityPos.m_82546_(startPos);
            double dotProduct = toEntity.m_82541_().m_82526_(lookDirection);
            if (!(dotProduct > 0.5) || !(distance < closestDistance) || !(distance < 8.0)) continue;
            targetAnomaly = anomaly;
            closestDistance = distance;
        }
        if (targetAnomaly != null) {
            targetedAnomalies.put(targetAnomaly, player);
            EchoVacuumItem.suckAnomaly(player, targetAnomaly, level);
        }
    }

    private static void suckAnomaly(Player player, BaseAnomalyEntity anomaly, Level level) {
        Vec3 playerPos = player.m_146892_();
        Vec3 anomalyPos = anomaly.m_20182_();
        Vec3 direction = playerPos.m_82546_(anomalyPos).m_82541_();
        if (!originalPositions.containsKey((Object)anomaly)) {
            originalPositions.put(anomaly, anomalyPos);
            originalScales.put(anomaly, Float.valueOf(anomaly.getScale()));
        }
        Vec3 newPos = anomalyPos.m_82549_(direction.m_82490_(0.1));
        anomaly.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        double distance = anomaly.m_20270_((Entity)player);
        double shrinkFactor = Math.max(0.1, distance / 8.0);
        anomaly.setScale((float)shrinkFactor);
        if (distance < 2.0) {
            EchoVacuumItem.containAnomaly(player, anomaly, level);
        }
    }

    private static void containAnomaly(Player player, BaseAnomalyEntity anomaly, Level level) {
        targetedAnomalies.remove((Object)anomaly);
        ItemStack emptyCapsule = null;
        int capsuleSlot = -1;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!(stack.m_41720_() instanceof ContainmentCapsuleItem) || ((ContainmentCapsuleItem)stack.m_41720_()).hasAnomaly()) continue;
            emptyCapsule = stack;
            capsuleSlot = i;
            break;
        }
        if (emptyCapsule != null) {
            ItemStack filledCapsule = EchoVacuumItem.createFilledCapsule(anomaly);
            if (emptyCapsule.m_41613_() > 1) {
                emptyCapsule.m_41774_(1);
                player.m_150109_().m_36054_(filledCapsule);
            } else {
                player.m_150109_().m_6836_(capsuleSlot, filledCapsule);
            }
            anomaly.m_142687_(Entity.RemovalReason.DISCARDED);
            originalPositions.remove((Object)anomaly);
            originalScales.remove((Object)anomaly);
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)StrangeMatterSounds.ECHO_VACUUM_CONTAIN.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_5810_();
        }
    }

    private static ItemStack createFilledCapsule(BaseAnomalyEntity anomaly) {
        if (anomaly instanceof GravityAnomalyEntity) {
            return new ItemStack((ItemLike)ContainmentCapsuleItem.GRAVITY_CAPSULE.get());
        }
        if (anomaly instanceof EnergeticRiftEntity) {
            return new ItemStack((ItemLike)ContainmentCapsuleItem.ENERGETIC_CAPSULE.get());
        }
        if (anomaly instanceof EchoingShadowEntity) {
            return new ItemStack((ItemLike)ContainmentCapsuleItem.ECHOING_SHADOW_CAPSULE.get());
        }
        if (anomaly instanceof TemporalBloomEntity) {
            return new ItemStack((ItemLike)ContainmentCapsuleItem.TEMPORAL_BLOOM_CAPSULE.get());
        }
        if (anomaly instanceof ThoughtwellEntity) {
            return new ItemStack((ItemLike)ContainmentCapsuleItem.THOUGHTWELL_CAPSULE.get());
        }
        if (anomaly instanceof WarpGateAnomalyEntity) {
            return new ItemStack((ItemLike)ContainmentCapsuleItem.WARP_GATE_CAPSULE.get());
        }
        return new ItemStack((ItemLike)ContainmentCapsuleItem.EMPTY_CAPSULE.get());
    }

    private static void cleanupPlayerTargeting(Player player) {
        targetedAnomalies.entrySet().removeIf(entry -> entry.getValue() == player);
        for (BaseAnomalyEntity anomaly : originalPositions.keySet()) {
            Player targeter = targetedAnomalies.get((Object)anomaly);
            if (targeter != player) continue;
            Vec3 originalPos = originalPositions.get((Object)anomaly);
            Float originalScale = originalScales.get((Object)anomaly);
            if (originalPos != null && originalScale != null) {
                anomaly.m_6034_(originalPos.f_82479_, originalPos.f_82480_, originalPos.f_82481_);
                anomaly.setScale(originalScale.floatValue());
            }
            originalPositions.remove((Object)anomaly);
            originalScales.remove((Object)anomaly);
            targetedAnomalies.remove((Object)anomaly);
        }
    }
}

