/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.item;

import com.hexvane.strangematter.entity.ThrowableContainmentCapsuleEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;

public class ContainmentCapsuleItem
extends Item {
    private final AnomalyType anomalyType;
    public static RegistryObject<Item> EMPTY_CAPSULE;
    public static RegistryObject<Item> GRAVITY_CAPSULE;
    public static RegistryObject<Item> ENERGETIC_CAPSULE;
    public static RegistryObject<Item> ECHOING_SHADOW_CAPSULE;
    public static RegistryObject<Item> TEMPORAL_BLOOM_CAPSULE;
    public static RegistryObject<Item> THOUGHTWELL_CAPSULE;
    public static RegistryObject<Item> WARP_GATE_CAPSULE;

    public ContainmentCapsuleItem(AnomalyType anomalyType) {
        super(new Item.Properties().m_41487_(64));
        this.anomalyType = anomalyType;
    }

    public boolean hasAnomaly() {
        return this.anomalyType != AnomalyType.NONE;
    }

    public AnomalyType getAnomalyType() {
        return this.anomalyType;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (this.hasAnomaly()) {
            if (!level.f_46443_) {
                ThrowableContainmentCapsuleEntity throwableCapsule = new ThrowableContainmentCapsuleEntity(level, (LivingEntity)player, itemStack);
                Vec3 lookDirection = player.m_20154_();
                Vec3 throwVelocity = lookDirection.m_82542_(1.5, 1.5, 1.5);
                throwableCapsule.m_6686_(throwVelocity.f_82479_, throwVelocity.f_82480_, throwVelocity.f_82481_, 1.0f, 1.0f);
                level.m_7967_((Entity)throwableCapsule);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12437_, SoundSource.PLAYERS, 0.5f, 0.4f);
            }
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        if (this.hasAnomaly()) {
            tooltip.add((Component)Component.m_237115_((String)"item.strangematter.containment_capsule.filled.tooltip").m_130940_(ChatFormatting.GREEN));
            String tooltipKey = "item.strangematter.containment_capsule_" + this.getAnomalyTypeKey() + ".tooltip";
            tooltip.add((Component)Component.m_237115_((String)tooltipKey).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)"Right click to throw and release anomaly").m_130940_(ChatFormatting.YELLOW));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.strangematter.containment_capsule.empty.tooltip").m_130940_(ChatFormatting.GRAY));
        }
    }

    private String getAnomalyTypeKey() {
        switch (this.anomalyType) {
            case GRAVITY: {
                return "gravity";
            }
            case ENERGETIC: {
                return "energetic";
            }
            case ECHOING_SHADOW: {
                return "echoing_shadow";
            }
            case TEMPORAL_BLOOM: {
                return "temporal_bloom";
            }
            case THOUGHTWELL: {
                return "thoughtwell";
            }
            case WARP_GATE: {
                return "warp_gate";
            }
        }
        return "empty";
    }

    public static enum AnomalyType {
        NONE,
        GRAVITY,
        ENERGETIC,
        ECHOING_SHADOW,
        TEMPORAL_BLOOM,
        THOUGHTWELL,
        WARP_GATE;

    }
}

