/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.item;

import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.client.ChronoBlisterRenderer;
import com.hexvane.strangematter.entity.ChronoBlisterProjectileEntity;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class ChronoBlisterItem
extends SwordItem {
    private static final String CHARGING_TAG = "charging";
    private static final String CHARGE_TIME_TAG = "charge_time";
    private static final String PROJECTILE_ID_TAG = "projectile_id";
    private static final int MAX_CHARGE_TIME = 20;

    public ChronoBlisterItem() {
        super((Tier)Tiers.WOOD, 3, -2.4f, new Item.Properties().m_41487_(1).m_41503_(100));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new ChronoBlisterRenderer());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.isCharging(stack)) {
            this.startCharging(level, player, stack);
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_5929_(@NotNull Level level, @NotNull LivingEntity livingEntity, @NotNull ItemStack stack, int remainingUseDuration) {
        if (level.f_46443_ || !(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!this.isCharging(stack)) {
            return;
        }
        int chargeTime = this.getChargeTime(stack);
        this.setChargeTime(stack, ++chargeTime);
        int projectileId = this.getProjectileId(stack);
        if (projectileId != -1) {
            Entity projectile = level.m_6815_(projectileId);
            if (projectile instanceof ChronoBlisterProjectileEntity) {
                ChronoBlisterProjectileEntity chronoProjectile = (ChronoBlisterProjectileEntity)projectile;
                float chargeProgress = Math.min(1.0f, (float)chargeTime / 20.0f);
                chronoProjectile.setChargeProgress(chargeProgress);
            } else {
                this.stopCharging(stack);
            }
        }
    }

    public void m_5551_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity, int timeCharged) {
        if (level.f_46443_ || !(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (this.isCharging(stack)) {
            Entity projectile;
            int chargeTime = this.getChargeTime(stack);
            boolean fullyCharged = chargeTime >= 20;
            int projectileId = this.getProjectileId(stack);
            if (projectileId != -1 && (projectile = level.m_6815_(projectileId)) instanceof ChronoBlisterProjectileEntity) {
                ChronoBlisterProjectileEntity chronoProjectile = (ChronoBlisterProjectileEntity)projectile;
                if (fullyCharged) {
                    Vec3 lookDirection = player.m_20154_();
                    chronoProjectile.m_6686_(lookDirection.f_82479_, lookDirection.f_82480_, lookDirection.f_82481_, 1.5f, 1.0f);
                    chronoProjectile.setFired(true);
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)StrangeMatterSounds.CHRONO_BLISTER_FIRE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    chronoProjectile.m_146870_();
                }
            }
            this.stopCharging(stack);
        }
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 72000;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.NONE;
    }

    private void startCharging(Level level, Player player, ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_(CHARGING_TAG, true);
        tag.m_128405_(CHARGE_TIME_TAG, 0);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)StrangeMatterSounds.CHRONO_BLISTER_CHARGE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!level.f_46443_) {
            Vec3 lookDirection = player.m_20154_();
            Vec3 eyePos = player.m_146892_();
            Vec3 startPos = eyePos.m_82549_(lookDirection.m_82490_(0.5));
            ChronoBlisterProjectileEntity projectile = new ChronoBlisterProjectileEntity((EntityType<? extends ChronoBlisterProjectileEntity>)((EntityType)StrangeMatterMod.CHRONO_BLISTER_PROJECTILE_ENTITY.get()), (LivingEntity)player, level);
            projectile.m_6034_(startPos.f_82479_, startPos.f_82480_, startPos.f_82481_);
            projectile.setChargeProgress(0.0f);
            projectile.setFired(false);
            projectile.m_20242_(true);
            level.m_7967_((Entity)projectile);
            tag.m_128405_(PROJECTILE_ID_TAG, projectile.m_19879_());
        }
    }

    private void stopCharging(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            tag.m_128379_(CHARGING_TAG, false);
            tag.m_128405_(CHARGE_TIME_TAG, 0);
            tag.m_128473_(PROJECTILE_ID_TAG);
        }
    }

    private boolean isCharging(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_(CHARGING_TAG);
    }

    private int getChargeTime(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_(CHARGE_TIME_TAG) : 0;
    }

    private void setChargeTime(ItemStack stack, int time) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(CHARGE_TIME_TAG, time);
    }

    private int getProjectileId(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_(PROJECTILE_ID_TAG) ? tag.m_128451_(PROJECTILE_ID_TAG) : -1;
    }
}

