/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.item;

import com.hexvane.strangematter.entity.BaseAnomalyEntity;
import com.hexvane.strangematter.entity.EchoingShadowEntity;
import com.hexvane.strangematter.entity.EnergeticRiftEntity;
import com.hexvane.strangematter.entity.GravityAnomalyEntity;
import com.hexvane.strangematter.entity.TemporalBloomEntity;
import com.hexvane.strangematter.entity.ThoughtwellEntity;
import com.hexvane.strangematter.entity.WarpGateAnomalyEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AnomalyResonatorItem
extends CompassItem {
    private static final String SYNCED_ANOMALIES_TAG = "synced_anomalies";
    private static final String LAST_ANOMALY_TAG = "last_anomaly";

    public AnomalyResonatorItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        List<UUID> syncedAnomalies = this.getSyncedAnomalies(stack);
        BaseAnomalyEntity nearestAnomaly = this.findNearestUnsyncedAnomaly(level, player, stack);
        if (nearestAnomaly != null) {
            AnomalyResonatorItem.setTargetPosition(stack, nearestAnomaly.m_20183_());
            double distance = player.m_20182_().m_82554_(nearestAnomaly.m_20182_());
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7eNearest unsynced anomaly: " + String.format("%.1f", distance) + " blocks away")));
        } else {
            AnomalyResonatorItem.clearTargetPosition(stack);
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7cNo unsynced anomalies detected."));
        }
        if (!syncedAnomalies.isEmpty()) {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7aSynced with " + syncedAnomalies.size() + " anomalies")));
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void onInteractWithAnomaly(ItemStack stack, Player player, BaseAnomalyEntity anomaly) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        List<UUID> syncedAnomalies = this.getSyncedAnomalies(stack);
        if (syncedAnomalies.contains(anomaly.m_20148_())) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7cThis anomaly has already been synced!"));
            return;
        }
        this.syncWithAnomaly(stack, anomaly);
        BaseAnomalyEntity nearestAnomaly = this.findNearestUnsyncedAnomaly(player.m_9236_(), player, stack);
        if (nearestAnomaly != null) {
            AnomalyResonatorItem.setTargetPosition(stack, nearestAnomaly.m_20183_());
        } else {
            AnomalyResonatorItem.clearTargetPosition(stack);
        }
        player.m_213846_((Component)Component.m_237113_((String)"\u00a7aResonator synced with this anomaly!"));
    }

    private BaseAnomalyEntity findNearestUnsyncedAnomaly(Level level, Player player, ItemStack stack) {
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 playerPos = player.m_20182_();
        List<UUID> syncedAnomalies = this.getSyncedAnomalies(stack);
        AABB searchArea = new AABB(playerPos.f_82479_ - 1000.0, playerPos.f_82480_ - 100.0, playerPos.f_82481_ - 1000.0, playerPos.f_82479_ + 1000.0, playerPos.f_82480_ + 100.0, playerPos.f_82481_ + 1000.0);
        ArrayList anomalies = new ArrayList();
        anomalies.addAll(serverLevel.m_45976_(GravityAnomalyEntity.class, searchArea));
        anomalies.addAll(serverLevel.m_45976_(WarpGateAnomalyEntity.class, searchArea));
        anomalies.addAll(serverLevel.m_45976_(EnergeticRiftEntity.class, searchArea));
        anomalies.addAll(serverLevel.m_45976_(TemporalBloomEntity.class, searchArea));
        anomalies.addAll(serverLevel.m_45976_(ThoughtwellEntity.class, searchArea));
        anomalies.addAll(serverLevel.m_45976_(EchoingShadowEntity.class, searchArea));
        BaseAnomalyEntity nearest = null;
        double nearestDistance = Double.MAX_VALUE;
        for (BaseAnomalyEntity anomaly : anomalies) {
            double distance;
            if (syncedAnomalies.contains(anomaly.m_20148_()) || !((distance = playerPos.m_82554_(anomaly.m_20182_())) < nearestDistance)) continue;
            nearest = anomaly;
            nearestDistance = distance;
        }
        return nearest;
    }

    private void syncWithAnomaly(ItemStack stack, BaseAnomalyEntity anomaly) {
        CompoundTag tag = stack.m_41784_();
        List<UUID> syncedAnomalies = this.getSyncedAnomalies(stack);
        syncedAnomalies.add(anomaly.m_20148_());
        this.setSyncedAnomalies(stack, syncedAnomalies);
        tag.m_128362_(LAST_ANOMALY_TAG, anomaly.m_20148_());
    }

    private List<UUID> getSyncedAnomalies(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(SYNCED_ANOMALIES_TAG)) {
            return new ArrayList<UUID>();
        }
        ArrayList<UUID> synced = new ArrayList<UUID>();
        ListTag listTag = tag.m_128437_(SYNCED_ANOMALIES_TAG, 8);
        for (int i = 0; i < listTag.size(); ++i) {
            try {
                synced.add(UUID.fromString(listTag.m_128778_(i)));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return synced;
    }

    private void setSyncedAnomalies(ItemStack stack, List<UUID> syncedAnomalies) {
        CompoundTag tag = stack.m_41784_();
        ListTag listTag = new ListTag();
        for (UUID uuid : syncedAnomalies) {
            listTag.add((Object)StringTag.m_129297_((String)uuid.toString()));
        }
        tag.m_128365_(SYNCED_ANOMALIES_TAG, (Tag)listTag);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237113_((String)"\u00a77Points to the nearest unsynced anomaly"));
        tooltip.add((Component)Component.m_237113_((String)"\u00a77Right-click to check status"));
        tooltip.add((Component)Component.m_237113_((String)"\u00a77Right-click anomaly to sync with it"));
        tooltip.add((Component)Component.m_237113_((String)"\u00a77Needle spins when no anomalies found"));
        List<UUID> syncedAnomalies = this.getSyncedAnomalies(stack);
        if (!syncedAnomalies.isEmpty()) {
            tooltip.add((Component)Component.m_237113_((String)("\u00a7aSynced with " + syncedAnomalies.size() + " anomalies")));
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return !this.getSyncedAnomalies(stack).isEmpty();
    }

    public static boolean shouldSpin(ItemStack stack, Level level, Player player) {
        return AnomalyResonatorItem.getTargetPosition(stack, level, player) == null;
    }

    public static float getAngle(ItemStack stack, Level level, Player player) {
        if (level == null || player == null) {
            return 0.0f;
        }
        if (AnomalyResonatorItem.shouldSpin(stack, level, player)) {
            return (float)((double)System.currentTimeMillis() * 0.1) % 360.0f;
        }
        BlockPos targetPos = AnomalyResonatorItem.getTargetPosition(stack, level, player);
        if (targetPos == null) {
            return 0.0f;
        }
        double dx = (double)targetPos.m_123341_() - player.m_20185_();
        double dz = (double)targetPos.m_123343_() - player.m_20189_();
        double angle = Math.atan2(dz, dx) * 180.0 / Math.PI;
        angle -= 90.0;
        while (angle < 0.0) {
            angle += 360.0;
        }
        while (angle >= 360.0) {
            angle -= 360.0;
        }
        return (float)angle;
    }

    public static BlockPos getTargetPosition(ItemStack stack, Level level, Player player) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("target_pos")) {
            CompoundTag posTag = tag.m_128469_("target_pos");
            int x = posTag.m_128451_("x");
            int y = posTag.m_128451_("y");
            int z = posTag.m_128451_("z");
            return new BlockPos(x, y, z);
        }
        return null;
    }

    public static void setTargetPosition(ItemStack stack, BlockPos pos) {
        CompoundTag tag = stack.m_41784_();
        CompoundTag posTag = new CompoundTag();
        posTag.m_128405_("x", pos.m_123341_());
        posTag.m_128405_("y", pos.m_123342_());
        posTag.m_128405_("z", pos.m_123343_());
        tag.m_128365_("target_pos", (Tag)posTag);
    }

    public static void clearTargetPosition(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            tag.m_128473_("target_pos");
        }
    }
}

