/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.event;

import com.hexvane.strangematter.Config;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(modid="strangematter")
public class VillageStructureAddition {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"StrangeMatter:VillageStructures");

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        if (event.getUpdateCause() != TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD) {
            return;
        }
        if (!Config.enableAnomalyScientistHouse) {
            LOGGER.info("Anomaly Scientist House generation is disabled in config");
            return;
        }
        for (String biome : new String[]{"plains", "snowy", "savanna", "desert", "taiga"}) {
            VillageStructureAddition.addToPool(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)("village/" + biome + "/houses")), ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"anomaly_scientist_lab"), event.getRegistryAccess());
        }
    }

    private static void addToPool(ResourceLocation poolId, ResourceLocation toAdd, RegistryAccess regAccess) {
        Registry registry = regAccess.m_175515_(Registries.f_256948_);
        StructureTemplatePool pool = Objects.requireNonNull((StructureTemplatePool)registry.m_7745_(poolId), poolId.m_135815_());
        try {
            List list;
            Object fieldValue2;
            String typeName;
            String fieldName;
            Field[] fields = StructureTemplatePool.class.getDeclaredFields();
            Field rawTemplatesField = null;
            Field templatesField = null;
            for (Field field : fields) {
                field.setAccessible(true);
                fieldName = field.getName();
                typeName = field.getType().getSimpleName();
                if (!typeName.equals("List") || !fieldName.toLowerCase().contains("raw") && !fieldName.startsWith("f_")) continue;
                try {
                    fieldValue2 = field.get(pool);
                    if (!(fieldValue2 instanceof List) || (list = (List)fieldValue2).isEmpty() || !(list.get(0) instanceof Pair)) continue;
                    rawTemplatesField = field;
                    break;
                }
                catch (Exception fieldValue2) {
                    // empty catch block
                }
            }
            for (Field field : fields) {
                field.setAccessible(true);
                fieldName = field.getName();
                typeName = field.getType().getSimpleName();
                if (!typeName.equals("List") && !typeName.equals("ObjectArrayList") || !fieldName.toLowerCase().contains("template") && !fieldName.toLowerCase().contains("element") && !fieldName.startsWith("f_")) continue;
                try {
                    fieldValue2 = field.get(pool);
                    if (!(fieldValue2 instanceof List) || (list = (List)fieldValue2).isEmpty() || !(list.get(0) instanceof StructurePoolElement)) continue;
                    templatesField = field;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (rawTemplatesField == null || templatesField == null) {
                for (Field field : fields) {
                    LOGGER.warn("  " + field.getName() + " (" + field.getType().getSimpleName() + ")");
                }
                return;
            }
            ArrayList<Pair> rawTemplates = (ArrayList<Pair>)rawTemplatesField.get(pool);
            if (!(rawTemplates instanceof ArrayList)) {
                rawTemplates = new ArrayList<Pair>(rawTemplates);
                rawTemplatesField.set(pool, rawTemplates);
            }
            List templates = (List)templatesField.get(pool);
            SinglePoolElement addedElement = (SinglePoolElement)SinglePoolElement.m_210526_((String)toAdd.toString()).apply(StructureTemplatePool.Projection.RIGID);
            int weight = Config.anomalyScientistHouseWeight;
            rawTemplates.add(Pair.of((Object)addedElement, (Object)weight));
            templates.add(addedElement);
            LOGGER.info("Successfully added structure " + toAdd + " to pool " + poolId + " with weight " + weight);
        }
        catch (Exception e) {
            LOGGER.error("Failed to add structure to pool " + poolId, (Throwable)e);
        }
    }
}

