/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.event;

import com.hexvane.strangematter.TimeDilationData;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="strangematter", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TimeDilationEventHandler {
    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        double slowdownFactor;
        Player player;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && (player = (Player)entity).getPersistentData().m_128441_("strangematter.time_dilation_factor") && (slowdownFactor = player.getPersistentData().m_128459_("strangematter.time_dilation_factor")) < 1.0) {
            Vec3 currentVelocity = player.m_20184_();
            Vec3 slowedVelocity = currentVelocity.m_82490_(slowdownFactor);
            player.m_20256_(slowedVelocity);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player.getPersistentData().m_128441_("strangematter.time_dilation_factor")) {
            TimeDilationData.removePlayerSlowdownFactor(player.m_20148_());
            player.getPersistentData().m_128473_("strangematter.time_dilation_factor");
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player.getPersistentData().m_128441_("strangematter.time_dilation_factor")) {
            TimeDilationData.removePlayerSlowdownFactor(player.m_20148_());
            player.getPersistentData().m_128473_("strangematter.time_dilation_factor");
        }
    }
}

