/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.event;

import com.hexvane.strangematter.morph.PlayerMorphData;
import com.hexvane.strangematter.network.NetworkHandler;
import com.hexvane.strangematter.network.PlayerMorphSyncPacket;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="strangematter")
public class PlayerMorphEventHandler {
    @SubscribeEvent
    public static void onPlayerJoinLevel(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer joiningPlayer = (ServerPlayer)entity;
        System.out.println("DEBUG: Player joined server, syncing morphs to: " + joiningPlayer.m_7755_().getString());
        for (Player otherPlayer : event.getLevel().m_6907_()) {
            String morphType = PlayerMorphData.getMorphEntityType(otherPlayer.m_20148_());
            if (morphType == null) continue;
            UUID targetPlayerUUID = PlayerMorphData.getMorphedPlayerUUID(otherPlayer.m_20148_());
            System.out.println("DEBUG: Syncing morph " + morphType + " for player " + otherPlayer.m_7755_().getString() + " to joining player");
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> joiningPlayer), (Object)new PlayerMorphSyncPacket(otherPlayer.m_20148_(), morphType, targetPlayerUUID, false));
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        try {
            Player player = event.getEntity();
            if (player != null) {
                PlayerMorphData.clearMorph(player.m_20148_());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

