/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.event;

import com.hexvane.strangematter.GravityData;
import com.hexvane.strangematter.network.GravitySyncPacket;
import com.hexvane.strangematter.network.NetworkHandler;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(modid="strangematter", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GravityEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GravityEventHandler.class);

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            boolean currentlyRidingHoverboard;
            Player player = (Player)livingEntity;
            boolean wasRidingHoverboard = player.getPersistentData().m_128471_("strangematter.was_riding_hoverboard");
            boolean bl = currentlyRidingHoverboard = player.m_20159_() && player.m_20202_() != null && player.m_20202_().getClass().getSimpleName().equals("HoverboardEntity");
            if (!wasRidingHoverboard && currentlyRidingHoverboard) {
                player.getPersistentData().m_128379_("strangematter.was_riding_hoverboard", true);
            } else if (wasRidingHoverboard && !currentlyRidingHoverboard && !player.m_9236_().f_46443_) {
                player.f_19789_ = 0.0f;
                player.getPersistentData().m_128379_("strangematter.was_riding_hoverboard", false);
            }
            if (player.getPersistentData().m_128441_("strangematter.gravity_force")) {
                double forceMultiplier = player.getPersistentData().m_128459_("strangematter.gravity_force");
                Vec3 currentVelocity = player.m_20184_();
                if (forceMultiplier > 0.0) {
                    if (currentVelocity.f_82480_ < 0.0) {
                        double gravityReduction = 1.0 - forceMultiplier * 0.9;
                        Vec3 newVelocity = new Vec3(currentVelocity.f_82479_, currentVelocity.f_82480_ * gravityReduction, currentVelocity.f_82481_);
                        double upwardForce = 0.15 * forceMultiplier;
                        newVelocity = newVelocity.m_82520_(0.0, upwardForce, 0.0);
                        player.m_20256_(newVelocity);
                    } else {
                        double upwardForce = 0.1 * forceMultiplier;
                        Vec3 newVelocity = currentVelocity.m_82520_(0.0, upwardForce, 0.0);
                        player.m_20256_(newVelocity);
                    }
                } else if (forceMultiplier < 0.0) {
                    double downwardForce = Math.abs(forceMultiplier) * 0.02;
                    if (currentVelocity.f_82480_ > -0.1) {
                        Vec3 newVelocity = currentVelocity.m_82520_(0.0, -downwardForce, 0.0);
                        player.m_20256_(newVelocity);
                    } else if (currentVelocity.f_82480_ < -0.5) {
                        Vec3 newVelocity = currentVelocity.m_82542_(1.0, 0.3, 1.0);
                        player.m_20256_(newVelocity);
                    }
                }
                if (player.f_19789_ > 0.0f) {
                    player.f_19789_ *= 1.0f - (float)(Math.abs(forceMultiplier) * 0.8);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            String vehicleClassName;
            Player player = (Player)livingEntity;
            if (player.m_20159_() && player.m_20202_() != null && (vehicleClassName = player.m_20202_().getClass().getSimpleName()).equals("HoverboardEntity")) {
                event.setCanceled(true);
                return;
            }
            if (player.getPersistentData().m_128441_("strangematter.gravity_force")) {
                double forceMultiplier = player.getPersistentData().m_128459_("strangematter.gravity_force");
                float originalDistance = event.getDistance();
                float newDistance = originalDistance * (1.0f - (float)(Math.abs(forceMultiplier) * 0.8));
                event.setDistance(newDistance);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player.getPersistentData().m_128441_("strangematter.gravity_force")) {
            GravityData.removePlayerGravityForce(player.m_20148_());
            player.getPersistentData().m_128473_("strangematter.gravity_force");
            LOGGER.info("[GRAVITY HANDLER] Cleared gravity effects for player {} who left the world", (Object)player.m_7755_().getString());
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player.getPersistentData().m_128441_("strangematter.gravity_force")) {
            GravityData.removePlayerGravityForce(player.m_20148_());
            player.getPersistentData().m_128473_("strangematter.gravity_force");
            LOGGER.info("[GRAVITY HANDLER] Cleared gravity effects for player {} who changed dimension", (Object)player.m_7755_().getString());
        }
    }

    @SubscribeEvent
    public static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        if ((event.getEntity().m_6095_().toString().equals("strangematter:gravity_anomaly") || event.getEntity().getClass().getSimpleName().equals("GravityAnomalyEntity")) && event.getLevel() != null) {
            for (Player player : event.getLevel().m_6907_()) {
                if (!player.getPersistentData().m_128441_("strangematter.gravity_force")) continue;
                GravityData.removePlayerGravityForce(player.m_20148_());
                player.getPersistentData().m_128473_("strangematter.gravity_force");
                if (!event.getLevel().f_46443_ && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new GravitySyncPacket(0.0));
                }
                LOGGER.info("[GRAVITY HANDLER] Cleared gravity effects for player {} due to Gravity Anomaly removal", (Object)player.m_7755_().getString());
            }
        }
    }
}

