/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.event;

import com.hexvane.strangematter.entity.BaseAnomalyEntity;
import com.hexvane.strangematter.item.FieldScannerItem;
import com.hexvane.strangematter.research.ResearchData;
import com.hexvane.strangematter.research.ScannableObject;
import com.hexvane.strangematter.research.ScannableObjectRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="strangematter")
public class FieldScannerEventHandler {
    private static final Map<String, Long> lastAlreadyScannedMessage = new HashMap<String, Long>();

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (entity instanceof BaseAnomalyEntity) {
            BaseAnomalyEntity anomaly = (BaseAnomalyEntity)entity;
            Player player = event.getEntity();
            ItemStack mainHand = player.m_21120_(InteractionHand.MAIN_HAND);
            ItemStack offHand = player.m_21120_(InteractionHand.OFF_HAND);
            FieldScannerItem scanner = null;
            ItemStack scannerStack = null;
            if (mainHand.m_41720_() instanceof FieldScannerItem) {
                scanner = (FieldScannerItem)mainHand.m_41720_();
                scannerStack = mainHand;
            } else if (offHand.m_41720_() instanceof FieldScannerItem) {
                scanner = (FieldScannerItem)offHand.m_41720_();
                scannerStack = offHand;
            }
            if (scanner != null && scannerStack != null) {
                if (!scanner.isScanning(scannerStack) && !scanner.isOnCooldown(scannerStack)) {
                    InteractionHand hand = mainHand.m_41720_() instanceof FieldScannerItem ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                    scanner.onInteractWithEntity(scannerStack, player, anomaly, hand);
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        Optional<ScannableObject> scannable;
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        BlockState blockState = event.getLevel().m_8055_(pos);
        ItemStack mainHand = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offHand = player.m_21120_(InteractionHand.OFF_HAND);
        FieldScannerItem scanner = null;
        ItemStack scannerStack = null;
        if (mainHand.m_41720_() instanceof FieldScannerItem) {
            scanner = (FieldScannerItem)mainHand.m_41720_();
            scannerStack = mainHand;
        } else if (offHand.m_41720_() instanceof FieldScannerItem) {
            scanner = (FieldScannerItem)offHand.m_41720_();
            scannerStack = offHand;
        }
        if (scanner != null && scannerStack != null && ScannableObjectRegistry.isBlockScannable(blockState) && (scannable = ScannableObjectRegistry.getScannableForBlock(blockState)).isPresent()) {
            String objectId = scannable.get().generateObjectId(pos);
            ResearchData researchData = ResearchData.get(player);
            if (!researchData.hasScanned(objectId)) {
                if (!scanner.isScanning(scannerStack) && !scanner.isOnCooldown(scannerStack)) {
                    InteractionHand hand = mainHand.m_41720_() instanceof FieldScannerItem ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                    scanner.onInteractWithBlock(scannerStack, player, pos, blockState, scannable.get(), hand);
                }
                event.setCanceled(true);
            } else {
                if (!scanner.isScanning(scannerStack) && !scanner.isOnCooldown(scannerStack)) {
                    InteractionHand hand = mainHand.m_41720_() instanceof FieldScannerItem ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                    scanner.onInteractWithBlock(scannerStack, player, pos, blockState, scannable.get(), hand);
                }
                event.setCanceled(true);
            }
        }
    }
}

