/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.event;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.event.level.ChunkDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="strangematter", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ChunkMarkerCleanupEventHandler {
    private static final String MARKER_BE_ID = "strangematter:anomaly_spawner_marker";

    @SubscribeEvent
    public static void onChunkDataLoad(ChunkDataEvent.Load event) {
        ChunkMarkerCleanupEventHandler.stripMarkerBlockEntities(event.getData());
    }

    @SubscribeEvent
    public static void onChunkDataSave(ChunkDataEvent.Save event) {
        ChunkMarkerCleanupEventHandler.stripMarkerBlockEntities(event.getData());
    }

    private static void stripMarkerBlockEntities(CompoundTag chunkNbt) {
        if (chunkNbt == null) {
            return;
        }
        ChunkMarkerCleanupEventHandler.stripFromList(chunkNbt, "block_entities");
        ChunkMarkerCleanupEventHandler.stripFromList(chunkNbt, "blockEntities");
    }

    private static void stripFromList(CompoundTag chunkNbt, String key) {
        if (!chunkNbt.m_128425_(key, 9)) {
            return;
        }
        ListTag list = chunkNbt.m_128437_(key, 10);
        if (list.isEmpty()) {
            return;
        }
        ListTag cleaned = new ListTag();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag beTag = list.m_128728_(i);
            String id = beTag.m_128461_("id");
            if (MARKER_BE_ID.equals(id)) continue;
            cleaned.add((Object)beTag);
        }
        if (cleaned.size() != list.size()) {
            chunkNbt.m_128365_(key, (Tag)cleaned);
        }
    }
}

