/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.entity;

import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.entity.MiniWarpGateEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class WarpProjectileEntity
extends ThrowableProjectile {
    private boolean isPurplePortal = false;

    public WarpProjectileEntity(EntityType<? extends WarpProjectileEntity> entityType, Level level) {
        super(entityType, level);
    }

    public WarpProjectileEntity(EntityType<? extends WarpProjectileEntity> entityType, LivingEntity shooter, Level level) {
        super(entityType, shooter, level);
    }

    protected void m_6532_(HitResult result) {
        BlockHitResult blockResult;
        BlockPos hitPos;
        if (result.m_6662_() == HitResult.Type.BLOCK && this.canSpawnWarpGate(hitPos = (blockResult = (BlockHitResult)result).m_82425_())) {
            BlockPos centerPos = this.findCenterPosition(hitPos);
            this.spawnMiniWarpGate(centerPos);
        }
        this.m_146870_();
    }

    private boolean canSpawnWarpGate(BlockPos hitPos) {
        for (int offsetX = -1; offsetX <= 1; ++offsetX) {
            for (int offsetY = -1; offsetY <= 1; ++offsetY) {
                for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
                    BlockPos searchPos = hitPos.m_7918_(offsetX, offsetY, offsetZ);
                    if (!this.hasSpaceForWarpGate(searchPos)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasSpaceForWarpGate(BlockPos centerPos) {
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                for (int z = 0; z < 2; ++z) {
                    BlockPos checkPos = centerPos.m_7918_(x, y, z);
                    BlockState state = this.m_9236_().m_8055_(checkPos);
                    if (state.m_60795_() || !state.m_60804_((BlockGetter)this.m_9236_(), checkPos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private BlockPos findCenterPosition(BlockPos hitPos) {
        for (int offsetX = -1; offsetX <= 1; ++offsetX) {
            for (int offsetY = -1; offsetY <= 1; ++offsetY) {
                for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
                    BlockPos searchPos = hitPos.m_7918_(offsetX, offsetY, offsetZ);
                    if (!this.hasSpaceForWarpGate(searchPos)) continue;
                    return searchPos;
                }
            }
        }
        return hitPos;
    }

    public void setPortalType(boolean isPurple) {
        this.isPurplePortal = isPurple;
    }

    private void spawnMiniWarpGate(BlockPos centerPos) {
        if (!this.m_9236_().f_46443_) {
            MiniWarpGateEntity miniWarpGate = new MiniWarpGateEntity((EntityType)StrangeMatterMod.MINI_WARP_GATE_ENTITY.get(), this.m_9236_());
            miniWarpGate.m_6034_((double)centerPos.m_123341_() + 0.5, (double)centerPos.m_123342_() + 1.0, (double)centerPos.m_123343_() + 0.5);
            miniWarpGate.setPortalType(this.isPurplePortal);
            System.out.println("Spawning mini warp gate with isPurple: " + this.isPurplePortal);
            Entity entity = this.m_19749_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                miniWarpGate.setOwner(player);
            }
            this.m_9236_().m_7967_((Entity)miniWarpGate);
        }
    }

    protected void m_8097_() {
    }
}

