/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.entity;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.data.WarpGateLocationData;
import com.hexvane.strangematter.entity.BaseAnomalyEntity;
import com.hexvane.strangematter.registry.WarpGateRegistry;
import com.hexvane.strangematter.research.ResearchType;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import com.hexvane.strangematter.worldgen.WorldGenUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.world.ForgeChunkManager;

public class WarpGateAnomalyEntity
extends BaseAnomalyEntity {
    private static final EntityDataAccessor<String> PAIRED_GATE_ID = SynchedEntityData.m_135353_(WarpGateAnomalyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> IS_ACTIVE = SynchedEntityData.m_135353_(WarpGateAnomalyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final float AURA_RADIUS = 4.0f;
    private int teleportCooldown = 0;
    private UUID pairedGateUUID;
    private BlockPos pairedGateStructureLocation;
    private Map<UUID, Integer> playerCooldowns = new HashMap<UUID, Integer>();

    private float getTeleportRadius() {
        return (float)Config.warpTeleportRadius;
    }

    @Override
    protected float getEffectRadius() {
        return this.getTeleportRadius();
    }

    private int getTeleportCooldownMax() {
        return Config.warpTeleportCooldown;
    }

    public WarpGateAnomalyEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.f_19804_.m_135381_(IS_ACTIVE, (Object)true);
        this.m_20011_(new AABB(-1.5, 0.0, -1.5, 1.5, 3.0, 1.5));
    }

    public void onAddedToWorld() {
        Level level;
        super.onAddedToWorld();
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            WarpGateLocationData data = WarpGateLocationData.get(serverLevel);
            data.addWarpGate(this.m_20148_(), this.m_20183_());
        }
    }

    @Override
    public void m_142687_(Entity.RemovalReason reason) {
        Level level;
        WarpGateRegistry.unregisterWarpGate(this.m_20148_());
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            WarpGateLocationData data = WarpGateLocationData.get(serverLevel);
            data.removeWarpGate(this.m_20148_());
        }
        super.m_142687_(reason);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PAIRED_GATE_ID, (Object)"");
        this.f_19804_.m_135372_(IS_ACTIVE, (Object)true);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Warp Gate");
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.tickCount == 1) {
            WarpGateRegistry.registerWarpGate(this);
        }
        if (this.teleportCooldown > 0) {
            --this.teleportCooldown;
        }
    }

    @Override
    protected void applyAnomalyEffects() {
        if (!this.isActive() || this.isContained() || !Config.enableWarpEffects) {
            return;
        }
        if (!Config.enableWarpTeleport) {
            return;
        }
        float teleportRadius = this.getTeleportRadius();
        AABB teleportBox = this.m_20191_().m_82400_((double)teleportRadius);
        List entitiesInRange = this.m_9236_().m_45933_((Entity)this, teleportBox);
        for (Entity entity : entitiesInRange) {
            Player player;
            UUID playerUUID;
            Integer playerCooldown;
            double distance = this.m_20270_(entity);
            if (distance <= (double)teleportRadius && this.teleportCooldown <= 0) {
                this.teleportEntity(entity);
                continue;
            }
            if (entity instanceof Player && (playerCooldown = this.playerCooldowns.get(playerUUID = (player = (Player)entity).m_20148_())) != null && playerCooldown <= 0) continue;
        }
    }

    private void teleportEntity(Entity entity) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.pairedGateStructureLocation != null) {
            Vec3 teleportPos = new Vec3((double)this.pairedGateStructureLocation.m_123341_() + 4.0, (double)(this.pairedGateStructureLocation.m_123342_() + 2), (double)this.pairedGateStructureLocation.m_123343_() + 0.5);
            this.performDirectTeleportation(entity, serverLevel, teleportPos);
            return;
        }
        WarpGateAnomalyEntity pairedGate = this.findAndPairWithUnpairedGate(serverLevel);
        if (pairedGate == null) {
            return;
        }
        Vec3 teleportPos = pairedGate.m_20182_().m_82520_(3.0, 1.0, 0.0);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_6021_(teleportPos.f_82479_, teleportPos.f_82480_, teleportPos.f_82481_);
        } else if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_6021_(teleportPos.f_82479_, teleportPos.f_82480_, teleportPos.f_82481_);
        } else {
            entity.m_6034_(teleportPos.f_82479_, teleportPos.f_82480_, teleportPos.f_82481_);
        }
        if (entity instanceof Player) {
            int cooldownMax;
            this.teleportCooldown = cooldownMax = this.getTeleportCooldownMax();
            pairedGate.teleportCooldown = cooldownMax;
        }
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11852_, SoundSource.AMBIENT, 1.0f, 1.5f);
        this.m_9236_().m_6263_(null, teleportPos.f_82479_, teleportPos.f_82480_, teleportPos.f_82481_, SoundEvents.f_11852_, SoundSource.AMBIENT, 1.0f, 1.5f);
        this.spawnTeleportParticles(this.m_20182_());
        this.spawnTeleportParticles(teleportPos);
    }

    private WarpGateAnomalyEntity findAndPairWithUnpairedGate(ServerLevel serverLevel) {
        Vec3 currentPos = this.m_20182_();
        try {
            TagKey warpGateTag = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("strangematter", "warp_gate_anomaly"));
            Random random = new Random();
            BlockPos currentPosBlock = this.m_20183_();
            for (int attempt = 0; attempt < 5; ++attempt) {
                int searchZ;
                double angle = random.nextDouble() * 2.0 * Math.PI;
                int distance = 1000 + random.nextInt(4000);
                int searchX = currentPosBlock.m_123341_() + (int)(Math.cos(angle) * (double)distance);
                BlockPos candidatePos = new BlockPos(searchX, 64, searchZ = currentPosBlock.m_123343_() + (int)(Math.sin(angle) * (double)distance));
                double actualDistance = Math.sqrt(currentPosBlock.m_123331_((Vec3i)candidatePos));
                if (actualDistance < 500.0) continue;
                int chunkX = candidatePos.m_123341_() >> 4;
                int chunkZ = candidatePos.m_123343_() >> 4;
                boolean chunkLoaded = ForgeChunkManager.forceChunk((ServerLevel)serverLevel, (String)"strangematter", (BlockPos)candidatePos, (int)chunkX, (int)chunkZ, (boolean)true, (boolean)true);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                int surfaceY = serverLevel.m_6924_(Heightmap.Types.WORLD_SURFACE, candidatePos.m_123341_(), candidatePos.m_123343_());
                BlockPos entitySpawnPos = new BlockPos(candidatePos.m_123341_(), surfaceY + 2, candidatePos.m_123343_());
                AABB searchArea = new AABB(entitySpawnPos).m_82377_(20.0, 10.0, 20.0);
                List nearbyGates = serverLevel.m_45976_(WarpGateAnomalyEntity.class, searchArea);
                if (!nearbyGates.isEmpty()) continue;
                BlockPos groundPos = new BlockPos(entitySpawnPos.m_123341_(), surfaceY, entitySpawnPos.m_123343_());
                RandomSource randomSource = serverLevel.m_213780_();
                WorldGenUtils.placeAnomalousGrassPatch((WorldGenLevel)serverLevel, groundPos, 5, 0.8f, randomSource);
                WorldGenUtils.placeAnomalyOres((WorldGenLevel)serverLevel, groundPos, 5, randomSource, (Block)StrangeMatterMod.SPATIAL_SHARD_ORE_BLOCK.get());
                WarpGateAnomalyEntity newWarpGate = (WarpGateAnomalyEntity)((EntityType)StrangeMatterMod.WARP_GATE_ANOMALY_ENTITY.get()).m_20615_((Level)serverLevel);
                if (newWarpGate == null) continue;
                newWarpGate.m_6034_((double)entitySpawnPos.m_123341_() + 0.5, entitySpawnPos.m_123342_() + 1, (double)entitySpawnPos.m_123343_() + 0.5);
                newWarpGate.setActive(true);
                serverLevel.m_7967_((Entity)newWarpGate);
                return this.pairWithGate(newWarpGate);
            }
            WarpGateRegistry.WarpGateEntry unpairedEntry = WarpGateRegistry.findUnpairedWarpGate(this.m_9236_(), currentPos, 100.0);
            if (unpairedEntry != null) {
                BlockPos searchPos = new BlockPos((int)unpairedEntry.position.f_82479_, (int)unpairedEntry.position.f_82480_, (int)unpairedEntry.position.f_82481_);
                List allGates = serverLevel.m_45976_(WarpGateAnomalyEntity.class, new AABB(searchPos).m_82377_(50.0, 50.0, 50.0));
                WarpGateAnomalyEntity foundGate = null;
                for (WarpGateAnomalyEntity gate : allGates) {
                    if (!gate.m_20148_().equals(unpairedEntry.uuid)) continue;
                    foundGate = gate;
                    break;
                }
                if (foundGate != null) {
                    return this.pairWithGate(foundGate);
                }
            }
            return null;
        }
        catch (Exception e) {
            System.err.println("WarpGate: Error during structure search: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private WarpGateAnomalyEntity pairWithGate(WarpGateAnomalyEntity foundGate) {
        BlockPos thisPos = this.m_20183_();
        BlockPos otherPos = foundGate.m_20183_();
        this.setPairedGateStructureLocation(otherPos);
        foundGate.setPairedGateStructureLocation(thisPos);
        WarpGateRegistry.markWarpGateAsPaired(this.m_20148_());
        WarpGateRegistry.markWarpGateAsPaired(foundGate.m_20148_());
        return foundGate;
    }

    private WarpGateAnomalyEntity findExistingWarpGateAtStructureLocation(ServerLevel serverLevel, BlockPos structurePos) {
        int chunkX = structurePos.m_123341_() >> 4;
        int chunkZ = structurePos.m_123343_() >> 4;
        boolean success = ForgeChunkManager.forceChunk((ServerLevel)serverLevel, (String)"strangematter", (BlockPos)structurePos, (int)chunkX, (int)chunkZ, (boolean)true, (boolean)true);
        AABB searchBox = new AABB(structurePos).m_82377_(50.0, 400.0, 50.0);
        List entities = serverLevel.m_45976_(WarpGateAnomalyEntity.class, searchBox);
        if (!entities.isEmpty()) {
            ForgeChunkManager.forceChunk((ServerLevel)serverLevel, (String)"strangematter", (BlockPos)structurePos, (int)chunkX, (int)chunkZ, (boolean)false, (boolean)false);
            return (WarpGateAnomalyEntity)((Object)entities.get(0));
        }
        ForgeChunkManager.forceChunk((ServerLevel)serverLevel, (String)"strangematter", (BlockPos)structurePos, (int)chunkX, (int)chunkZ, (boolean)false, (boolean)false);
        return null;
    }

    private void spawnTeleportParticles(Vec3 pos) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        for (int i = 0; i < 20; ++i) {
            double x = pos.f_82479_ + (this.m_9236_().f_46441_.m_188500_() - 0.5) * 2.0;
            double y = pos.f_82480_ + this.m_9236_().f_46441_.m_188500_() * 2.0;
            double z = pos.f_82481_ + (this.m_9236_().f_46441_.m_188500_() - 0.5) * 2.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.1, this.m_9236_().f_46441_.m_188500_() * 0.1, (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.1);
        }
    }

    private void performDirectTeleportation(Entity entity, ServerLevel serverLevel, Vec3 teleportPos) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_6021_(teleportPos.f_82479_, teleportPos.f_82480_, teleportPos.f_82481_);
        } else if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_6021_(teleportPos.f_82479_, teleportPos.f_82480_, teleportPos.f_82481_);
        } else {
            entity.m_6034_(teleportPos.f_82479_, teleportPos.f_82480_, teleportPos.f_82481_);
        }
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11852_, SoundSource.AMBIENT, 1.0f, 1.5f);
        this.m_9236_().m_6263_(null, teleportPos.f_82479_, teleportPos.f_82480_, teleportPos.f_82481_, SoundEvents.f_11852_, SoundSource.AMBIENT, 1.0f, 1.5f);
        this.spawnTeleportParticles(this.m_20182_());
        this.spawnTeleportParticles(teleportPos);
    }

    private BlockPos findStructureLocationForPairedGate(ServerLevel serverLevel, UUID pairedUUID) {
        Entity pairedEntity = serverLevel.m_8791_(pairedUUID);
        if (pairedEntity instanceof WarpGateAnomalyEntity) {
            WarpGateAnomalyEntity pairedGate = (WarpGateAnomalyEntity)pairedEntity;
            return pairedGate.m_20183_();
        }
        return null;
    }

    private WarpGateAnomalyEntity findPairedGate(ServerLevel level) {
        if (this.pairedGateUUID == null) {
            return null;
        }
        Entity entity = level.m_8791_(this.pairedGateUUID);
        if (entity instanceof WarpGateAnomalyEntity) {
            WarpGateAnomalyEntity warpGate = (WarpGateAnomalyEntity)entity;
            return warpGate;
        }
        if (entity != null) {
            // empty if block
        }
        return null;
    }

    @Override
    protected void spawnParticles() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.tickCount % 2 == 0) {
            double radius = 4.0;
            double angle = (double)this.tickCount * 0.1 % (Math.PI * 2);
            double x = this.m_20185_() + Math.cos(angle) * radius;
            double z = this.m_20189_() + Math.sin(angle) * radius;
            double y = this.m_20186_() + 0.5;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, -Math.sin(angle) * 0.1, 0.05, Math.cos(angle) * 0.1);
        }
        if (this.tickCount % 5 == 0) {
            for (int i = 0; i < 3; ++i) {
                double angle = ((double)this.tickCount * 0.05 + (double)i * Math.PI * 2.0 / 3.0) % (Math.PI * 2);
                double radius = 1.0 + Math.sin((double)this.tickCount * 0.1) * 0.5;
                double x = this.m_20185_() + Math.cos(angle) * radius;
                double z = this.m_20189_() + Math.sin(angle) * radius;
                double y = this.m_20186_() + 0.5;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, 0.0, 0.1, 0.0);
            }
        }
        if (this.tickCount % 10 == 0) {
            double x = this.m_20185_() + (this.m_9236_().f_46441_.m_188500_() - 0.5) * 2.0;
            double y = this.m_20186_() + this.m_9236_().f_46441_.m_188500_() * 2.0;
            double z = this.m_20189_() + (this.m_9236_().f_46441_.m_188500_() - 0.5) * 2.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123789_, x, y, z, (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.2, this.m_9236_().f_46441_.m_188500_() * 0.2, (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.2);
        }
    }

    @Override
    protected void updateClientEffects() {
    }

    @Override
    public ResourceLocation getAnomalySound() {
        return ((SoundEvent)StrangeMatterSounds.WARP_GATE_LOOP.get()).m_11660_();
    }

    @Override
    protected ResearchType getResearchType() {
        return ResearchType.SPACE;
    }

    @Override
    protected String getAnomalyName() {
        return "WarpGate";
    }

    public String getPairedGateId() {
        return (String)this.f_19804_.m_135370_(PAIRED_GATE_ID);
    }

    public void setPairedGateId(String gateId) {
        this.f_19804_.m_135381_(PAIRED_GATE_ID, (Object)gateId);
    }

    public void setPairedGateStructureLocation(BlockPos location) {
        this.pairedGateStructureLocation = location;
    }

    @Override
    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(IS_ACTIVE);
    }

    public void setActive(boolean active) {
        this.f_19804_.m_135381_(IS_ACTIVE, (Object)active);
    }

    public UUID getPairedGateUUID() {
        return this.pairedGateUUID;
    }

    public void setPairedGateUUID(UUID uuid) {
        this.pairedGateUUID = uuid;
    }

    public float getAuraRadius() {
        return 4.0f;
    }

    public SoundEvent getAmbientSound() {
        return SoundEvents.f_12286_;
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("PairedGateId")) {
            this.f_19804_.m_135381_(PAIRED_GATE_ID, (Object)compound.m_128461_("PairedGateId"));
        }
        if (compound.m_128441_("IsActive")) {
            this.f_19804_.m_135381_(IS_ACTIVE, (Object)compound.m_128471_("IsActive"));
        }
        if (compound.m_128441_("PairedGateUUID")) {
            this.pairedGateUUID = compound.m_128342_("PairedGateUUID");
        }
        if (compound.m_128441_("TeleportCooldown")) {
            this.teleportCooldown = compound.m_128451_("TeleportCooldown");
        }
        if (compound.m_128441_("PairedGateStructureLocation")) {
            CompoundTag posTag = compound.m_128469_("PairedGateStructureLocation");
            this.pairedGateStructureLocation = new BlockPos(posTag.m_128451_("x"), posTag.m_128451_("y"), posTag.m_128451_("z"));
        }
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("PairedGateId", (String)this.f_19804_.m_135370_(PAIRED_GATE_ID));
        compound.m_128379_("IsActive", ((Boolean)this.f_19804_.m_135370_(IS_ACTIVE)).booleanValue());
        if (this.pairedGateUUID != null) {
            compound.m_128362_("PairedGateUUID", this.pairedGateUUID);
        }
        compound.m_128405_("TeleportCooldown", this.teleportCooldown);
        if (this.pairedGateStructureLocation != null) {
            CompoundTag posTag = new CompoundTag();
            posTag.m_128405_("x", this.pairedGateStructureLocation.m_123341_());
            posTag.m_128405_("y", this.pairedGateStructureLocation.m_123342_());
            posTag.m_128405_("z", this.pairedGateStructureLocation.m_123343_());
            compound.m_128365_("PairedGateStructureLocation", (Tag)posTag);
        }
    }
}

