/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.entity;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.entity.BaseAnomalyEntity;
import com.hexvane.strangematter.network.MobDisguiseSyncPacket;
import com.hexvane.strangematter.network.NetworkHandler;
import com.hexvane.strangematter.research.ResearchType;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PacketDistributor;

public class ThoughtwellEntity
extends BaseAnomalyEntity {
    private static final EntityDataAccessor<Boolean> IS_ACTIVE = SynchedEntityData.m_135353_(ThoughtwellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int NAUSEA_COOLDOWN = 100;
    private static final int CONFUSION_COOLDOWN = 200;
    private static final int PARTICLE_BURST_COOLDOWN = 40;
    private static final int RUNIC_PARTICLE_COOLDOWN = 60;
    private static final Map<UUID, String> DISGUISE_MAP = new ConcurrentHashMap<UUID, String>();
    private static final Map<UUID, Integer> DISGUISE_DURATION_MAP = new ConcurrentHashMap<UUID, Integer>();
    private static final String[] DISGUISE_TYPES = new String[]{"minecraft:chicken", "minecraft:cow", "minecraft:pig", "minecraft:sheep", "minecraft:villager", "minecraft:zombie", "minecraft:skeleton", "minecraft:spider", "minecraft:creeper", "minecraft:enderman", "minecraft:witch", "minecraft:slime", "minecraft:husk", "minecraft:stray", "minecraft:cave_spider", "minecraft:silverfish", "minecraft:endermite", "minecraft:magma_cube", "minecraft:blaze"};
    private int nauseaCooldown = 0;
    private int confusionCooldown = 0;
    private int particleBurstCooldown = 0;
    private int runicParticleCooldown = 0;

    private float getThoughtwellEffectRadius() {
        return (float)Config.thoughtwellEffectRadius;
    }

    @Override
    protected float getEffectRadius() {
        return this.getThoughtwellEffectRadius();
    }

    private int getConfusionDuration() {
        return Config.thoughtwellConfusionDuration;
    }

    public ThoughtwellEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.m_20011_(new AABB(-1.0, 0.0, -1.0, 1.0, 2.0, 1.0));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ACTIVE, (Object)true);
    }

    @Override
    protected void updatePulseAnimation() {
        float time = (float)(this.tickCount % 100) / 100.0f;
        float pulseIntensity = (float)(0.4 + 0.6 * Math.sin((double)(time * 2.0f) * Math.PI));
        this.setPulseIntensity(pulseIntensity);
    }

    @Override
    protected void applyAnomalyEffects() {
        if (!this.isActive() || this.isContained() || !Config.enableThoughtwellEffects) {
            return;
        }
        if (this.nauseaCooldown > 0) {
            --this.nauseaCooldown;
        }
        if (this.confusionCooldown > 0) {
            --this.confusionCooldown;
        }
        if (this.particleBurstCooldown > 0) {
            --this.particleBurstCooldown;
        }
        if (this.runicParticleCooldown > 0) {
            --this.runicParticleCooldown;
        }
        this.updateDisguiseDurations();
        if (this.nauseaCooldown <= 0 && Config.enableThoughtwellNausea) {
            this.affectNearbyPlayers();
        }
        if (this.confusionCooldown <= 0 && Config.enableThoughtwellMobDisguise) {
            this.confuseNearbyMobs();
        }
        if (this.particleBurstCooldown <= 0) {
            this.createCyanBurst();
        }
        if (this.runicParticleCooldown <= 0) {
            this.createRunicParticles();
        }
    }

    private void affectNearbyPlayers() {
        float effectRadius = this.getThoughtwellEffectRadius();
        AABB effectBox = new AABB(this.m_20185_() - (double)effectRadius, this.m_20186_() - (double)effectRadius, this.m_20189_() - (double)effectRadius, this.m_20185_() + (double)effectRadius, this.m_20186_() + (double)effectRadius, this.m_20189_() + (double)effectRadius);
        List entitiesInRange = this.m_9236_().m_45933_((Entity)this, effectBox);
        boolean foundPlayer = false;
        for (Entity entity : entitiesInRange) {
            Player player;
            double distance;
            if (!(entity instanceof Player) || !((distance = (double)this.m_20270_((Entity)(player = (Player)entity))) <= (double)effectRadius) || player.m_6844_(EquipmentSlot.HEAD).m_41720_() == StrangeMatterMod.TINFOIL_HAT.get()) continue;
            float intensity = 1.0f - (float)(distance / (double)effectRadius);
            int duration = 100 + (int)(intensity * 100.0f);
            int amplifier = intensity > 0.7f ? 1 : 0;
            player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, duration, amplifier, false, true));
            foundPlayer = true;
        }
        if (foundPlayer) {
            this.nauseaCooldown = 100;
        }
    }

    private void confuseNearbyMobs() {
        float effectRadius = this.getThoughtwellEffectRadius();
        AABB confusionBox = new AABB(this.m_20185_() - (double)effectRadius, this.m_20186_() - (double)effectRadius, this.m_20189_() - (double)effectRadius, this.m_20185_() + (double)effectRadius, this.m_20186_() + (double)effectRadius, this.m_20189_() + (double)effectRadius);
        List entitiesInRange = this.m_9236_().m_45933_((Entity)this, confusionBox);
        boolean foundMob = false;
        for (Entity entity : entitiesInRange) {
            double distance;
            if (!(entity instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            if (entity instanceof Player || !((distance = (double)this.m_20270_((Entity)mob)) <= (double)effectRadius)) continue;
            this.confuseMob(mob);
            foundMob = true;
        }
        if (foundMob) {
            this.confusionCooldown = 200;
        }
    }

    private void confuseMob(Mob mob) {
        int confusionDuration = this.getConfusionDuration();
        mob.m_7292_(new MobEffectInstance(MobEffects.f_19604_, confusionDuration, 0, false, true));
        this.applyCognitiveDisguise(mob);
        this.m_9236_().m_5594_(null, mob.m_20183_(), SoundEvents.f_144243_, SoundSource.AMBIENT, 0.5f, 0.8f);
        if (mob.m_5448_() != null && this.m_9236_().m_213780_().m_188501_() < 0.3f) {
            mob.m_6710_(null);
        }
    }

    private void createCyanBurst() {
        double radius = (double)this.getThoughtwellEffectRadius() * 0.8;
        int particleCount = 12 + this.m_9236_().m_213780_().m_188503_(8);
        for (int i = 0; i < particleCount; ++i) {
            double angle = this.m_9236_().m_213780_().m_188500_() * 2.0 * Math.PI;
            double distance = this.m_9236_().m_213780_().m_188500_() * radius;
            double height = (this.m_9236_().m_213780_().m_188500_() - 0.5) * 2.0;
            double x = this.m_20185_() + Math.cos(angle) * distance;
            double z = this.m_20189_() + Math.sin(angle) * distance;
            double y = this.m_20186_() + height;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, x, y, z, (this.m_9236_().m_213780_().m_188500_() - 0.5) * 0.2, (this.m_9236_().m_213780_().m_188500_() - 0.5) * 0.2, (this.m_9236_().m_213780_().m_188500_() - 0.5) * 0.2);
        }
        this.particleBurstCooldown = 40;
    }

    private void createRunicParticles() {
        int runeCount = 6 + this.m_9236_().m_213780_().m_188503_(4);
        for (int i = 0; i < runeCount; ++i) {
            double angle = (double)i * Math.PI * 2.0 / (double)runeCount + (double)this.tickCount * 0.02;
            double radius = 2.0 + this.m_9236_().m_213780_().m_188500_() * 1.5;
            double height = (this.m_9236_().m_213780_().m_188500_() - 0.5) * 2.0;
            double x = this.m_20185_() + Math.cos(angle) * radius;
            double z = this.m_20189_() + Math.sin(angle) * radius;
            double y = this.m_20186_() + height;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, Math.cos(angle + 1.5707963267948966) * 0.05, 0.1, Math.sin(angle + 1.5707963267948966) * 0.05);
        }
        this.runicParticleCooldown = 60;
    }

    @Override
    protected void spawnParticles() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.tickCount % 20 == 0) {
            this.spawnEnchantRingParticles(serverLevel);
        }
        if (this.m_9236_().m_213780_().m_188501_() < 0.1f) {
            this.spawnRandomEnchantSphereParticles(serverLevel);
        }
    }

    private void spawnEnchantRingParticles(ServerLevel serverLevel) {
        int ringCount = 12;
        for (int i = 0; i < ringCount; ++i) {
            double angle = (double)i * Math.PI * 2.0 / (double)ringCount + (double)this.tickCount * 0.02;
            double radius = 2.8;
            double height = Math.sin((double)this.tickCount * 0.05 + (double)i) * 0.6;
            double x = this.m_20185_() + Math.cos(angle) * radius;
            double z = this.m_20189_() + Math.sin(angle) * radius;
            double y = this.m_20186_() + height;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123809_, x, y, z, 1, Math.cos(angle + 1.5707963267948966) * 0.01, 0.02, Math.sin(angle + 1.5707963267948966) * 0.01, 0.0);
        }
    }

    private void spawnRandomEnchantSphereParticles(ServerLevel serverLevel) {
        for (int i = 0; i < 2; ++i) {
            double offsetX = (this.m_9236_().m_213780_().m_188500_() - 0.5) * 6.0;
            double offsetY = (this.m_9236_().m_213780_().m_188500_() - 0.5) * 4.0;
            double offsetZ = (this.m_9236_().m_213780_().m_188500_() - 0.5) * 6.0;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123809_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void updateClientEffects() {
    }

    @Override
    public ResourceLocation getAnomalySound() {
        return ((SoundEvent)StrangeMatterSounds.THOUGHTWELL_LOOP.get()).m_11660_();
    }

    @Override
    protected ResearchType getResearchType() {
        return ResearchType.COGNITION;
    }

    @Override
    protected String getAnomalyName() {
        return "Thoughtwell";
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"entity.strangematter.thoughtwell");
    }

    public static String getDisguiseType(UUID entityUUID) {
        return DISGUISE_MAP.get(entityUUID);
    }

    public static int getDisguiseDuration(UUID entityUUID) {
        return DISGUISE_DURATION_MAP.getOrDefault(entityUUID, 0);
    }

    public static boolean hasDisguise(UUID entityUUID) {
        return DISGUISE_MAP.containsKey(entityUUID);
    }

    public static void removeDisguise(UUID entityUUID) {
        DISGUISE_MAP.remove(entityUUID);
        DISGUISE_DURATION_MAP.remove(entityUUID);
    }

    public static void setDisguise(UUID entityUUID, String disguiseType, int duration) {
        DISGUISE_MAP.put(entityUUID, disguiseType);
        DISGUISE_DURATION_MAP.put(entityUUID, duration);
    }

    private void updateDisguiseDurations() {
        Iterator<Map.Entry<UUID, Integer>> iterator = DISGUISE_DURATION_MAP.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, Integer> entry = iterator.next();
            int duration = entry.getValue() - 1;
            if (duration <= 0) {
                UUID uuid = entry.getKey();
                DISGUISE_MAP.remove(uuid);
                iterator.remove();
                if (!(this.m_9236_() instanceof ServerLevel)) continue;
                MobDisguiseSyncPacket packet = new MobDisguiseSyncPacket(uuid);
                NetworkHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)packet);
                continue;
            }
            entry.setValue(duration);
        }
    }

    private void applyCognitiveDisguise(Mob mob) {
        Level level;
        if (DISGUISE_MAP.containsKey(mob.m_20148_())) {
            return;
        }
        String disguiseType = DISGUISE_TYPES[this.m_9236_().m_213780_().m_188503_(DISGUISE_TYPES.length)];
        int duration = 2400;
        DISGUISE_MAP.put(mob.m_20148_(), disguiseType);
        DISGUISE_DURATION_MAP.put(mob.m_20148_(), duration);
        if (this.m_9236_() instanceof ServerLevel) {
            MobDisguiseSyncPacket packet = new MobDisguiseSyncPacket(mob.m_20148_(), disguiseType, duration);
            NetworkHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)packet);
        }
        if ((level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 8; ++i) {
                double offsetX = (this.m_9236_().m_213780_().m_188500_() - 0.5) * 3.0;
                double offsetY = this.m_9236_().m_213780_().m_188500_() * 2.0;
                double offsetZ = (this.m_9236_().m_213780_().m_188500_() - 0.5) * 3.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123809_, mob.m_20185_() + offsetX, mob.m_20186_() + offsetY, mob.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(IS_ACTIVE);
    }

    public void setActive(boolean active) {
        this.f_19804_.m_135381_(IS_ACTIVE, (Object)active);
    }
}

