/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.entity;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.entity.BaseAnomalyEntity;
import com.hexvane.strangematter.research.ResearchType;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TemporalBloomEntity
extends BaseAnomalyEntity {
    private static final EntityDataAccessor<Boolean> IS_ACTIVE = SynchedEntityData.m_135353_(TemporalBloomEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int PARTICLE_BURST_COOLDOWN = 40;
    private int cropEffectCooldown = 0;
    private int mobTransformCooldown = 0;
    private int particleBurstCooldown = 0;

    private float getTemporalEffectRadius() {
        return (float)Config.temporalEffectRadius;
    }

    @Override
    protected float getEffectRadius() {
        return this.getTemporalEffectRadius();
    }

    private int getCropCooldownMax() {
        return Config.temporalCropCooldown;
    }

    private int getMobCooldownMax() {
        return Config.temporalMobCooldown;
    }

    private int getCropGrowthStages() {
        return Config.temporalCropGrowthStages;
    }

    public TemporalBloomEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ACTIVE, (Object)true);
    }

    @Override
    protected void updatePulseAnimation() {
        float time = (float)(this.tickCount % 80) / 80.0f;
        float pulseIntensity = (float)(0.3 + 0.7 * Math.sin((double)(time * 2.0f) * Math.PI));
        this.setPulseIntensity(pulseIntensity);
    }

    @Override
    protected void applyAnomalyEffects() {
        if (!this.isActive() || this.isContained() || !Config.enableTemporalEffects) {
            return;
        }
        if (this.cropEffectCooldown > 0) {
            --this.cropEffectCooldown;
        }
        if (this.mobTransformCooldown > 0) {
            --this.mobTransformCooldown;
        }
        if (this.particleBurstCooldown > 0) {
            --this.particleBurstCooldown;
        }
        if (this.cropEffectCooldown <= 0 && Config.enableTemporalCropGrowth) {
            this.affectNearbyCrops();
        }
        if (this.mobTransformCooldown <= 0 && Config.enableTemporalMobTransform) {
            this.transformNearbyMobs();
        }
        if (this.particleBurstCooldown <= 0) {
            this.createTemporalBurst();
        }
    }

    private void affectNearbyCrops() {
        BlockPos center = this.m_20183_();
        float effectRadius = this.getTemporalEffectRadius();
        int x = (int)(-effectRadius);
        while ((float)x <= effectRadius) {
            int z = (int)(-effectRadius);
            while ((float)z <= effectRadius) {
                double distance = Math.sqrt(x * x + z * z);
                if (distance <= (double)effectRadius) {
                    BlockPos pos = center.m_7918_(x, 0, z);
                    for (int y = -2; y <= 2; ++y) {
                        BlockPos cropPos = pos.m_7918_(0, y, 0);
                        BlockState state = this.m_9236_().m_8055_(cropPos);
                        Block block = state.m_60734_();
                        if (!(block instanceof CropBlock)) continue;
                        CropBlock cropBlock = (CropBlock)block;
                        this.affectCrop(cropPos, state, cropBlock);
                    }
                }
                ++z;
            }
            ++x;
        }
        this.cropEffectCooldown = this.getCropCooldownMax();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void affectCrop(BlockPos pos, BlockState state, CropBlock cropBlock) {
        IntegerProperty ageProperty = null;
        try {
            Method getAgePropertyMethod = CropBlock.class.getDeclaredMethod("getAgeProperty", new Class[0]);
            getAgePropertyMethod.setAccessible(true);
            ageProperty = (IntegerProperty)getAgePropertyMethod.invoke((Object)cropBlock, new Object[0]);
        }
        catch (Exception e) {
            for (Property property : state.m_61147_()) {
                if (!(property instanceof IntegerProperty) || !property.m_61708_().equals("age")) continue;
                ageProperty = (IntegerProperty)property;
                break;
            }
        }
        if (ageProperty == null) {
            return;
        }
        int currentAge = (Integer)state.m_61143_(ageProperty);
        int maxAge = cropBlock.m_7419_();
        RandomSource random = this.m_9236_().m_213780_();
        int ageChange = 0;
        int maxStages = this.getCropGrowthStages();
        ageChange = random.m_188499_() ? 1 + random.m_188503_(maxStages) : -(1 + random.m_188503_(maxStages));
        int newAge = Math.max(0, Math.min(maxAge, currentAge + ageChange));
        if (newAge != currentAge) {
            BlockState newState = (BlockState)state.m_61124_((Property)ageProperty, (Comparable)Integer.valueOf(newAge));
            this.m_9236_().m_7731_(pos, newState, 3);
            this.spawnTemporalParticles((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 8);
            this.spawnBlockEffectParticles(pos);
            this.m_9236_().m_5594_(null, pos, SoundEvents.f_144243_, SoundSource.AMBIENT, 0.6f, 1.2f);
        }
    }

    private void transformNearbyMobs() {
        float effectRadius = this.getTemporalEffectRadius();
        AABB transformBox = this.m_20191_().m_82400_((double)effectRadius);
        List entitiesInRange = this.m_9236_().m_45933_((Entity)this, transformBox);
        boolean foundTarget = false;
        for (Entity entity : entitiesInRange) {
            double distance;
            if (!(entity instanceof LivingEntity) || entity instanceof Player || !((distance = (double)this.m_20270_(entity)) <= (double)effectRadius)) continue;
            this.transformMob((LivingEntity)entity);
            foundTarget = true;
        }
        if (foundTarget) {
            this.mobTransformCooldown = this.getMobCooldownMax();
        }
    }

    private void transformMob(LivingEntity mob) {
        if (mob instanceof Animal) {
            Animal animal = (Animal)mob;
            if (animal.m_6162_()) {
                animal.m_146762_(0);
                this.spawnTemporalParticles(mob.m_20185_(), mob.m_20186_() + 1.0, mob.m_20189_(), 10);
                this.spawnEntityEffectParticles(mob);
                this.m_9236_().m_5594_(null, mob.m_20183_(), SoundEvents.f_144243_, SoundSource.AMBIENT, 0.8f, 1.5f);
            } else {
                animal.m_146762_(-24000);
                this.spawnTemporalParticles(mob.m_20185_(), mob.m_20186_() + 1.0, mob.m_20189_(), 10);
                this.spawnEntityEffectParticles(mob);
                this.m_9236_().m_5594_(null, mob.m_20183_(), SoundEvents.f_144243_, SoundSource.AMBIENT, 0.8f, 0.8f);
            }
        } else if (mob instanceof Monster) {
            this.spawnTemporalParticles(mob.m_20185_(), mob.m_20186_() + 1.0, mob.m_20189_(), 8);
            this.spawnEntityEffectParticles(mob);
            this.m_9236_().m_5594_(null, mob.m_20183_(), SoundEvents.f_144243_, SoundSource.AMBIENT, 0.6f, 1.0f);
            this.createTemporalDistortion(mob);
        }
    }

    private void createTemporalDistortion(LivingEntity mob) {
        Vec3 mobPos = mob.m_20182_();
        for (int i = 0; i < 12; ++i) {
            double angle = (double)i * Math.PI * 2.0 / 12.0;
            double radius = 1.5;
            double x = mobPos.f_82479_ + Math.cos(angle) * radius;
            double z = mobPos.f_82481_ + Math.sin(angle) * radius;
            double y = mobPos.f_82480_ + 1.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, (Math.random() - 0.5) * 0.1, 0.1, (Math.random() - 0.5) * 0.1);
        }
    }

    private void createTemporalBurst() {
        double radius = (double)this.getTemporalEffectRadius() * 0.8;
        int particleCount = 15 + this.m_9236_().m_213780_().m_188503_(10);
        for (int i = 0; i < particleCount; ++i) {
            double angle = this.m_9236_().m_213780_().m_188500_() * 2.0 * Math.PI;
            double distance = this.m_9236_().m_213780_().m_188500_() * radius;
            double height = (this.m_9236_().m_213780_().m_188500_() - 0.5) * 3.0;
            double x = this.m_20185_() + Math.cos(angle) * distance;
            double z = this.m_20189_() + Math.sin(angle) * distance;
            double y = this.m_20186_() + height;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, (this.m_9236_().m_213780_().m_188500_() - 0.5) * 0.2, (this.m_9236_().m_213780_().m_188500_() - 0.5) * 0.2, (this.m_9236_().m_213780_().m_188500_() - 0.5) * 0.2);
        }
        this.particleBurstCooldown = 40;
    }

    @Override
    protected void spawnParticles() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.tickCount % 1 == 0) {
            this.spawnFloatingCrystals();
        }
        if (this.tickCount % 15 == 0) {
            this.spawnEnergyRipples();
        }
        if (this.tickCount % 8 == 0) {
            this.spawnAuraParticles();
        }
    }

    private void spawnFloatingCrystals() {
        double radius = 2.0 + this.m_9236_().m_213780_().m_188500_() * 2.0;
        double angle = (double)this.tickCount * 0.05 + this.m_9236_().m_213780_().m_188500_() * 0.5;
        double x = this.m_20185_() + Math.cos(angle) * radius;
        double z = this.m_20189_() + Math.sin(angle) * radius;
        double y = this.m_20186_() + (this.m_9236_().m_213780_().m_188500_() - 0.5) * 2.0;
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, Math.cos(angle + 1.5707963267948966) * 0.05, 0.1, Math.sin(angle + 1.5707963267948966) * 0.05);
    }

    private void spawnEnergyRipples() {
        double rippleRadius = (double)(this.tickCount % 60) * 0.2;
        if (rippleRadius > (double)this.getTemporalEffectRadius()) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            double angle = (double)i * Math.PI * 2.0 / 8.0;
            double x = this.m_20185_() + Math.cos(angle) * rippleRadius;
            double z = this.m_20189_() + Math.sin(angle) * rippleRadius;
            double y = this.m_20186_() + Math.sin((double)this.tickCount * 0.1) * 0.5;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, x, y, z, 0.0, 0.05, 0.0);
        }
    }

    private void spawnAuraParticles() {
        double auraRadius = 1.0;
        for (int i = 0; i < 6; ++i) {
            double angle = (double)this.tickCount * 0.03 + (double)i * Math.PI / 3.0;
            double x = this.m_20185_() + Math.cos(angle) * auraRadius;
            double z = this.m_20189_() + Math.sin(angle) * auraRadius;
            double y = this.m_20186_() + Math.sin((double)this.tickCount * 0.08) * 0.3;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, 0.0, 0.02, 0.0);
        }
    }

    private void spawnTemporalParticles(double x, double y, double z, int count) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < count; ++i) {
                double offsetX = (this.m_9236_().m_213780_().m_188500_() - 0.5) * 1.0;
                double offsetY = this.m_9236_().m_213780_().m_188500_() * 1.0;
                double offsetZ = (this.m_9236_().m_213780_().m_188500_() - 0.5) * 1.0;
                if (i % 2 != 0) continue;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, x + offsetX, y + offsetY, z + offsetZ, 1, (this.m_9236_().m_213780_().m_188500_() - 0.5) * 0.2, (this.m_9236_().m_213780_().m_188500_() - 0.5) * 0.2, (this.m_9236_().m_213780_().m_188500_() - 0.5) * 0.2, 0.0);
            }
        }
    }

    private void spawnBlockEffectParticles(BlockPos pos) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 4; ++i) {
                double x = (double)pos.m_123341_() + 0.5 + (this.m_9236_().m_213780_().m_188500_() - 0.5) * 1.0;
                double z = (double)pos.m_123343_() + 0.5 + (this.m_9236_().m_213780_().m_188500_() - 0.5) * 1.0;
                double y = (double)pos.m_123342_() + 0.5 + this.m_9236_().m_213780_().m_188500_() * 0.5;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, 1, (this.m_9236_().m_213780_().m_188500_() - 0.5) * 0.1, 0.1, (this.m_9236_().m_213780_().m_188500_() - 0.5) * 0.1, 0.0);
            }
        }
    }

    private void spawnEntityEffectParticles(LivingEntity entity) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 6; ++i) {
                double x = entity.m_20185_() + (this.m_9236_().m_213780_().m_188500_() - 0.5) * (double)entity.m_20205_();
                double z = entity.m_20189_() + (this.m_9236_().m_213780_().m_188500_() - 0.5) * (double)entity.m_20205_();
                double y = entity.m_20186_() + (double)entity.m_20206_() * 0.5 + (this.m_9236_().m_213780_().m_188500_() - 0.5) * (double)entity.m_20206_();
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, 1, (this.m_9236_().m_213780_().m_188500_() - 0.5) * 0.1, 0.1, (this.m_9236_().m_213780_().m_188500_() - 0.5) * 0.1, 0.0);
            }
        }
    }

    @Override
    protected void updateClientEffects() {
    }

    @Override
    public ResourceLocation getAnomalySound() {
        return ((SoundEvent)StrangeMatterSounds.TEMPORAL_BLOOM_LOOP.get()).m_11660_();
    }

    @Override
    protected ResearchType getResearchType() {
        return ResearchType.TIME;
    }

    @Override
    protected String getAnomalyName() {
        return "Temporal Bloom";
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"entity.strangematter.temporal_bloom");
    }

    @Override
    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(IS_ACTIVE);
    }

    public void setActive(boolean active) {
        this.f_19804_.m_135381_(IS_ACTIVE, (Object)active);
    }
}

