/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.entity;

import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MiniWarpGateEntity
extends Entity {
    private static final EntityDataAccessor<Float> ROTATION = SynchedEntityData.m_135353_(MiniWarpGateEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> IS_ACTIVE = SynchedEntityData.m_135353_(MiniWarpGateEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> PAIRED_GATE_ID = SynchedEntityData.m_135353_(MiniWarpGateEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> IS_PURPLE_PORTAL = SynchedEntityData.m_135353_(MiniWarpGateEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final float TELEPORT_RADIUS = 1.0f;
    private static final float AURA_RADIUS = 2.0f;
    private static final int TELEPORT_COOLDOWN = 40;
    private static final int MAX_LIFETIME = 12000;
    private float rotationSpeed = 0.5f;
    private int tickCount = 0;
    private int teleportCooldown = 0;
    private UUID ownerUUID;
    private UUID pairedGateUUID;
    private boolean hasBeenManaged = false;
    private boolean isPurplePortal = false;

    public MiniWarpGateEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.m_20242_(true);
        this.m_20331_(true);
        this.m_20011_(new AABB(-0.5, 0.0, -0.5, 0.5, 2.0, 0.5));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ROTATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(IS_ACTIVE, (Object)true);
        this.f_19804_.m_135372_(PAIRED_GATE_ID, (Object)"");
        this.f_19804_.m_135372_(IS_PURPLE_PORTAL, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.tickCount;
        if (!this.m_9236_().f_46443_) {
            this.updateRotation();
            this.updateTeleportation();
            this.manageWarpGates();
            if (this.tickCount > 12000) {
                this.m_146870_();
                return;
            }
            if (this.teleportCooldown > 0) {
                --this.teleportCooldown;
            }
        }
    }

    private void updateRotation() {
        float currentRotation = ((Float)this.f_19804_.m_135370_(ROTATION)).floatValue();
        float newRotation = currentRotation + this.rotationSpeed;
        if (newRotation >= 360.0f) {
            newRotation -= 360.0f;
        }
        this.f_19804_.m_135381_(ROTATION, (Object)Float.valueOf(newRotation));
    }

    private void updateTeleportation() {
        if (!this.isActive() || this.teleportCooldown > 0) {
            return;
        }
        AABB teleportBox = this.m_20191_().m_82400_(1.0);
        List entitiesInRange = this.m_9236_().m_45933_((Entity)this, teleportBox);
        for (Entity entity : entitiesInRange) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            double distance = this.m_20270_(entity);
            if (!(distance <= 1.0)) continue;
            this.teleportEntity(livingEntity);
            break;
        }
    }

    private void teleportEntity(LivingEntity entity) {
        MiniWarpGateEntity pairedGate = this.getPairedGate();
        if (pairedGate != null && pairedGate.isActive() && pairedGate.isPurplePortal != this.isPurplePortal) {
            Vec3 teleportPos = pairedGate.m_20182_().m_82520_(0.0, 0.5, 0.0);
            Vec3 velocity = entity.m_20184_();
            float yRot = entity.m_146908_();
            float xRot = entity.m_146909_();
            entity.m_6021_(teleportPos.f_82479_, teleportPos.f_82480_, teleportPos.f_82481_);
            entity.m_20256_(velocity);
            entity.m_146922_(yRot);
            entity.m_146926_(xRot);
            this.teleportCooldown = 40;
            pairedGate.teleportCooldown = 40;
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private MiniWarpGateEntity getPairedGate() {
        String pairedId = (String)this.f_19804_.m_135370_(PAIRED_GATE_ID);
        if (pairedId.isEmpty()) {
            return null;
        }
        try {
            ServerLevel serverLevel;
            Entity entity;
            UUID pairedUUID = UUID.fromString(pairedId);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).m_8791_(pairedUUID)) instanceof MiniWarpGateEntity) {
                MiniWarpGateEntity miniGate = (MiniWarpGateEntity)entity;
                return miniGate;
            }
        }
        catch (IllegalArgumentException e) {
            this.f_19804_.m_135381_(PAIRED_GATE_ID, (Object)"");
        }
        return null;
    }

    private void manageWarpGates() {
        ServerLevel serverLevel;
        Player player;
        if (this.ownerUUID == null || this.hasBeenManaged) {
            return;
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel && (player = (serverLevel = (ServerLevel)level).m_46003_(this.ownerUUID)) != null) {
            this.removeExistingPortalOfSameColor();
            this.pairWithOppositeColor();
            this.hasBeenManaged = true;
        }
    }

    private void pairWithOppositeColor() {
        List<MiniWarpGateEntity> playerGates = this.m_9236_().m_45976_(MiniWarpGateEntity.class, new AABB(this.m_20182_().m_82520_(-100.0, -100.0, -100.0), this.m_20182_().m_82520_(100.0, 100.0, 100.0))).stream().filter(gate -> gate != this).filter(gate -> gate.ownerUUID != null && gate.ownerUUID.equals(this.ownerUUID)).filter(gate -> gate.isPurplePortal != this.isPurplePortal).toList();
        if (!playerGates.isEmpty()) {
            MiniWarpGateEntity oppositeGate = playerGates.get(0);
            this.f_19804_.m_135381_(PAIRED_GATE_ID, (Object)oppositeGate.m_20148_().toString());
            oppositeGate.f_19804_.m_135381_(PAIRED_GATE_ID, (Object)this.m_20148_().toString());
            this.f_19804_.m_135381_(IS_ACTIVE, (Object)true);
            oppositeGate.f_19804_.m_135381_(IS_ACTIVE, (Object)true);
        }
    }

    private void removeExistingPortalOfSameColor() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List<MiniWarpGateEntity> playerGates = this.m_9236_().m_45976_(MiniWarpGateEntity.class, new AABB(this.m_20182_().m_82520_(-100.0, -100.0, -100.0), this.m_20182_().m_82520_(100.0, 100.0, 100.0))).stream().filter(gate -> gate != this).filter(gate -> gate.ownerUUID != null && gate.ownerUUID.equals(this.ownerUUID)).filter(gate -> gate.isPurplePortal == this.isPurplePortal).toList();
            for (MiniWarpGateEntity existingGate : playerGates) {
                existingGate.m_146870_();
            }
        }
    }

    public void setOwner(Player player) {
        this.ownerUUID = player.m_20148_();
    }

    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(IS_ACTIVE);
    }

    public float getRotation() {
        return ((Float)this.f_19804_.m_135370_(ROTATION)).floatValue();
    }

    public boolean isOnCooldown() {
        return this.teleportCooldown > 0;
    }

    public float getCooldownProgress() {
        return (float)this.teleportCooldown / 40.0f;
    }

    public void setPairedGateId(String pairedId) {
        this.f_19804_.m_135381_(PAIRED_GATE_ID, (Object)pairedId);
    }

    public void setActive(boolean active) {
        this.f_19804_.m_135381_(IS_ACTIVE, (Object)active);
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void clearPairing() {
        this.f_19804_.m_135381_(PAIRED_GATE_ID, (Object)"");
        this.f_19804_.m_135381_(IS_ACTIVE, (Object)false);
    }

    public void setPortalType(boolean isPurple) {
        this.isPurplePortal = isPurple;
        this.f_19804_.m_135381_(IS_PURPLE_PORTAL, (Object)isPurple);
    }

    public boolean isPurplePortal() {
        return (Boolean)this.f_19804_.m_135370_(IS_PURPLE_PORTAL);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("OwnerUUID")) {
            this.ownerUUID = compound.m_128342_("OwnerUUID");
        }
        if (compound.m_128441_("PairedGateUUID")) {
            this.pairedGateUUID = compound.m_128342_("PairedGateUUID");
            this.f_19804_.m_135381_(PAIRED_GATE_ID, (Object)this.pairedGateUUID.toString());
        }
        this.tickCount = compound.m_128451_("TickCount");
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.ownerUUID != null) {
            compound.m_128362_("OwnerUUID", this.ownerUUID);
        }
        if (this.pairedGateUUID != null) {
            compound.m_128362_("PairedGateUUID", this.pairedGateUUID);
        }
        compound.m_128405_("TickCount", this.tickCount);
    }
}

