/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.entity;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HoverboardEntity
extends Entity {
    private static final EntityDataAccessor<Float> BOARD_ROTATION = SynchedEntityData.m_135353_(HoverboardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> FORWARD_MOMENTUM = SynchedEntityData.m_135353_(HoverboardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> IS_BOOSTING = SynchedEntityData.m_135353_(HoverboardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_JUMPING = SynchedEntityData.m_135353_(HoverboardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final float FRICTION = 0.85f;
    private static final float ROTATION_SPEED = 3.0f;
    private static final float BRAKE_FORCE = 0.95f;
    private static final float BOOST_ACCELERATION_MULTIPLIER = 2.0f;
    private static final float BOOST_MAX_SPEED_MULTIPLIER = 1.5f;
    private static final float TARGET_HOVER_HEIGHT = 0.5f;
    private static final float HOVER_ADJUSTMENT_SPEED = 0.2f;
    private static final float MAX_HOVER_SCAN_DISTANCE = 10.0f;
    private static final float CLIMB_BOOST = 0.25f;
    private static final float JUMP_VELOCITY = 0.4f;
    private int jumpCooldown = 0;
    private static final int JUMP_COOLDOWN_TICKS = 10;
    private boolean isJumping = false;
    private int jumpTicks = 0;
    private int loopSoundCooldown = 0;
    private static final int LOOP_SOUND_INTERVAL = 40;

    public HoverboardEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.m_20242_(true);
        this.m_274367_(1.0f);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BOARD_ROTATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(FORWARD_MOMENTUM, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(IS_BOOSTING, (Object)false);
        this.f_19804_.m_135372_(IS_JUMPING, (Object)false);
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int lerpSteps, boolean teleport) {
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        if (teleport || lerpSteps <= 0) {
            this.m_6034_(x, y, z);
            this.m_19915_(yaw, pitch);
        } else {
            double smoothingFactor = 1.0 / Math.max((double)lerpSteps, 1.0);
            double yDiff = Math.abs(y - this.m_20186_());
            boolean isLikelyJumping = yDiff > 0.3 || (Boolean)this.f_19804_.m_135370_(IS_JUMPING) != false;
            double ySmoothingFactor = isLikelyJumping ? smoothingFactor * 0.5 : smoothingFactor * 0.8;
            double deltaX = (x - this.m_20185_()) * smoothingFactor;
            double deltaY = (y - this.m_20186_()) * ySmoothingFactor;
            double deltaZ = (z - this.m_20189_()) * smoothingFactor;
            this.m_6034_(this.m_20185_() + deltaX, this.m_20186_() + deltaY, this.m_20189_() + deltaZ);
            float deltaYaw = (float)((double)Mth.m_14177_((float)(yaw - this.m_146908_())) * smoothingFactor);
            float deltaPitch = (float)((double)(pitch - this.m_146909_()) * smoothingFactor);
            this.m_19915_(this.m_146908_() + deltaYaw, this.m_146909_() + deltaPitch);
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("BoardRotation", ((Float)this.f_19804_.m_135370_(BOARD_ROTATION)).floatValue());
        compound.m_128350_("ForwardMomentum", ((Float)this.f_19804_.m_135370_(FORWARD_MOMENTUM)).floatValue());
        compound.m_128379_("IsBoosting", ((Boolean)this.f_19804_.m_135370_(IS_BOOSTING)).booleanValue());
        compound.m_128405_("JumpCooldown", this.jumpCooldown);
        compound.m_128379_("IsJumping", this.isJumping);
        compound.m_128405_("JumpTicks", this.jumpTicks);
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("BoardRotation")) {
            this.f_19804_.m_135381_(BOARD_ROTATION, (Object)Float.valueOf(compound.m_128457_("BoardRotation")));
        }
        if (compound.m_128441_("ForwardMomentum")) {
            this.f_19804_.m_135381_(FORWARD_MOMENTUM, (Object)Float.valueOf(compound.m_128457_("ForwardMomentum")));
        }
        if (compound.m_128441_("IsBoosting")) {
            this.f_19804_.m_135381_(IS_BOOSTING, (Object)compound.m_128471_("IsBoosting"));
        }
        if (compound.m_128441_("JumpCooldown")) {
            this.jumpCooldown = compound.m_128451_("JumpCooldown");
        }
        if (compound.m_128441_("IsJumping")) {
            this.isJumping = compound.m_128471_("IsJumping");
        }
        if (compound.m_128441_("JumpTicks")) {
            this.jumpTicks = compound.m_128451_("JumpTicks");
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.handleDismount();
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        if (this.isJumping) {
            ++this.jumpTicks;
        }
        if (this.m_20184_().f_82480_ < 0.05 || this.jumpTicks > 15) {
            if (this.isJumping) {
                this.isJumping = false;
                this.f_19804_.m_135381_(IS_JUMPING, (Object)false);
            }
            this.jumpTicks = 0;
        }
        if (this.loopSoundCooldown > 0) {
            --this.loopSoundCooldown;
        }
        if (this.m_20160_()) {
            this.preventFallDamageForRiders();
            this.handleMovement();
            this.handleLoopSound();
            this.maintainHoverHeight();
            this.ensureSmoothFollowing();
        } else {
            this.applyFriction();
            Vec3 currentVelocity = this.m_20184_();
            this.m_20334_(currentVelocity.f_82479_, currentVelocity.f_82480_ - 0.02, currentVelocity.f_82481_);
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_()) {
            ItemStack hoverboardItem = new ItemStack((ItemLike)StrangeMatterMod.HOVERBOARD.get());
            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), hoverboardItem);
            this.m_9236_().m_7967_((Entity)itemEntity);
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.8f, 1.0f);
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        if (player.m_20159_()) {
            return InteractionResult.PASS;
        }
        if (this.m_20160_()) {
            return InteractionResult.PASS;
        }
        player.m_20329_((Entity)this);
        return InteractionResult.SUCCESS;
    }

    private void handleDismount() {
        if (!this.m_20160_()) {
            return;
        }
        for (Entity passenger : this.m_20197_()) {
            Player player;
            if (!(passenger instanceof Player) || !(player = (Player)passenger).m_6144_()) continue;
            player.f_19789_ = 0.0f;
            if (passenger instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)passenger;
                living.f_19789_ = 0.0f;
            }
            passenger.m_8127_();
        }
    }

    private void preventFallDamageForRiders() {
        for (Entity passenger : this.m_20197_()) {
            if (!(passenger instanceof Player)) continue;
            Player player = (Player)passenger;
            player.f_19789_ = 0.0f;
            if (!(passenger instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)passenger;
            living.f_19789_ = 0.0f;
        }
    }

    private void handleMovement() {
        if (!this.m_20160_()) {
            return;
        }
        LivingEntity rider = this.m_6688_();
        if (rider == null && !this.m_20197_().isEmpty()) {
            rider = (Entity)this.m_20197_().get(0);
        }
        if (rider instanceof Player) {
            Player player = (Player)rider;
            boolean forwardPressed = player.f_20902_ > 0.0f;
            boolean backwardPressed = player.f_20902_ < 0.0f;
            boolean boostPressed = player.m_20142_();
            this.f_19804_.m_135381_(IS_BOOSTING, (Object)boostPressed);
            if (forwardPressed) {
                this.applyForwardMovement(boostPressed);
            } else if (backwardPressed) {
                this.applyBackwardMovement(boostPressed);
            } else {
                this.applyFriction();
            }
        }
    }

    private void handleLoopSound() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.m_20160_() && this.loopSoundCooldown <= 0) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)StrangeMatterSounds.HOVERBOARD_LOOP.get(), SoundSource.PLAYERS, 0.4f, 1.0f);
            this.loopSoundCooldown = 40;
        }
    }

    private void ensureSmoothFollowing() {
        if (!this.m_20160_()) {
            return;
        }
        LivingEntity rider = this.m_6688_();
        if (rider == null && !this.m_20197_().isEmpty()) {
            rider = (Entity)this.m_20197_().get(0);
        }
        if (rider != null) {
            float yawDiff;
            float targetYaw = rider.m_146908_();
            float currentYaw = this.m_146908_();
            for (yawDiff = targetYaw - currentYaw; yawDiff > 180.0f; yawDiff -= 360.0f) {
            }
            while (yawDiff < -180.0f) {
                yawDiff += 360.0f;
            }
            float rotationSpeed = 0.3f;
            float newYaw = currentYaw + yawDiff * rotationSpeed;
            this.m_146922_(newYaw);
            this.f_19859_ = this.m_146908_();
        }
    }

    private void applyForwardMovement(boolean boost) {
        double yaw = Math.toRadians(this.m_146908_());
        float acceleration = boost ? (float)(Config.hoverboardAcceleration * 2.0) : (float)Config.hoverboardAcceleration;
        float maxSpeed = boost ? (float)(Config.hoverboardMaxSpeed * 1.5) : (float)Config.hoverboardMaxSpeed;
        double moveX = -Math.sin(yaw) * (double)acceleration;
        double moveZ = Math.cos(yaw) * (double)acceleration;
        Vec3 currentVelocity = this.m_20184_();
        Vec3 newVelocity = currentVelocity.m_82520_(moveX, 0.0, moveZ);
        double horizontalSpeed = Math.sqrt(newVelocity.f_82479_ * newVelocity.f_82479_ + newVelocity.f_82481_ * newVelocity.f_82481_);
        if (horizontalSpeed > (double)maxSpeed) {
            double scale = (double)maxSpeed / horizontalSpeed;
            newVelocity = new Vec3(newVelocity.f_82479_ * scale, newVelocity.f_82480_, newVelocity.f_82481_ * scale);
        }
        this.f_19804_.m_135381_(FORWARD_MOMENTUM, (Object)Float.valueOf((float)horizontalSpeed));
        this.m_20256_(newVelocity);
    }

    private void applyBackwardMovement(boolean boost) {
        Vec3 currentVelocity = this.m_20184_();
        float brakeForce = boost ? 0.85499996f : 0.95f;
        Vec3 newVelocity = new Vec3(currentVelocity.f_82479_ * (double)brakeForce, currentVelocity.f_82480_, currentVelocity.f_82481_ * (double)brakeForce);
        double horizontalSpeed = Math.sqrt(newVelocity.f_82479_ * newVelocity.f_82479_ + newVelocity.f_82481_ * newVelocity.f_82481_);
        this.f_19804_.m_135381_(FORWARD_MOMENTUM, (Object)Float.valueOf((float)horizontalSpeed));
        this.m_20256_(newVelocity);
    }

    private void applyFriction() {
        Vec3 velocity = this.m_20184_();
        Vec3 newVelocity = new Vec3(velocity.f_82479_ * (double)0.85f, velocity.f_82480_, velocity.f_82481_ * (double)0.85f);
        double horizontalSpeed = Math.sqrt(newVelocity.f_82479_ * newVelocity.f_82479_ + newVelocity.f_82481_ * newVelocity.f_82481_);
        this.f_19804_.m_135381_(FORWARD_MOMENTUM, (Object)Float.valueOf((float)horizontalSpeed));
        this.m_20256_(newVelocity);
    }

    public void handleJumpRequest() {
        if (this.jumpCooldown <= 0 && !this.isJumping) {
            BlockPos groundPos = this.findGroundBelow();
            if (groundPos != null) {
                boolean nearHoverHeight;
                double currentY;
                double maxHeightAdjustment;
                double baseTargetY = (double)groundPos.m_123342_() + 1.0 + 0.5 + 0.5;
                double targetY = baseTargetY + (maxHeightAdjustment = this.findMaxHeightInRadius());
                double heightDifference = targetY - (currentY = this.m_20186_());
                boolean bl = nearHoverHeight = Math.abs(heightDifference) < 1.5 && this.m_20184_().f_82480_ < 0.1;
                if (nearHoverHeight) {
                    Vec3 currentVelocity = this.m_20184_();
                    Vec3 jumpVelocity = new Vec3(currentVelocity.f_82479_, currentVelocity.f_82480_ + (double)0.4f, currentVelocity.f_82481_);
                    this.m_20256_(jumpVelocity);
                    this.isJumping = true;
                    this.jumpTicks = 0;
                    this.jumpCooldown = 10;
                    this.f_19804_.m_135381_(IS_JUMPING, (Object)true);
                    if (!this.m_9236_().f_46443_) {
                        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)StrangeMatterSounds.HOVERBOARD_JUMP.get(), SoundSource.PLAYERS, 0.7f, 1.2f);
                    }
                }
            } else if (this.m_20184_().f_82480_ < 0.1) {
                Vec3 currentVelocity = this.m_20184_();
                Vec3 jumpVelocity = new Vec3(currentVelocity.f_82479_, currentVelocity.f_82480_ + (double)0.4f, currentVelocity.f_82481_);
                this.m_20256_(jumpVelocity);
                this.isJumping = true;
                this.jumpTicks = 0;
                this.jumpCooldown = 10;
                this.f_19804_.m_135381_(IS_JUMPING, (Object)true);
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)StrangeMatterSounds.HOVERBOARD_JUMP.get(), SoundSource.PLAYERS, 0.7f, 1.2f);
                }
            }
        }
    }

    public void setJumpPressed(boolean pressed) {
        if (pressed && !this.m_9236_().f_46443_) {
            this.handleJumpRequest();
        }
    }

    private void maintainHoverHeight() {
        BlockPos groundPos = this.findGroundBelow();
        if (groundPos != null) {
            double baseTargetY = (double)groundPos.m_123342_() + 1.0 + 0.5 + 0.5;
            double maxHeightAdjustment = this.findMaxHeightInRadius();
            double targetY = baseTargetY + maxHeightAdjustment;
            double currentY = this.m_20186_();
            double heightDifference = targetY - currentY;
            Vec3 currentVelocity = this.m_20184_();
            double verticalAdjustment = heightDifference * (double)0.2f;
            verticalAdjustment = Math.max(-0.25, Math.min(0.3, verticalAdjustment));
            if (this.isJumping && currentVelocity.f_82480_ > 0.05 && this.jumpTicks < 12) {
                return;
            }
            if (this.isJumping && this.jumpTicks < 18) {
                if (heightDifference < -0.3) {
                    double newY = Math.max(currentVelocity.f_82480_ - 0.015, -0.1);
                    this.m_20334_(currentVelocity.f_82479_, newY, currentVelocity.f_82481_);
                } else {
                    this.m_20334_(currentVelocity.f_82479_, currentVelocity.f_82480_ * 0.98, currentVelocity.f_82481_);
                }
            } else {
                double smoothedY = currentVelocity.f_82480_ * 0.8 + verticalAdjustment * 0.2;
                this.m_20334_(currentVelocity.f_82479_, smoothedY, currentVelocity.f_82481_);
            }
        } else {
            Vec3 currentVelocity = this.m_20184_();
            this.m_20334_(currentVelocity.f_82479_, currentVelocity.f_82480_ - 0.02, currentVelocity.f_82481_);
        }
    }

    private BlockPos findGroundBelow() {
        BlockPos currentPos = this.m_20183_();
        int i = 0;
        while ((float)i < 10.0f) {
            BlockPos checkPos = currentPos.m_6625_(i);
            BlockState blockState = this.m_9236_().m_8055_(checkPos);
            FluidState fluidState = this.m_9236_().m_6425_(checkPos);
            if (!fluidState.m_76178_() && (fluidState.m_76170_() || this.isTopOfFluid(checkPos, fluidState))) {
                return checkPos;
            }
            if (!blockState.m_60795_() && this.canBlockSupportHoverboard(blockState, checkPos)) {
                return checkPos;
            }
            ++i;
        }
        return null;
    }

    private boolean canBlockSupportHoverboard(BlockState blockState, BlockPos pos) {
        if (blockState.m_60804_((BlockGetter)this.m_9236_(), pos)) {
            return true;
        }
        VoxelShape shape = blockState.m_60812_((BlockGetter)this.m_9236_(), pos);
        if (!shape.m_83281_()) {
            double topBox = shape.m_83215_().f_82292_;
            return topBox >= 0.5;
        }
        return false;
    }

    private boolean isTopOfFluid(BlockPos pos, FluidState fluidState) {
        BlockPos above = pos.m_7494_();
        FluidState aboveFluid = this.m_9236_().m_6425_(above);
        return aboveFluid.m_76178_();
    }

    private double findMaxHeightInRadius() {
        BlockPos currentPos = this.m_20183_();
        double maxHeightAdjustment = 0.0;
        int radius = 2;
        int maxHeightCap = 1;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x == 0 && z == 0) continue;
                BlockPos checkPos = currentPos.m_7918_(x, 0, z);
                for (int y = 0; y <= maxHeightCap; ++y) {
                    BlockPos heightCheckPos = checkPos.m_6630_(y);
                    BlockState blockState = this.m_9236_().m_8055_(heightCheckPos);
                    if (blockState.m_60795_() || !blockState.m_60804_((BlockGetter)this.m_9236_(), heightCheckPos)) continue;
                    double requiredHeight = (double)y + 1.0;
                    maxHeightAdjustment = Math.max(maxHeightAdjustment, requiredHeight);
                }
            }
        }
        return Math.min(maxHeightAdjustment, (double)maxHeightCap);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_20160_()) {
            return false;
        }
        return super.m_6469_(damageSource, amount);
    }

    public double m_6048_() {
        return 0.4;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    protected boolean m_7341_(Entity entity) {
        return entity instanceof Player;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }
}

