/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.entity;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.GravityData;
import com.hexvane.strangematter.entity.BaseAnomalyEntity;
import com.hexvane.strangematter.network.GravitySyncPacket;
import com.hexvane.strangematter.network.NetworkHandler;
import com.hexvane.strangematter.research.ResearchType;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GravityAnomalyEntity
extends BaseAnomalyEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(GravityAnomalyEntity.class);
    private static final EntityDataAccessor<Boolean> IS_ACTIVE = SynchedEntityData.m_135353_(GravityAnomalyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final float AURA_RADIUS = 2.0f;
    private Set<Player> affectedPlayers = new HashSet<Player>();
    private AttributeModifier lowGravityModifier = new AttributeModifier("Low Gravity", 0.0, AttributeModifier.Operation.ADDITION);

    private float getLevitationRadius() {
        return (float)Config.gravityLevitationRadius;
    }

    @Override
    protected float getEffectRadius() {
        return this.getLevitationRadius();
    }

    private float getLevitationForce() {
        return (float)Config.gravityLevitationForce;
    }

    public GravityAnomalyEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ACTIVE, (Object)true);
    }

    @Override
    protected void applyAnomalyEffects() {
        if (!this.isActive() || this.isContained() || !Config.enableGravityEffects) {
            return;
        }
        if (!Config.enableGravityLevitation) {
            return;
        }
        float levitationRadius = this.getLevitationRadius();
        AABB levitationBox = this.m_20191_().m_82400_((double)levitationRadius);
        List entitiesInRange = this.m_9236_().m_45933_((Entity)this, levitationBox);
        this.affectedPlayers.removeIf(player -> {
            double distance = this.m_20270_((Entity)player);
            if (distance > (double)levitationRadius) {
                GravityData.removePlayerGravityForce(player.m_20148_());
                player.getPersistentData().m_128473_("strangematter.gravity_force");
                if (!this.m_9236_().f_46443_) {
                    NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new GravitySyncPacket(0.0));
                    LOGGER.info("[GRAVITY ANOMALY] Server: Player {} left range, sent clear packet", (Object)player.m_7755_().getString());
                }
                return true;
            }
            return false;
        });
        for (Entity entity : entitiesInRange) {
            double distance;
            if (entity instanceof Player && ((Player)entity).m_7500_() || !((distance = (double)this.m_20270_(entity)) <= (double)levitationRadius)) continue;
            this.applyLowGravityEffect(entity, distance);
        }
    }

    private void applyLowGravityEffect(Entity entity, double distance) {
        float levitationRadius = this.getLevitationRadius();
        double forceMultiplier = 1.0 - distance / (double)levitationRadius;
        forceMultiplier = Math.max(0.1, forceMultiplier);
        Vec3 currentVelocity = entity.m_20184_();
        if (entity instanceof ItemEntity) {
            this.applyItemLowGravity((ItemEntity)entity, currentVelocity, forceMultiplier);
        } else if (entity instanceof Player) {
            this.applyPlayerLowGravity((Player)entity, currentVelocity, forceMultiplier);
        } else if (entity instanceof LivingEntity) {
            this.applyMobLowGravity((LivingEntity)entity, currentVelocity, forceMultiplier);
        } else {
            this.applyGenericLowGravity(entity, currentVelocity, forceMultiplier);
        }
    }

    private void applyItemLowGravity(ItemEntity item, Vec3 currentVelocity, double forceMultiplier) {
        double time = (double)(System.currentTimeMillis() % 360000L) / 1000.0;
        double itemId = (double)item.m_19879_() * 0.1;
        double floatHeight = Math.sin(time * 0.5 + itemId) * 0.1 * forceMultiplier;
        double driftX = Math.cos(time * 0.3 + itemId) * 0.02 * forceMultiplier;
        double driftZ = Math.sin(time * 0.4 + itemId) * 0.02 * forceMultiplier;
        Vec3 newVelocity = new Vec3(currentVelocity.f_82479_ * 0.8 + driftX, currentVelocity.f_82480_ * 0.3 + floatHeight, currentVelocity.f_82481_ * 0.8 + driftZ);
        if ((newVelocity = newVelocity.m_82542_(1.0, 1.0, 1.0)).m_82553_() > 0.5) {
            newVelocity = newVelocity.m_82541_().m_82542_(0.5, 0.5, 0.5);
        }
        item.m_20256_(newVelocity);
    }

    private void applyPlayerLowGravity(Player player, Vec3 currentVelocity, double forceMultiplier) {
        if (!this.affectedPlayers.contains(player)) {
            this.affectedPlayers.add(player);
        }
        GravityData.setPlayerGravityForce(player.m_20148_(), forceMultiplier);
        player.getPersistentData().m_128347_("strangematter.gravity_force", forceMultiplier);
        if (!this.m_9236_().f_46443_) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new GravitySyncPacket(forceMultiplier));
        } else {
            LOGGER.info("[GRAVITY ANOMALY] Client: Player {} in field, force: {}", (Object)player.m_7755_().getString(), (Object)forceMultiplier);
        }
    }

    private void applyMobLowGravity(LivingEntity mob, Vec3 currentVelocity, double forceMultiplier) {
        double time = (double)(System.currentTimeMillis() % 360000L) / 1000.0;
        double mobId = (double)mob.m_19879_() * 0.1;
        double floatHeight = Math.sin(time * 0.8 + mobId) * 0.15 * forceMultiplier;
        double driftX = Math.cos(time * 0.6 + mobId) * 0.03 * forceMultiplier;
        double driftZ = Math.sin(time * 0.7 + mobId) * 0.03 * forceMultiplier;
        double secondaryFloat = Math.sin(time * 1.2 + mobId * 1.5) * 0.05 * forceMultiplier;
        double secondaryDriftX = Math.cos(time * 0.9 + mobId * 1.3) * 0.01 * forceMultiplier;
        double secondaryDriftZ = Math.sin(time * 1.1 + mobId * 1.7) * 0.01 * forceMultiplier;
        Vec3 newVelocity = new Vec3(currentVelocity.f_82479_ * 0.7 + driftX + secondaryDriftX, currentVelocity.f_82480_ * 0.2 + floatHeight + secondaryFloat, currentVelocity.f_82481_ * 0.7 + driftZ + secondaryDriftZ);
        if (forceMultiplier > 0.3) {
            float rotationSpeed = (float)(forceMultiplier * 1.5);
            mob.m_146922_(mob.m_146908_() + rotationSpeed);
        }
        mob.m_20256_(newVelocity);
    }

    private void applyGenericLowGravity(Entity entity, Vec3 currentVelocity, double forceMultiplier) {
        float levitationForce = this.getLevitationForce();
        Vec3 upwardForce = new Vec3(0.0, (double)levitationForce * forceMultiplier * 0.6, 0.0);
        Vec3 newVelocity = currentVelocity.m_82549_(upwardForce);
        if (newVelocity.f_82480_ < 0.0) {
            newVelocity = new Vec3(newVelocity.f_82479_, newVelocity.f_82480_ * 0.3, newVelocity.f_82481_);
        }
        entity.m_20256_(newVelocity);
    }

    @Override
    protected void spawnParticles() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.tickCount % 1 == 0) {
            double radius = (double)this.getLevitationRadius() * 0.8;
            double angle = this.m_9236_().f_46441_.m_188500_() * 2.0 * Math.PI;
            double x = this.m_20185_() + Math.cos(angle) * radius * this.m_9236_().f_46441_.m_188500_();
            double z = this.m_20189_() + Math.sin(angle) * radius * this.m_9236_().f_46441_.m_188500_();
            double y = this.m_20186_() - 1.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, 0.0, 0.1, 0.0);
        }
        if (this.tickCount % 10 == 0) {
            double auraRadius = 2.0;
            for (int i = 0; i < 3; ++i) {
                double angle = (double)this.tickCount * 0.1 + (double)i * Math.PI * 2.0 / 3.0;
                double x = this.m_20185_() + Math.cos(angle) * auraRadius;
                double z = this.m_20189_() + Math.sin(angle) * auraRadius;
                double y = this.m_20186_() + 0.5;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, 0.0, 0.05, 0.0);
            }
        }
    }

    @Override
    protected void updateClientEffects() {
    }

    @Override
    public ResourceLocation getAnomalySound() {
        return ((SoundEvent)StrangeMatterSounds.GRAVITY_ANOMALY_LOOP.get()).m_11660_();
    }

    @Override
    protected ResearchType getResearchType() {
        return ResearchType.GRAVITY;
    }

    @Override
    protected String getAnomalyName() {
        return "Gravity";
    }

    public float getAuraRadius() {
        return 2.0f;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)SoundEvents.f_11689_.get();
    }

    @Override
    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(IS_ACTIVE);
    }

    public void setActive(boolean active) {
        this.f_19804_.m_135381_(IS_ACTIVE, (Object)active);
    }
}

