/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.entity;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.entity.BaseAnomalyEntity;
import com.hexvane.strangematter.research.ResearchType;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EnergeticRiftEntity
extends BaseAnomalyEntity {
    private static final EntityDataAccessor<Boolean> IS_ACTIVE = SynchedEntityData.m_135353_(EnergeticRiftEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int LIGHTNING_ROD_RECHECK_COOLDOWN_TICKS = 5;
    private int zapCooldown = 0;
    private int lightningCooldown = 0;
    private final List<TargetingSpark> targetingSparks = new ArrayList<TargetingSpark>();

    private float getZapRadius() {
        return (float)Config.energeticZapRadius;
    }

    @Override
    protected float getEffectRadius() {
        return this.getZapRadius();
    }

    private float getLightningRodRadius() {
        return (float)Config.energeticLightningRadius;
    }

    private float getZapDamage() {
        return (float)Config.energeticZapDamage;
    }

    private int getZapCooldownMax() {
        return Config.energeticZapCooldown;
    }

    private int getLightningCooldownMax() {
        return Config.energeticLightningCooldown;
    }

    public EnergeticRiftEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ACTIVE, (Object)true);
    }

    @Override
    protected void updatePulseAnimation() {
        float time = (float)(this.tickCount % 120) / 120.0f;
        float breathingIntensity = (float)(0.5 + 0.5 * Math.sin((double)(time * 2.0f) * Math.PI));
        this.setPulseIntensity(breathingIntensity);
    }

    @Override
    protected void applyAnomalyEffects() {
        if (!this.isActive() || this.isContained() || !Config.enableEnergeticEffects) {
            return;
        }
        if (this.zapCooldown > 0) {
            --this.zapCooldown;
        }
        if (this.lightningCooldown > 0) {
            --this.lightningCooldown;
        }
        if (this.zapCooldown <= 0 && Config.enableEnergeticZap) {
            if (this.hasLightningRodNearby()) {
                this.zapCooldown = 5;
            } else {
                this.zapEntitiesInRange();
            }
        }
        if (this.lightningCooldown <= 0 && Config.enableEnergeticLightning) {
            this.strikeLightningRods();
        }
        this.targetingSparks.removeIf(spark -> spark.age++ > spark.maxAge);
    }

    private void zapEntitiesInRange() {
        float zapRadius = this.getZapRadius();
        AABB zapBox = this.m_20191_().m_82400_((double)zapRadius);
        List entitiesInRange = this.m_9236_().m_45933_((Entity)this, zapBox);
        boolean foundTarget = false;
        for (Entity entity : entitiesInRange) {
            double distance;
            if (!(entity instanceof LivingEntity) || entity instanceof Player && ((Player)entity).m_7500_() || !((distance = (double)this.m_20270_(entity)) <= (double)zapRadius)) continue;
            this.zapEntity((LivingEntity)entity);
            foundTarget = true;
        }
        if (foundTarget) {
            this.zapCooldown = this.getZapCooldownMax();
        }
    }

    private void zapEntity(LivingEntity entity) {
        Player player;
        boolean isProtected = false;
        if (entity instanceof Player && (player = (Player)entity).m_6844_(EquipmentSlot.HEAD).m_41720_() == StrangeMatterMod.TINFOIL_HAT.get()) {
            isProtected = true;
        }
        if (!isProtected) {
            DamageSource electricDamage = this.m_269291_().m_269548_();
            entity.m_6469_(electricDamage, this.getZapDamage());
        }
        this.createTargetingSpark((Entity)entity);
        this.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_12090_, SoundSource.AMBIENT, 0.3f, 1.5f);
        this.spawnElectricParticles(entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), 8);
    }

    private void strikeLightningRods() {
        ArrayList<BlockPos> lightningRods = new ArrayList<BlockPos>();
        float lightningRadius = this.getLightningRodRadius();
        BlockPos center = this.m_20183_();
        int x = (int)(-lightningRadius);
        while ((float)x <= lightningRadius) {
            for (int y = -3; y <= 3; ++y) {
                int z = (int)(-lightningRadius);
                while ((float)z <= lightningRadius) {
                    double distance;
                    BlockPos pos = center.m_7918_(x, y, z);
                    BlockState state = this.m_9236_().m_8055_(pos);
                    if (state.m_60713_(Blocks.f_152587_) && (distance = Math.sqrt(x * x + z * z)) <= (double)lightningRadius) {
                        lightningRods.add(pos);
                    }
                    ++z;
                }
            }
            ++x;
        }
        if (!lightningRods.isEmpty()) {
            BlockPos targetRod = (BlockPos)lightningRods.get(this.m_9236_().m_213780_().m_188503_(lightningRods.size()));
            this.strikeLightningRod(targetRod);
            this.lightningCooldown = this.getLightningCooldownMax();
        }
    }

    private boolean hasLightningRodNearby() {
        float lightningRadius = this.getLightningRodRadius();
        if (lightningRadius <= 0.0f) {
            return false;
        }
        int r = (int)lightningRadius;
        double radiusSq = lightningRadius * lightningRadius;
        BlockPos center = this.m_20183_();
        for (int x = -r; x <= r; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -r; z <= r; ++z) {
                    double horizSq = (double)x * (double)x + (double)z * (double)z;
                    if (horizSq > radiusSq) continue;
                    BlockPos pos = center.m_7918_(x, y, z);
                    if (!this.m_9236_().m_8055_(pos).m_60713_(Blocks.f_152587_)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void strikeLightningRod(BlockPos rodPos) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LightningBolt lightning = new LightningBolt(EntityType.f_20465_, (Level)serverLevel);
            lightning.m_20219_(Vec3.m_82539_((Vec3i)rodPos.m_7494_()));
            serverLevel.m_7967_((Entity)lightning);
            this.m_9236_().m_5594_(null, rodPos, SoundEvents.f_12090_, SoundSource.WEATHER, 1.0f, 0.8f);
            this.spawnElectricParticles((double)rodPos.m_123341_() + 0.5, (double)rodPos.m_123342_() + 1.0, (double)rodPos.m_123343_() + 0.5, 12);
        }
    }

    @Override
    protected void spawnParticles() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.tickCount % 1 == 0) {
            this.spawnSwirlingParticles();
        }
        if (this.tickCount % 5 == 0) {
            this.spawnElectricSparks();
        }
        if (this.tickCount % 10 == 0) {
            this.spawnAuraParticles();
        }
    }

    private void spawnSwirlingParticles() {
        double radius = (double)this.getZapRadius() * 0.6;
        double angle = (double)this.tickCount * 0.1 + this.m_9236_().m_213780_().m_188500_() * 0.5;
        double x = this.m_20185_() + Math.cos(angle) * radius;
        double z = this.m_20189_() + Math.sin(angle) * radius;
        double y = this.m_20186_() + (this.m_9236_().m_213780_().m_188500_() - 0.5) * 2.0;
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, x, y, z, Math.cos(angle + 1.5707963267948966) * 0.1, 0.2, Math.sin(angle + 1.5707963267948966) * 0.1);
    }

    private void spawnElectricSparks() {
        RandomSource random = this.m_9236_().m_213780_();
        int sparkCount = 2 + random.m_188503_(3);
        for (int i = 0; i < sparkCount; ++i) {
            double radius = (double)this.getZapRadius() * (0.3 + random.m_188500_() * 0.7);
            double angle = random.m_188500_() * 2.0 * Math.PI;
            double height = random.m_188500_() * 2.0 - 1.0;
            double x = this.m_20185_() + Math.cos(angle) * radius;
            double z = this.m_20189_() + Math.sin(angle) * radius;
            double y = this.m_20186_() + height;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, x, y, z, (random.m_188500_() - 0.5) * 0.3, (random.m_188500_() - 0.5) * 0.3, (random.m_188500_() - 0.5) * 0.3);
        }
    }

    private void spawnAuraParticles() {
        double auraRadius = 1.5;
        for (int i = 0; i < 4; ++i) {
            double angle = (double)this.tickCount * 0.05 + (double)i * Math.PI / 2.0;
            double x = this.m_20185_() + Math.cos(angle) * auraRadius;
            double z = this.m_20189_() + Math.sin(angle) * auraRadius;
            double y = this.m_20186_() + Math.sin((double)this.tickCount * 0.1) * 0.5;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, x, y, z, 0.0, 0.1, 0.0);
        }
    }

    private void spawnElectricParticles(double x, double y, double z, int count) {
        RandomSource random = this.m_9236_().m_213780_();
        for (int i = 0; i < count; ++i) {
            double offsetX = (random.m_188500_() - 0.5) * 2.0;
            double offsetY = random.m_188500_() * 2.0;
            double offsetZ = (random.m_188500_() - 0.5) * 2.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, x + offsetX, y + offsetY, z + offsetZ, (random.m_188500_() - 0.5) * 0.5, (random.m_188500_() - 0.5) * 0.5, (random.m_188500_() - 0.5) * 0.5);
        }
    }

    @Override
    protected void updateClientEffects() {
    }

    @Override
    public ResourceLocation getAnomalySound() {
        return ((SoundEvent)StrangeMatterSounds.ENERGETIC_RIFT_LOOP.get()).m_11660_();
    }

    @Override
    protected ResearchType getResearchType() {
        return ResearchType.ENERGY;
    }

    @Override
    protected String getAnomalyName() {
        return "Energetic Rift";
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"entity.strangematter.energetic_rift");
    }

    public List<TargetingSpark> getTargetingSparks() {
        return this.targetingSparks;
    }

    private void createTargetingSpark(Entity target) {
        Vec3 riftPos = this.m_20182_().m_82520_(0.0, 0.5, 0.0);
        Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
        this.targetingSparks.add(new TargetingSpark(riftPos, targetPos, target.m_19879_()));
    }

    @Override
    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(IS_ACTIVE);
    }

    public void setActive(boolean active) {
        this.f_19804_.m_135381_(IS_ACTIVE, (Object)active);
    }

    public static class TargetingSpark {
        public final Vec3 startPos;
        public final Vec3 endPos;
        public final int targetId;
        public int age = 0;
        public final int maxAge = 20;

        public TargetingSpark(Vec3 start, Vec3 end, int targetId) {
            this.startPos = start;
            this.endPos = end;
            this.targetId = targetId;
        }
    }
}

