/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.entity;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.entity.BaseAnomalyEntity;
import com.hexvane.strangematter.platform.AnomalySoundClient;
import com.hexvane.strangematter.platform.ClientServices;
import com.hexvane.strangematter.research.ResearchType;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EchoingShadowEntity
extends BaseAnomalyEntity {
    private static final EntityDataAccessor<Boolean> IS_ACTIVE = SynchedEntityData.m_135353_(EchoingShadowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int MOB_SPAWN_BOOST_TICKS = 20;
    private static final int MAX_SPAWNED_MOBS = 6;
    private final Set<UUID> spawnedMobs = new HashSet<UUID>();
    private int mobSpawnTimer = 0;
    private static final float ECHOING_SHADOW_SOUND_DISTANCE = 16.0f;
    private static final float ECHOING_SHADOW_MAX_VOLUME_DISTANCE = 8.0f;

    private float getShadowEffectRadius() {
        return (float)Config.shadowEffectRadius;
    }

    @Override
    protected float getEffectRadius() {
        return this.getShadowEffectRadius();
    }

    private double getMobSpawnBoost() {
        return Config.shadowMobSpawnBoost;
    }

    public EchoingShadowEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ACTIVE, (Object)true);
    }

    @Override
    protected void applyAnomalyEffects() {
        if (!this.isActive() || this.isContained() || !Config.enableShadowEffects) {
            return;
        }
        if (Config.enableShadowMobSpawnBoost) {
            if (this.mobSpawnTimer <= 0) {
                this.boostMobSpawning();
                this.mobSpawnTimer = 20;
            } else {
                --this.mobSpawnTimer;
            }
        }
    }

    private void boostMobSpawning() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        float effectRadius = this.getShadowEffectRadius();
        AABB shadowBox = this.m_20191_().m_82400_((double)effectRadius);
        List entitiesInRange = this.m_9236_().m_45933_((Entity)this, shadowBox);
        int hostileMobCount = 0;
        for (Entity entity : entitiesInRange) {
            BlockPos mobPos;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity instanceof Player || livingEntity.m_6095_().m_20674_().m_21609_() || !this.isInShadowRadius(mobPos = livingEntity.m_20183_())) continue;
            ++hostileMobCount;
            this.protectMobFromSunlight(livingEntity);
        }
        this.cleanupDeadMobs();
        double spawnChance = 0.25 * (this.getMobSpawnBoost() / 2.0);
        if (this.spawnedMobs.size() < 6 && (double)this.m_9236_().m_213780_().m_188501_() < spawnChance) {
            this.attemptSpawnerLikeMobSpawn(serverLevel);
        }
    }

    private void cleanupDeadMobs() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.spawnedMobs.removeIf(uuid -> {
                Entity entity = serverLevel.m_8791_(uuid);
                return entity == null || !entity.m_6084_() || entity.m_213877_();
            });
        }
    }

    private void protectMobFromSunlight(LivingEntity mob) {
        if (mob == null || !this.m_9236_().m_46461_()) {
            return;
        }
        BlockPos mobPos = mob.m_20183_();
        if (!this.isInShadowRadius(mobPos)) {
            return;
        }
        if (mob instanceof Zombie || mob instanceof Skeleton || mob instanceof Stray || mob instanceof Husk || mob instanceof ZombieVillager || mob instanceof Drowned) {
            mob.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 40, 0, false, false, false));
            if (mob.m_6060_()) {
                mob.m_20095_();
            }
        }
    }

    private void attemptSpawnerLikeMobSpawn(ServerLevel serverLevel) {
        BlockPos centerPos = this.m_20183_();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Entity newMob;
            float shadowRadius = this.getShadowEffectRadius();
            int x = centerPos.m_123341_() + this.m_9236_().m_213780_().m_188503_((int)(shadowRadius * 2.0f)) - (int)shadowRadius;
            int z = centerPos.m_123343_() + this.m_9236_().m_213780_().m_188503_((int)(shadowRadius * 2.0f)) - (int)shadowRadius;
            BlockPos spawnPos = new BlockPos(x, centerPos.m_123342_(), z);
            BlockPos groundPos = serverLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING, spawnPos);
            if (!this.isInShadowRadius(groundPos)) continue;
            EntityType[] hostileMobs = new EntityType[]{EntityType.f_20501_, EntityType.f_20524_, EntityType.f_20479_, EntityType.f_20558_, EntityType.f_20566_};
            EntityType mobType = hostileMobs[this.m_9236_().m_213780_().m_188503_(hostileMobs.length)];
            if (!serverLevel.m_8055_(groundPos).m_60795_() || !serverLevel.m_8055_(groundPos.m_7494_()).m_60795_() || (newMob = mobType.m_20615_((Level)serverLevel)) == null) continue;
            newMob.m_7678_((double)groundPos.m_123341_() + 0.5, (double)groundPos.m_123342_(), (double)groundPos.m_123343_() + 0.5, this.m_9236_().m_213780_().m_188501_() * 360.0f, 0.0f);
            if (!serverLevel.m_7967_(newMob)) continue;
            this.spawnedMobs.add(newMob.m_20148_());
            break;
        }
    }

    @Override
    protected void updateClientEffects() {
    }

    @Override
    protected void spawnParticles() {
        int i;
        if (this.m_9236_().f_46443_) {
            return;
        }
        for (i = 0; i < 1; ++i) {
            double offsetX = (this.m_9236_().m_213780_().m_188500_() - 0.5) * 2.0;
            double offsetY = (this.m_9236_().m_213780_().m_188500_() - 0.5) * 2.0;
            double offsetZ = (this.m_9236_().m_213780_().m_188500_() - 0.5) * 2.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
        }
        if (this.m_9236_().m_213780_().m_188501_() < 0.05f) {
            for (i = 0; i < 4; ++i) {
                double angle = (double)i / 4.0 * Math.PI * 2.0;
                double radius = 1.5 + this.m_9236_().m_213780_().m_188500_() * 0.5;
                double offsetX = Math.cos(angle) * radius;
                double offsetZ = Math.sin(angle) * radius;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + offsetX, this.m_20186_() + 0.5, this.m_20189_() + offsetZ, 0.0, 0.1, 0.0);
            }
        }
    }

    @Override
    public ResourceLocation getAnomalySound() {
        return ((SoundEvent)StrangeMatterSounds.ECHOING_SHADOW_LOOP.get()).m_11660_();
    }

    @Override
    protected void updateSoundEffects() {
        if (!this.m_9236_().f_46443_) {
            return;
        }
        AnomalySoundClient soundClient = ClientServices.anomalySound();
        if (soundClient == null) {
            return;
        }
        soundClient.initializeIfNeeded();
        Player nearestPlayer = this.m_9236_().m_45930_((Entity)this, 16.0);
        if (nearestPlayer == null) {
            if (this.isSoundActive) {
                soundClient.stopAmbientSound(this.getAnomalySound());
                this.isSoundActive = false;
            }
            return;
        }
        double distance = this.m_20270_((Entity)nearestPlayer);
        if (distance > 16.0) {
            if (this.isSoundActive) {
                soundClient.stopAmbientSound(this.getAnomalySound());
                this.isSoundActive = false;
            }
            return;
        }
        float volume = this.calculateEchoingShadowSoundVolume(distance);
        if (!this.isSoundActive) {
            soundClient.playAmbientSound(this.getAnomalySound(), this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, volume, true);
            this.isSoundActive = true;
            this.lastCalculatedVolume = volume;
        } else {
            if (Math.abs(volume - this.lastCalculatedVolume) > 0.01f) {
                soundClient.updateSoundVolume(this.getAnomalySound(), volume);
                this.lastCalculatedVolume = volume;
            }
            soundClient.updateSoundPosition(this.getAnomalySound(), this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_);
        }
    }

    private float calculateEchoingShadowSoundVolume(double distance) {
        if (distance <= 8.0) {
            return 1.0f;
        }
        if (distance <= 16.0) {
            float fadeRange = 8.0f;
            float fadeDistance = (float)(distance - 8.0);
            float volumeRatio = 1.0f - fadeDistance / fadeRange;
            return Math.max(0.0f, volumeRatio);
        }
        return 0.0f;
    }

    @Override
    protected ResearchType getResearchType() {
        return ResearchType.SHADOW;
    }

    @Override
    protected String getAnomalyName() {
        return "Echoing Shadow";
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("MobSpawnTimer")) {
            this.mobSpawnTimer = compound.m_128451_("MobSpawnTimer");
        }
        this.spawnedMobs.clear();
        if (compound.m_128425_("SpawnedMobs", 9)) {
            ListTag mobList = compound.m_128437_("SpawnedMobs", 8);
            for (int i = 0; i < mobList.size(); ++i) {
                try {
                    this.spawnedMobs.add(UUID.fromString(mobList.m_128778_(i)));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("MobSpawnTimer", this.mobSpawnTimer);
        ListTag mobList = new ListTag();
        for (UUID uuid : this.spawnedMobs) {
            mobList.add((Object)StringTag.m_129297_((String)uuid.toString()));
        }
        compound.m_128365_("SpawnedMobs", (Tag)mobList);
    }

    public boolean isInShadowRadius(BlockPos pos) {
        double distance = this.m_20182_().m_82554_(new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5));
        return distance <= (double)this.getShadowEffectRadius();
    }

    @Override
    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(IS_ACTIVE);
    }

    public void setActive(boolean active) {
        this.f_19804_.m_135381_(IS_ACTIVE, (Object)active);
    }
}

