/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.entity;

import com.hexvane.strangematter.StrangeMatterMod;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ChronoBlisterProjectileEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Float> CHARGE_PROGRESS = SynchedEntityData.m_135353_(ChronoBlisterProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> FIRED = SynchedEntityData.m_135353_(ChronoBlisterProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float chargeProgress = 0.0f;
    private boolean fired = false;

    public ChronoBlisterProjectileEntity(EntityType<? extends ChronoBlisterProjectileEntity> entityType, Level level) {
        super(entityType, level);
    }

    public ChronoBlisterProjectileEntity(EntityType<? extends ChronoBlisterProjectileEntity> entityType, LivingEntity shooter, Level level) {
        super(entityType, shooter, level);
    }

    public void setChargeProgress(float progress) {
        this.chargeProgress = Math.max(0.0f, Math.min(1.0f, progress));
        this.f_19804_.m_135381_(CHARGE_PROGRESS, (Object)Float.valueOf(this.chargeProgress));
    }

    public float getChargeProgress() {
        return ((Float)this.f_19804_.m_135370_(CHARGE_PROGRESS)).floatValue();
    }

    public void setFired(boolean fired) {
        this.fired = fired;
        this.f_19804_.m_135381_(FIRED, (Object)fired);
        if (fired) {
            this.m_20242_(false);
        }
    }

    public boolean isFired() {
        return (Boolean)this.f_19804_.m_135370_(FIRED);
    }

    public void m_8119_() {
        Entity entity;
        super.m_8119_();
        this.chargeProgress = ((Float)this.f_19804_.m_135370_(CHARGE_PROGRESS)).floatValue();
        this.fired = (Boolean)this.f_19804_.m_135370_(FIRED);
        if (!this.fired && (entity = this.m_19749_()) instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            Vec3 lookDirection = owner.m_20154_();
            Vec3 eyePos = owner.m_146892_();
            Vec3 startPos = eyePos.m_82549_(lookDirection.m_82490_(0.5));
            this.m_6034_(startPos.f_82479_, startPos.f_82480_, startPos.f_82481_);
            this.m_20256_(Vec3.f_82478_);
        }
    }

    protected void m_6532_(HitResult result) {
        BlockPos hitPos;
        if (!this.fired) {
            return;
        }
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockResult = (BlockHitResult)result;
            hitPos = blockResult.m_82425_().m_121945_(blockResult.m_82434_());
        } else if (result.m_6662_() == HitResult.Type.ENTITY) {
            EntityHitResult entityResult = (EntityHitResult)result;
            hitPos = entityResult.m_82443_().m_20183_();
        } else {
            this.m_146870_();
            return;
        }
        this.spawnTimeDilationBlob(hitPos);
        this.m_146870_();
    }

    private void spawnTimeDilationBlob(BlockPos centerPos) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        int radius = 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    double distance = Math.sqrt(x * x + y * y + z * z);
                    if (!(distance <= (double)radius + 0.5) || !(distance <= (double)radius - 0.3) && !(this.m_9236_().m_213780_().m_188500_() < 0.7)) continue;
                    BlockPos spawnPos = centerPos.m_7918_(x, y, z);
                    BlockState currentState = this.m_9236_().m_8055_(spawnPos);
                    if (!currentState.m_60795_() && !currentState.m_247087_()) continue;
                    this.m_9236_().m_7731_(spawnPos, ((Block)StrangeMatterMod.TIME_DILATION_BLOCK.get()).m_49966_(), 3);
                }
            }
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CHARGE_PROGRESS, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(FIRED, (Object)false);
    }

    protected void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("ChargeProgress", this.chargeProgress);
        tag.m_128379_("Fired", this.fired);
    }

    protected void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.chargeProgress = tag.m_128457_("ChargeProgress");
        this.fired = tag.m_128471_("Fired");
        this.f_19804_.m_135381_(CHARGE_PROGRESS, (Object)Float.valueOf(this.chargeProgress));
        this.f_19804_.m_135381_(FIRED, (Object)this.fired);
    }
}

