/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.entity;

import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.platform.AnomalySoundClient;
import com.hexvane.strangematter.platform.ClientServices;
import com.hexvane.strangematter.research.ResearchType;
import com.hexvane.strangematter.research.ScannableObject;
import com.hexvane.strangematter.research.ScannableObjectRegistry;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public abstract class BaseAnomalyEntity
extends Entity {
    private static final EntityDataAccessor<Float> ROTATION = SynchedEntityData.m_135353_(BaseAnomalyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> PULSE_INTENSITY = SynchedEntityData.m_135353_(BaseAnomalyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> IS_CONTAINED = SynchedEntityData.m_135353_(BaseAnomalyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> SCALE = SynchedEntityData.m_135353_(BaseAnomalyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final float ROTATION_SPEED = 0.5f;
    protected static final int PARTICLE_SPAWN_RATE = 20;
    protected int tickCount = 0;
    protected float lastPulseTime = 0.0f;
    protected static final float MAX_SOUND_DISTANCE = 10.0f;
    protected boolean isSoundActive = false;
    protected float lastCalculatedVolume = 0.0f;
    private boolean spawnedFromCapsule = false;

    public BaseAnomalyEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.m_20242_(true);
        this.m_20331_(true);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ROTATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(PULSE_INTENSITY, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(IS_CONTAINED, (Object)false);
        this.f_19804_.m_135372_(SCALE, (Object)Float.valueOf(1.0f));
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.tickCount;
        if (!this.m_9236_().f_46443_) {
            this.updateRotation();
            this.updatePulseAnimation();
            this.applyAnomalyEffects();
            this.checkForFirstContact();
            this.spawnParticles();
        } else {
            this.updateClientEffects();
            this.updateSoundEffects();
        }
    }

    protected void updateRotation() {
        float currentRotation = ((Float)this.f_19804_.m_135370_(ROTATION)).floatValue();
        float newRotation = currentRotation + 0.5f;
        if (newRotation >= 360.0f) {
            newRotation -= 360.0f;
        }
        this.f_19804_.m_135381_(ROTATION, (Object)Float.valueOf(newRotation));
    }

    protected void updatePulseAnimation() {
        float currentPulse;
        if (this.tickCount % 60 == 0) {
            this.f_19804_.m_135381_(PULSE_INTENSITY, (Object)Float.valueOf(1.0f));
        }
        if ((currentPulse = ((Float)this.f_19804_.m_135370_(PULSE_INTENSITY)).floatValue()) > 0.0f) {
            this.f_19804_.m_135381_(PULSE_INTENSITY, (Object)Float.valueOf(Math.max(0.0f, currentPulse - 0.05f)));
        }
    }

    protected abstract void applyAnomalyEffects();

    protected abstract void spawnParticles();

    protected abstract void updateClientEffects();

    private void checkForFirstContact() {
        if (!this.isActive() || this.isContained()) {
            return;
        }
        if (this.tickCount % 20 != 0) {
            return;
        }
        float effectRadius = this.getEffectRadius();
        AABB effectBox = this.m_20191_().m_82400_((double)effectRadius);
        List entitiesInRange = this.m_9236_().m_45933_((Entity)this, effectBox);
        for (Entity entity : entitiesInRange) {
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            double distance = this.m_20270_(entity);
            if (!(distance <= (double)effectRadius)) continue;
            StrangeMatterMod.ANOMALY_EFFECT_TRIGGER.trigger(serverPlayer);
        }
    }

    protected float getEffectRadius() {
        return 5.0f;
    }

    public abstract ResourceLocation getAnomalySound();

    protected abstract ResearchType getResearchType();

    protected int getResearchAmount() {
        return ScannableObjectRegistry.getScannableForEntity(this).map(ScannableObject::getResearchAmount).orElse(0);
    }

    protected abstract String getAnomalyName();

    public void setSpawnedFromCapsule(boolean spawnedFromCapsule) {
        this.spawnedFromCapsule = spawnedFromCapsule;
    }

    public boolean isSpawnedFromCapsule() {
        return this.spawnedFromCapsule;
    }

    public boolean isActive() {
        return true;
    }

    protected void updateSoundEffects() {
        if (!this.m_9236_().f_46443_) {
            return;
        }
        AnomalySoundClient soundClient = ClientServices.anomalySound();
        if (soundClient == null) {
            return;
        }
        soundClient.initializeIfNeeded();
        Player nearestPlayer = this.m_9236_().m_45930_((Entity)this, 10.0);
        if (nearestPlayer == null) {
            if (this.isSoundActive) {
                soundClient.stopAmbientSound(this.getAnomalySound());
                this.isSoundActive = false;
            }
            return;
        }
        double distance = this.m_20270_((Entity)nearestPlayer);
        if (distance > 10.0) {
            if (this.isSoundActive) {
                soundClient.stopAmbientSound(this.getAnomalySound());
                this.isSoundActive = false;
            }
            return;
        }
        float volume = this.calculateSoundVolume(distance);
        if (!this.isSoundActive) {
            soundClient.playAmbientSound(this.getAnomalySound(), this.m_20185_(), this.m_20186_(), this.m_20189_(), volume, true);
            this.isSoundActive = true;
            this.lastCalculatedVolume = volume;
        } else {
            if (Math.abs(volume - this.lastCalculatedVolume) > 0.01f) {
                soundClient.updateSoundVolume(this.getAnomalySound(), volume);
                this.lastCalculatedVolume = volume;
            }
            soundClient.updateSoundPosition(this.getAnomalySound(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
    }

    private float calculateSoundVolume(double distance) {
        float volumeRatio = 1.0f - (float)(distance / 10.0);
        volumeRatio = Math.max(0.0f, Math.min(1.0f, volumeRatio));
        return 0.5f + volumeRatio * 0.5f;
    }

    public float getRotation() {
        return ((Float)this.f_19804_.m_135370_(ROTATION)).floatValue();
    }

    public float getPulseIntensity() {
        return ((Float)this.f_19804_.m_135370_(PULSE_INTENSITY)).floatValue();
    }

    protected void setPulseIntensity(float intensity) {
        this.f_19804_.m_135381_(PULSE_INTENSITY, (Object)Float.valueOf(intensity));
    }

    public boolean isContained() {
        return (Boolean)this.f_19804_.m_135370_(IS_CONTAINED);
    }

    public void setContained(boolean contained) {
        this.f_19804_.m_135381_(IS_CONTAINED, (Object)contained);
    }

    public float getScale() {
        return ((Float)this.f_19804_.m_135370_(SCALE)).floatValue();
    }

    public void setScale(float scale) {
        this.f_19804_.m_135381_(SCALE, (Object)Float.valueOf(Math.max(0.1f, Math.min(2.0f, scale))));
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("Rotation")) {
            this.f_19804_.m_135381_(ROTATION, (Object)Float.valueOf(compound.m_128457_("Rotation")));
        }
        if (compound.m_128441_("PulseIntensity")) {
            this.f_19804_.m_135381_(PULSE_INTENSITY, (Object)Float.valueOf(compound.m_128457_("PulseIntensity")));
        }
        if (compound.m_128441_("IsContained")) {
            this.f_19804_.m_135381_(IS_CONTAINED, (Object)compound.m_128471_("IsContained"));
        }
        if (compound.m_128441_("Scale")) {
            this.f_19804_.m_135381_(SCALE, (Object)Float.valueOf(compound.m_128457_("Scale")));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("Rotation", ((Float)this.f_19804_.m_135370_(ROTATION)).floatValue());
        compound.m_128350_("PulseIntensity", ((Float)this.f_19804_.m_135370_(PULSE_INTENSITY)).floatValue());
        compound.m_128379_("IsContained", ((Boolean)this.f_19804_.m_135370_(IS_CONTAINED)).booleanValue());
        compound.m_128350_("Scale", ((Float)this.f_19804_.m_135370_(SCALE)).floatValue());
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public void registerAsScannable() {
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (this.isSoundActive) {
            this.stopSoundEffects();
        }
        super.m_142687_(reason);
    }

    protected void stopSoundEffects() {
        this.isSoundActive = false;
    }
}

