/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.energy;

import net.minecraftforge.energy.EnergyStorage;

public class ResonanceEnergyStorage
extends EnergyStorage {
    public ResonanceEnergyStorage(int capacity) {
        super(capacity);
    }

    public ResonanceEnergyStorage(int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
    }

    public ResonanceEnergyStorage(int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract);
    }

    public ResonanceEnergyStorage(int capacity, int maxReceive, int maxExtract, int energy) {
        super(capacity, maxReceive, maxExtract, energy);
    }

    public void setEnergy(int energy) {
        this.energy = Math.max(0, Math.min(energy, this.capacity));
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
        if (this.energy > capacity) {
            this.energy = capacity;
        }
    }

    public void setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
    }

    public void setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
    }

    public boolean canReceive() {
        return this.maxReceive > 0;
    }

    public boolean canExtract() {
        return this.maxExtract > 0;
    }

    public float getEnergyPercentage() {
        return this.capacity > 0 ? (float)this.energy / (float)this.capacity : 0.0f;
    }

    public int getEnergyPercentageInt() {
        return this.capacity > 0 ? (int)((float)this.energy / (float)this.capacity * 100.0f) : 0;
    }

    public boolean isFull() {
        return this.energy >= this.capacity;
    }

    public boolean isEmpty() {
        return this.energy <= 0;
    }
}

