/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.energy;

import com.hexvane.strangematter.energy.ResonanceEnergyStorage;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class ResonanceEnergyCapability
implements ICapabilityProvider {
    public static final Capability<IEnergyStorage> RESONANCE_ENERGY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IEnergyStorage>(){});
    private final ResonanceEnergyStorage energyStorage;
    private final LazyOptional<IEnergyStorage> energyOptional;

    public ResonanceEnergyCapability(int capacity) {
        this.energyStorage = new ResonanceEnergyStorage(capacity);
        this.energyOptional = LazyOptional.of(() -> this.energyStorage);
    }

    public ResonanceEnergyCapability(int capacity, int maxReceive, int maxExtract) {
        this.energyStorage = new ResonanceEnergyStorage(capacity, maxReceive, maxExtract);
        this.energyOptional = LazyOptional.of(() -> this.energyStorage);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == RESONANCE_ENERGY || cap == ForgeCapabilities.ENERGY) {
            return this.energyOptional.cast();
        }
        return LazyOptional.empty();
    }

    public ResonanceEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public void invalidate() {
        this.energyOptional.invalidate();
    }
}

