/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class WarpGateLocationData
extends SavedData {
    private final Map<UUID, BlockPos> warpGateLocations = new HashMap<UUID, BlockPos>();

    public static WarpGateLocationData create() {
        return new WarpGateLocationData();
    }

    public static WarpGateLocationData load(CompoundTag tag) {
        WarpGateLocationData data = new WarpGateLocationData();
        if (tag.m_128425_("warpGates", 9)) {
            ListTag warpGatesList = tag.m_128437_("warpGates", 10);
            for (int i = 0; i < warpGatesList.size(); ++i) {
                CompoundTag gateTag = warpGatesList.m_128728_(i);
                UUID gateId = gateTag.m_128342_("id");
                BlockPos pos = NbtUtils.m_129239_((CompoundTag)gateTag.m_128469_("pos"));
                data.warpGateLocations.put(gateId, pos);
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag warpGatesList = new ListTag();
        for (Map.Entry<UUID, BlockPos> entry : this.warpGateLocations.entrySet()) {
            CompoundTag gateTag = new CompoundTag();
            gateTag.m_128362_("id", entry.getKey());
            gateTag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)entry.getValue()));
            warpGatesList.add((Object)gateTag);
        }
        tag.m_128365_("warpGates", (Tag)warpGatesList);
        return tag;
    }

    public void addWarpGate(UUID gateId, BlockPos pos) {
        this.warpGateLocations.put(gateId, pos);
        this.m_77762_();
        System.out.println("WarpGate: Registered warp gate " + gateId + " at " + pos);
    }

    public void removeWarpGate(UUID gateId) {
        this.warpGateLocations.remove(gateId);
        this.m_77762_();
        System.out.println("WarpGate: Unregistered warp gate " + gateId);
    }

    public BlockPos getWarpGateLocation(UUID gateId) {
        return this.warpGateLocations.get(gateId);
    }

    public List<BlockPos> getAllWarpGateLocations() {
        return new ArrayList<BlockPos>(this.warpGateLocations.values());
    }

    public List<BlockPos> getUnpairedWarpGateLocations(UUID excludeId) {
        ArrayList<BlockPos> locations = new ArrayList<BlockPos>();
        for (Map.Entry<UUID, BlockPos> entry : this.warpGateLocations.entrySet()) {
            if (entry.getKey().equals(excludeId)) continue;
            locations.add(entry.getValue());
        }
        return locations;
    }

    public static WarpGateLocationData get(ServerLevel level) {
        DimensionDataStorage storage = level.m_8895_();
        return (WarpGateLocationData)storage.m_164861_(WarpGateLocationData::load, WarpGateLocationData::create, "warp_gate_locations");
    }
}

