/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.command;

import com.hexvane.strangematter.research.ResearchData;
import com.hexvane.strangematter.research.ResearchType;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ResearchPointsCondition {
    private static final DynamicCommandExceptionType INVALID_RESEARCH_TYPE = new DynamicCommandExceptionType(type -> Component.m_237113_((String)("Invalid research type: " + type)));

    public static boolean checkResearchPoints(CommandSourceStack source, Collection<ServerPlayer> targets, String researchTypeStr, int minPoints, int maxPoints) throws CommandSyntaxException {
        ResearchType researchType = ResearchPointsCondition.parseResearchType(researchTypeStr);
        if (researchType == null) {
            throw INVALID_RESEARCH_TYPE.create((Object)researchTypeStr);
        }
        for (ServerPlayer player : targets) {
            ResearchData researchData = ResearchData.get((Player)player);
            int points = researchData.getResearchPoints(researchType);
            if (points < minPoints || points > maxPoints) continue;
            return true;
        }
        return false;
    }

    public static boolean checkResearchPoints(CommandSourceStack source, Collection<ServerPlayer> targets, String researchTypeStr, int minPoints) throws CommandSyntaxException {
        return ResearchPointsCondition.checkResearchPoints(source, targets, researchTypeStr, minPoints, Integer.MAX_VALUE);
    }

    private static ResearchType parseResearchType(String researchTypeStr) {
        return switch (researchTypeStr.toLowerCase()) {
            case "gravity" -> ResearchType.GRAVITY;
            case "time" -> ResearchType.TIME;
            case "space" -> ResearchType.SPACE;
            case "energy" -> ResearchType.ENERGY;
            case "shadow" -> ResearchType.SHADOW;
            case "cognition" -> ResearchType.COGNITION;
            default -> null;
        };
    }

    public static class ResearchTypeArgument
    implements ArgumentType<String> {
        public String parse(StringReader reader) throws CommandSyntaxException {
            return reader.readUnquotedString();
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return SharedSuggestionProvider.m_82967_((String[])new String[]{"gravity", "time", "space", "energy", "shadow", "cognition"}, (SuggestionsBuilder)builder);
        }
    }
}

