/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.command;

import com.hexvane.strangematter.research.ResearchData;
import com.hexvane.strangematter.research.ResearchType;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ResearchPointsCommand {
    private static final DynamicCommandExceptionType INVALID_RESEARCH_TYPE = new DynamicCommandExceptionType(type -> Component.m_237113_((String)("Invalid research type: " + type)));
    private static final SuggestionProvider<CommandSourceStack> RESEARCH_TYPE_SUGGESTIONS = (context, builder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"gravity", "time", "space", "energy", "shadow", "cognition"}, (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"researchpoints").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"check").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"researchType", (ArgumentType)StringArgumentType.string()).suggests(RESEARCH_TYPE_SUGGESTIONS).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"minPoints", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ResearchPointsCommand::checkResearchPoints)).then(Commands.m_82129_((String)"maxPoints", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ResearchPointsCommand::checkResearchPointsRange)))))));
    }

    private static int checkResearchPoints(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(context, (String)"targets");
        String researchTypeStr = StringArgumentType.getString(context, (String)"researchType");
        ResearchType researchType = ResearchPointsCommand.parseResearchType(researchTypeStr);
        if (researchType == null) {
            throw INVALID_RESEARCH_TYPE.create((Object)researchTypeStr);
        }
        int minPoints = IntegerArgumentType.getInteger(context, (String)"minPoints");
        int maxPoints = Integer.MAX_VALUE;
        try {
            maxPoints = IntegerArgumentType.getInteger(context, (String)"maxPoints");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int successCount = 0;
        for (ServerPlayer player : targets) {
            ResearchData researchData = ResearchData.get((Player)player);
            int points = researchData.getResearchPoints(researchType);
            if (points < minPoints || points > maxPoints) continue;
            ++successCount;
        }
        return successCount;
    }

    private static int checkResearchPointsRange(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return ResearchPointsCommand.checkResearchPoints(context);
    }

    private static ResearchType parseResearchType(String researchTypeStr) {
        return switch (researchTypeStr.toLowerCase()) {
            case "gravity" -> ResearchType.GRAVITY;
            case "time" -> ResearchType.TIME;
            case "space" -> ResearchType.SPACE;
            case "energy" -> ResearchType.ENERGY;
            case "shadow" -> ResearchType.SHADOW;
            case "cognition" -> ResearchType.COGNITION;
            default -> null;
        };
    }
}

