/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.command;

import com.hexvane.strangematter.item.ResearchNoteItem;
import com.hexvane.strangematter.research.ResearchData;
import com.hexvane.strangematter.research.ResearchNode;
import com.hexvane.strangematter.research.ResearchNodeRegistry;
import com.hexvane.strangematter.research.ResearchType;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ResearchCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"research").requires(source -> source.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"check").executes(ResearchCommand::checkOwnResearch)).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(ResearchCommand::checkPlayerResearch)))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ResearchCommand::addResearch)).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(ResearchCommand::addResearchToPlayer)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").executes(ResearchCommand::resetOwnResearch)).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(ResearchCommand::resetPlayerResearch)))).then(Commands.m_82127_((String)"give").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"research_id", (ArgumentType)StringArgumentType.string()).executes(ResearchCommand::giveOwnResearchNote)).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(ResearchCommand::givePlayerResearchNote))))).then(Commands.m_82127_((String)"unlock").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"research_id", (ArgumentType)StringArgumentType.string()).executes(ResearchCommand::unlockOwnResearch)).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(ResearchCommand::unlockPlayerResearch))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"unlock_all").executes(ResearchCommand::unlockAllOwnResearch)).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(ResearchCommand::unlockAllPlayerResearch))));
    }

    private static int checkOwnResearch(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        return ResearchCommand.checkResearch(context, player);
    }

    private static int checkPlayerResearch(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)"target");
        int result = 0;
        for (ServerPlayer player : players) {
            result = ResearchCommand.checkResearch(context, player);
        }
        return result;
    }

    private static int checkResearch(CommandContext<CommandSourceStack> context, ServerPlayer player) {
        ResearchData researchData = ResearchData.get((Player)player);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a76Research Points for " + player.m_7755_().getString() + ":")), false);
        for (ResearchType type : ResearchType.values()) {
            int points = researchData.getResearchPoints(type);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7e" + type.getName() + ": \u00a7f" + points)), false);
        }
        int scannedCount = researchData.getScannedObjects().size();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7eScanned Objects: \u00a7f" + scannedCount)), false);
        return 1;
    }

    private static int addResearch(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        return ResearchCommand.addResearchToPlayers(context, List.of(player));
    }

    private static int addResearchToPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)"target");
        return ResearchCommand.addResearchToPlayers(context, players);
    }

    private static int addResearchToPlayers(CommandContext<CommandSourceStack> context, Collection<ServerPlayer> players) throws CommandSyntaxException {
        String typeName = (String)context.getArgument("type", String.class);
        int amount = (Integer)context.getArgument("amount", Integer.class);
        ResearchType type = ResearchType.fromName(typeName);
        if (type == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("\u00a7cInvalid research type: " + typeName)));
            return 0;
        }
        int result = 0;
        for (ServerPlayer player : players) {
            ResearchData researchData = ResearchData.get((Player)player);
            researchData.addResearchPoints(type, amount);
            researchData.syncToClient(player);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7aAdded " + amount + " " + type.getName() + " research points to " + player.m_7755_().getString())), true);
            result = 1;
        }
        return result;
    }

    private static int resetOwnResearch(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        return ResearchCommand.resetResearch(context, player);
    }

    private static int resetPlayerResearch(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)"target");
        int result = 0;
        for (ServerPlayer player : players) {
            result = ResearchCommand.resetResearch(context, player);
        }
        return result;
    }

    private static int resetResearch(CommandContext<CommandSourceStack> context, ServerPlayer player) {
        ResearchData researchData = ResearchData.get((Player)player);
        for (ResearchType type : ResearchType.values()) {
            researchData.addResearchPoints(type, -researchData.getResearchPoints(type));
        }
        researchData.setScannedObjects(Set.of());
        Set<String> defaultUnlocked = Set.of("foundation", "basic_scanner");
        researchData.setUnlockedResearch(defaultUnlocked);
        researchData.syncToClient(player);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7aReset all research data for " + player.m_7755_().getString())), true);
        return 1;
    }

    private static int giveOwnResearchNote(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        return ResearchCommand.giveResearchNoteToPlayers(context, List.of(player));
    }

    private static int givePlayerResearchNote(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)"target");
        return ResearchCommand.giveResearchNoteToPlayers(context, players);
    }

    private static int giveResearchNoteToPlayers(CommandContext<CommandSourceStack> context, Collection<ServerPlayer> players) throws CommandSyntaxException {
        String researchId = (String)context.getArgument("research_id", String.class);
        ResearchNode node = ResearchNodeRegistry.getNode(researchId);
        if (node == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("\u00a7cInvalid research ID: " + researchId)));
            return 0;
        }
        int result = 0;
        for (ServerPlayer player : players) {
            ItemStack researchNote = ResearchNoteItem.createResearchNote(node.getResearchCosts(), node.getId());
            if (player.m_150109_().m_36054_(researchNote)) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7aGave research notes for '" + node.getDisplayName().getString() + "' to " + player.m_7755_().getString())), true);
                result = 1;
                continue;
            }
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("\u00a7cFailed to give research notes to " + player.m_7755_().getString() + " (inventory full)")));
        }
        return result;
    }

    private static int unlockOwnResearch(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        return ResearchCommand.unlockResearchForPlayers(context, List.of(player));
    }

    private static int unlockPlayerResearch(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)"target");
        return ResearchCommand.unlockResearchForPlayers(context, players);
    }

    private static int unlockResearchForPlayers(CommandContext<CommandSourceStack> context, Collection<ServerPlayer> players) throws CommandSyntaxException {
        String researchId = (String)context.getArgument("research_id", String.class);
        ResearchNode node = ResearchNodeRegistry.getNode(researchId);
        if (node == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("\u00a7cInvalid research ID: " + researchId)));
            return 0;
        }
        int result = 0;
        for (ServerPlayer player : players) {
            ResearchData researchData = ResearchData.get((Player)player);
            if (researchData.hasUnlockedResearch(researchId)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("\u00a7c" + player.m_7755_().getString() + " has already unlocked '" + node.getDisplayName().getString() + "'")));
                continue;
            }
            researchData.unlockResearch(researchId);
            researchData.syncToClient(player);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7aUnlocked '" + node.getDisplayName().getString() + "' for " + player.m_7755_().getString())), true);
            result = 1;
        }
        return result;
    }

    private static int unlockAllOwnResearch(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        return ResearchCommand.unlockAllResearchForPlayers(context, List.of(player));
    }

    private static int unlockAllPlayerResearch(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)"target");
        return ResearchCommand.unlockAllResearchForPlayers(context, players);
    }

    private static int unlockAllResearchForPlayers(CommandContext<CommandSourceStack> context, Collection<ServerPlayer> players) throws CommandSyntaxException {
        Collection<ResearchNode> allNodes = ResearchNodeRegistry.getAllNodes();
        HashSet<String> allResearchIds = new HashSet<String>();
        for (ResearchNode node : allNodes) {
            allResearchIds.add(node.getId());
        }
        int result = 0;
        for (ServerPlayer player : players) {
            ResearchData researchData = ResearchData.get((Player)player);
            researchData.setUnlockedResearch(allResearchIds);
            researchData.syncToClient(player);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7aUnlocked all research for " + player.m_7755_().getString() + " (" + allResearchIds.size() + " research nodes)")), true);
            result = 1;
        }
        return result;
    }
}

