/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.command;

import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.entity.EchoingShadowEntity;
import com.hexvane.strangematter.entity.EnergeticRiftEntity;
import com.hexvane.strangematter.entity.GravityAnomalyEntity;
import com.hexvane.strangematter.entity.TemporalBloomEntity;
import com.hexvane.strangematter.entity.ThoughtwellEntity;
import com.hexvane.strangematter.entity.WarpGateAnomalyEntity;
import com.hexvane.strangematter.worldgen.WorldGenUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;

public class AnomalyCommand {
    private static final SimpleCommandExceptionType INVALID_ANOMALY_TYPE = new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Invalid anomaly type. Available types: gravity, warp_gate, energetic_rift, echoing_shadow, temporal_bloom, thoughtwell"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"anomaly").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"spawn").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).executes(AnomalyCommand::spawnAnomalyAtPlayer)).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(AnomalyCommand::spawnAnomalyAtPosition))))).then(Commands.m_82127_((String)"locate").then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).executes(AnomalyCommand::locateAnomaly)))).then(Commands.m_82127_((String)"list").executes(AnomalyCommand::listAnomalyTypes))).then(Commands.m_82127_((String)"debug_chunk").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(AnomalyCommand::debugChunkLoad))));
    }

    private static int spawnAnomalyAtPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String anomalyType = StringArgumentType.getString(context, (String)"type");
        ServerLevel level = source.m_81372_();
        BlockPos playerPos = source.m_81375_().m_20183_();
        BlockPos spawnPos = new BlockPos(playerPos.m_123341_(), level.m_6924_(Heightmap.Types.WORLD_SURFACE, playerPos.m_123341_(), playerPos.m_123343_()) + 2, playerPos.m_123343_());
        return AnomalyCommand.spawnAnomaly(source, anomalyType, spawnPos);
    }

    private static int spawnAnomalyAtPosition(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String anomalyType = StringArgumentType.getString(context, (String)"type");
        BlockPos spawnPos = BlockPosArgument.m_264582_(context, (String)"pos");
        return AnomalyCommand.spawnAnomaly(source, anomalyType, spawnPos);
    }

    private static int spawnAnomaly(CommandSourceStack source, String anomalyType, BlockPos spawnPos) throws CommandSyntaxException {
        ServerLevel level = source.m_81372_();
        switch (anomalyType.toLowerCase()) {
            case "gravity": {
                GravityAnomalyEntity gravityAnomaly = (GravityAnomalyEntity)((EntityType)StrangeMatterMod.GRAVITY_ANOMALY.get()).m_20615_((Level)level);
                if (gravityAnomaly != null) {
                    gravityAnomaly.m_6034_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_() + 1.0, (double)spawnPos.m_123343_() + 0.5);
                    level.m_7967_((Entity)gravityAnomaly);
                    source.m_288197_(() -> Component.m_237113_((String)("Spawned gravity anomaly at " + spawnPos.m_123341_() + ", " + spawnPos.m_123342_() + ", " + spawnPos.m_123343_())), true);
                    return 1;
                }
                throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Failed to create gravity anomaly entity")).create();
            }
            case "warp_gate": {
                WarpGateAnomalyEntity warpGate = (WarpGateAnomalyEntity)((EntityType)StrangeMatterMod.WARP_GATE_ANOMALY_ENTITY.get()).m_20615_((Level)level);
                if (warpGate != null) {
                    warpGate.m_6034_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_() + 1.0, (double)spawnPos.m_123343_() + 0.5);
                    warpGate.setActive(true);
                    level.m_7967_((Entity)warpGate);
                    AnomalyCommand.spawnAnomalousGrassAndOre(level, spawnPos);
                    source.m_288197_(() -> Component.m_237113_((String)("Spawned active warp gate anomaly at " + spawnPos.m_123341_() + ", " + spawnPos.m_123342_() + ", " + spawnPos.m_123343_() + " (ready for teleportation)")), true);
                    return 1;
                }
                throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Failed to create warp gate entity")).create();
            }
            case "energetic_rift": {
                EnergeticRiftEntity energeticRift = (EnergeticRiftEntity)((EntityType)StrangeMatterMod.ENERGETIC_RIFT.get()).m_20615_((Level)level);
                if (energeticRift != null) {
                    energeticRift.m_6034_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_() + 1.0, (double)spawnPos.m_123343_() + 0.5);
                    level.m_7967_((Entity)energeticRift);
                    AnomalyCommand.spawnAnomalousGrassAndOre(level, spawnPos);
                    source.m_288197_(() -> Component.m_237113_((String)("Spawned energetic rift at " + spawnPos.m_123341_() + ", " + spawnPos.m_123342_() + ", " + spawnPos.m_123343_())), true);
                    return 1;
                }
                throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Failed to create energetic rift entity")).create();
            }
            case "echoing_shadow": {
                EchoingShadowEntity echoingShadow = (EchoingShadowEntity)((EntityType)StrangeMatterMod.ECHOING_SHADOW.get()).m_20615_((Level)level);
                if (echoingShadow != null) {
                    echoingShadow.m_6034_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_() + 1.0, (double)spawnPos.m_123343_() + 0.5);
                    level.m_7967_((Entity)echoingShadow);
                    AnomalyCommand.spawnAnomalousGrassAndOre(level, spawnPos);
                    source.m_288197_(() -> Component.m_237113_((String)("Spawned echoing shadow at " + spawnPos.m_123341_() + ", " + spawnPos.m_123342_() + ", " + spawnPos.m_123343_())), true);
                    return 1;
                }
                throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Failed to create echoing shadow entity")).create();
            }
            case "temporal_bloom": {
                TemporalBloomEntity temporalBloom = (TemporalBloomEntity)((EntityType)StrangeMatterMod.TEMPORAL_BLOOM.get()).m_20615_((Level)level);
                if (temporalBloom != null) {
                    temporalBloom.m_6034_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_() + 1.0, (double)spawnPos.m_123343_() + 0.5);
                    level.m_7967_((Entity)temporalBloom);
                    AnomalyCommand.spawnAnomalousGrassAndOre(level, spawnPos);
                    source.m_288197_(() -> Component.m_237113_((String)("Spawned temporal bloom at " + spawnPos.m_123341_() + ", " + spawnPos.m_123342_() + ", " + spawnPos.m_123343_())), true);
                    return 1;
                }
                throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Failed to create temporal bloom entity")).create();
            }
            case "thoughtwell": {
                ThoughtwellEntity thoughtwell = (ThoughtwellEntity)((EntityType)StrangeMatterMod.THOUGHTWELL.get()).m_20615_((Level)level);
                if (thoughtwell != null) {
                    thoughtwell.m_6034_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_() + 1.0, (double)spawnPos.m_123343_() + 0.5);
                    level.m_7967_((Entity)thoughtwell);
                    AnomalyCommand.spawnAnomalousGrassAndOre(level, spawnPos);
                    source.m_288197_(() -> Component.m_237113_((String)("Spawned thoughtwell at " + spawnPos.m_123341_() + ", " + spawnPos.m_123342_() + ", " + spawnPos.m_123343_())), true);
                    return 1;
                }
                throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Failed to create thoughtwell entity")).create();
            }
        }
        throw INVALID_ANOMALY_TYPE.create();
    }

    private static int locateAnomaly(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String anomalyType = StringArgumentType.getString(context, (String)"type");
        ServerLevel serverLevel = source.m_81372_();
        BlockPos playerPos = source.m_81375_().m_20183_();
        switch (anomalyType.toLowerCase()) {
            case "gravity": {
                List gravityEntities = serverLevel.m_45976_(GravityAnomalyEntity.class, new AABB(playerPos).m_82400_(10000.0));
                if (gravityEntities.isEmpty()) {
                    source.m_288197_(() -> Component.m_237113_((String)"No gravity anomalies found within 10000 blocks"), false);
                    return 0;
                }
                GravityAnomalyEntity nearest = null;
                double nearestDistance = Double.MAX_VALUE;
                for (GravityAnomalyEntity entity : gravityEntities) {
                    double distance = playerPos.m_123331_((Vec3i)entity.m_20183_());
                    if (!(distance < nearestDistance)) continue;
                    nearest = entity;
                    nearestDistance = distance;
                }
                if (nearest == null) break;
                BlockPos nearestPos = nearest.m_20183_();
                double distance = Math.sqrt(nearestDistance);
                source.m_288197_(() -> Component.m_237113_((String)("Nearest gravity anomaly at " + nearestPos.m_123341_() + ", " + nearestPos.m_123342_() + ", " + nearestPos.m_123343_() + " (distance: " + String.format("%.1f", distance) + " blocks)")), false);
                return 1;
            }
            case "warp_gate": {
                try {
                    System.out.println("=== LOCATE COMMAND DEBUG ===");
                    System.out.println("Locate Command: Searching for warp gate structures from player position: " + playerPos);
                    System.out.println("Locate Command: Server level: " + serverLevel);
                    TagKey warpGateTag = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"warp_gate_anomaly"));
                    System.out.println("Locate Command: Created TagKey: " + warpGateTag);
                    System.out.println("Locate Command: Searching within 10000 blocks...");
                    BlockPos structurePos = serverLevel.m_215011_(warpGateTag, playerPos, 10000, false);
                    System.out.println("Locate Command: findNearestMapStructure result: " + structurePos);
                    if (structurePos == null) {
                        System.out.println("Locate Command: No structures found");
                        source.m_288197_(() -> Component.m_237113_((String)"No warp gate structures found within 10000 blocks"), false);
                        return 0;
                    }
                    double distance = Math.sqrt(playerPos.m_123331_((Vec3i)structurePos));
                    System.out.println("Locate Command: Found structure at " + structurePos + " (distance: " + distance + ")");
                    source.m_288197_(() -> Component.m_237113_((String)("Nearest warp gate structure at " + structurePos.m_123341_() + ", " + structurePos.m_123342_() + ", " + structurePos.m_123343_() + " (distance: " + String.format("%.1f", distance) + " blocks)")), false);
                    return 1;
                }
                catch (Exception e) {
                    System.out.println("Locate Command: Exception occurred: " + e.getMessage());
                    e.printStackTrace();
                    source.m_288197_(() -> Component.m_237113_((String)("Error locating warp gate structure: " + e.getMessage())), false);
                    return 0;
                }
            }
            case "energetic_rift": {
                List energeticRiftEntities = serverLevel.m_45976_(EnergeticRiftEntity.class, new AABB(playerPos).m_82400_(10000.0));
                if (energeticRiftEntities.isEmpty()) {
                    source.m_288197_(() -> Component.m_237113_((String)"No energetic rift anomalies found within 10000 blocks"), false);
                    return 0;
                }
                EnergeticRiftEntity nearestRift = null;
                double nearestRiftDistance = Double.MAX_VALUE;
                for (EnergeticRiftEntity entity : energeticRiftEntities) {
                    double distance = playerPos.m_123331_((Vec3i)entity.m_20183_());
                    if (!(distance < nearestRiftDistance)) continue;
                    nearestRift = entity;
                    nearestRiftDistance = distance;
                }
                if (nearestRift == null) break;
                BlockPos nearestPos = nearestRift.m_20183_();
                double distance = Math.sqrt(nearestRiftDistance);
                source.m_288197_(() -> Component.m_237113_((String)("Nearest energetic rift at " + nearestPos.m_123341_() + ", " + nearestPos.m_123342_() + ", " + nearestPos.m_123343_() + " (distance: " + String.format("%.1f", distance) + " blocks)")), false);
                return 1;
            }
            case "echoing_shadow": {
                List echoingShadowEntities = serverLevel.m_45976_(EchoingShadowEntity.class, new AABB(playerPos).m_82400_(10000.0));
                if (echoingShadowEntities.isEmpty()) {
                    source.m_288197_(() -> Component.m_237113_((String)"No echoing shadow anomalies found within 10000 blocks"), false);
                    return 0;
                }
                EchoingShadowEntity nearestShadow = null;
                double nearestShadowDistance = Double.MAX_VALUE;
                for (EchoingShadowEntity entity : echoingShadowEntities) {
                    double distance = playerPos.m_123331_((Vec3i)entity.m_20183_());
                    if (!(distance < nearestShadowDistance)) continue;
                    nearestShadow = entity;
                    nearestShadowDistance = distance;
                }
                if (nearestShadow == null) break;
                BlockPos nearestPos = nearestShadow.m_20183_();
                double distance = Math.sqrt(nearestShadowDistance);
                source.m_288197_(() -> Component.m_237113_((String)("Nearest echoing shadow at " + nearestPos.m_123341_() + ", " + nearestPos.m_123342_() + ", " + nearestPos.m_123343_() + " (distance: " + String.format("%.1f", distance) + " blocks)")), false);
                return 1;
            }
            case "temporal_bloom": {
                List temporalBloomEntities = serverLevel.m_45976_(TemporalBloomEntity.class, new AABB(playerPos).m_82400_(10000.0));
                if (temporalBloomEntities.isEmpty()) {
                    source.m_288197_(() -> Component.m_237113_((String)"No temporal bloom anomalies found within 10000 blocks"), false);
                    return 0;
                }
                TemporalBloomEntity nearestBloom = null;
                double nearestBloomDistance = Double.MAX_VALUE;
                for (TemporalBloomEntity entity : temporalBloomEntities) {
                    double distance = playerPos.m_123331_((Vec3i)entity.m_20183_());
                    if (!(distance < nearestBloomDistance)) continue;
                    nearestBloom = entity;
                    nearestBloomDistance = distance;
                }
                if (nearestBloom == null) break;
                BlockPos nearestPos = nearestBloom.m_20183_();
                double distance = Math.sqrt(nearestBloomDistance);
                source.m_288197_(() -> Component.m_237113_((String)("Nearest temporal bloom at " + nearestPos.m_123341_() + ", " + nearestPos.m_123342_() + ", " + nearestPos.m_123343_() + " (distance: " + String.format("%.1f", distance) + " blocks)")), false);
                return 1;
            }
            case "thoughtwell": {
                List thoughtwellEntities = serverLevel.m_45976_(ThoughtwellEntity.class, new AABB(playerPos).m_82400_(10000.0));
                if (thoughtwellEntities.isEmpty()) {
                    source.m_288197_(() -> Component.m_237113_((String)"No thoughtwell anomalies found within 10000 blocks"), false);
                    return 0;
                }
                ThoughtwellEntity nearestThoughtwell = null;
                double nearestThoughtwellDistance = Double.MAX_VALUE;
                for (ThoughtwellEntity entity : thoughtwellEntities) {
                    double distance = playerPos.m_123331_((Vec3i)entity.m_20183_());
                    if (!(distance < nearestThoughtwellDistance)) continue;
                    nearestThoughtwell = entity;
                    nearestThoughtwellDistance = distance;
                }
                if (nearestThoughtwell == null) break;
                BlockPos nearestPos = nearestThoughtwell.m_20183_();
                double distance = Math.sqrt(nearestThoughtwellDistance);
                source.m_288197_(() -> Component.m_237113_((String)("Nearest thoughtwell at " + nearestPos.m_123341_() + ", " + nearestPos.m_123342_() + ", " + nearestPos.m_123343_() + " (distance: " + String.format("%.1f", distance) + " blocks)")), false);
                return 1;
            }
            default: {
                throw INVALID_ANOMALY_TYPE.create();
            }
        }
        source.m_288197_(() -> Component.m_237113_((String)("No " + anomalyType + " anomalies found")), false);
        return 0;
    }

    private static int listAnomalyTypes(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_288197_(() -> Component.m_237113_((String)"Available anomaly types:"), false);
        source.m_288197_(() -> Component.m_237113_((String)"- gravity: Creates a floating icosahedron with levitation field"), false);
        source.m_288197_(() -> Component.m_237113_((String)"- warp_gate: Creates a spatial anomaly for teleportation"), false);
        source.m_288197_(() -> Component.m_237113_((String)"- energetic_rift: Creates an electric anomaly that zaps entities and strikes lightning rods"), false);
        source.m_288197_(() -> Component.m_237113_((String)"- echoing_shadow: Creates a shadow anomaly that absorbs light and boosts mob spawning"), false);
        source.m_288197_(() -> Component.m_237113_((String)"- temporal_bloom: Creates a temporal anomaly that affects crop growth and transforms mobs"), false);
        source.m_288197_(() -> Component.m_237113_((String)"- thoughtwell: Creates a cognitive anomaly that affects player perception and confuses mobs"), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"Commands:"), false);
        source.m_288197_(() -> Component.m_237113_((String)"- /anomaly spawn <type> [pos]: Spawn single anomaly"), false);
        source.m_288197_(() -> Component.m_237113_((String)"- /anomaly locate <type>: Locate nearest anomaly of specified type"), false);
        return 1;
    }

    private static void spawnAnomalousGrassAndOre(ServerLevel level, BlockPos centerPos) {
        int z;
        int x;
        RandomSource random = level.m_213780_();
        int radius = 2;
        for (x = -radius; x <= radius; ++x) {
            for (z = -radius; z <= radius; ++z) {
                BlockPos properGrassPos;
                BlockPos grassPos = centerPos.m_7918_(x, -1, z);
                if (!(random.m_188501_() < 0.8f) || (properGrassPos = WorldGenUtils.findAnomalousGrassPosition((WorldGenLevel)level, grassPos.m_123341_(), grassPos.m_123343_())) == null) continue;
                level.m_7731_(properGrassPos, ((Block)StrangeMatterMod.ANOMALOUS_GRASS_BLOCK.get()).m_49966_(), 2);
            }
        }
        for (x = -1; x <= 1; ++x) {
            for (z = -1; z <= 1; ++z) {
                for (int y = -3; y <= -1; ++y) {
                    BlockPos orePos = centerPos.m_7918_(x, y, z);
                    if (!(random.m_188501_() < 0.15f) || !level.m_8055_(orePos).m_60713_(Blocks.f_50069_)) continue;
                    level.m_7731_(orePos, ((Block)StrangeMatterMod.RESONITE_ORE_BLOCK.get()).m_49966_(), 2);
                }
            }
        }
    }

    private static int debugChunkLoad(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.m_81372_();
        BlockPos pos = BlockPosArgument.m_118242_(context, (String)"pos");
        source.m_288197_(() -> Component.m_237113_((String)("Debugging chunk load at " + pos)), false);
        try {
            TagKey warpGateTag = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"warp_gate_anomaly"));
            source.m_288197_(() -> Component.m_237113_((String)("Searching for warp gate structure with TagKey: " + warpGateTag)), false);
            BlockPos structurePos = level.m_215011_(warpGateTag, pos, 100, false);
            source.m_288197_(() -> Component.m_237113_((String)("Structure search result: " + structurePos)), false);
            if (structurePos != null) {
                List existingEntities = level.m_45976_(WarpGateAnomalyEntity.class, new AABB(structurePos).m_82400_(5.0));
                source.m_288197_(() -> Component.m_237113_((String)("Existing entities found: " + existingEntities.size())), false);
                if (existingEntities.isEmpty()) {
                    source.m_288197_(() -> Component.m_237113_((String)"No existing warp gate entity found, spawning new one"), false);
                    int surfaceY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, structurePos.m_123341_(), structurePos.m_123343_());
                    BlockPos surfacePos = new BlockPos(structurePos.m_123341_(), surfaceY, structurePos.m_123343_());
                    source.m_288197_(() -> Component.m_237113_((String)("Structure pos: " + structurePos + ", Surface pos: " + surfacePos)), false);
                    WarpGateAnomalyEntity warpGate = new WarpGateAnomalyEntity((EntityType)StrangeMatterMod.WARP_GATE_ANOMALY_ENTITY.get(), (Level)level);
                    warpGate.m_6034_((double)surfacePos.m_123341_() + 0.5, surfacePos.m_123342_() + 2, (double)surfacePos.m_123343_() + 0.5);
                    warpGate.setActive(true);
                    level.m_7967_((Entity)warpGate);
                    source.m_288197_(() -> Component.m_237113_((String)("Successfully spawned warp gate entity at " + surfacePos)), false);
                } else {
                    source.m_288197_(() -> Component.m_237113_((String)("Warp gate entity already exists at " + structurePos)), false);
                }
            } else {
                source.m_288197_(() -> Component.m_237113_((String)"No warp gate structure found near position"), false);
            }
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Error: " + e.getMessage())));
            e.printStackTrace();
        }
        return 1;
    }
}

