/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client.sound;

import java.io.InputStream;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC10;
import org.lwjgl.stb.STBVorbis;
import org.lwjgl.system.MemoryStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomSoundManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomSoundManager.class);
    private static CustomSoundManager instance;
    private final Map<ResourceLocation, Integer> soundBuffers = new ConcurrentHashMap<ResourceLocation, Integer>();
    private final Map<ResourceLocation, AmbientSoundInstance> activeSounds = new ConcurrentHashMap<ResourceLocation, AmbientSoundInstance>();
    private boolean initialized = false;

    private CustomSoundManager() {
    }

    public static CustomSoundManager getInstance() {
        if (instance == null) {
            instance = new CustomSoundManager();
        }
        return instance;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        try {
            long currentContext = ALC10.alcGetCurrentContext();
            if (currentContext == 0L) {
                LOGGER.warn("No OpenAL context available - Minecraft's audio system not initialized yet");
                return;
            }
            this.initialized = true;
            LOGGER.info("Custom Sound Manager initialized using Minecraft's OpenAL context");
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize Custom Sound Manager", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSound(ResourceLocation soundLocation) {
        if (!this.initialized) {
            return;
        }
        try {
            String path = "assets/" + soundLocation.m_135827_() + "/sounds/" + soundLocation.m_135815_() + ".ogg";
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(path);
            if (inputStream == null) {
                LOGGER.warn("Could not find sound file: " + path);
                return;
            }
            Path tempFile = Files.createTempFile("sound", ".ogg", new FileAttribute[0]);
            Files.copy(inputStream, tempFile, StandardCopyOption.REPLACE_EXISTING);
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer channels = stack.mallocInt(1);
                IntBuffer sampleRate = stack.mallocInt(1);
                ShortBuffer rawAudioBuffer = STBVorbis.stb_vorbis_decode_filename((CharSequence)tempFile.toString(), (IntBuffer)channels, (IntBuffer)sampleRate);
                if (rawAudioBuffer == null) {
                    LOGGER.error("Failed to decode sound file: " + path);
                    return;
                }
                int buffer = AL10.alGenBuffers();
                AL10.alBufferData((int)buffer, (int)4353, (ShortBuffer)rawAudioBuffer, (int)sampleRate.get(0));
                this.soundBuffers.put(soundLocation, buffer);
                LOGGER.info("Loaded sound: " + soundLocation);
            }
            finally {
                Files.deleteIfExists(tempFile);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load sound: " + soundLocation, (Throwable)e);
        }
    }

    public void playAmbientSound(ResourceLocation soundLocation, double x, double y, double z, float volume, boolean loop) {
        if (!this.initialized || !this.soundBuffers.containsKey(soundLocation)) {
            this.loadSound(soundLocation);
            if (!this.soundBuffers.containsKey(soundLocation)) {
                return;
            }
        }
        this.stopAmbientSound(soundLocation);
        AmbientSoundInstance instance = new AmbientSoundInstance(soundLocation, x, y, z, volume, loop);
        this.activeSounds.put(soundLocation, instance);
        instance.start();
    }

    public void updateSoundVolume(ResourceLocation soundLocation, float newVolume) {
        AmbientSoundInstance instance = this.activeSounds.get(soundLocation);
        if (instance != null) {
            instance.setVolume(newVolume);
        }
    }

    public void updateSoundPosition(ResourceLocation soundLocation, double x, double y, double z) {
        AmbientSoundInstance instance = this.activeSounds.get(soundLocation);
        if (instance != null) {
            instance.setPosition(x, y, z);
        }
    }

    public void stopAmbientSound(ResourceLocation soundLocation) {
        AmbientSoundInstance instance = this.activeSounds.remove(soundLocation);
        if (instance != null) {
            instance.stop();
        }
    }

    public void shutdown() {
        LOGGER.info("Shutting down Custom Sound Manager");
        this.cleanup();
    }

    public void stopAllSounds() {
        for (AmbientSoundInstance instance : this.activeSounds.values()) {
            instance.stop();
        }
        this.activeSounds.clear();
    }

    public void cleanup() {
        this.stopAllSounds();
        for (Map.Entry<ResourceLocation, Integer> entry : this.soundBuffers.entrySet()) {
            try {
                int buffer = entry.getValue();
                if (buffer == 0) continue;
                AL10.alDeleteBuffers((int)buffer);
            }
            catch (Exception e) {
                LOGGER.warn("Error deleting sound buffer for " + entry.getKey(), (Throwable)e);
            }
        }
        this.soundBuffers.clear();
        if (this.initialized) {
            this.initialized = false;
            LOGGER.info("Custom Sound Manager cleaned up (preserving Minecraft's OpenAL context)");
        }
    }

    private static class AmbientSoundInstance {
        private final ResourceLocation soundLocation;
        private final int source;
        private final boolean loop;
        private double x;
        private double y;
        private double z;
        private float volume;
        private boolean playing = false;

        public AmbientSoundInstance(ResourceLocation soundLocation, double x, double y, double z, float volume, boolean loop) {
            this.soundLocation = soundLocation;
            this.x = x;
            this.y = y;
            this.z = z;
            this.volume = volume;
            this.loop = loop;
            this.source = AL10.alGenSources();
            AL10.alSourcei((int)this.source, (int)4105, (int)CustomSoundManager.getInstance().soundBuffers.get(soundLocation));
            AL10.alSourcei((int)this.source, (int)4103, (int)(loop ? 1 : 0));
            AL10.alSource3f((int)this.source, (int)4100, (float)((float)x), (float)((float)y), (float)((float)z));
            AL10.alSourcef((int)this.source, (int)4106, (float)volume);
            AL10.alSourcef((int)this.source, (int)4128, (float)1.0f);
            AL10.alSourcef((int)this.source, (int)4131, (float)10.0f);
            AL10.alSourcef((int)this.source, (int)4129, (float)1.0f);
        }

        public void start() {
            if (!this.playing) {
                AL10.alSourcePlay((int)this.source);
                this.playing = true;
            }
        }

        public void stop() {
            if (this.playing) {
                try {
                    int state = AL10.alGetSourcei((int)this.source, (int)4112);
                    if (state != -1) {
                        AL10.alSourceStop((int)this.source);
                        AL10.alDeleteSources((int)this.source);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Error stopping sound source", (Throwable)e);
                }
                finally {
                    this.playing = false;
                }
            }
        }

        public void setVolume(float newVolume) {
            this.volume = newVolume;
            if (this.playing) {
                try {
                    int state = AL10.alGetSourcei((int)this.source, (int)4112);
                    if (state != -1) {
                        AL10.alSourcef((int)this.source, (int)4106, (float)this.volume);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Error setting sound volume", (Throwable)e);
                }
            }
        }

        public void setPosition(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
            if (this.playing) {
                try {
                    int state = AL10.alGetSourcei((int)this.source, (int)4112);
                    if (state != -1) {
                        AL10.alSource3f((int)this.source, (int)4100, (float)((float)x), (float)((float)y), (float)((float)z));
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Error setting sound position", (Throwable)e);
                }
            }
        }

        public boolean isPlaying() {
            return this.playing && AL10.alGetSourcei((int)this.source, (int)4112) == 4114;
        }
    }
}

