/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client.screen.minigames;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.client.screen.minigames.ResearchMinigame;
import com.hexvane.strangematter.research.ResearchType;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class TimeMinigame
extends ResearchMinigame {
    private static final int CLOCK_WIDTH = 34;
    private static final int CLOCK_HEIGHT = 33;
    private static final int MINUTE_HAND_LENGTH = 12;
    private static final int SECOND_HAND_LENGTH = 14;
    private static final int BUTTON_SIZE = 12;
    private static final int LIGHT_SIZE = 8;
    private static final int MINUTE_HAND_COLOR = -12982047;
    private static final int SECOND_HAND_COLOR = -6929990;
    private static final int FADED_HAND_COLOR = -2130706433;
    private static final double MAX_SPEED = 2.0;
    private static final ResourceLocation CLOCK_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/time_clock.png");
    private static final ResourceLocation LEFT_BUTTON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/left_button.png");
    private static final ResourceLocation RIGHT_BUTTON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/right_button.png");
    private static final ResourceLocation LIGHT_ON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/time_light_on.png");
    private static final ResourceLocation LIGHT_OFF_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/time_light_off.png");
    private double clockSpeed = 1.0;
    private double targetSpeed = 1.0;
    private double fadedHandSpeed = 1.0;
    private double clockAngle = 0.0;
    private double minuteAngle = 0.0;
    private double fadedHandAngle = 0.0;
    private int secondCounter = 0;
    private int minuteCounter = 0;
    private int fadedHandCounter = 0;
    private boolean lightOn = false;
    private int lightTick = 0;
    private boolean isStable = false;
    private int stableTicks = 0;
    private boolean isDrifting = false;
    private int driftTicks = 0;
    private boolean leftButtonHovered = false;
    private boolean rightButtonHovered = false;
    private boolean leftButtonPressed = false;
    private boolean rightButtonPressed = false;
    private int buttonCooldown = 0;
    private static final int BUTTON_COOLDOWN_TICKS = 5;
    private Minecraft minecraft = Minecraft.m_91087_();

    private double getSpeedAdjustment() {
        return Config.timeSpeedAdjustment;
    }

    private double getSpeedThreshold() {
        return Config.timeSpeedThreshold;
    }

    private int getDriftDelayTicks() {
        return Config.timeDriftDelayTicks;
    }

    private double getSnapThreshold() {
        return Config.timeSnapThreshold;
    }

    public TimeMinigame() {
        super(ResearchType.TIME);
    }

    @Override
    public void activate() {
        super.activate();
        this.clockSpeed = 1.0;
        this.targetSpeed = 1.0;
        this.fadedHandSpeed = 1.0;
        this.clockAngle = 0.0;
        this.minuteAngle = 0.0;
        this.fadedHandAngle = 0.0;
        this.secondCounter = 0;
        this.minuteCounter = 0;
        this.fadedHandCounter = 0;
        this.lightOn = false;
        this.lightTick = 0;
        this.isStable = false;
        this.stableTicks = 0;
        this.isDrifting = false;
        this.driftTicks = 0;
        this.leftButtonHovered = false;
        this.rightButtonHovered = false;
        this.leftButtonPressed = false;
        this.rightButtonPressed = false;
        this.buttonCooldown = 0;
        this.clockSpeed = Math.random() < 0.5 ? 0.3 + Math.random() * 0.4 : 1.3 + Math.random() * 0.4;
        this.minuteAngle = Math.random() * 360.0;
        this.fadedHandAngle = Math.random() * 360.0;
        this.setState(ResearchMinigame.MinigameState.UNSTABLE);
    }

    @Override
    protected void onActivate() {
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.leftButtonPressed = false;
        this.rightButtonPressed = false;
    }

    @Override
    protected void onDeactivate() {
        this.leftButtonPressed = false;
        this.rightButtonPressed = false;
        this.leftButtonHovered = false;
        this.rightButtonHovered = false;
    }

    @Override
    protected boolean handleClick(int mouseX, int mouseY, int button, int panelX, int panelY, int panelWidth, int panelHeight) {
        if (!this.isActive) {
            return false;
        }
        int leftButtonX = panelX + panelWidth / 2 - 12 - 5;
        int rightButtonX = panelX + panelWidth / 2 + 5;
        int buttonY = panelY + panelHeight / 2 + 16 + 5;
        if (button == 0 && this.buttonCooldown <= 0) {
            if (mouseX >= leftButtonX && mouseX < leftButtonX + 12 && mouseY >= buttonY && mouseY < buttonY + 12) {
                this.leftButtonPressed = true;
                this.adjustSpeed(-1.0);
                this.buttonCooldown = 5;
                if (this.minecraft != null && this.minecraft.f_91074_ != null) {
                    this.minecraft.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.RESEARCH_MACHINE_NOTE_INSERT.get(), 0.3f, 1.0f);
                }
                return true;
            }
            if (mouseX >= rightButtonX && mouseX < rightButtonX + 12 && mouseY >= buttonY && mouseY < buttonY + 12) {
                this.rightButtonPressed = true;
                this.adjustSpeed(1.0);
                this.buttonCooldown = 5;
                if (this.minecraft != null && this.minecraft.f_91074_ != null) {
                    this.minecraft.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.RESEARCH_MACHINE_NOTE_INSERT.get(), 0.3f, 1.0f);
                }
                return true;
            }
        }
        return false;
    }

    public void handleMouseDrag(int mouseX, int mouseY, int panelX, int panelY, int panelWidth, int panelHeight) {
    }

    public void handleMouseRelease(int mouseX, int mouseY, int panelX, int panelY, int panelWidth, int panelHeight, int button) {
        if (!this.isActive) {
            return;
        }
        if (button == 0) {
            this.leftButtonPressed = false;
            this.rightButtonPressed = false;
        }
    }

    public void updateHoverStates(int mouseX, int mouseY, int panelX, int panelY, int panelWidth, int panelHeight) {
        if (!this.isActive) {
            return;
        }
        int leftButtonX = panelX + panelWidth / 2 - 12 - 5;
        int rightButtonX = panelX + panelWidth / 2 + 5;
        int buttonY = panelY + panelHeight / 2 + 16 + 5;
        this.leftButtonHovered = mouseX >= leftButtonX && mouseX < leftButtonX + 12 && mouseY >= buttonY && mouseY < buttonY + 12;
        this.rightButtonHovered = mouseX >= rightButtonX && mouseX < rightButtonX + 12 && mouseY >= buttonY && mouseY < buttonY + 12;
    }

    @Override
    public void updateMinigame() {
        if (!this.isActive) {
            return;
        }
        if (this.buttonCooldown > 0) {
            --this.buttonCooldown;
        }
        this.updateClock();
        this.updateLight();
        this.checkStability();
        this.updateDrift();
    }

    private void updateClock() {
        this.clockAngle += this.clockSpeed * 6.0;
        while (this.clockAngle >= 360.0) {
            this.clockAngle -= 360.0;
            ++this.secondCounter;
        }
        while (this.clockAngle < 0.0) {
            this.clockAngle += 360.0;
            --this.secondCounter;
        }
        if (this.secondCounter >= 60) {
            this.secondCounter = 0;
            ++this.minuteCounter;
            this.minuteAngle += 6.0;
        } else if (this.secondCounter < 0) {
            this.secondCounter = 59;
            --this.minuteCounter;
            this.minuteAngle -= 6.0;
        }
        while (this.minuteAngle >= 360.0) {
            this.minuteAngle -= 360.0;
        }
        while (this.minuteAngle < 0.0) {
            this.minuteAngle += 360.0;
        }
        this.fadedHandAngle += this.fadedHandSpeed * 6.0;
        while (this.fadedHandAngle >= 360.0) {
            this.fadedHandAngle -= 360.0;
            ++this.fadedHandCounter;
        }
        while (this.fadedHandAngle < 0.0) {
            this.fadedHandAngle += 360.0;
            --this.fadedHandCounter;
        }
        this.checkAutoSnap();
    }

    private void updateLight() {
        ++this.lightTick;
        if (this.lightTick >= 20) {
            this.lightTick = 0;
            this.lightOn = !this.lightOn;
        }
    }

    private void checkStability() {
        boolean speedMatch;
        double threshold = this.getSpeedThreshold();
        boolean bl = speedMatch = Math.abs(this.clockSpeed - this.fadedHandSpeed) < threshold;
        if (speedMatch) {
            if (!this.isStable) {
                this.isStable = true;
                this.stableTicks = 0;
                this.setState(ResearchMinigame.MinigameState.STABLE);
                this.syncHandAngles();
            } else {
                ++this.stableTicks;
            }
        } else {
            this.isStable = false;
            this.stableTicks = 0;
            this.setState(ResearchMinigame.MinigameState.UNSTABLE);
        }
    }

    private void updateDrift() {
        int driftDelay = this.getDriftDelayTicks();
        if (this.isStable && this.stableTicks >= driftDelay) {
            if (!this.isDrifting) {
                this.isDrifting = true;
                this.driftTicks = 0;
            } else {
                ++this.driftTicks;
                double driftSpeed = 0.01;
                this.fadedHandSpeed += (Math.random() - 0.5) * driftSpeed;
                this.fadedHandSpeed = Math.max(0.1, Math.min(2.0, this.fadedHandSpeed));
            }
        } else {
            this.isDrifting = false;
        }
    }

    private void adjustSpeed(double adjustment) {
        double step = this.getSpeedAdjustment();
        this.clockSpeed += adjustment * step;
        this.clockSpeed = Math.max(-2.0, Math.min(2.0, this.clockSpeed));
        this.checkAutoSnap();
    }

    private void checkAutoSnap() {
        double snapThreshold = this.getSnapThreshold();
        if (Math.abs(this.clockSpeed - this.fadedHandSpeed) < snapThreshold) {
            this.clockSpeed = this.fadedHandSpeed;
        }
    }

    private void syncHandAngles() {
        this.clockAngle = this.fadedHandAngle;
        this.secondCounter = this.fadedHandCounter;
    }

    @Override
    public void renderActive(GuiGraphics guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        int clockX = x + width / 2 - 17;
        int clockY = y + height / 2 - 16;
        guiGraphics.m_280163_(CLOCK_TEXTURE, clockX, clockY, 0.0f, 0.0f, 34, 33, 34, 33);
        this.renderHands(guiGraphics, clockX + 17, clockY + 16);
        this.renderButtons(guiGraphics, x, y, width, height);
        this.renderLight(guiGraphics, x, y, width, height);
    }

    @Override
    public void renderInactive(GuiGraphics guiGraphics, int x, int y, int width, int height) {
    }

    private void renderHands(GuiGraphics guiGraphics, int centerX, int centerY) {
        double minuteRad = Math.toRadians(this.minuteAngle - 90.0);
        double secondRad = Math.toRadians(this.clockAngle - 90.0);
        double fadedRad = Math.toRadians(this.fadedHandAngle - 90.0);
        int minuteEndX = centerX + (int)(Math.cos(minuteRad) * 12.0);
        int minuteEndY = centerY + (int)(Math.sin(minuteRad) * 12.0);
        int secondEndX = centerX + (int)(Math.cos(secondRad) * 14.0);
        int secondEndY = centerY + (int)(Math.sin(secondRad) * 14.0);
        int fadedEndX = centerX + (int)(Math.cos(fadedRad) * 14.0);
        int fadedEndY = centerY + (int)(Math.sin(fadedRad) * 14.0);
        this.drawLine(guiGraphics, centerX, centerY, minuteEndX, minuteEndY, -12982047);
        this.drawLine(guiGraphics, centerX, centerY, fadedEndX, fadedEndY, -2130706433);
        this.drawLine(guiGraphics, centerX, centerY, secondEndX, secondEndY, -6929990);
    }

    private void drawLine(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int color) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int err = dx - dy;
        int x = x1;
        int y = y1;
        while (true) {
            guiGraphics.m_280509_(x, y, x + 1, y + 1, color);
            if (x == x2 && y == y2) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y += sy;
        }
    }

    private void renderButtons(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        int leftButtonX = x + width / 2 - 12 - 5;
        int rightButtonX = x + width / 2 + 5;
        int buttonY = y + height / 2 + 16 + 5;
        if (this.leftButtonPressed) {
            guiGraphics.m_280246_(0.8f, 0.8f, 0.8f, 1.0f);
        } else if (this.leftButtonHovered) {
            guiGraphics.m_280246_(1.2f, 1.2f, 1.2f, 1.0f);
        } else {
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        }
        guiGraphics.m_280163_(LEFT_BUTTON_TEXTURE, leftButtonX, buttonY, 0.0f, 0.0f, 12, 12, 12, 12);
        if (this.rightButtonPressed) {
            guiGraphics.m_280246_(0.8f, 0.8f, 0.8f, 1.0f);
        } else if (this.rightButtonHovered) {
            guiGraphics.m_280246_(1.2f, 1.2f, 1.2f, 1.0f);
        } else {
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        }
        guiGraphics.m_280163_(RIGHT_BUTTON_TEXTURE, rightButtonX, buttonY, 0.0f, 0.0f, 12, 12, 12, 12);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderLight(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        int lightX = x + width / 2 - 4;
        int lightY = y + height / 2 - 16 - 8 - 5;
        ResourceLocation lightTexture = this.lightOn ? LIGHT_ON_TEXTURE : LIGHT_OFF_TEXTURE;
        guiGraphics.m_280163_(lightTexture, lightX, lightY, 0.0f, 0.0f, 8, 8, 8, 8);
    }

    public double getClockSpeed() {
        return this.clockSpeed;
    }

    public void setClockSpeed(double clockSpeed) {
        this.clockSpeed = clockSpeed;
    }

    public double getTargetSpeed() {
        return this.targetSpeed;
    }

    public void setTargetSpeed(double targetSpeed) {
        this.targetSpeed = targetSpeed;
    }

    public double getFadedHandSpeed() {
        return this.fadedHandSpeed;
    }

    public void setFadedHandSpeed(double fadedHandSpeed) {
        this.fadedHandSpeed = fadedHandSpeed;
    }

    public double getClockAngle() {
        return this.clockAngle;
    }

    public void setClockAngle(double clockAngle) {
        this.clockAngle = clockAngle;
    }

    public double getMinuteAngle() {
        return this.minuteAngle;
    }

    public void setMinuteAngle(double minuteAngle) {
        this.minuteAngle = minuteAngle;
    }

    public double getFadedHandAngle() {
        return this.fadedHandAngle;
    }

    public void setFadedHandAngle(double fadedHandAngle) {
        this.fadedHandAngle = fadedHandAngle;
    }

    public int getSecondCounter() {
        return this.secondCounter;
    }

    public void setSecondCounter(int secondCounter) {
        this.secondCounter = secondCounter;
    }

    public int getMinuteCounter() {
        return this.minuteCounter;
    }

    public void setMinuteCounter(int minuteCounter) {
        this.minuteCounter = minuteCounter;
    }

    public int getFadedHandCounter() {
        return this.fadedHandCounter;
    }

    public void setFadedHandCounter(int fadedHandCounter) {
        this.fadedHandCounter = fadedHandCounter;
    }

    public boolean isLightOn() {
        return this.lightOn;
    }

    public void setLightOn(boolean lightOn) {
        this.lightOn = lightOn;
    }

    public int getLightTick() {
        return this.lightTick;
    }

    public void setLightTick(int lightTick) {
        this.lightTick = lightTick;
    }

    @Override
    public boolean isStable() {
        return this.isStable;
    }

    public void setStable(boolean stable) {
        this.isStable = stable;
    }

    public int getStableTicks() {
        return this.stableTicks;
    }

    public void setStableTicks(int stableTicks) {
        this.stableTicks = stableTicks;
    }

    public boolean isDrifting() {
        return this.isDrifting;
    }

    public void setDrifting(boolean drifting) {
        this.isDrifting = drifting;
    }

    public int getDriftTicks() {
        return this.driftTicks;
    }

    public void setDriftTicks(int driftTicks) {
        this.driftTicks = driftTicks;
    }

    public int getButtonCooldown() {
        return this.buttonCooldown;
    }

    public void setButtonCooldown(int buttonCooldown) {
        this.buttonCooldown = buttonCooldown;
    }
}

