/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client.screen.minigames;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.client.screen.minigames.ResearchMinigame;
import com.hexvane.strangematter.research.ResearchType;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class SpaceMinigame
extends ResearchMinigame {
    private static final int IMAGE_WIDTH = 32;
    private static final int IMAGE_HEIGHT = 32;
    private static final int CONTROL_SIZE = 12;
    private static final int CONTROL_SPACING = 5;
    private static final double MAX_WARP = 1.0;
    private static final ResourceLocation SPACE_IMAGE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/space_image.png");
    private static final ResourceLocation LEFT_BUTTON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/left_button.png");
    private static final ResourceLocation RIGHT_BUTTON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/right_button.png");
    private double warpAmount = 1.0;
    private double targetWarp = 0.0;
    private double warpX = 0.0;
    private double warpY = 0.0;
    private boolean isStable = false;
    private int stableTicks = 0;
    private boolean isDrifting = false;
    private int driftTicks = 0;
    private double warpDrift = 0.0;
    private boolean leftButtonHovered = false;
    private boolean rightButtonHovered = false;
    private boolean leftButtonPressed = false;
    private boolean rightButtonPressed = false;
    private int buttonCooldown = 0;
    private static final int BUTTON_COOLDOWN_TICKS = 5;
    private Minecraft minecraft = Minecraft.m_91087_();

    private double getWarpAdjustment() {
        return Config.spaceWarpAdjustment;
    }

    private double getStabilityThreshold() {
        return Config.spaceStabilityThreshold;
    }

    private int getDriftDelayTicks() {
        return Config.spaceDriftDelayTicks;
    }

    public SpaceMinigame() {
        super(ResearchType.SPACE);
    }

    @Override
    public void activate() {
        super.activate();
        this.warpAmount = 1.0;
        this.targetWarp = 0.0;
        this.warpX = 0.0;
        this.warpY = 0.0;
        this.isStable = false;
        this.stableTicks = 0;
        this.isDrifting = false;
        this.driftTicks = 0;
        this.warpDrift = 0.0;
        this.leftButtonHovered = false;
        this.rightButtonHovered = false;
        this.leftButtonPressed = false;
        this.rightButtonPressed = false;
        this.buttonCooldown = 0;
        this.warpAmount = Math.random() < 0.5 ? 0.8 + Math.random() * 0.2 : 0.0 + Math.random() * 0.2;
        this.warpX = (Math.random() - 0.5) * 0.5;
        this.warpY = (Math.random() - 0.5) * 0.5;
        this.setState(ResearchMinigame.MinigameState.UNSTABLE);
    }

    @Override
    protected void onActivate() {
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.leftButtonPressed = false;
        this.rightButtonPressed = false;
    }

    @Override
    protected void onDeactivate() {
        this.leftButtonPressed = false;
        this.rightButtonPressed = false;
        this.leftButtonHovered = false;
        this.rightButtonHovered = false;
    }

    @Override
    protected boolean handleClick(int mouseX, int mouseY, int button, int panelX, int panelY, int panelWidth, int panelHeight) {
        if (!this.isActive) {
            return false;
        }
        int imageX = panelX + panelWidth / 2 - 16;
        int imageY = panelY + panelHeight / 2 - 16 - 10;
        int controlsY = imageY + 32 + 10;
        int leftButtonX = panelX + panelWidth / 2 - 12 - 5;
        int rightButtonX = panelX + panelWidth / 2 + 5;
        if (button == 0 && this.buttonCooldown <= 0) {
            if (mouseX >= leftButtonX && mouseX < leftButtonX + 12 && mouseY >= controlsY && mouseY < controlsY + 12) {
                this.leftButtonPressed = true;
                this.adjustWarp(-1.0);
                this.buttonCooldown = 5;
                if (this.minecraft != null && this.minecraft.f_91074_ != null) {
                    this.minecraft.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.RESEARCH_MACHINE_NOTE_INSERT.get(), 0.3f, 1.0f);
                }
                return true;
            }
            if (mouseX >= rightButtonX && mouseX < rightButtonX + 12 && mouseY >= controlsY && mouseY < controlsY + 12) {
                this.rightButtonPressed = true;
                this.adjustWarp(1.0);
                this.buttonCooldown = 5;
                if (this.minecraft != null && this.minecraft.f_91074_ != null) {
                    this.minecraft.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.RESEARCH_MACHINE_NOTE_INSERT.get(), 0.3f, 1.0f);
                }
                return true;
            }
        }
        return false;
    }

    public void handleMouseDrag(int mouseX, int mouseY, int panelX, int panelY, int panelWidth, int panelHeight) {
    }

    public void handleMouseRelease(int mouseX, int mouseY, int panelX, int panelY, int panelWidth, int panelHeight, int button) {
        if (!this.isActive) {
            return;
        }
        if (button == 0) {
            this.leftButtonPressed = false;
            this.rightButtonPressed = false;
        }
    }

    public void updateHoverStates(int mouseX, int mouseY, int panelX, int panelY, int panelWidth, int panelHeight) {
        if (!this.isActive) {
            return;
        }
        int imageY = panelY + panelHeight / 2 - 16 - 10;
        int controlsY = imageY + 32 + 10;
        int leftButtonX = panelX + panelWidth / 2 - 12 - 5;
        int rightButtonX = panelX + panelWidth / 2 + 5;
        this.leftButtonHovered = mouseX >= leftButtonX && mouseX < leftButtonX + 12 && mouseY >= controlsY && mouseY < controlsY + 12;
        this.rightButtonHovered = mouseX >= rightButtonX && mouseX < rightButtonX + 12 && mouseY >= controlsY && mouseY < controlsY + 12;
    }

    @Override
    public void updateMinigame() {
        if (!this.isActive) {
            return;
        }
        if (this.buttonCooldown > 0) {
            --this.buttonCooldown;
        }
        if (Math.random() < 0.01) {
            double randomDrift = (Math.random() - 0.5) * 0.01;
            this.warpAmount = Math.max(0.0, Math.min(1.0, this.warpAmount + randomDrift));
        }
        this.checkStability();
        this.updateDrift();
    }

    private void checkStability() {
        boolean warpMatch;
        double threshold = this.getStabilityThreshold();
        boolean bl = warpMatch = Math.abs(this.warpAmount - this.targetWarp) < threshold;
        if (warpMatch) {
            if (!this.isStable) {
                this.isStable = true;
                this.stableTicks = 0;
                this.setState(ResearchMinigame.MinigameState.STABLE);
            } else {
                ++this.stableTicks;
            }
        } else {
            this.isStable = false;
            this.stableTicks = 0;
            this.setState(ResearchMinigame.MinigameState.UNSTABLE);
        }
    }

    private void updateDrift() {
        int driftDelay = this.getDriftDelayTicks();
        if (this.isStable && this.stableTicks >= driftDelay) {
            if (!this.isDrifting) {
                this.isDrifting = true;
                this.driftTicks = 0;
            } else {
                ++this.driftTicks;
                double driftSpeed = 0.02;
                this.warpDrift += (Math.random() - 0.5) * driftSpeed;
                this.warpDrift = Math.max(-0.2, Math.min(0.2, this.warpDrift));
                this.warpAmount = Math.max(0.0, Math.min(1.0, this.warpAmount + this.warpDrift));
            }
        } else {
            this.isDrifting = false;
            this.warpDrift = 0.0;
        }
    }

    private void adjustWarp(double adjustment) {
        double step = this.getWarpAdjustment();
        this.warpAmount += adjustment * step;
        this.warpAmount = Math.max(0.0, Math.min(1.0, this.warpAmount));
        this.isDrifting = false;
        this.warpDrift = 0.0;
        this.driftTicks = 0;
    }

    @Override
    public void renderActive(GuiGraphics guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        int imageX = x + width / 2 - 16;
        int imageY = y + height / 2 - 16 - 10;
        this.renderImageBorder(guiGraphics, imageX, imageY);
        guiGraphics.m_280588_(imageX, imageY, imageX + 32, imageY + 32);
        this.renderWarpedImage(guiGraphics, imageX, imageY);
        guiGraphics.m_280618_();
        this.renderControls(guiGraphics, x, y, width, height);
    }

    private void renderImageBorder(GuiGraphics guiGraphics, int x, int y) {
        int borderColor = -12728377;
        guiGraphics.m_280509_(x - 1, y - 1, x + 32 + 1, y, borderColor);
        guiGraphics.m_280509_(x - 1, y + 32, x + 32 + 1, y + 32 + 1, borderColor);
        guiGraphics.m_280509_(x - 1, y - 1, x, y + 32 + 1, borderColor);
        guiGraphics.m_280509_(x + 32, y - 1, x + 32 + 1, y + 32 + 1, borderColor);
    }

    private void renderWarpedImage(GuiGraphics guiGraphics, int x, int y) {
        int j;
        int i;
        float warpFactor = (float)Math.max(0.0, Math.min(1.0, this.warpAmount));
        float centerX = (float)x + 16.0f;
        float centerY = (float)y + 16.0f;
        int meshSize = 8;
        float[][] meshX = new float[meshSize][meshSize];
        float[][] meshY = new float[meshSize][meshSize];
        for (i = 0; i < meshSize; ++i) {
            j = 0;
            while (j < meshSize) {
                float baseX = x + i * 32 / (meshSize - 1);
                float baseY = y + j * 32 / (meshSize - 1);
                float distX = baseX - centerX;
                float distY = baseY - centerY;
                float distance = (float)Math.sqrt(distX * distX + distY * distY);
                float maxDistance = (float)Math.sqrt(2048.0) / 2.0f;
                float warpStrength = warpFactor * (1.0f - distance / maxDistance);
                float angle = (float)Math.atan2(distY, distX) + warpStrength * 3.0f;
                float warpRadius = distance * (1.0f + warpStrength * 0.5f);
                meshX[i][j] = centerX + (float)Math.cos(angle) * warpRadius;
                meshY[i][j] = centerY + (float)Math.sin(angle) * warpRadius;
                float[] fArray = meshX[i];
                int n = j;
                fArray[n] = fArray[n] + (float)this.warpX * warpFactor * 10.0f;
                float[] fArray2 = meshY[i];
                int n2 = j++;
                fArray2[n2] = fArray2[n2] + (float)this.warpY * warpFactor * 10.0f;
            }
        }
        for (i = 0; i < meshSize - 1; ++i) {
            for (j = 0; j < meshSize - 1; ++j) {
                float u1 = (float)i / (float)(meshSize - 1);
                float v1 = (float)j / (float)(meshSize - 1);
                float u2 = (float)(i + 1) / (float)(meshSize - 1);
                float v2 = (float)(j + 1) / (float)(meshSize - 1);
                float x1 = meshX[i][j];
                float y1 = meshY[i][j];
                float x2 = meshX[i + 1][j];
                float y2 = meshY[i + 1][j];
                float x3 = meshX[i + 1][j + 1];
                float y3 = meshY[i + 1][j + 1];
                float x4 = meshX[i][j + 1];
                float y4 = meshY[i][j + 1];
                this.renderTriangle(guiGraphics, x1, y1, x2, y2, x3, y3, u1, v1, u2, v1, u2, v2);
                this.renderTriangle(guiGraphics, x1, y1, x3, y3, x4, y4, u1, v1, u2, v2, u1, v2);
            }
        }
    }

    private void renderTriangle(GuiGraphics guiGraphics, float x1, float y1, float x2, float y2, float x3, float y3, float u1, float v1, float u2, float v2, float u3, float v3) {
        float minX = Math.min(Math.min(x1, x2), x3);
        float maxX = Math.max(Math.max(x1, x2), x3);
        float minY = Math.min(Math.min(y1, y2), y3);
        float maxY = Math.max(Math.max(y1, y2), y3);
        float minU = Math.min(Math.min(u1, u2), u3);
        float maxU = Math.max(Math.max(u1, u2), u3);
        float minV = Math.min(Math.min(v1, v2), v3);
        float maxV = Math.max(Math.max(v1, v2), v3);
        int width = (int)(maxX - minX);
        int height = (int)(maxY - minY);
        if (width > 0 && height > 0) {
            guiGraphics.m_280163_(SPACE_IMAGE_TEXTURE, (int)minX, (int)minY, (float)((int)(minU * 32.0f)), (float)((int)(minV * 32.0f)), width, height, 32, 32);
        }
    }

    @Override
    public void renderInactive(GuiGraphics guiGraphics, int x, int y, int width, int height) {
    }

    private void renderControls(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        int imageY = y + height / 2 - 16 - 10;
        int controlsY = imageY + 32 + 10;
        int leftButtonX = x + width / 2 - 12 - 5;
        int rightButtonX = x + width / 2 + 5;
        this.renderButton(guiGraphics, LEFT_BUTTON_TEXTURE, leftButtonX, controlsY, this.leftButtonPressed, this.leftButtonHovered);
        this.renderButton(guiGraphics, RIGHT_BUTTON_TEXTURE, rightButtonX, controlsY, this.rightButtonPressed, this.rightButtonHovered);
    }

    private void renderButton(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, boolean pressed, boolean hovered) {
        if (pressed) {
            guiGraphics.m_280246_(0.8f, 0.8f, 0.8f, 1.0f);
        } else if (hovered) {
            guiGraphics.m_280246_(1.2f, 1.2f, 1.2f, 1.0f);
        } else {
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        }
        guiGraphics.m_280163_(texture, x, y, 0.0f, 0.0f, 12, 12, 12, 12);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public double getWarpAmount() {
        return this.warpAmount;
    }

    public void setWarpAmount(double warpAmount) {
        this.warpAmount = warpAmount;
    }

    public double getTargetWarp() {
        return this.targetWarp;
    }

    public void setTargetWarp(double targetWarp) {
        this.targetWarp = targetWarp;
    }

    public double getWarpX() {
        return this.warpX;
    }

    public void setWarpX(double warpX) {
        this.warpX = warpX;
    }

    public double getWarpY() {
        return this.warpY;
    }

    public void setWarpY(double warpY) {
        this.warpY = warpY;
    }

    @Override
    public boolean isStable() {
        return this.isStable;
    }

    public void setStable(boolean stable) {
        this.isStable = stable;
    }

    public int getStableTicks() {
        return this.stableTicks;
    }

    public void setStableTicks(int stableTicks) {
        this.stableTicks = stableTicks;
    }

    public boolean isDrifting() {
        return this.isDrifting;
    }

    public void setDrifting(boolean drifting) {
        this.isDrifting = drifting;
    }

    public int getDriftTicks() {
        return this.driftTicks;
    }

    public void setDriftTicks(int driftTicks) {
        this.driftTicks = driftTicks;
    }

    public double getWarpDrift() {
        return this.warpDrift;
    }

    public void setWarpDrift(double warpDrift) {
        this.warpDrift = warpDrift;
    }

    public int getButtonCooldown() {
        return this.buttonCooldown;
    }

    public void setButtonCooldown(int buttonCooldown) {
        this.buttonCooldown = buttonCooldown;
    }
}

