/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client.screen.minigames;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.client.screen.minigames.ResearchMinigame;
import com.hexvane.strangematter.research.ResearchType;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class ShadowMinigame
extends ResearchMinigame {
    private static final int PANEL_WIDTH = 40;
    private static final int PANEL_HEIGHT = 40;
    private static final int CUBE_SIZE = 12;
    private static final int LIGHT_SIZE = 6;
    private static final int CONTROL_SIZE = 8;
    private static final int CONTROL_SPACING = 6;
    private static final double MIN_LIGHT_DISTANCE = 20.0;
    private static final double MAX_LIGHT_DISTANCE = 50.0;
    private static final double LIGHT_ANGLE_RANGE = 120.0;
    private static final ResourceLocation CUBE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/shadow_cube.png");
    private static final ResourceLocation LIGHT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/shadow_light.png");
    private static final ResourceLocation LEFT_BUTTON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/left_button.png");
    private static final ResourceLocation RIGHT_BUTTON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/right_button.png");
    private static final ResourceLocation UP_BUTTON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/left_button.png");
    private static final ResourceLocation DOWN_BUTTON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/right_button.png");
    private static final int TARGET_SHADOW_COLOR = -12566464;
    private static final int BLOCK_SHADOW_COLOR = -14671840;
    private static final int LIGHT_COLOR = -10496;
    private static final int BACKGROUND_COLOR = -14013910;
    private static final int BORDER_COLOR = -12728377;
    private double lightDistance = 20.0;
    private double lightAngle = 0.0;
    private double targetShadowAngle = 0.0;
    private double targetShadowLength = 15.0;
    private boolean isStable = false;
    private int stableTicks = 0;
    private boolean isDrifting = false;
    private int driftTicks = 0;
    private double lightDrift = 0.0;
    private boolean leftButtonHovered = false;
    private boolean rightButtonHovered = false;
    private boolean upButtonHovered = false;
    private boolean downButtonHovered = false;
    private boolean leftButtonPressed = false;
    private boolean rightButtonPressed = false;
    private boolean upButtonPressed = false;
    private boolean downButtonPressed = false;
    private int buttonCooldown = 0;
    private static final int BUTTON_COOLDOWN_TICKS = 5;
    private Minecraft minecraft = Minecraft.m_91087_();

    private double getAlignmentThreshold() {
        return Config.shadowAlignmentThreshold;
    }

    private int getDriftDelayTicks() {
        return Config.shadowDriftDelayTicks;
    }

    private double getRotationStep() {
        return Config.shadowRotationStep;
    }

    public ShadowMinigame() {
        super(ResearchType.SHADOW);
    }

    @Override
    public void activate() {
        super.activate();
        this.lightDistance = 20.0;
        this.lightAngle = 0.0;
        this.isStable = false;
        this.stableTicks = 0;
        this.isDrifting = false;
        this.driftTicks = 0;
        this.lightDrift = 0.0;
        this.leftButtonHovered = false;
        this.rightButtonHovered = false;
        this.upButtonHovered = false;
        this.downButtonHovered = false;
        this.leftButtonPressed = false;
        this.rightButtonPressed = false;
        this.upButtonPressed = false;
        this.downButtonPressed = false;
        this.buttonCooldown = 0;
        this.targetShadowAngle = (Math.random() - 0.5) * 120.0 + 180.0;
        double minAchievableLength = 16.0;
        double maxAchievableLength = 40.0;
        this.targetShadowLength = minAchievableLength + Math.random() * (maxAchievableLength - minAchievableLength);
        this.lightAngle = (Math.random() - 0.5) * 120.0;
        this.lightDistance = 20.0 + Math.random() * 30.0;
        this.setState(ResearchMinigame.MinigameState.UNSTABLE);
    }

    @Override
    protected void onActivate() {
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.leftButtonPressed = false;
        this.rightButtonPressed = false;
        this.upButtonPressed = false;
        this.downButtonPressed = false;
    }

    @Override
    protected void onDeactivate() {
        this.leftButtonPressed = false;
        this.rightButtonPressed = false;
        this.upButtonPressed = false;
        this.downButtonPressed = false;
        this.leftButtonHovered = false;
        this.rightButtonHovered = false;
        this.upButtonHovered = false;
        this.downButtonHovered = false;
    }

    @Override
    protected boolean handleClick(int mouseX, int mouseY, int button, int panelX, int panelY, int panelWidth, int panelHeight) {
        if (!this.isActive) {
            return false;
        }
        int panelX_center = panelX + panelWidth / 2;
        int panelY_center = panelY + panelHeight / 2;
        int centerX = panelX + panelWidth / 2;
        int centerY = panelY + panelHeight / 2;
        int buttonRowY = panelY + panelHeight - 15;
        int upButtonX = centerX - 4;
        int upButtonY = buttonRowY - 8 - 2;
        int downButtonX = centerX - 4;
        int downButtonY = buttonRowY;
        int leftButtonX = centerX - 8 - 6;
        int leftButtonY = buttonRowY;
        int rightButtonX = centerX + 6;
        int rightButtonY = buttonRowY;
        if (button == 0 && this.buttonCooldown <= 0) {
            if (mouseX >= leftButtonX && mouseX < leftButtonX + 8 && mouseY >= leftButtonY && mouseY < leftButtonY + 8) {
                this.leftButtonPressed = true;
                double rotStep = -this.getRotationStep();
                this.adjustLightAngle(rotStep);
                this.buttonCooldown = 5;
                if (this.minecraft != null && this.minecraft.f_91074_ != null) {
                    this.minecraft.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.RESEARCH_MACHINE_NOTE_INSERT.get(), 0.3f, 1.0f);
                }
                return true;
            }
            if (mouseX >= rightButtonX && mouseX < rightButtonX + 8 && mouseY >= rightButtonY && mouseY < rightButtonY + 8) {
                this.rightButtonPressed = true;
                double rotStep = this.getRotationStep();
                this.adjustLightAngle(rotStep);
                this.buttonCooldown = 5;
                if (this.minecraft != null && this.minecraft.f_91074_ != null) {
                    this.minecraft.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.RESEARCH_MACHINE_NOTE_INSERT.get(), 0.3f, 1.0f);
                }
                return true;
            }
            if (mouseX >= upButtonX && mouseX < upButtonX + 8 && mouseY >= upButtonY && mouseY < upButtonY + 8) {
                this.upButtonPressed = true;
                this.adjustLightDistance(-2.0);
                this.buttonCooldown = 5;
                if (this.minecraft != null && this.minecraft.f_91074_ != null) {
                    this.minecraft.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.RESEARCH_MACHINE_NOTE_INSERT.get(), 0.3f, 1.0f);
                }
                return true;
            }
            if (mouseX >= downButtonX && mouseX < downButtonX + 8 && mouseY >= downButtonY && mouseY < downButtonY + 8) {
                this.downButtonPressed = true;
                this.adjustLightDistance(2.0);
                this.buttonCooldown = 5;
                if (this.minecraft != null && this.minecraft.f_91074_ != null) {
                    this.minecraft.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.RESEARCH_MACHINE_NOTE_INSERT.get(), 0.3f, 1.0f);
                }
                return true;
            }
        }
        return false;
    }

    public void handleMouseDrag(int mouseX, int mouseY, int panelX, int panelY, int panelWidth, int panelHeight) {
    }

    public void handleMouseRelease(int mouseX, int mouseY, int panelX, int panelY, int panelWidth, int panelHeight, int button) {
        if (!this.isActive) {
            return;
        }
        if (button == 0) {
            this.leftButtonPressed = false;
            this.rightButtonPressed = false;
            this.upButtonPressed = false;
            this.downButtonPressed = false;
        }
    }

    public void updateHoverStates(int mouseX, int mouseY, int panelX, int panelY, int panelWidth, int panelHeight) {
        if (!this.isActive) {
            return;
        }
        int panelX_center = panelX + panelWidth / 2;
        int panelY_center = panelY + panelHeight / 2;
        int centerX = panelX + panelWidth / 2;
        int centerY = panelY + panelHeight / 2;
        int buttonRowY = panelY + panelHeight - 15;
        int upButtonX = centerX - 4;
        int upButtonY = buttonRowY - 8 - 2;
        int downButtonX = centerX - 4;
        int downButtonY = buttonRowY;
        int leftButtonX = centerX - 8 - 6;
        int leftButtonY = buttonRowY;
        int rightButtonX = centerX + 6;
        int rightButtonY = buttonRowY;
        this.leftButtonHovered = mouseX >= leftButtonX && mouseX < leftButtonX + 8 && mouseY >= leftButtonY && mouseY < leftButtonY + 8;
        this.rightButtonHovered = mouseX >= rightButtonX && mouseX < rightButtonX + 8 && mouseY >= rightButtonY && mouseY < rightButtonY + 8;
        this.upButtonHovered = mouseX >= upButtonX && mouseX < upButtonX + 8 && mouseY >= upButtonY && mouseY < upButtonY + 8;
        this.downButtonHovered = mouseX >= downButtonX && mouseX < downButtonX + 8 && mouseY >= downButtonY && mouseY < downButtonY + 8;
    }

    @Override
    public void updateMinigame() {
        if (!this.isActive) {
            return;
        }
        if (this.buttonCooldown > 0) {
            --this.buttonCooldown;
        }
        this.checkStability();
        this.updateDrift();
    }

    private void checkStability() {
        double threshold;
        boolean shadowAligned;
        double blockShadowAngle = this.lightAngle + 180.0;
        double blockShadowLength = this.calculateShadowLength();
        double angleDiff = Math.abs(blockShadowAngle - this.targetShadowAngle);
        double lengthDiff = Math.abs(blockShadowLength - this.targetShadowLength);
        if (angleDiff > 180.0) {
            angleDiff = 360.0 - angleDiff;
        }
        boolean bl = shadowAligned = angleDiff < (threshold = this.getAlignmentThreshold()) && lengthDiff < threshold;
        if (shadowAligned) {
            if (!this.isStable) {
                this.isStable = true;
                this.stableTicks = 0;
                this.setState(ResearchMinigame.MinigameState.STABLE);
            } else {
                ++this.stableTicks;
            }
        } else {
            this.isStable = false;
            this.stableTicks = 0;
            this.setState(ResearchMinigame.MinigameState.UNSTABLE);
        }
    }

    private void updateDrift() {
        int driftDelay = this.getDriftDelayTicks();
        if (this.isStable && this.stableTicks >= driftDelay) {
            if (!this.isDrifting) {
                this.isDrifting = true;
                this.driftTicks = 0;
            } else {
                ++this.driftTicks;
                double driftSpeed = 0.5;
                this.lightDrift += (Math.random() - 0.5) * driftSpeed;
                this.lightDrift = Math.max(-2.0, Math.min(2.0, this.lightDrift));
                this.lightAngle += this.lightDrift;
                this.lightAngle = Math.max(-60.0, Math.min(60.0, this.lightAngle));
            }
        } else {
            this.isDrifting = false;
            this.lightDrift = 0.0;
        }
    }

    private double calculateShadowLength() {
        return (50.0 - this.lightDistance + 20.0) * 0.8;
    }

    private void adjustLightAngle(double adjustment) {
        this.lightAngle += adjustment;
        this.lightAngle = Math.max(-60.0, Math.min(60.0, this.lightAngle));
        this.isDrifting = false;
        this.lightDrift = 0.0;
        this.driftTicks = 0;
    }

    private void adjustLightDistance(double adjustment) {
        this.lightDistance += adjustment;
        this.lightDistance = Math.max(20.0, Math.min(50.0, this.lightDistance));
        this.isDrifting = false;
        this.lightDrift = 0.0;
        this.driftTicks = 0;
    }

    @Override
    public void renderActive(GuiGraphics guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        int panelX = x + width / 2 - 20;
        int panelY = y + height / 2 - 20 - 10;
        this.renderShadowScene(guiGraphics, panelX, panelY);
        this.renderControls(guiGraphics, x, y, width, height);
    }

    @Override
    public void renderInactive(GuiGraphics guiGraphics, int x, int y, int width, int height) {
    }

    private void renderShadowScene(GuiGraphics guiGraphics, int panelX, int panelY) {
        int centerX = panelX + 20;
        int centerY = panelY + 20;
        guiGraphics.m_280509_(panelX, panelY, panelX + 40, panelY + 40, -14013910);
        guiGraphics.m_280509_(panelX - 1, panelY - 1, panelX + 40 + 1, panelY, -12728377);
        guiGraphics.m_280509_(panelX - 1, panelY + 40, panelX + 40 + 1, panelY + 40 + 1, -12728377);
        guiGraphics.m_280509_(panelX - 1, panelY - 1, panelX, panelY + 40 + 1, -12728377);
        guiGraphics.m_280509_(panelX + 40, panelY - 1, panelX + 40 + 1, panelY + 40 + 1, -12728377);
        guiGraphics.m_280588_(panelX, panelY, panelX + 40, panelY + 40);
        this.renderFakeShadow(guiGraphics, centerX, centerY, this.targetShadowAngle, this.targetShadowLength, -12566464);
        double blockShadowAngle = this.lightAngle + 180.0;
        double blockShadowLength = this.calculateShadowLength();
        this.renderFakeShadow(guiGraphics, centerX, centerY, blockShadowAngle, blockShadowLength, -16777216);
        int cubeX = centerX - 6;
        int cubeY = centerY - 6;
        guiGraphics.m_280163_(CUBE_TEXTURE, cubeX, cubeY, 0.0f, 0.0f, 12, 12, 12, 12);
        double lightRad = Math.toRadians(this.lightAngle);
        int lightX = centerX + (int)(Math.cos(lightRad) * this.lightDistance * 0.3);
        int lightY = centerY + (int)(Math.sin(lightRad) * this.lightDistance * 0.3);
        guiGraphics.m_280163_(LIGHT_TEXTURE, lightX - 3, lightY - 3, 0.0f, 0.0f, 6, 6, 6, 6);
        guiGraphics.m_280618_();
    }

    private void renderFakeShadow(GuiGraphics guiGraphics, int centerX, int centerY, double angle, double length, int tintColor) {
        double rad = Math.toRadians(angle);
        int shadowWidth = 12 + (int)(length * 0.3);
        int shadowHeight = 12 + (int)(length * 0.2);
        int shadowX = centerX - shadowWidth / 2 + (int)(Math.cos(rad) * length * 0.4);
        int shadowY = centerY - shadowHeight / 2 + (int)(Math.sin(rad) * length * 0.4);
        guiGraphics.m_280246_((float)(tintColor >> 16 & 0xFF) / 255.0f, (float)(tintColor >> 8 & 0xFF) / 255.0f, (float)(tintColor & 0xFF) / 255.0f, 0.7f);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85837_((double)shadowX + (double)shadowWidth / 2.0, (double)shadowY + (double)shadowHeight / 2.0, 0.0);
        guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_((float)angle));
        guiGraphics.m_280168_().m_85837_((double)(-shadowWidth) / 2.0, (double)(-shadowHeight) / 2.0, 0.0);
        guiGraphics.m_280163_(CUBE_TEXTURE, 0, 0, 0.0f, 0.0f, shadowWidth, shadowHeight, shadowWidth, shadowHeight);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderControls(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        int panelX_center = x + width / 2;
        int panelY_center = y + height / 2;
        int centerX = x + width / 2;
        int centerY = y + height / 2;
        int buttonRowY = y + height - 15;
        int upButtonX = centerX - 4;
        int upButtonY = buttonRowY - 8 - 2;
        int downButtonX = centerX - 4;
        int downButtonY = buttonRowY;
        int leftButtonX = centerX - 8 - 6;
        int leftButtonY = buttonRowY;
        int rightButtonX = centerX + 6;
        int rightButtonY = buttonRowY;
        this.renderRotatedButton(guiGraphics, LEFT_BUTTON_TEXTURE, upButtonX, upButtonY, this.upButtonPressed, this.upButtonHovered, 90);
        this.renderButton(guiGraphics, LEFT_BUTTON_TEXTURE, leftButtonX, leftButtonY, this.leftButtonPressed, this.leftButtonHovered);
        this.renderRotatedButton(guiGraphics, RIGHT_BUTTON_TEXTURE, downButtonX, downButtonY, this.downButtonPressed, this.downButtonHovered, 90);
        this.renderButton(guiGraphics, RIGHT_BUTTON_TEXTURE, rightButtonX, rightButtonY, this.rightButtonPressed, this.rightButtonHovered);
        if (this.upButtonHovered) {
            guiGraphics.m_280509_(upButtonX - 1, upButtonY - 1, upButtonX + 8 + 1, upButtonY + 8 + 1, -2130706433);
        }
        if (this.leftButtonHovered) {
            guiGraphics.m_280509_(leftButtonX - 1, leftButtonY - 1, leftButtonX + 8 + 1, leftButtonY + 8 + 1, -2130706433);
        }
        if (this.downButtonHovered) {
            guiGraphics.m_280509_(downButtonX - 1, downButtonY - 1, downButtonX + 8 + 1, downButtonY + 8 + 1, -2130706433);
        }
        if (this.rightButtonHovered) {
            guiGraphics.m_280509_(rightButtonX - 1, rightButtonY - 1, rightButtonX + 8 + 1, rightButtonY + 8 + 1, -2130706433);
        }
    }

    private void renderButton(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, boolean pressed, boolean hovered) {
        guiGraphics.m_280163_(texture, x, y, 0.0f, 0.0f, 8, 8, 8, 8);
        if (pressed) {
            guiGraphics.m_280509_(x, y, x + 8, y + 8, Integer.MIN_VALUE);
        }
    }

    private void renderRotatedButton(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, boolean pressed, boolean hovered, int rotationDegrees) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85837_((double)x + 4.0, (double)y + 4.0, 0.0);
        guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_((float)rotationDegrees));
        guiGraphics.m_280168_().m_85837_(-4.0, -4.0, 0.0);
        guiGraphics.m_280163_(texture, 0, 0, 0.0f, 0.0f, 8, 8, 8, 8);
        guiGraphics.m_280168_().m_85849_();
        if (pressed) {
            guiGraphics.m_280509_(x, y, x + 8, y + 8, Integer.MIN_VALUE);
        }
    }

    public double getLightDistance() {
        return this.lightDistance;
    }

    public void setLightDistance(double lightDistance) {
        this.lightDistance = lightDistance;
    }

    public double getLightAngle() {
        return this.lightAngle;
    }

    public void setLightAngle(double lightAngle) {
        this.lightAngle = lightAngle;
    }

    public double getTargetShadowAngle() {
        return this.targetShadowAngle;
    }

    public void setTargetShadowAngle(double targetShadowAngle) {
        this.targetShadowAngle = targetShadowAngle;
    }

    public double getTargetShadowLength() {
        return this.targetShadowLength;
    }

    public void setTargetShadowLength(double targetShadowLength) {
        this.targetShadowLength = targetShadowLength;
    }

    @Override
    public boolean isStable() {
        return this.isStable;
    }

    public void setStable(boolean stable) {
        this.isStable = stable;
    }

    public int getStableTicks() {
        return this.stableTicks;
    }

    public void setStableTicks(int stableTicks) {
        this.stableTicks = stableTicks;
    }

    public boolean isDrifting() {
        return this.isDrifting;
    }

    public void setDrifting(boolean drifting) {
        this.isDrifting = drifting;
    }

    public int getDriftTicks() {
        return this.driftTicks;
    }

    public void setDriftTicks(int driftTicks) {
        this.driftTicks = driftTicks;
    }

    public double getLightDrift() {
        return this.lightDrift;
    }

    public void setLightDrift(double lightDrift) {
        this.lightDrift = lightDrift;
    }

    public int getButtonCooldown() {
        return this.buttonCooldown;
    }

    public void setButtonCooldown(int buttonCooldown) {
        this.buttonCooldown = buttonCooldown;
    }
}

