/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client.screen.minigames;

import com.hexvane.strangematter.research.ResearchType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public abstract class ResearchMinigame {
    private static final ResourceLocation INDICATOR_GREEN = new ResourceLocation("strangematter", "textures/ui/indicator_light_green.png");
    private static final ResourceLocation INDICATOR_RED = new ResourceLocation("strangematter", "textures/ui/indicator_light_red.png");
    private static final ResourceLocation SHUTTER_TEXTURE = new ResourceLocation("strangematter", "textures/ui/minigame_shutter.png");
    protected final ResearchType researchType;
    protected MinigameState state;
    protected boolean isActive;
    private float leftShutterOffset = 0.0f;
    private float rightShutterOffset = 0.0f;
    private boolean shuttersAnimating = false;
    private int animationTicks = 0;
    private static final int ANIMATION_DURATION = 20;

    public ResearchMinigame(ResearchType researchType) {
        this.researchType = researchType;
        this.state = MinigameState.INACTIVE;
        this.isActive = false;
    }

    public void activate() {
        this.isActive = true;
        this.state = MinigameState.STABLE;
        this.startShutterAnimation(true);
        this.onActivate();
    }

    public void deactivate() {
        this.isActive = false;
        this.state = MinigameState.INACTIVE;
        this.startShutterAnimation(false);
        this.onDeactivate();
    }

    public void tick() {
        if (this.shuttersAnimating) {
            ++this.animationTicks;
            float progress = (float)this.animationTicks / 20.0f;
            if (progress >= 1.0f) {
                progress = 1.0f;
                this.shuttersAnimating = false;
            }
            float easedProgress = this.sCurveEasing(progress);
            if (this.isActive) {
                this.leftShutterOffset = easedProgress;
                this.rightShutterOffset = easedProgress;
            } else {
                this.leftShutterOffset = 1.0f - easedProgress;
                this.rightShutterOffset = 1.0f - easedProgress;
            }
        }
        if (this.isActive) {
            this.updateMinigame();
        }
    }

    public void render(GuiGraphics guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        this.renderTitle(guiGraphics, x, y, width, height);
        this.renderStabilityIndicator(guiGraphics, x, y, width);
        if (this.leftShutterOffset < 1.0f || this.rightShutterOffset < 1.0f) {
            guiGraphics.m_280588_(x + 3, y + 2, x + width - 6, y + height - 4);
            if (this.isActive) {
                this.renderActive(guiGraphics, x + 3, y + 2, width - 6, height - 4, mouseX, mouseY);
            } else {
                this.renderInactive(guiGraphics, x + 3, y + 2, width - 6, height - 4);
            }
            this.renderShutters(guiGraphics, x + 3, y + 2, width - 6, height - 4);
            guiGraphics.m_280618_();
        } else if (this.isActive) {
            this.renderActive(guiGraphics, x, y, width, height, mouseX, mouseY);
        } else {
            this.renderInactive(guiGraphics, x, y, width, height);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button, int panelX, int panelY, int panelWidth, int panelHeight) {
        if (this.isActive && mouseX >= (double)panelX && mouseX < (double)(panelX + panelWidth) && mouseY >= (double)panelY && mouseY < (double)(panelY + panelHeight)) {
            return this.handleClick((int)mouseX, (int)mouseY, button, panelX, panelY, panelWidth, panelHeight);
        }
        return false;
    }

    protected abstract void onActivate();

    protected abstract void onDeactivate();

    protected abstract void updateMinigame();

    protected abstract void renderActive(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected abstract void renderInactive(GuiGraphics var1, int var2, int var3, int var4, int var5);

    protected abstract boolean handleClick(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public ResearchType getResearchType() {
        return this.researchType;
    }

    public MinigameState getState() {
        return this.state;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isStable() {
        return this.state == MinigameState.STABLE;
    }

    public boolean isUnstable() {
        return this.state == MinigameState.UNSTABLE;
    }

    public boolean isAnimating() {
        return this.shuttersAnimating;
    }

    protected void setState(MinigameState newState) {
        this.state = newState;
    }

    private void renderTitle(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        String title = this.researchType.getDisplayName();
        guiGraphics.m_280137_(Minecraft.m_91087_().f_91062_, title, x + width / 2, y - 10, -12728377);
    }

    protected void renderStabilityIndicator(GuiGraphics guiGraphics, int x, int y, int width) {
        int indicatorX = x + width - 8;
        int indicatorY = y + 2;
        if (this.isActive) {
            ResourceLocation indicatorTexture = this.state == MinigameState.STABLE ? INDICATOR_GREEN : INDICATOR_RED;
            guiGraphics.m_280163_(indicatorTexture, indicatorX, indicatorY, 0.0f, 0.0f, 6, 6, 6, 6);
        }
    }

    private void startShutterAnimation(boolean opening) {
        this.shuttersAnimating = true;
        this.animationTicks = 0;
        if (opening) {
            this.leftShutterOffset = 0.0f;
            this.rightShutterOffset = 0.0f;
        } else {
            this.leftShutterOffset = 1.0f;
            this.rightShutterOffset = 1.0f;
        }
    }

    private void renderShutters(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        int shutterWidth = width / 2;
        int leftShutterX = (int)((float)x - (float)shutterWidth * this.leftShutterOffset);
        guiGraphics.m_280163_(SHUTTER_TEXTURE, leftShutterX, y, 0.0f, 0.0f, shutterWidth, height, shutterWidth, height);
        int rightShutterX = (int)((float)(x + width) - (float)shutterWidth * (1.0f - this.rightShutterOffset));
        guiGraphics.m_280163_(SHUTTER_TEXTURE, rightShutterX, y, (float)shutterWidth, 0.0f, shutterWidth, height, shutterWidth, height);
    }

    private float sCurveEasing(float t) {
        float k = 12.0f;
        float x = k * (t - 0.5f);
        x = Math.max(-6.0f, Math.min(6.0f, x));
        float sigmoid = 1.0f / (1.0f + (float)Math.exp(-x));
        return sigmoid;
    }

    public static enum MinigameState {
        INACTIVE,
        STABLE,
        UNSTABLE;

    }
}

