/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client.screen.minigames;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.client.screen.components.BubblingParticleSystem;
import com.hexvane.strangematter.client.screen.minigames.ResearchMinigame;
import com.hexvane.strangematter.research.ResearchType;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class GravityMinigame
extends ResearchMinigame {
    private final Minecraft minecraft = Minecraft.m_91087_();
    private static final ResourceLocation GRAVITY_TUBE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/gravity_tube.png");
    private static final ResourceLocation GRAVITY_CUBE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/gravity_cube.png");
    private static final ResourceLocation SLIDER_BAR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/slider_bar.png");
    private static final ResourceLocation SLIDER_HANDLE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/slider_handle.png");
    private static final int TUBE_WIDTH = 19;
    private static final int TUBE_HEIGHT = 43;
    private static final int CUBE_WIDTH = 12;
    private static final int CUBE_HEIGHT = 15;
    private static final int SLIDER_WIDTH = 34;
    private static final int SLIDER_HEIGHT = 3;
    private static final int SLIDER_HANDLE_WIDTH = 4;
    private static final int SLIDER_HANDLE_HEIGHT = 8;
    private int targetGravity = 0;
    private int sliderValue = 0;
    private double cubePosition = 0.5;
    private double cubeVelocity = 0.0;
    private static final int MIN_GRAVITY = -5;
    private static final int MAX_GRAVITY = 5;
    private static final int SLIDER_NOTCHES = 11;
    private static final double CENTER_POSITION = 0.5;
    private boolean isInEquilibrium = false;
    private int equilibriumTicks = 0;
    private int requiredEquilibriumTicks = 100;
    private int driftTicks = 0;
    private boolean isDrifting = false;
    private boolean needsNewTarget = false;
    private boolean sliderActive = false;
    private BubblingParticleSystem particleSystem;

    private double getBalanceThreshold() {
        return Config.gravityBalanceThreshold;
    }

    private int getDriftDelayTicks() {
        return Config.gravityDriftDelayTicks;
    }

    public GravityMinigame() {
        super(ResearchType.GRAVITY);
    }

    @Override
    protected void onActivate() {
        this.isInEquilibrium = false;
        this.equilibriumTicks = 0;
        this.driftTicks = 0;
        this.isDrifting = false;
        this.needsNewTarget = false;
        do {
            this.targetGravity = -5 + (int)(Math.random() * 11.0);
        } while (this.targetGravity == 0);
        this.targetGravity = Math.max(-5, Math.min(5, this.targetGravity));
        this.sliderValue = 0;
        this.cubePosition = 0.5;
        this.cubeVelocity = 0.0;
        this.setState(ResearchMinigame.MinigameState.UNSTABLE);
        this.particleSystem = null;
    }

    @Override
    protected void onDeactivate() {
        this.sliderActive = false;
    }

    private boolean checkEquilibrium() {
        double threshold = this.getBalanceThreshold();
        return Math.abs(this.cubePosition - 0.5) < threshold;
    }

    private void updatePhysics() {
        int netForce = this.targetGravity + this.sliderValue;
        if (netForce == 0) {
            double centerForce = (0.5 - this.cubePosition) * 0.1;
            this.cubeVelocity += centerForce;
            this.cubeVelocity *= 0.9;
        } else {
            double acceleration = (double)netForce * 0.01;
            this.cubeVelocity += acceleration;
            this.cubeVelocity *= 0.95;
        }
        this.cubePosition += this.cubeVelocity;
        this.cubePosition = Math.max(0.0, Math.min(1.0, this.cubePosition));
        if (this.cubePosition <= 0.0 || this.cubePosition >= 1.0) {
            this.cubeVelocity = 0.0;
        }
    }

    private void updateDrift() {
        if (this.needsNewTarget) {
            do {
                this.targetGravity = -5 + (int)(Math.random() * 11.0);
            } while (this.targetGravity == 0);
            this.targetGravity = Math.max(-5, Math.min(5, this.targetGravity));
            this.needsNewTarget = false;
            this.isDrifting = false;
            this.driftTicks = 0;
        }
    }

    @Override
    protected void renderActive(GuiGraphics guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        this.renderGravityTube(guiGraphics, x + width / 2 - 9, y + 10, 19, 43);
        this.renderForceSlider(guiGraphics, x + width / 2 - 17, y + height - 8, 34, 3, mouseX, mouseY);
    }

    @Override
    protected void renderInactive(GuiGraphics guiGraphics, int x, int y, int width, int height) {
    }

    private void renderGravityTube(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        if (this.particleSystem == null) {
            this.particleSystem = BubblingParticleSystem.createGravityTubeEffect(x + 2, y + 20, width - 10, height - 15);
        }
        guiGraphics.m_280163_(GRAVITY_TUBE_TEXTURE, x, y, 0.0f, 0.0f, width, height, width, height);
        this.particleSystem.update();
        this.particleSystem.render(guiGraphics);
        int centerY = y + height / 2;
        int notchWidth = 4;
        int notchHeight = 2;
        guiGraphics.m_280509_(x - notchWidth, centerY - 10, x + width + notchWidth, centerY - 10 + notchHeight, -8388480);
        guiGraphics.m_280509_(x - notchWidth, centerY + 10, x + width + notchWidth, centerY + 10 + notchHeight, -8388480);
        int cubeY = y + (int)((1.0 - this.cubePosition) * (double)(height - 15));
        guiGraphics.m_280163_(GRAVITY_CUBE_TEXTURE, x + (width - 12) / 2, cubeY, 0.0f, 0.0f, 12, 15, 12, 15);
    }

    private void renderForceSlider(GuiGraphics guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        boolean handleHovered;
        guiGraphics.m_280163_(SLIDER_BAR_TEXTURE, x, y, 0.0f, 0.0f, width, height, width, height);
        for (int i = 0; i < 11; ++i) {
            int notchX = x + (int)((double)i / 10.0 * (double)(width - 1));
            int notchY = y - 2;
            int notchHeight = 4;
            guiGraphics.m_280509_(notchX, notchY, notchX + 1, notchY + notchHeight, -10066330);
        }
        double normalizedValue = (double)(this.sliderValue - -5) / 10.0;
        int handleX = x + (int)(normalizedValue * (double)(width - 4));
        int handleY = y - (8 - height) / 2;
        boolean bl = handleHovered = mouseX >= handleX && mouseX < handleX + 4 && mouseY >= handleY && mouseY < handleY + 8;
        if (this.sliderActive) {
            guiGraphics.m_280163_(SLIDER_HANDLE_TEXTURE, handleX, handleY, 0.0f, 0.0f, 4, 8, 4, 8);
            guiGraphics.m_280509_(handleX - 2, handleY - 2, handleX + 4 + 2, handleY + 8 + 2, -2130706433);
        } else if (handleHovered) {
            guiGraphics.m_280163_(SLIDER_HANDLE_TEXTURE, handleX, handleY, 0.0f, 0.0f, 4, 8, 4, 8);
            guiGraphics.m_280509_(handleX - 1, handleY - 1, handleX + 4 + 1, handleY + 8 + 1, 0x40FFFFFF);
        } else {
            guiGraphics.m_280163_(SLIDER_HANDLE_TEXTURE, handleX, handleY, 0.0f, 0.0f, 4, 8, 4, 8);
        }
        String label = "Force";
        int labelWidth = this.minecraft.f_91062_.m_92895_(label);
        guiGraphics.m_280488_(this.minecraft.f_91062_, label, x + (width - labelWidth) / 2, y - 12, -12728377);
    }

    @Override
    protected void updateMinigame() {
        this.updatePhysics();
        this.updateDrift();
        boolean wasInEquilibrium = this.isInEquilibrium;
        this.isInEquilibrium = this.checkEquilibrium();
        if (this.isInEquilibrium) {
            if (!wasInEquilibrium) {
                this.driftTicks = 0;
                this.isDrifting = false;
            }
            ++this.equilibriumTicks;
            if (this.equilibriumTicks >= this.requiredEquilibriumTicks) {
                ++this.driftTicks;
                int driftDelay = this.getDriftDelayTicks();
                if (this.driftTicks >= driftDelay && !this.isDrifting) {
                    this.isDrifting = true;
                    this.needsNewTarget = true;
                }
            }
        } else {
            this.equilibriumTicks = 0;
            this.driftTicks = 0;
            this.isDrifting = false;
        }
        this.state = this.isInEquilibrium && this.equilibriumTicks >= this.requiredEquilibriumTicks ? ResearchMinigame.MinigameState.STABLE : ResearchMinigame.MinigameState.UNSTABLE;
    }

    @Override
    protected boolean handleClick(int mouseX, int mouseY, int button, int panelX, int panelY, int panelWidth, int panelHeight) {
        if (!this.isActive) {
            return false;
        }
        int sliderX = panelX + panelWidth / 2 - 17;
        int sliderY = panelY + panelHeight - 8;
        int clickAreaHeight = Math.max(3, 8);
        int clickAreaY = sliderY - (clickAreaHeight - 3) / 2;
        if (mouseX >= sliderX && mouseX < sliderX + 34 && mouseY >= clickAreaY && mouseY < clickAreaY + clickAreaHeight) {
            this.sliderActive = true;
            double relativeX = (double)(mouseX - sliderX) / 34.0;
            relativeX = Math.max(0.0, Math.min(1.0, relativeX));
            double normalizedValue = relativeX * 10.0;
            int nearestNotch = (int)Math.round(normalizedValue);
            this.sliderValue = -5 + nearestNotch;
            this.sliderValue = Math.max(-5, Math.min(5, this.sliderValue));
            this.isDrifting = false;
            this.driftTicks = 0;
            if (this.minecraft != null && this.minecraft.f_91074_ != null) {
                this.minecraft.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.RESEARCH_MACHINE_NOTE_INSERT.get(), 0.3f, 1.0f);
            }
            return true;
        }
        return false;
    }

    public void updateHoverStates(int mouseX, int mouseY, int panelX, int panelY, int panelWidth, int panelHeight) {
        if (!this.isActive) {
            return;
        }
    }

    public void handleMouseDrag(int mouseX, int mouseY, int panelX, int panelY, int panelWidth, int panelHeight) {
        int sliderX;
        if (!this.isActive) {
            return;
        }
        if (!this.sliderActive) {
            sliderX = panelX + panelWidth / 2 - 17;
            int sliderY = panelY + panelHeight - 8;
            int clickAreaHeight = Math.max(3, 8);
            int clickAreaY = sliderY - (clickAreaHeight - 3) / 2;
            if (mouseX >= sliderX && mouseX < sliderX + 34 && mouseY >= clickAreaY && mouseY < clickAreaY + clickAreaHeight) {
                this.sliderActive = true;
            } else {
                return;
            }
        }
        sliderX = panelX + panelWidth / 2 - 17;
        double relativeX = (double)(mouseX - sliderX) / 34.0;
        relativeX = Math.max(0.0, Math.min(1.0, relativeX));
        double normalizedValue = relativeX * 10.0;
        int nearestNotch = (int)Math.round(normalizedValue);
        this.sliderValue = -5 + nearestNotch;
        this.sliderValue = Math.max(-5, Math.min(5, this.sliderValue));
        this.isDrifting = false;
        this.driftTicks = 0;
    }

    public void handleMouseRelease(int mouseX, int mouseY, int panelX, int panelY, int panelWidth, int panelHeight, int button) {
        if (!this.isActive) {
            return;
        }
        this.sliderActive = false;
    }

    @Override
    public boolean isStable() {
        return this.state == ResearchMinigame.MinigameState.STABLE;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public boolean isSliderActive() {
        return this.sliderActive;
    }

    public int getSliderValue() {
        return this.sliderValue;
    }

    public int getTargetGravity() {
        return this.targetGravity;
    }

    public double getCubePosition() {
        return this.cubePosition;
    }

    public double getCubeVelocity() {
        return this.cubeVelocity;
    }

    public boolean isInEquilibrium() {
        return this.isInEquilibrium;
    }

    public int getEquilibriumTicks() {
        return this.equilibriumTicks;
    }

    public int getDriftTicks() {
        return this.driftTicks;
    }

    public boolean isDrifting() {
        return this.isDrifting;
    }

    public boolean getNeedsNewTarget() {
        return this.needsNewTarget;
    }

    public int getRequiredSliderValue() {
        return -this.targetGravity;
    }

    public void setSliderActive(boolean sliderActive) {
        this.sliderActive = sliderActive;
    }

    public void setSliderValue(int sliderValue) {
        this.sliderValue = sliderValue;
    }

    public void setTargetGravity(int targetGravity) {
        this.targetGravity = targetGravity;
    }

    public void setCubePosition(double cubePosition) {
        this.cubePosition = cubePosition;
    }

    public void setCubeVelocity(double cubeVelocity) {
        this.cubeVelocity = cubeVelocity;
    }

    public void setInEquilibrium(boolean isInEquilibrium) {
        this.isInEquilibrium = isInEquilibrium;
    }

    public void setEquilibriumTicks(int equilibriumTicks) {
        this.equilibriumTicks = equilibriumTicks;
    }

    public void setDriftTicks(int driftTicks) {
        this.driftTicks = driftTicks;
    }

    public void setDrifting(boolean isDrifting) {
        this.isDrifting = isDrifting;
    }

    public void setNeedsNewTarget(boolean needsNewTarget) {
        this.needsNewTarget = needsNewTarget;
    }

    public void setRequiredSliderValue(int requiredValue) {
        this.targetGravity = -requiredValue;
    }
}

