/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client.screen.minigames;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.client.screen.minigames.ResearchMinigame;
import com.hexvane.strangematter.research.ResearchType;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class EnergyMinigame
extends ResearchMinigame {
    private final Minecraft minecraft = Minecraft.m_91087_();
    private static final ResourceLocation DIAL_OFF_TEXTURE = new ResourceLocation("strangematter", "textures/ui/dial_off.png");
    private static final ResourceLocation DIAL_ON_TEXTURE = new ResourceLocation("strangematter", "textures/ui/dial_on.png");
    private static final ResourceLocation RIGHT_BUTTON_TEXTURE = new ResourceLocation("strangematter", "textures/ui/right_button.png");
    private static final ResourceLocation LEFT_BUTTON_TEXTURE = new ResourceLocation("strangematter", "textures/ui/left_button.png");
    private static final int DIAL_SIZE = 10;
    private static final int BUTTON_SIZE = 10;
    private static final int WAVE_AREA_HEIGHT = 40;
    private static final int WAVE_AREA_Y_OFFSET = 10;
    private double targetAmplitude = 1.0;
    private double targetPeriod = 2.0;
    private double currentAmplitude = 0.5;
    private double currentPeriod = 1.5;
    private static final double MIN_AMPLITUDE = 0.5;
    private static final double MAX_AMPLITUDE = 1.5;
    private static final double MIN_PERIOD = 1.0;
    private static final double MAX_PERIOD = 1.25;
    private boolean amplitudeDialActive = false;
    private boolean periodDialActive = false;
    private boolean isAligned = false;
    private int alignmentTicks = 0;
    private int driftTicks = 0;
    private double amplitudeDrift = 0.0;
    private double periodDrift = 0.0;
    private double amplitudeDriftTarget = 0.0;
    private double periodDriftTarget = 0.0;
    private int animationTicks = 0;
    private boolean amplitudeDialHovered = false;
    private boolean periodDialHovered = false;
    private boolean leftButtonHovered = false;
    private boolean rightButtonHovered = false;

    private int getRequiredAlignmentTicks() {
        return Config.energyRequiredAlignmentTicks;
    }

    private int getDriftDelayTicks() {
        return Config.energyDriftDelayTicks;
    }

    private double getAmplitudeStep() {
        return Config.energyAmplitudeStep;
    }

    private double getPeriodStep() {
        return Config.energyPeriodStep;
    }

    public EnergyMinigame() {
        super(ResearchType.ENERGY);
    }

    @Override
    protected void onActivate() {
        this.isAligned = false;
        this.alignmentTicks = 0;
        this.driftTicks = 0;
        this.amplitudeDrift = 0.0;
        this.periodDrift = 0.0;
        this.amplitudeDriftTarget = 0.0;
        this.periodDriftTarget = 0.0;
        this.targetAmplitude = 0.5 + Math.random() * 1.0;
        this.targetPeriod = 1.0 + Math.random() * 0.25;
        this.currentAmplitude = 0.5;
        this.currentPeriod = 1.5;
    }

    @Override
    protected void onDeactivate() {
        this.amplitudeDialActive = false;
        this.periodDialActive = false;
    }

    private boolean checkAlignment() {
        double amplitudeDiff = Math.abs(this.currentAmplitude - this.targetAmplitude);
        double periodDiff = Math.abs(this.currentPeriod - this.targetPeriod);
        return amplitudeDiff < 0.1 && periodDiff < 0.1;
    }

    private void applyDrift() {
        if (Math.random() < 0.1) {
            this.amplitudeDriftTarget = (Math.random() - 0.5) * 0.1;
            this.periodDriftTarget = (Math.random() - 0.5) * 0.1;
        }
        double driftSpeed = 0.005;
        if (this.amplitudeDrift < this.amplitudeDriftTarget) {
            this.amplitudeDrift = Math.min(this.amplitudeDriftTarget, this.amplitudeDrift + driftSpeed);
        } else if (this.amplitudeDrift > this.amplitudeDriftTarget) {
            this.amplitudeDrift = Math.max(this.amplitudeDriftTarget, this.amplitudeDrift - driftSpeed);
        }
        if (this.periodDrift < this.periodDriftTarget) {
            this.periodDrift = Math.min(this.periodDriftTarget, this.periodDrift + driftSpeed);
        } else if (this.periodDrift > this.periodDriftTarget) {
            this.periodDrift = Math.max(this.periodDriftTarget, this.periodDrift - driftSpeed);
        }
        this.currentAmplitude += this.amplitudeDrift;
        this.currentPeriod += this.periodDrift;
        this.currentAmplitude = Math.max(0.5, Math.min(1.5, this.currentAmplitude));
        this.currentPeriod = Math.max(1.0, Math.min(1.25, this.currentPeriod));
    }

    @Override
    protected void renderActive(GuiGraphics guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        this.renderSineWaves(guiGraphics, x + width / 2 - 20, y + 10, 40, 30);
        this.renderControls(guiGraphics, x, y, width, height);
    }

    @Override
    protected void renderInactive(GuiGraphics guiGraphics, int x, int y, int width, int height) {
    }

    private void renderSineWaves(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        guiGraphics.m_280509_(x, y, x + width, y + height, -15197404);
        int centerY = y + height / 2;
        this.renderSineWave(guiGraphics, x, centerY, width, height, this.targetAmplitude, this.targetPeriod, -16776961);
        this.renderSineWave(guiGraphics, x, centerY, width, height, this.currentAmplitude, this.currentPeriod, -16711936);
    }

    private void renderSineWave(GuiGraphics guiGraphics, int x, int centerY, int width, int height, double amplitude, double period, int color) {
        double timeOffset = (double)this.animationTicks * 0.1;
        for (int i = 0; i < width; ++i) {
            double normalizedX = (double)i / (double)width * Math.PI * 4.0;
            double normalizedY = Math.sin((normalizedX + timeOffset) / period) * amplitude;
            int pixelY = centerY - (int)(normalizedY * (double)height / 4.0);
            guiGraphics.m_280509_(x + i, pixelY, x + i + 1, pixelY + 2, color);
        }
    }

    private void renderControls(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        boolean rightDisabled;
        int centerX = x + width / 2;
        int dialY = y + height - 30;
        int amplitudeDialX = centerX - 13;
        ResourceLocation amplitudeDialTexture = this.amplitudeDialActive ? DIAL_ON_TEXTURE : DIAL_OFF_TEXTURE;
        guiGraphics.m_280163_(amplitudeDialTexture, amplitudeDialX, dialY, 0.0f, 0.0f, 10, 10, 10, 10);
        if (this.amplitudeDialHovered) {
            guiGraphics.m_280509_(amplitudeDialX - 1, dialY - 1, amplitudeDialX + 10 + 1, dialY + 10 + 1, -2130706433);
        }
        int periodDialX = centerX + 3;
        ResourceLocation periodDialTexture = this.periodDialActive ? DIAL_ON_TEXTURE : DIAL_OFF_TEXTURE;
        guiGraphics.m_280163_(periodDialTexture, periodDialX, dialY, 0.0f, 0.0f, 10, 10, 10, 10);
        if (this.periodDialHovered) {
            guiGraphics.m_280509_(periodDialX - 1, dialY - 1, periodDialX + 10 + 1, dialY + 10 + 1, -2130706433);
        }
        int buttonY = y + height - 15;
        int leftButtonX = centerX - 13;
        int rightButtonX = centerX + 3;
        boolean leftDisabled = this.amplitudeDialActive && this.isAmplitudeAtMin() || this.periodDialActive && this.isPeriodAtMin();
        boolean bl = rightDisabled = this.amplitudeDialActive && this.isAmplitudeAtMax() || this.periodDialActive && this.isPeriodAtMax();
        if (leftDisabled) {
            guiGraphics.m_280163_(LEFT_BUTTON_TEXTURE, leftButtonX, buttonY, 0.0f, 0.0f, 10, 10, 10, 10);
            guiGraphics.m_280509_(leftButtonX, buttonY, leftButtonX + 10, buttonY + 10, Integer.MIN_VALUE);
        } else {
            guiGraphics.m_280163_(LEFT_BUTTON_TEXTURE, leftButtonX, buttonY, 0.0f, 0.0f, 10, 10, 10, 10);
        }
        if (rightDisabled) {
            guiGraphics.m_280163_(RIGHT_BUTTON_TEXTURE, rightButtonX, buttonY, 0.0f, 0.0f, 10, 10, 10, 10);
            guiGraphics.m_280509_(rightButtonX, buttonY, rightButtonX + 10, buttonY + 10, Integer.MIN_VALUE);
        } else {
            guiGraphics.m_280163_(RIGHT_BUTTON_TEXTURE, rightButtonX, buttonY, 0.0f, 0.0f, 10, 10, 10, 10);
        }
        if (this.leftButtonHovered && !leftDisabled) {
            guiGraphics.m_280509_(leftButtonX - 1, buttonY - 1, leftButtonX + 10 + 1, buttonY + 10 + 1, -2130706433);
        }
        if (this.rightButtonHovered && !rightDisabled) {
            guiGraphics.m_280509_(rightButtonX - 1, buttonY - 1, rightButtonX + 10 + 1, buttonY + 10 + 1, -2130706433);
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(0.7f, 0.7f, 1.0f);
        guiGraphics.m_280137_(this.minecraft.f_91062_, "AMP", (int)((float)(amplitudeDialX + 5) / 0.7f), (int)((float)(dialY - 5) / 0.7f), -12728377);
        guiGraphics.m_280137_(this.minecraft.f_91062_, "PER", (int)((float)(periodDialX + 5) / 0.7f), (int)((float)(dialY - 5) / 0.7f), -12728377);
        guiGraphics.m_280168_().m_85849_();
    }

    @Override
    protected boolean handleClick(int mouseX, int mouseY, int button, int panelX, int panelY, int panelWidth, int panelHeight) {
        boolean rightDisabled;
        if (!this.isActive) {
            return false;
        }
        int centerX = panelX + panelWidth / 2;
        int dialY = panelY + panelHeight - 32;
        int amplitudeDialX = centerX - 13;
        int periodDialX = centerX + 3;
        if (mouseX >= amplitudeDialX && mouseX <= amplitudeDialX + 10 && mouseY >= dialY && mouseY <= dialY + 10) {
            boolean bl = this.amplitudeDialActive = !this.amplitudeDialActive;
            if (this.minecraft != null && this.minecraft.f_91074_ != null) {
                this.minecraft.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.ENERGY_DIAL_TOGGLE.get(), 0.6f, 1.0f);
            }
            return true;
        }
        if (mouseX >= periodDialX && mouseX <= periodDialX + 10 && mouseY >= dialY && mouseY <= dialY + 10) {
            boolean bl = this.periodDialActive = !this.periodDialActive;
            if (this.minecraft != null && this.minecraft.f_91074_ != null) {
                this.minecraft.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.ENERGY_DIAL_TOGGLE.get(), 0.6f, 1.0f);
            }
            return true;
        }
        int buttonY = panelY + panelHeight - 15;
        int leftButtonX = centerX - 13;
        int rightButtonX = centerX + 3;
        boolean leftDisabled = this.amplitudeDialActive && this.isAmplitudeAtMin() || this.periodDialActive && this.isPeriodAtMin();
        boolean bl = rightDisabled = this.amplitudeDialActive && this.isAmplitudeAtMax() || this.periodDialActive && this.isPeriodAtMax();
        if (mouseX >= leftButtonX && mouseX <= leftButtonX + 10 && mouseY >= buttonY && mouseY <= buttonY + 10 && !leftDisabled) {
            this.adjustValues(-1);
            if (this.minecraft != null && this.minecraft.f_91074_ != null) {
                this.minecraft.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.ENERGY_BUTTON_CLICK.get(), 0.5f, 1.0f);
            }
            return true;
        }
        if (mouseX >= rightButtonX && mouseX <= rightButtonX + 10 && mouseY >= buttonY && mouseY <= buttonY + 10 && !rightDisabled) {
            this.adjustValues(1);
            if (this.minecraft != null && this.minecraft.f_91074_ != null) {
                this.minecraft.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.ENERGY_BUTTON_CLICK.get(), 0.5f, 1.0f);
            }
            return true;
        }
        return false;
    }

    private void adjustValues(int direction) {
        double step;
        if (this.amplitudeDialActive) {
            step = this.getAmplitudeStep();
            this.currentAmplitude += (double)direction * step;
            this.currentAmplitude = Math.max(0.5, Math.min(1.5, this.currentAmplitude));
            if (Math.abs(this.currentAmplitude - this.targetAmplitude) < step * 1.6) {
                this.currentAmplitude = this.targetAmplitude;
            }
        }
        if (this.periodDialActive) {
            step = this.getPeriodStep();
            this.currentPeriod += (double)direction * step;
            this.currentPeriod = Math.max(1.0, Math.min(1.25, this.currentPeriod));
            if (Math.abs(this.currentPeriod - this.targetPeriod) < step * 1.6) {
                this.currentPeriod = this.targetPeriod;
            }
        }
    }

    private boolean isAmplitudeAtMin() {
        return this.currentAmplitude <= 0.501;
    }

    private boolean isAmplitudeAtMax() {
        return this.currentAmplitude >= 1.499;
    }

    private boolean isPeriodAtMin() {
        return this.currentPeriod <= 1.001;
    }

    private boolean isPeriodAtMax() {
        return this.currentPeriod >= 1.249;
    }

    @Override
    protected void updateMinigame() {
        if (!this.isActive) {
            return;
        }
        ++this.animationTicks;
        boolean currentlyAligned = this.checkAlignment();
        if (currentlyAligned) {
            if (!this.isAligned) {
                this.isAligned = true;
                this.alignmentTicks = 0;
                this.driftTicks = 0;
                if (this.minecraft != null && this.minecraft.f_91074_ != null) {
                    this.minecraft.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.ENERGY_WAVE_ALIGN.get(), 0.4f, 1.0f);
                }
            } else {
                ++this.alignmentTicks;
                int requiredTicks = this.getRequiredAlignmentTicks();
                if (this.alignmentTicks >= requiredTicks) {
                    ++this.driftTicks;
                    int driftDelay = this.getDriftDelayTicks();
                    if (this.driftTicks >= driftDelay) {
                        this.applyDrift();
                    }
                    this.setState(ResearchMinigame.MinigameState.STABLE);
                } else {
                    this.setState(ResearchMinigame.MinigameState.UNSTABLE);
                }
            }
        } else {
            if (this.isAligned && this.minecraft != null && this.minecraft.f_91074_ != null) {
                this.minecraft.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.ENERGY_WAVE_MISALIGN.get(), 0.3f, 1.0f);
            }
            this.isAligned = false;
            this.alignmentTicks = 0;
            this.driftTicks = 0;
            this.amplitudeDrift = 0.0;
            this.periodDrift = 0.0;
            this.setState(ResearchMinigame.MinigameState.UNSTABLE);
        }
    }

    @Override
    protected void setState(ResearchMinigame.MinigameState newState) {
        ResearchMinigame.MinigameState oldState = this.state;
        super.setState(newState);
        if (oldState != newState && this.minecraft != null && this.minecraft.f_91074_ != null) {
            switch (newState) {
                case STABLE: {
                    this.minecraft.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.MINIGAME_STABLE.get(), 0.4f, 1.0f);
                    break;
                }
                case UNSTABLE: {
                    this.minecraft.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.MINIGAME_UNSTABLE.get(), 0.3f, 1.0f);
                }
            }
        }
    }

    public void updateHoverStates(int mouseX, int mouseY, int panelX, int panelY, int panelWidth, int panelHeight) {
        int centerX = panelX + panelWidth / 2;
        int dialY = panelY + panelHeight - 32;
        int amplitudeDialX = centerX - 13;
        int periodDialX = centerX + 3;
        this.amplitudeDialHovered = mouseX >= amplitudeDialX && mouseX <= amplitudeDialX + 10 && mouseY >= dialY && mouseY <= dialY + 10;
        this.periodDialHovered = mouseX >= periodDialX && mouseX <= periodDialX + 10 && mouseY >= dialY && mouseY <= dialY + 10;
        int buttonY = panelY + panelHeight - 15;
        int leftButtonX = centerX - 13;
        int rightButtonX = centerX + 3;
        this.leftButtonHovered = mouseX >= leftButtonX && mouseX <= leftButtonX + 10 && mouseY >= buttonY && mouseY <= buttonY + 10;
        this.rightButtonHovered = mouseX >= rightButtonX && mouseX <= rightButtonX + 10 && mouseY >= buttonY && mouseY <= buttonY + 10;
    }

    public boolean isAmplitudeDialActive() {
        return this.amplitudeDialActive;
    }

    public boolean isPeriodDialActive() {
        return this.periodDialActive;
    }

    public double getCurrentAmplitude() {
        return this.currentAmplitude;
    }

    public double getCurrentPeriod() {
        return this.currentPeriod;
    }

    public double getTargetAmplitude() {
        return this.targetAmplitude;
    }

    public double getTargetPeriod() {
        return this.targetPeriod;
    }

    public void setAmplitudeDialActive(boolean active) {
        this.amplitudeDialActive = active;
    }

    public void setPeriodDialActive(boolean active) {
        this.periodDialActive = active;
    }

    public void setCurrentAmplitude(double amplitude) {
        this.currentAmplitude = amplitude;
    }

    public void setCurrentPeriod(double period) {
        this.currentPeriod = period;
    }

    public void setTargetAmplitude(double amplitude) {
        this.targetAmplitude = amplitude;
    }

    public void setTargetPeriod(double period) {
        this.targetPeriod = period;
    }
}

