/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client.screen.minigames;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.client.screen.minigames.ResearchMinigame;
import com.hexvane.strangematter.research.ResearchType;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.sounds.SoundEvent;

public class CognitionMinigame
extends ResearchMinigame {
    private static final int GRID_SIZE = 3;
    private static final int SYMBOL_SIZE = 12;
    private static final int GRID_SPACING = 2;
    private static final int TOTAL_GRID_SIZE = 40;
    private static final int PATTERN_REDISPLAY_TICKS = 100;
    private static final int DRIFT_DELAY_TICKS = 600;
    private static final String[] ENCHANTING_SYMBOLS = new String[]{"\u16a0", "\u16a2", "\u16a6", "\u16a8", "\u16b1", "\u16b2", "\u16b7", "\u16b9", "\u16ba"};
    private static final int SYMBOL_COLOR = -12728377;
    private static final int BORDER_COLOR = -12728377;
    private static final int HIGHLIGHT_COLOR = -2130706433;
    private static final int CORRECT_COLOR = -2147418368;
    private static final int INCORRECT_COLOR = -2130771968;
    private List<Integer> targetPattern = new ArrayList<Integer>();
    private List<Integer> playerInput = new ArrayList<Integer>();
    private int displayTicks = 0;
    private boolean patternDisplayed = false;
    private int redisplayTicks = 0;
    private int driftTicks = 0;
    private int currentSymbolIndex = 0;
    private int symbolDisplayTicks = 0;
    private Random random = new Random();
    private boolean[] buttonHovered = new boolean[9];
    private boolean[] buttonPressed = new boolean[9];
    private int buttonCooldown = 0;
    private static final int BUTTON_COOLDOWN_TICKS = 5;
    private final Minecraft minecraft = Minecraft.m_91087_();

    private int getMatchDuration() {
        return Config.cognitionMatchDuration;
    }

    private int getDifficulty() {
        return Config.cognitionDifficulty;
    }

    public CognitionMinigame() {
        super(ResearchType.COGNITION);
    }

    @Override
    protected void onActivate() {
        this.generateNewPattern();
        this.setState(ResearchMinigame.MinigameState.UNSTABLE);
    }

    @Override
    protected void onDeactivate() {
        this.targetPattern.clear();
        this.playerInput.clear();
        this.displayTicks = 0;
        this.patternDisplayed = false;
        this.redisplayTicks = 0;
        this.driftTicks = 0;
        this.currentSymbolIndex = 0;
        this.symbolDisplayTicks = 0;
    }

    @Override
    public void updateMinigame() {
        if (!this.isActive) {
            return;
        }
        if (this.patternDisplayed) {
            ++this.symbolDisplayTicks;
            int symbolDuration = this.getMatchDuration();
            if (this.symbolDisplayTicks >= symbolDuration) {
                ++this.currentSymbolIndex;
                this.symbolDisplayTicks = 0;
                if (this.currentSymbolIndex >= this.targetPattern.size()) {
                    this.patternDisplayed = false;
                    this.currentSymbolIndex = 0;
                }
            }
        } else {
            ++this.redisplayTicks;
            if (this.redisplayTicks >= 100) {
                this.patternDisplayed = true;
                this.currentSymbolIndex = 0;
                this.symbolDisplayTicks = 0;
                this.redisplayTicks = 0;
            }
        }
        if (this.buttonCooldown > 0) {
            --this.buttonCooldown;
        }
        this.checkStability();
        if (this.getState() == ResearchMinigame.MinigameState.STABLE) {
            ++this.driftTicks;
            if (this.driftTicks >= 600) {
                this.generateNewPattern();
                this.driftTicks = 0;
                this.setState(ResearchMinigame.MinigameState.UNSTABLE);
            }
        } else {
            this.driftTicks = 0;
        }
    }

    @Override
    protected void renderActive(GuiGraphics guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        int centerX = x + width / 2;
        int centerY = y + height / 2;
        int gridX = centerX - 20;
        int gridY = centerY - 20;
        this.renderSymbolGrid(guiGraphics, gridX, gridY);
        if (this.patternDisplayed) {
            this.renderPatternDisplay(guiGraphics, gridX, gridY);
        }
        this.renderInputFeedback(guiGraphics, gridX, gridY);
    }

    @Override
    protected void renderInactive(GuiGraphics guiGraphics, int x, int y, int width, int height) {
    }

    @Override
    protected boolean handleClick(int mouseX, int mouseY, int button, int panelX, int panelY, int panelWidth, int panelHeight) {
        if (!this.isActive || button != 0 || this.buttonCooldown > 0) {
            return false;
        }
        int centerX = panelX + panelWidth / 2;
        int centerY = panelY + panelHeight / 2;
        int gridX = centerX - 20;
        int gridY = centerY - 20;
        if (mouseX >= gridX && mouseX < gridX + 40 && mouseY >= gridY && mouseY < gridY + 40) {
            int relativeX = mouseX - gridX;
            int relativeY = mouseY - gridY;
            int symbolX = relativeX / 14;
            int symbolY = relativeY / 14;
            if (symbolX >= 0 && symbolX < 3 && symbolY >= 0 && symbolY < 3) {
                int symbolIndex = symbolY * 3 + symbolX;
                this.playerInput.add(symbolIndex);
                if (this.playerInput.size() >= this.targetPattern.size()) {
                    this.checkPattern();
                }
                this.buttonCooldown = 5;
                if (this.minecraft != null && this.minecraft.f_91074_ != null) {
                    this.minecraft.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.RESEARCH_MACHINE_NOTE_INSERT.get(), 0.3f, 1.0f);
                }
                return true;
            }
        }
        return false;
    }

    public void updateHoverStates(int mouseX, int mouseY, int panelX, int panelY, int panelWidth, int panelHeight) {
        if (!this.isActive) {
            return;
        }
        int centerX = panelX + panelWidth / 2;
        int centerY = panelY + panelHeight / 2;
        int gridX = centerX - 20;
        int gridY = centerY - 20;
        for (int i = 0; i < this.buttonHovered.length; ++i) {
            this.buttonHovered[i] = false;
        }
        if (mouseX >= gridX && mouseX < gridX + 40 && mouseY >= gridY && mouseY < gridY + 40) {
            int relativeX = mouseX - gridX;
            int relativeY = mouseY - gridY;
            int symbolX = relativeX / 14;
            int symbolY = relativeY / 14;
            if (symbolX >= 0 && symbolX < 3 && symbolY >= 0 && symbolY < 3) {
                int symbolIndex = symbolY * 3 + symbolX;
                this.buttonHovered[symbolIndex] = true;
            }
        }
    }

    private void generateNewPattern() {
        int i;
        this.targetPattern.clear();
        this.playerInput.clear();
        int patternLength = this.getDifficulty();
        ArrayList<Integer> availableSymbols = new ArrayList<Integer>();
        for (i = 0; i < 9; ++i) {
            availableSymbols.add(i);
        }
        for (i = 0; i < patternLength; ++i) {
            int randomIndex = this.random.nextInt(availableSymbols.size());
            int symbol = (Integer)availableSymbols.remove(randomIndex);
            this.targetPattern.add(symbol);
        }
        this.patternDisplayed = true;
        this.currentSymbolIndex = 0;
        this.symbolDisplayTicks = 0;
    }

    private void checkPattern() {
        boolean correct = true;
        if (this.playerInput.size() != this.targetPattern.size()) {
            correct = false;
        } else {
            for (int i = 0; i < this.targetPattern.size(); ++i) {
                if (this.playerInput.get(i).equals(this.targetPattern.get(i))) continue;
                correct = false;
                break;
            }
        }
        if (correct) {
            this.setState(ResearchMinigame.MinigameState.STABLE);
            if (this.minecraft != null && this.minecraft.f_91074_ != null) {
                this.minecraft.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.MINIGAME_STABLE.get(), 0.4f, 1.0f);
            }
        } else {
            this.setState(ResearchMinigame.MinigameState.UNSTABLE);
            if (this.minecraft != null && this.minecraft.f_91074_ != null) {
                this.minecraft.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.MINIGAME_UNSTABLE.get(), 0.3f, 1.0f);
            }
            this.playerInput.clear();
        }
    }

    private void checkStability() {
    }

    private void renderSymbolGrid(GuiGraphics guiGraphics, int gridX, int gridY) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int symbolIndex = y * 3 + x;
                int symbolX = gridX + x * 14;
                int symbolY = gridY + y * 14;
                guiGraphics.m_280509_(symbolX, symbolY, symbolX + 12, symbolY + 12, -14013910);
                guiGraphics.m_280509_(symbolX - 1, symbolY - 1, symbolX + 12 + 1, symbolY, -12728377);
                guiGraphics.m_280509_(symbolX - 1, symbolY + 12, symbolX + 12 + 1, symbolY + 12 + 1, -12728377);
                guiGraphics.m_280509_(symbolX - 1, symbolY - 1, symbolX, symbolY + 12 + 1, -12728377);
                guiGraphics.m_280509_(symbolX + 12, symbolY - 1, symbolX + 12 + 1, symbolY + 12 + 1, -12728377);
                String symbol = ENCHANTING_SYMBOLS[symbolIndex];
                Font font = this.minecraft.f_91062_;
                Objects.requireNonNull(this.minecraft.f_91062_);
                guiGraphics.m_280137_(font, symbol, symbolX + 6, symbolY + 6 - 9 / 2, -12728377);
                if (!this.buttonHovered[symbolIndex]) continue;
                guiGraphics.m_280509_(symbolX - 2, symbolY - 2, symbolX + 12 + 2, symbolY + 12 + 2, -2130706433);
            }
        }
    }

    private void renderPatternDisplay(GuiGraphics guiGraphics, int gridX, int gridY) {
        if (this.currentSymbolIndex < this.targetPattern.size()) {
            int symbolIndex = this.targetPattern.get(this.currentSymbolIndex);
            int x = symbolIndex % 3;
            int y = symbolIndex / 3;
            int symbolX = gridX + x * 14;
            int symbolY = gridY + y * 14;
            guiGraphics.m_280509_(symbolX - 2, symbolY - 2, symbolX + 12 + 2, symbolY + 12 + 2, -2130706688);
        }
    }

    private void renderInputFeedback(GuiGraphics guiGraphics, int gridX, int gridY) {
        for (int i = 0; i < this.playerInput.size(); ++i) {
            int symbolIndex = this.playerInput.get(i);
            int x = symbolIndex % 3;
            int y = symbolIndex / 3;
            int symbolX = gridX + x * 14;
            int symbolY = gridY + y * 14;
            boolean correct = i < this.targetPattern.size() && this.playerInput.get(i).equals(this.targetPattern.get(i));
            int color = correct ? -2147418368 : -2130771968;
            guiGraphics.m_280509_(symbolX - 1, symbolY - 1, symbolX + 12 + 1, symbolY + 12 + 1, color);
        }
    }

    public List<Integer> getTargetPattern() {
        return new ArrayList<Integer>(this.targetPattern);
    }

    public void setTargetPattern(List<Integer> targetPattern) {
        this.targetPattern = new ArrayList<Integer>(targetPattern);
    }

    public List<Integer> getPlayerInput() {
        return new ArrayList<Integer>(this.playerInput);
    }

    public void setPlayerInput(List<Integer> playerInput) {
        this.playerInput = new ArrayList<Integer>(playerInput);
    }

    public int getDisplayTicks() {
        return this.displayTicks;
    }

    public void setDisplayTicks(int displayTicks) {
        this.displayTicks = displayTicks;
    }

    public boolean isPatternDisplayed() {
        return this.patternDisplayed;
    }

    public void setPatternDisplayed(boolean patternDisplayed) {
        this.patternDisplayed = patternDisplayed;
    }

    public int getRedisplayTicks() {
        return this.redisplayTicks;
    }

    public void setRedisplayTicks(int redisplayTicks) {
        this.redisplayTicks = redisplayTicks;
    }

    public int getCurrentSymbolIndex() {
        return this.currentSymbolIndex;
    }

    public void setCurrentSymbolIndex(int currentSymbolIndex) {
        this.currentSymbolIndex = currentSymbolIndex;
    }

    public int getSymbolDisplayTicks() {
        return this.symbolDisplayTicks;
    }

    public void setSymbolDisplayTicks(int symbolDisplayTicks) {
        this.symbolDisplayTicks = symbolDisplayTicks;
    }

    public int getDriftTicks() {
        return this.driftTicks;
    }

    public void setDriftTicks(int driftTicks) {
        this.driftTicks = driftTicks;
    }

    public int getButtonCooldown() {
        return this.buttonCooldown;
    }

    public void setButtonCooldown(int buttonCooldown) {
        this.buttonCooldown = buttonCooldown;
    }
}

