/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client.screen.components;

import com.hexvane.strangematter.client.screen.components.BubblingParticleSystem;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class InstabilityGauge {
    private static final ResourceLocation TUBE_TEXTURE = new ResourceLocation("strangematter", "textures/ui/instability_tube.png");
    private static final ResourceLocation FILL_TEXTURE = new ResourceLocation("strangematter", "textures/ui/instability_tube_fill.png");
    private static final int TEXT_COLOR = -12728377;
    private static final int GAUGE_WIDTH = 50;
    private static final int GAUGE_HEIGHT = 140;
    private int x;
    private int y;
    private float fillLevel = 0.5f;
    private BubblingParticleSystem particleSystem;

    public InstabilityGauge(int x, int y) {
        this.x = x;
        this.y = y;
        this.particleSystem = BubblingParticleSystem.createInstabilityTubeEffect(x + 25, y, 20, 125);
    }

    public void setFillLevel(float fillLevel) {
        this.fillLevel = Math.max(0.0f, Math.min(1.0f, fillLevel));
    }

    public float getFillLevel() {
        return this.fillLevel;
    }

    public void update() {
        this.particleSystem.update();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderFill(guiGraphics);
        this.particleSystem.render(guiGraphics);
        guiGraphics.m_280163_(TUBE_TEXTURE, this.x, this.y, 0.0f, 0.0f, 50, 140, 50, 140);
        this.renderVerticalText(guiGraphics);
    }

    private void renderFill(GuiGraphics guiGraphics) {
        int fillHeight = (int)(140.0f * this.fillLevel);
        if (fillHeight > 0) {
            int fillY = this.y + 140 - fillHeight;
            guiGraphics.m_280163_(FILL_TEXTURE, this.x, fillY, 0.0f, (float)(140 - fillHeight), 50, fillHeight, 50, 140);
        }
    }

    private void renderVerticalText(GuiGraphics guiGraphics) {
        String text = "INSTABILITY";
        int textX = this.x + 7;
        int textY = this.y + 70 + text.length() + 10;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)textX, (float)textY, 0.0f);
        guiGraphics.m_280168_().m_85841_(0.8f, 0.8f, 1.0f);
        guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(-90.0f));
        guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, text, 0, 0, -12728377);
        guiGraphics.m_280168_().m_85849_();
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return 70;
    }

    public int getHeight() {
        return 140;
    }
}

