/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client.screen.components;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.GuiGraphics;

public class BubblingParticleSystem {
    private final List<Particle> particles = new ArrayList<Particle>();
    private final Random random = new Random();
    private final int tubeX;
    private final int tubeY;
    private final int tubeWidth;
    private final int tubeHeight;
    private final int particleColor;
    private final float spawnRate;
    private final float minSize;
    private final float maxSize;
    private final float minSpeed;
    private final float maxSpeed;
    private final float maxLife;
    private float spawnAccumulator = 0.0f;

    public BubblingParticleSystem(int tubeX, int tubeY, int tubeWidth, int tubeHeight, int particleColor, float spawnRate, float minSize, float maxSize, float minSpeed, float maxSpeed, float maxLife) {
        this.tubeX = tubeX;
        this.tubeY = tubeY;
        this.tubeWidth = tubeWidth;
        this.tubeHeight = tubeHeight;
        this.particleColor = particleColor;
        this.spawnRate = spawnRate;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.minSpeed = minSpeed;
        this.maxSpeed = maxSpeed;
        this.maxLife = maxLife;
    }

    public void update() {
        this.spawnAccumulator += this.spawnRate;
        while (this.spawnAccumulator >= 1.0f) {
            this.spawnParticle();
            this.spawnAccumulator -= 1.0f;
        }
        this.particles.removeIf(particle -> {
            particle.update();
            return !particle.isAlive();
        });
    }

    public void render(GuiGraphics guiGraphics) {
        for (Particle particle : this.particles) {
            particle.render(guiGraphics);
        }
    }

    private void spawnParticle() {
        float x = (float)this.tubeX + this.random.nextFloat() * (float)this.tubeWidth;
        float y = (float)this.tubeY + this.random.nextFloat() * (float)(this.tubeHeight - 5);
        float size = this.minSize + this.random.nextFloat() * (this.maxSize - this.minSize);
        float speed = this.minSpeed + this.random.nextFloat() * (this.maxSpeed - this.minSpeed);
        this.particles.add(new Particle(x, y, size, this.particleColor, this.maxLife, speed));
    }

    public static BubblingParticleSystem createInstabilityTubeEffect(int tubeX, int tubeY, int tubeWidth, int tubeHeight) {
        return new BubblingParticleSystem(tubeX, tubeY, tubeWidth, tubeHeight, -6929990, 0.3f, 1.0f, 3.0f, 0.5f, 1.5f, 20.0f);
    }

    public static BubblingParticleSystem createGravityTubeEffect(int tubeX, int tubeY, int tubeWidth, int tubeHeight) {
        return new BubblingParticleSystem(tubeX, tubeY, tubeWidth, tubeHeight, -12728377, 0.3f, 1.0f, 3.0f, 0.5f, 1.5f, 20.0f);
    }

    private static class Particle {
        float x;
        float y;
        float size;
        int color;
        float life;
        float maxLife;
        float speed;

        Particle(float x, float y, float size, int color, float maxLife, float speed) {
            this.x = x;
            this.y = y;
            this.size = size;
            this.color = color;
            this.life = 0.0f;
            this.maxLife = maxLife;
            this.speed = speed;
        }

        boolean isAlive() {
            return this.life < this.maxLife;
        }

        void update() {
            this.life += 1.0f;
            this.y -= this.speed;
        }

        void render(GuiGraphics guiGraphics) {
            float alpha = 1.0f - this.life / this.maxLife;
            int alphaInt = (int)(alpha * 255.0f) << 24;
            int finalColor = this.color & 0xFFFFFF | alphaInt;
            int particleSize = Math.max(1, (int)this.size);
            guiGraphics.m_280509_((int)this.x, (int)this.y, (int)this.x + particleSize, (int)this.y + particleSize, finalColor);
        }
    }
}

