/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client.screen;

import com.hexvane.strangematter.client.network.ClientPacketHandlers;
import com.hexvane.strangematter.client.research.ResearchNodePositionManager;
import com.hexvane.strangematter.client.screen.ResearchNodeInfoScreen;
import com.hexvane.strangematter.network.NetworkHandler;
import com.hexvane.strangematter.network.SpendResearchPointsPacket;
import com.hexvane.strangematter.research.ResearchData;
import com.hexvane.strangematter.research.ResearchNode;
import com.hexvane.strangematter.research.ResearchNodeRegistry;
import com.hexvane.strangematter.research.ResearchType;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class ResearchTabletScreen
extends Screen {
    private static final ResourceLocation RESEARCH_TABLET_BACKGROUND = ResourceLocation.parse((String)"strangematter:textures/ui/research_tablet_background.png");
    private static final ResourceLocation RESEARCH_TABLET_OVERLAY = ResourceLocation.parse((String)"strangematter:textures/ui/research_tablet_overlay.png");
    private static final ResourceLocation RESEARCH_NODE_TEXTURE = ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png");
    private static final int GUI_WIDTH = 320;
    private static final int GUI_HEIGHT = 240;
    private static final int DRAGGABLE_AREA_WIDTH = 246;
    private static final int DRAGGABLE_AREA_HEIGHT = 161;
    private static final int BACKGROUND_TILE_SIZE = 64;
    private int guiX;
    private int guiY;
    private double dragOffsetX = 0.0;
    private double dragOffsetY = 0.0;
    private boolean isDragging = false;
    private double lastMouseX;
    private double lastMouseY;
    private String selectedCategory = "general";
    private double savedDragOffsetX = 0.0;
    private double savedDragOffsetY = 0.0;
    private int refreshCounter = 0;
    private ResearchNode lastHoveredNode = null;
    private final Map<String, Button> categoryButtons = new HashMap<String, Button>();
    private boolean debugMode = false;
    private ResearchNodePositionManager positionManager;
    private ResearchNode draggedNode = null;
    private static final float MIN_ZOOM = 0.5f;
    private static final float MAX_ZOOM = 2.5f;
    private static final float ZOOM_STEP_FACTOR = 1.12f;
    private float zoom = 1.0f;

    public ResearchTabletScreen() {
        super((Component)Component.m_237115_((String)"gui.strangematter.research_tablet"));
        ResearchNodeRegistry.initializeDefaultNodes();
        this.positionManager = ResearchNodePositionManager.getInstance();
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.RESEARCH_TABLET_OPEN.get(), 0.7f, 1.0f);
        }
        this.guiX = (this.f_96543_ - 320) / 2;
        this.guiY = (this.f_96544_ - 240) / 2;
        this.dragOffsetX = 0.0;
        this.dragOffsetY = 0.0;
        this.zoom = 1.0f;
    }

    private int getDraggableAreaX() {
        return this.guiX + 37;
    }

    private int getDraggableAreaY() {
        return this.guiY + 21;
    }

    private boolean isMouseInDraggableArea(double mouseX, double mouseY) {
        int x = this.getDraggableAreaX();
        int y = this.getDraggableAreaY();
        return mouseX >= (double)x && mouseX <= (double)(x + 246) && mouseY >= (double)y && mouseY <= (double)(y + 161);
    }

    private double getAreaCenterX() {
        return (double)this.getDraggableAreaX() + 123.0;
    }

    private double getAreaCenterY() {
        return (double)this.getDraggableAreaY() + 80.5;
    }

    private double screenToResearchX(double mouseX) {
        return (mouseX - this.getAreaCenterX()) / (double)this.zoom - this.dragOffsetX;
    }

    private double screenToResearchY(double mouseY) {
        return (mouseY - this.getAreaCenterY()) / (double)this.zoom - this.dragOffsetY;
    }

    private double researchToScreenX(double researchX) {
        return this.getAreaCenterX() + (researchX + this.dragOffsetX) * (double)this.zoom;
    }

    private double researchToScreenY(double researchY) {
        return this.getAreaCenterY() + (researchY + this.dragOffsetY) * (double)this.zoom;
    }

    private float clampZoom(float value) {
        return Math.max(0.5f, Math.min(2.5f, value));
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 68 && (modifiers & 2) != 0) {
            boolean bl = this.debugMode = !this.debugMode;
            if (this.debugMode) {
                this.positionManager.savePositions();
            }
            return true;
        }
        if (this.debugMode && keyCode == 83 && (modifiers & 2) != 0) {
            this.positionManager.savePositions();
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7aSaved research node positions"));
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (!this.isMouseInDraggableArea(mouseX, mouseY)) {
            return super.m_6050_(mouseX, mouseY, scrollDelta);
        }
        if (scrollDelta == 0.0) {
            return true;
        }
        double localX = mouseX - this.getAreaCenterX();
        double localY = mouseY - this.getAreaCenterY();
        float oldZoom = this.zoom;
        float newZoom = this.clampZoom((float)((double)oldZoom * Math.pow(1.12f, scrollDelta)));
        if (newZoom == oldZoom) {
            return true;
        }
        double anchorResearchX = localX / (double)oldZoom - this.dragOffsetX;
        double anchorResearchY = localY / (double)oldZoom - this.dragOffsetY;
        this.zoom = newZoom;
        this.dragOffsetX = localX / (double)newZoom - anchorResearchX;
        this.dragOffsetY = localY / (double)newZoom - anchorResearchY;
        return true;
    }

    private void createCategoryButtons() {
        List<String> categories = ResearchNodeRegistry.getCategories();
        int buttonWidth = 60;
        int buttonHeight = 20;
        int buttonSpacing = 5;
        int totalButtonWidth = categories.size() * buttonWidth + (categories.size() - 1) * buttonSpacing;
        int startX = this.guiX + (320 - totalButtonWidth) / 2;
        int buttonY = this.guiY + 20;
        for (int i = 0; i < categories.size(); ++i) {
            String category = categories.get(i);
            Button button = Button.m_253074_((Component)Component.m_237115_((String)("research.category.strangematter." + category)), btn -> {
                this.selectedCategory = category;
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.RESEARCH_TABLET_PAGE_TURN.get(), 0.6f, 1.0f);
                }
            }).m_252987_(startX + i * (buttonWidth + buttonSpacing), buttonY, buttonWidth, buttonHeight).m_253136_();
            this.categoryButtons.put(category, button);
            this.m_142416_((GuiEventListener)button);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        int bPadding = 10;
        guiGraphics.m_280509_(this.guiX + bPadding, this.guiY + bPadding, this.guiX + 320 - bPadding, this.guiY + 240 - bPadding, -12566464);
        this.renderDraggableArea(guiGraphics, mouseX, mouseY);
        this.renderResearchPointsBackground(guiGraphics);
        this.renderResearchPoints(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RESEARCH_TABLET_OVERLAY);
        guiGraphics.m_280163_(RESEARCH_TABLET_OVERLAY, this.guiX, this.guiY, 0.0f, 0.0f, 320, 240, 320, 240);
        if (this.debugMode) {
            this.renderDebugOverlay(guiGraphics, mouseX, mouseY);
        }
        this.renderResearchNodeTooltips(guiGraphics, mouseX, mouseY);
    }

    private void renderDebugOverlay(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isMouseInDraggableArea(mouseX, mouseY)) {
            int researchX = (int)Math.round(this.screenToResearchX(mouseX));
            int researchY = (int)Math.round(this.screenToResearchY(mouseY));
            int gridX = ResearchNodePositionManager.snapToGrid(researchX);
            int gridY = ResearchNodePositionManager.snapToGrid(researchY);
            String coordText = String.format("X: %d, Y: %d", researchX, researchY);
            String gridText = String.format("Grid: X: %d, Y: %d", gridX, gridY);
            int textX = mouseX + 10;
            int textY = mouseY - 30;
            int textWidth = Math.max(this.f_96547_.m_92895_(coordText), this.f_96547_.m_92895_(gridText)) + 4;
            guiGraphics.m_280509_(textX - 2, textY - 2, textX + textWidth + 2, textY + 24, Integer.MIN_VALUE);
            guiGraphics.m_280637_(textX - 2, textY - 2, textWidth + 4, 24, -16711936);
            guiGraphics.m_280488_(this.f_96547_, coordText, textX, textY, 0xFFFFFF);
            guiGraphics.m_280488_(this.f_96547_, gridText, textX, textY + 12, 65280);
        }
        String debugText = "DEBUG MODE - Ctrl+D to toggle, Ctrl+S to save";
        int indicatorX = this.guiX + 5;
        int indicatorY = this.guiY + 5;
        int indicatorWidth = this.f_96547_.m_92895_(debugText) + 4;
        int indicatorHeight = 12;
        guiGraphics.m_280509_(indicatorX - 2, indicatorY - 2, indicatorX + indicatorWidth + 2, indicatorY + indicatorHeight + 2, Integer.MIN_VALUE);
        guiGraphics.m_280637_(indicatorX - 2, indicatorY - 2, indicatorWidth + 4, indicatorHeight + 2, -65536);
        guiGraphics.m_280488_(this.f_96547_, debugText, indicatorX, indicatorY, 0xFFFF00);
    }

    private void renderDraggableArea(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int draggableX = this.getDraggableAreaX();
        int draggableY = this.getDraggableAreaY();
        guiGraphics.m_280588_(draggableX, draggableY, draggableX + 246, draggableY + 161);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.getAreaCenterX(), (float)this.getAreaCenterY(), 0.0f);
        guiGraphics.m_280168_().m_85841_(this.zoom, this.zoom, 1.0f);
        guiGraphics.m_280168_().m_252880_((float)this.dragOffsetX, (float)this.dragOffsetY, 0.0f);
        this.renderTiledBackground(guiGraphics);
        this.renderResearchNodeConnections(guiGraphics);
        this.renderResearchNodes(guiGraphics, mouseX, mouseY);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280618_();
    }

    private void renderTiledBackground(GuiGraphics guiGraphics) {
        double halfW = 246.0 / (2.0 * (double)this.zoom);
        double halfH = 161.0 / (2.0 * (double)this.zoom);
        double left = -halfW - this.dragOffsetX;
        double right = halfW - this.dragOffsetX;
        double top = -halfH - this.dragOffsetY;
        double bottom = halfH - this.dragOffsetY;
        int bufferTiles = 2;
        double startX = Math.floor(left / 64.0) * 64.0 - (double)(bufferTiles * 64);
        double startY = Math.floor(top / 64.0) * 64.0 - (double)(bufferTiles * 64);
        double endX = Math.ceil(right / 64.0) * 64.0 + (double)(bufferTiles * 64);
        double endY = Math.ceil(bottom / 64.0) * 64.0 + (double)(bufferTiles * 64);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RESEARCH_TABLET_BACKGROUND);
        for (double x = startX; x <= endX; x += 64.0) {
            for (double y = startY; y <= endY; y += 64.0) {
                guiGraphics.m_280163_(RESEARCH_TABLET_BACKGROUND, (int)x, (int)y, 0.0f, 0.0f, 64, 64, 64, 64);
            }
        }
    }

    private void renderResearchNodeConnections(GuiGraphics guiGraphics) {
        List<ResearchNode> nodes = ResearchNodeRegistry.getNodesByCategory(this.selectedCategory);
        ResearchData researchData = ClientPacketHandlers.getClientResearchData();
        ArrayList<ConnectionLine> allLines = new ArrayList<ConnectionLine>();
        for (ResearchNode node : nodes) {
            if (!node.hasPrerequisites()) continue;
            int nodeX = this.positionManager.getEffectiveX(node);
            int nodeY = this.positionManager.getEffectiveY(node);
            for (String prerequisiteId : node.getPrerequisites()) {
                int priority;
                int lineColor;
                ResearchNode prerequisite = ResearchNodeRegistry.getNode(prerequisiteId);
                if (prerequisite == null) continue;
                int prereqX = this.positionManager.getEffectiveX(prerequisite);
                int prereqY = this.positionManager.getEffectiveY(prerequisite);
                boolean isUnlocked = researchData.getUnlockedResearch().contains(node.getId());
                boolean prereqUnlocked = researchData.getUnlockedResearch().contains(prerequisiteId);
                if (isUnlocked && prereqUnlocked) {
                    lineColor = 4305536;
                    priority = 3;
                } else if (prereqUnlocked) {
                    lineColor = 0xFFFFFF;
                    priority = 2;
                } else {
                    lineColor = 0x808080;
                    priority = 1;
                }
                int centerX1 = prereqX + 16;
                int centerY1 = prereqY + 16;
                int centerX2 = nodeX + 16;
                int centerY2 = nodeY + 16;
                allLines.add(new ConnectionLine(centerX1, centerY1, centerX2, centerY2, lineColor, prerequisiteId, node.getId(), priority));
            }
        }
        allLines.sort((a, b) -> Integer.compare(a.priority, b.priority));
        for (ConnectionLine line : allLines) {
            this.drawLine(guiGraphics, line.x1, line.y1, line.x2, line.y2, line.color, line.nodeId1, line.nodeId2);
        }
    }

    private boolean hasPrerequisitesUnlocked(ResearchNode node, ResearchData researchData) {
        for (String prerequisiteId : node.getPrerequisites()) {
            if (researchData.getUnlockedResearch().contains(prerequisiteId)) continue;
            return false;
        }
        return true;
    }

    private ResearchNode getClickedNode(double mouseX, double mouseY) {
        for (ResearchNode node : ResearchNodeRegistry.getNodesByCategory(this.selectedCategory)) {
            int nodeResearchX = this.positionManager.getEffectiveX(node);
            int nodeResearchY = this.positionManager.getEffectiveY(node);
            double nodeScreenX = this.researchToScreenX(nodeResearchX);
            double nodeScreenY = this.researchToScreenY(nodeResearchY);
            double nodeScreenSize = 32.0 * (double)this.zoom;
            if (!(mouseX >= nodeScreenX) || !(mouseX <= nodeScreenX + nodeScreenSize) || !(mouseY >= nodeScreenY) || !(mouseY <= nodeScreenY + nodeScreenSize)) continue;
            return node;
        }
        return null;
    }

    private void openNodeInformationPage(ResearchNode node) {
        this.savedDragOffsetX = this.dragOffsetX;
        this.savedDragOffsetY = this.dragOffsetY;
        this.f_96541_.m_91152_((Screen)new ResearchNodeInfoScreen(node, this));
    }

    public void restoreDragPosition() {
        this.dragOffsetX = this.savedDragOffsetX;
        this.dragOffsetY = this.savedDragOffsetY;
    }

    private String generateObfuscatedText(String originalText) {
        return "\u00a7k" + originalText;
    }

    private List<Component> generateWrappedObfuscatedText(String originalText, int maxWidth) {
        ArrayList<Component> wrappedLines = new ArrayList<Component>();
        String[] words = originalText.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.length() > 0 ? currentLine + " " + word : word;
            if (this.f_96547_.m_92895_(testLine) <= maxWidth) {
                if (currentLine.length() > 0) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            if (currentLine.length() > 0) {
                wrappedLines.add((Component)Component.m_237113_((String)("\u00a77\u00a7k" + currentLine.toString())));
                currentLine = new StringBuilder(word);
                continue;
            }
            wrappedLines.add((Component)Component.m_237113_((String)("\u00a77\u00a7k" + word)));
        }
        if (currentLine.length() > 0) {
            wrappedLines.add((Component)Component.m_237113_((String)("\u00a77\u00a7k" + currentLine.toString())));
        }
        return wrappedLines;
    }

    private void drawLine(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int color, String nodeId1, String nodeId2) {
        int brightColor = color | 0xFF000000;
        float r = (float)(brightColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(brightColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(brightColor & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        int lineThickness = 3;
        int halfThickness = lineThickness / 2;
        if (x1 != x2 && y1 != y2) {
            this.drawCircuitBoardTrace(guiGraphics, x1, y1, x2, y2, brightColor, halfThickness, nodeId1, nodeId2);
        } else if (x1 != x2) {
            int startX = Math.min(x1, x2);
            int endX = Math.max(x1, x2);
            guiGraphics.m_280509_(startX, y1 - halfThickness, endX, y1 + halfThickness, brightColor);
        } else if (y1 != y2) {
            int startY = Math.min(y1, y2);
            int endY = Math.max(y1, y2);
            guiGraphics.m_280509_(x1 - halfThickness, startY, x1 + halfThickness, endY, brightColor);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawCircuitBoardTrace(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int color, int halfThickness, String nodeId1, String nodeId2) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        if (dx > 80 || dy > 80) {
            this.drawLongCircuitTrace(guiGraphics, x1, y1, x2, y2, color, halfThickness, nodeId1, nodeId2);
        } else {
            this.drawShortCircuitTrace(guiGraphics, x1, y1, x2, y2, color, halfThickness);
        }
    }

    private void drawShortCircuitTrace(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int color, int halfThickness) {
        int startX = Math.min(x1, x2);
        int endX = Math.max(x1, x2);
        guiGraphics.m_280509_(startX, y1 - halfThickness, endX + halfThickness, y1 + halfThickness, color);
        int startY = Math.min(y1, y2);
        int endY = Math.max(y1, y2);
        guiGraphics.m_280509_(x2 - halfThickness, startY - halfThickness, x2 + halfThickness, endY + halfThickness, color);
        this.drawVia(guiGraphics, x2, y1, color);
    }

    private void drawLongCircuitTrace(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int color, int halfThickness, String nodeId1, String nodeId2) {
        int waypointX = x1 + (x2 - x1) / 2;
        int waypointY = y1 + (y2 - y1) / 2;
        int connectionHash = Math.abs(nodeId1.hashCode() + nodeId2.hashCode());
        int stableOffset = connectionHash % 16 - 8;
        int startX = Math.min(x1, waypointX + stableOffset);
        int endX = Math.max(x1, waypointX + stableOffset);
        guiGraphics.m_280509_(startX, y1 - halfThickness, endX + halfThickness, y1 + halfThickness, color);
        int intermediateY = y1 + (y2 - y1) / 3;
        guiGraphics.m_280509_(waypointX + stableOffset - halfThickness, y1 - halfThickness, waypointX + stableOffset + halfThickness, intermediateY, color);
        int finalX = x2;
        guiGraphics.m_280509_(waypointX + stableOffset, intermediateY - halfThickness, finalX, intermediateY + halfThickness, color);
        guiGraphics.m_280509_(finalX - halfThickness, intermediateY, finalX + halfThickness, y2, color);
        this.drawVia(guiGraphics, waypointX + stableOffset, y1, color);
        this.drawVia(guiGraphics, waypointX + stableOffset, intermediateY, color);
        this.drawVia(guiGraphics, finalX, intermediateY, color);
    }

    private void drawVia(GuiGraphics guiGraphics, int x, int y, int color) {
        int viaSize = 4;
        int viaHalf = viaSize / 2;
        guiGraphics.m_280509_(x - viaHalf, y - viaHalf, x + viaHalf, y + viaHalf, color);
        int darkerColor = color & 0xFF000000 | (int)((double)(color >> 16 & 0xFF) * 0.7) << 16 | (int)((double)(color >> 8 & 0xFF) * 0.7) << 8 | (int)((double)(color & 0xFF) * 0.7);
        guiGraphics.m_280509_(x - 1, y - 1, x + 1, y + 1, darkerColor);
    }

    private void renderResearchNodes(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        List<ResearchNode> nodes = ResearchNodeRegistry.getNodesByCategory(this.selectedCategory);
        ResearchData researchData = ClientPacketHandlers.getClientResearchData();
        for (ResearchNode node : nodes) {
            boolean isDragged;
            int nodeX = this.positionManager.getEffectiveX(node);
            int nodeY = this.positionManager.getEffectiveY(node);
            double nodeScreenX = this.researchToScreenX(nodeX);
            double nodeScreenY = this.researchToScreenY(nodeY);
            double nodeScreenSize = 32.0 * (double)this.zoom;
            if (!(nodeScreenX + nodeScreenSize >= (double)this.getDraggableAreaX()) || !(nodeScreenX <= (double)(this.getDraggableAreaX() + 246)) || !(nodeScreenY + nodeScreenSize >= (double)this.getDraggableAreaY()) || !(nodeScreenY <= (double)(this.getDraggableAreaY() + 161))) continue;
            boolean isUnlocked = researchData.getUnlockedResearch().contains(node.getId());
            boolean canAfford = node.canAfford(this.getPlayerResearchPoints(researchData));
            boolean prerequisitesUnlocked = this.hasPrerequisitesUnlocked(node, researchData);
            boolean isHovered = (double)mouseX >= nodeScreenX && (double)mouseX <= nodeScreenX + nodeScreenSize && (double)mouseY >= nodeScreenY && (double)mouseY <= nodeScreenY + nodeScreenSize;
            boolean bl = isDragged = this.debugMode && this.draggedNode == node;
            if (isHovered && this.lastHoveredNode != node) {
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.RESEARCH_TABLET_NODE_HOVER.get(), 0.3f, 1.0f);
                }
                this.lastHoveredNode = node;
            } else if (!isHovered && this.lastHoveredNode == node) {
                this.lastHoveredNode = null;
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)RESEARCH_NODE_TEXTURE);
            int color = isUnlocked ? 4305536 : (prerequisitesUnlocked ? 0xFFFFFF : 0x808080);
            RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
            guiGraphics.m_280163_(RESEARCH_NODE_TEXTURE, nodeX, nodeY, 0.0f, 0.0f, 32, 32, 32, 32);
            if (node.hasIconItem()) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.m_280480_(node.getIconItem(), nodeX + 8, nodeY + 8);
            } else if (node.hasIconTexture()) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)node.getIconTexture());
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.m_280163_(node.getIconTexture(), nodeX + 8, nodeY + 8, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            if (isHovered && !this.debugMode) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                guiGraphics.m_280509_(nodeX, nodeY, nodeX + 32, nodeY + 32, -1);
            }
            if (isDragged) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)0.0f, (float)0.7f);
                guiGraphics.m_280509_(nodeX - 2, nodeY - 2, nodeX + 34, nodeY + 34, -256);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderResearchNodeTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        List<ResearchNode> nodes = ResearchNodeRegistry.getNodesByCategory(this.selectedCategory);
        ResearchData researchData = ClientPacketHandlers.getClientResearchData();
        int draggableX = this.getDraggableAreaX();
        int draggableY = this.getDraggableAreaY();
        for (ResearchNode node : nodes) {
            boolean isHovered;
            int nodeResearchX = this.positionManager.getEffectiveX(node);
            int nodeResearchY = this.positionManager.getEffectiveY(node);
            double nodeScreenX = this.researchToScreenX(nodeResearchX);
            double nodeScreenY = this.researchToScreenY(nodeResearchY);
            double nodeScreenSize = 32.0 * (double)this.zoom;
            if (!(nodeScreenX + nodeScreenSize >= (double)draggableX) || !(nodeScreenX <= (double)(draggableX + 246)) || !(nodeScreenY + nodeScreenSize >= (double)draggableY) || !(nodeScreenY <= (double)(draggableY + 161)) || !(isHovered = (double)mouseX >= nodeScreenX && (double)mouseX <= nodeScreenX + nodeScreenSize && (double)mouseY >= nodeScreenY && (double)mouseY <= nodeScreenY + nodeScreenSize)) continue;
            this.renderTooltip(guiGraphics, node, researchData, mouseX, mouseY);
        }
    }

    private void renderTooltip(GuiGraphics guiGraphics, ResearchNode node, ResearchData researchData, int mouseX, int mouseY) {
        int n;
        ArrayList<TooltipLine> tooltipLines = new ArrayList<TooltipLine>();
        boolean isUnlocked = researchData.getUnlockedResearch().contains(node.getId());
        boolean prerequisitesUnlocked = this.hasPrerequisitesUnlocked(node, researchData);
        if (prerequisitesUnlocked || isUnlocked) {
            tooltipLines.add(new TooltipLine(node.getDisplayName(), null));
        } else {
            String displayName = node.getDisplayName().getString();
            String string = this.generateObfuscatedText(displayName);
            tooltipLines.add(new TooltipLine((Component)Component.m_237113_((String)string), null));
        }
        if (isUnlocked) {
            tooltipLines.add(new TooltipLine((Component)Component.m_237115_((String)"gui.strangematter.research_tablet.unlocked").m_130938_(style -> style.m_178520_(65280)), null));
        } else {
            tooltipLines.add(new TooltipLine((Component)Component.m_237115_((String)"gui.strangematter.research_tablet.locked").m_130938_(style -> style.m_178520_(0xFF0000)), null));
            if (prerequisitesUnlocked && !node.getResearchCosts().isEmpty()) {
                for (Map.Entry entry : node.getResearchCosts().entrySet()) {
                    int requiredPoints;
                    int playerPoints = researchData.getResearchPoints((ResearchType)((Object)entry.getKey()));
                    boolean canAfford = playerPoints >= (requiredPoints = ((Integer)entry.getValue()).intValue());
                    String color = canAfford ? "\u00a7a" : "\u00a7c";
                    MutableComponent costLine = Component.m_237113_((String)(color + "\u2022 " + requiredPoints));
                    tooltipLines.add(new TooltipLine((Component)costLine, (ResearchType)((Object)entry.getKey())));
                }
            }
        }
        String descriptionText = node.getDisplayDescription().getString();
        if (!descriptionText.isEmpty()) {
            if (prerequisitesUnlocked || isUnlocked) {
                List<Component> list = this.wrapText((Component)Component.m_237113_((String)("\u00a77" + descriptionText)), 200);
                for (Component descLine : list) {
                    tooltipLines.add(new TooltipLine(descLine, null));
                }
            } else {
                List<Component> list = this.generateWrappedObfuscatedText(descriptionText, 200);
                for (Component descLine : list) {
                    tooltipLines.add(new TooltipLine(descLine, null));
                }
            }
        }
        boolean bl = false;
        for (TooltipLine line : tooltipLines) {
            n = Math.max(n, this.f_96547_.m_92852_((FormattedText)line.text));
        }
        void tooltipWidth = n + 8;
        int tooltipHeight = tooltipLines.size() * 12 + 8;
        int tooltipX = mouseX + 12;
        int tooltipY = mouseY - 12;
        if (tooltipX + tooltipWidth > this.f_96543_) {
            tooltipX = mouseX - tooltipWidth - 12;
        }
        if (tooltipY + tooltipHeight > this.f_96544_) {
            tooltipY = mouseY - tooltipHeight - 12;
        }
        guiGraphics.m_280509_(tooltipX, tooltipY, tooltipX + tooltipWidth, tooltipY + tooltipHeight, -1072693232);
        guiGraphics.m_280637_(tooltipX, tooltipY, (int)tooltipWidth, tooltipHeight, -14346185);
        int textY = tooltipY + 4;
        for (TooltipLine line : tooltipLines) {
            if (line.researchType != null) {
                ResourceLocation iconTexture = line.researchType.getIconResourceLocation();
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)iconTexture);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.m_280163_(iconTexture, tooltipX + 4, textY, 0.0f, 0.0f, 8, 8, 8, 8);
                guiGraphics.m_280430_(this.f_96547_, line.text, tooltipX + 16, textY, 0xFFFFFF);
            } else {
                guiGraphics.m_280430_(this.f_96547_, line.text, tooltipX + 4, textY, 0xFFFFFF);
            }
            textY += 12;
        }
    }

    private List<Component> wrapText(Component text, int maxWidth) {
        ArrayList<Component> wrappedLines = new ArrayList<Component>();
        String textString = text.getString();
        String formattingCode = "";
        if (textString.startsWith("\u00a7")) {
            int codeEnd = 2;
            if (textString.length() > codeEnd) {
                formattingCode = textString.substring(0, codeEnd);
                textString = textString.substring(codeEnd);
            }
        }
        String[] words = textString.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            MutableComponent wrappedLine;
            String testLine;
            String string = testLine = currentLine.length() > 0 ? currentLine + " " + word : word;
            if (this.f_96547_.m_92895_(testLine) <= maxWidth) {
                currentLine = new StringBuilder(testLine);
                continue;
            }
            if (currentLine.length() > 0) {
                wrappedLine = Component.m_237113_((String)(formattingCode + currentLine.toString()));
                wrappedLines.add((Component)wrappedLine);
                currentLine = new StringBuilder(word);
                continue;
            }
            wrappedLine = Component.m_237113_((String)(formattingCode + word));
            wrappedLines.add((Component)wrappedLine);
        }
        if (currentLine.length() > 0) {
            MutableComponent wrappedLine = Component.m_237113_((String)(formattingCode + currentLine.toString()));
            wrappedLines.add((Component)wrappedLine);
        }
        return wrappedLines;
    }

    private void renderResearchPointsBackground(GuiGraphics guiGraphics) {
        int startX = this.guiX + 320 - 110;
        int startY = this.guiY + 25;
        int width = 95;
        int height = 10 + ResearchType.values().length * 9 + 5;
        guiGraphics.m_280509_(startX - 5, startY - 5, startX + width, startY + height, Integer.MIN_VALUE);
    }

    private void renderResearchPoints(GuiGraphics guiGraphics) {
        ResearchData researchData = ClientPacketHandlers.getClientResearchData();
        int startX = this.guiX + 320 - 110;
        int startY = this.guiY + 25;
        guiGraphics.m_280488_(this.f_96547_, "Research:", startX, startY, 0xFFFFFF);
        int yOffset = 10;
        for (ResearchType type : ResearchType.values()) {
            int points = researchData.getResearchPoints(type);
            ResourceLocation icon = type.getIconResourceLocation();
            guiGraphics.m_280163_(icon, startX, startY + yOffset, 0.0f, 0.0f, 8, 8, 8, 8);
            MutableComponent text = Component.m_237113_((String)(type.getName() + ": " + points));
            guiGraphics.m_280430_(this.f_96547_, (Component)text, startX + 10, startY + yOffset + 1, 0xFFFFFF);
            yOffset += 9;
        }
    }

    private Map<ResearchType, Integer> getPlayerResearchPoints(ResearchData researchData) {
        HashMap<ResearchType, Integer> points = new HashMap<ResearchType, Integer>();
        for (ResearchType type : ResearchType.values()) {
            points.put(type, researchData.getResearchPoints(type));
        }
        return points;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isMouseInDraggableArea(mouseX, mouseY)) {
            ResearchNode clickedNode = this.getClickedNode(mouseX, mouseY);
            if (clickedNode != null) {
                if (this.debugMode) {
                    this.draggedNode = clickedNode;
                    return true;
                }
                ResearchData researchData = ClientPacketHandlers.getClientResearchData();
                boolean isUnlocked = researchData.getUnlockedResearch().contains(clickedNode.getId());
                if (isUnlocked) {
                    this.openNodeInformationPage(clickedNode);
                    this.f_96541_.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.RESEARCH_TABLET_NODE_CLICK.get(), 0.7f, 1.0f);
                    return true;
                }
                boolean canAfford = true;
                for (Map.Entry<ResearchType, Integer> entry : clickedNode.getResearchCosts().entrySet()) {
                    ResearchType type = entry.getKey();
                    int cost = entry.getValue();
                    int currentPoints = researchData.getResearchPoints(type);
                    if (currentPoints >= cost) continue;
                    canAfford = false;
                    break;
                }
                if (canAfford) {
                    this.spendResearchPointsAndGiveNote(clickedNode);
                    this.f_96541_.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.RESEARCH_NOTE_CREATE.get(), 0.8f, 1.0f);
                    return true;
                }
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237115_((String)"research.strangematter.cannot_afford"));
                this.f_96541_.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.RESEARCH_NODE_LOCKED_CLICK.get(), 0.6f, 1.0f);
                return true;
            }
            this.isDragging = true;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0) {
            if (this.debugMode && this.draggedNode != null) {
                int researchX = (int)Math.round(this.screenToResearchX(mouseX));
                int researchY = (int)Math.round(this.screenToResearchY(mouseY));
                this.positionManager.setPosition(this.draggedNode.getId(), researchX, researchY);
                return true;
            }
            if (this.isDragging) {
                double dx = mouseX - this.lastMouseX;
                double dy = mouseY - this.lastMouseY;
                this.dragOffsetX += dx / (double)this.zoom;
                this.dragOffsetY += dy / (double)this.zoom;
                this.lastMouseX = mouseX;
                this.lastMouseY = mouseY;
                return true;
            }
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.debugMode && this.draggedNode != null) {
                this.positionManager.savePositions();
                this.draggedNode = null;
                this.isDragging = false;
                return true;
            }
            this.isDragging = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_86600_() {
        super.m_86600_();
        ++this.refreshCounter;
        if (this.refreshCounter % 20 == 0) {
            // empty if block
        }
    }

    private void spendResearchPointsAndGiveNote(ResearchNode node) {
        SpendResearchPointsPacket packet = new SpendResearchPointsPacket(node.getResearchCosts(), node.getId());
        NetworkHandler.INSTANCE.sendToServer((Object)packet);
    }

    private static class ConnectionLine {
        final int x1;
        final int y1;
        final int x2;
        final int y2;
        final int color;
        final int priority;
        final String nodeId1;
        final String nodeId2;

        ConnectionLine(int x1, int y1, int x2, int y2, int color, String nodeId1, String nodeId2, int priority) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.color = color;
            this.nodeId1 = nodeId1;
            this.nodeId2 = nodeId2;
            this.priority = priority;
        }
    }

    private static class TooltipLine {
        final Component text;
        final ResearchType researchType;

        TooltipLine(Component text, ResearchType researchType) {
            this.text = text;
            this.researchType = researchType;
        }
    }
}

