/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client.screen;

import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.client.screen.ResearchTabletScreen;
import com.hexvane.strangematter.recipe.RealityForgeRecipe;
import com.hexvane.strangematter.recipe.RealityForgeRecipeRegistry;
import com.hexvane.strangematter.research.ResearchNode;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public class ResearchNodeInfoScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("strangematter:textures/ui/research_tablet_background.png");
    private final ResearchNode node;
    private final Screen parentScreen;
    private int currentPage = 0;
    private List<InfoPage> pages;
    private int guiX;
    private int guiY;
    private static final int GUI_WIDTH = 320;
    private static final int GUI_HEIGHT = 240;
    private Button prevButton;
    private Button nextButton;
    private Button closeButton;
    private List<TooltipSlot> tooltipSlots = new ArrayList<TooltipSlot>();

    public ResearchNodeInfoScreen(ResearchNode node, Screen parentScreen) {
        super(node.getDisplayName());
        this.node = node;
        this.parentScreen = parentScreen;
        this.pages = new ArrayList<InfoPage>();
        this.initializePages();
    }

    public ResearchNodeInfoScreen(ResearchNode node, Screen parentScreen, int startingPage) {
        super(node.getDisplayName());
        this.node = node;
        this.parentScreen = parentScreen;
        this.currentPage = startingPage;
        this.pages = new ArrayList<InfoPage>();
        this.initializePages();
    }

    private void initializePages() {
        if (this.node.getId().equals("research")) {
            this.initializeResearchPages();
        } else if (this.node.getId().equals("foundation")) {
            this.initializeFoundationPages();
        } else if (this.node.getId().equals("anomaly_resonator")) {
            this.initializeResonatorPages();
        } else if (this.node.getId().equals("field_scanner")) {
            this.initializeFieldScannerPages();
        } else if (this.node.getId().equals("anomaly_shards")) {
            this.initializeAnomalyShardsPages();
        } else if (this.node.getId().equals("anomaly_types")) {
            this.initializeAnomalyTypesPages();
        } else if (this.node.getId().equals("resonite")) {
            this.initializeResonitePages();
        } else if (this.node.getId().equals("resonant_energy")) {
            this.initializeResonantEnergyPages();
        } else if (this.node.getId().equals("reality_forge")) {
            this.initializeRealityForgePages();
        } else if (this.node.getId().equals("resonance_condenser")) {
            this.initializeResonanceCondenserPages();
        } else if (this.node.getId().equals("containment_basics")) {
            this.initializeContainmentBasicsPages();
        } else if (this.node.getId().equals("echoform_imprinter")) {
            this.initializeEchoformImprinterPages();
        } else if (this.node.getId().equals("warp_gun")) {
            this.initializeWarpGunPages();
        } else if (this.node.getId().equals("chrono_blister")) {
            this.initializeChronoBlisterPages();
        } else if (this.node.getId().equals("stasis_projector")) {
            this.initializeStasisProjectorPages();
        } else if (this.node.getId().equals("rift_stabilizer")) {
            this.initializeRiftStabilizerPages();
        } else if (this.node.getId().equals("levitation_pad")) {
            this.initializeLevitationPadPages();
        } else if (this.node.getId().equals("hoverboard")) {
            this.initializeHoverboardPages();
        } else if (this.node.getId().equals("graviton_hammer")) {
            this.initializeGravitonHammerPages();
        } else if (this.node.getId().equals("gravity_anomalies")) {
            this.initializeGravityAnomaliesPages();
        } else if (this.node.getId().equals("temporal_anomalies")) {
            this.initializeTemporalAnomaliesPages();
        } else if (this.node.getId().equals("spatial_anomalies")) {
            this.initializeSpatialAnomaliesPages();
        } else if (this.node.getId().equals("energy_anomalies")) {
            this.initializeEnergyAnomaliesPages();
        } else if (this.node.getId().equals("shadow_anomalies")) {
            this.initializeShadowAnomaliesPages();
        } else if (this.node.getId().equals("cognitive_anomalies")) {
            this.initializeCognitiveAnomaliesPages();
        } else if (this.node.getId().equals("tinfoil_hat")) {
            this.initializeTinfoilHatPages();
        } else if (!this.hasCustomPagesFromKubeJS()) {
            this.initializeDefaultPages();
        }
        this.loadCustomPages();
    }

    private boolean hasCustomPagesFromKubeJS() {
        try {
            Class<?> customRegistry = Class.forName("com.hexvane.strangematter.kubejs.CustomResearchRegistry");
            Boolean hasPages = (Boolean)customRegistry.getMethod("hasCustomPages", String.class).invoke(null, this.node.getId());
            return hasPages != null && hasPages != false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void loadCustomPages() {
        try {
            Class<?> customRegistry = Class.forName("com.hexvane.strangematter.kubejs.CustomResearchRegistry");
            Class<?> researchInfoPage = Class.forName("com.hexvane.strangematter.kubejs.ResearchInfoPage");
            LOGGER.info("[Strange Matter] Checking for custom pages for node: {}", (Object)this.node.getId());
            Boolean hasPages = (Boolean)customRegistry.getMethod("hasCustomPages", String.class).invoke(null, this.node.getId());
            LOGGER.info("[Strange Matter] Has custom pages: {}", (Object)hasPages);
            if (hasPages != null && hasPages.booleanValue()) {
                List customPages = (List)customRegistry.getMethod("getInfoPages", String.class).invoke(null, this.node.getId());
                LOGGER.info("[Strange Matter] Retrieved {} custom pages", (Object)(customPages != null ? customPages.size() : 0));
                if (customPages != null && !customPages.isEmpty()) {
                    for (Object customPage : customPages) {
                        InfoPage page = new InfoPage();
                        page.title = (String)researchInfoPage.getField("title").get(customPage);
                        page.content = (String)researchInfoPage.getField("content").get(customPage);
                        page.hasRecipes = (Boolean)researchInfoPage.getField("hasRecipes").get(customPage);
                        page.hasScreenshots = (Boolean)researchInfoPage.getField("hasScreenshots").get(customPage);
                        page.recipeName = (String)researchInfoPage.getField("recipeName").get(customPage);
                        page.isRealityForgeRecipe = (Boolean)researchInfoPage.getField("isRealityForgeRecipe").get(customPage);
                        page.screenshotPath = (String)researchInfoPage.getField("screenshotPath").get(customPage);
                        LOGGER.info("[Strange Matter] Adding custom page: {}", (Object)page.title);
                        this.pages.add(page);
                    }
                    LOGGER.info("[Strange Matter] Appended {} custom pages to research node: {}", (Object)customPages.size(), (Object)this.node.getId());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[Strange Matter] Error loading custom pages for {}: {}", new Object[]{this.node.getId(), e.getMessage(), e});
        }
    }

    private void initializeResearchPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.research.intro.title";
        intro.content = "research.strangematter.research.intro.content";
        intro.hasRecipes = false;
        intro.hasScreenshots = false;
        this.pages.add(intro);
        InfoPage fieldScanner = new InfoPage();
        fieldScanner.title = "research.strangematter.research.field_scanner.title";
        fieldScanner.content = "research.strangematter.research.field_scanner.content";
        fieldScanner.hasRecipes = true;
        fieldScanner.hasScreenshots = false;
        fieldScanner.recipeName = "strangematter:field_scanner";
        this.pages.add(fieldScanner);
        InfoPage researchTablet = new InfoPage();
        researchTablet.title = "research.strangematter.research.research_tablet.title";
        researchTablet.content = "research.strangematter.research.research_tablet.content";
        researchTablet.hasRecipes = true;
        researchTablet.hasScreenshots = false;
        researchTablet.recipeName = "strangematter:research_tablet";
        this.pages.add(researchTablet);
        InfoPage machineUsage = new InfoPage();
        machineUsage.title = "research.strangematter.research.machine_usage.title";
        machineUsage.content = "research.strangematter.research.machine_usage.content";
        machineUsage.hasRecipes = true;
        machineUsage.hasScreenshots = false;
        machineUsage.recipeName = "strangematter:research_machine";
        this.pages.add(machineUsage);
        InfoPage minigames = new InfoPage();
        minigames.title = "research.strangematter.research.minigames.title";
        minigames.content = "research.strangematter.research.minigames.content";
        minigames.hasRecipes = false;
        minigames.hasScreenshots = true;
        minigames.screenshotPath = "strangematter:textures/ui/research_minigames_overview.png";
        this.pages.add(minigames);
        InfoPage instability = new InfoPage();
        instability.title = "research.strangematter.research.instability.title";
        instability.content = "research.strangematter.research.instability.content";
        instability.hasRecipes = false;
        instability.hasScreenshots = true;
        instability.screenshotPath = "strangematter:textures/ui/instability_gauge_example.png";
        this.pages.add(instability);
    }

    private void initializeFoundationPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.foundation.intro.title";
        intro.content = "research.strangematter.foundation.intro.content";
        intro.hasRecipes = false;
        intro.hasScreenshots = false;
        this.pages.add(intro);
        InfoPage researchTypes = new InfoPage();
        researchTypes.title = "research.strangematter.foundation.types.title";
        researchTypes.content = "research.strangematter.foundation.types.content";
        researchTypes.hasRecipes = false;
        researchTypes.hasScreenshots = false;
        this.pages.add(researchTypes);
        InfoPage scannerRecipe = new InfoPage();
        scannerRecipe.title = "research.strangematter.foundation.scanner.title";
        scannerRecipe.content = "research.strangematter.foundation.scanner.content";
        scannerRecipe.hasRecipes = true;
        scannerRecipe.hasScreenshots = false;
        scannerRecipe.recipeName = "strangematter:field_scanner";
        this.pages.add(scannerRecipe);
        InfoPage scannerUsage = new InfoPage();
        scannerUsage.title = "research.strangematter.foundation.scanner_usage.title";
        scannerUsage.content = "research.strangematter.foundation.scanner_usage.content";
        scannerUsage.hasRecipes = false;
        scannerUsage.hasScreenshots = false;
        scannerUsage.screenshotPath = "strangematter:textures/ui/foundation_scanner_usage.png";
        this.pages.add(scannerUsage);
    }

    private void initializeResonatorPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.anomaly_resonator.intro.title";
        intro.content = "research.strangematter.anomaly_resonator.intro.content";
        intro.hasRecipes = true;
        intro.hasScreenshots = false;
        intro.recipeName = "strangematter:anomaly_resonator";
        this.pages.add(intro);
        InfoPage mechanics = new InfoPage();
        mechanics.title = "research.strangematter.anomaly_resonator.mechanics.title";
        mechanics.content = "research.strangematter.anomaly_resonator.mechanics.content";
        mechanics.hasRecipes = false;
        mechanics.hasScreenshots = false;
        this.pages.add(mechanics);
    }

    private void initializeFieldScannerPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.field_scanner.intro.title";
        intro.content = "research.strangematter.field_scanner.intro.content";
        intro.hasRecipes = true;
        intro.hasScreenshots = false;
        intro.recipeName = "strangematter:field_scanner";
        this.pages.add(intro);
    }

    private void initializeAnomalyShardsPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.anomaly_shards.intro.title";
        intro.content = "research.strangematter.anomaly_shards.intro.content";
        intro.hasRecipes = false;
        intro.hasScreenshots = true;
        intro.screenshotPath = "strangematter:textures/ui/anomaly_shard_ore.png";
        this.pages.add(intro);
        InfoPage formation = new InfoPage();
        formation.title = "research.strangematter.anomaly_shards.formation.title";
        formation.content = "research.strangematter.anomaly_shards.formation.content";
        formation.hasRecipes = false;
        formation.hasScreenshots = false;
        formation.recipeName = null;
        formation.screenshotPath = null;
        this.pages.add(formation);
        InfoPage categories = new InfoPage();
        categories.title = "research.strangematter.anomaly_shards.categories.title";
        categories.content = "research.strangematter.anomaly_shards.categories.content";
        categories.hasRecipes = false;
        categories.hasScreenshots = false;
        categories.recipeName = null;
        categories.screenshotPath = null;
        this.pages.add(categories);
        InfoPage collection = new InfoPage();
        collection.title = "research.strangematter.anomaly_shards.collection.title";
        collection.content = "research.strangematter.anomaly_shards.collection.content";
        collection.hasRecipes = false;
        collection.hasScreenshots = false;
        collection.recipeName = null;
        collection.screenshotPath = null;
        this.pages.add(collection);
    }

    private void initializeAnomalyTypesPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.anomaly_types.intro.title";
        intro.content = "research.strangematter.anomaly_types.intro.content";
        intro.hasRecipes = false;
        intro.hasScreenshots = false;
        this.pages.add(intro);
        InfoPage fundamentalTypes = new InfoPage();
        fundamentalTypes.title = "research.strangematter.anomaly_types.fundamental.title";
        fundamentalTypes.content = "research.strangematter.anomaly_types.fundamental.content";
        fundamentalTypes.hasRecipes = false;
        fundamentalTypes.hasScreenshots = false;
        this.pages.add(fundamentalTypes);
        InfoPage interactions = new InfoPage();
        interactions.title = "research.strangematter.anomaly_types.interactions.title";
        interactions.content = "research.strangematter.anomaly_types.interactions.content";
        interactions.hasRecipes = false;
        interactions.hasScreenshots = false;
        this.pages.add(interactions);
        InfoPage applications = new InfoPage();
        applications.title = "research.strangematter.anomaly_types.applications.title";
        applications.content = "research.strangematter.anomaly_types.applications.content";
        applications.hasRecipes = false;
        applications.hasScreenshots = false;
        this.pages.add(applications);
    }

    private void initializeResonitePages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.resonite.intro.title";
        intro.content = "research.strangematter.resonite.intro.content";
        intro.hasRecipes = false;
        intro.hasScreenshots = true;
        intro.screenshotPath = "strangematter:textures/ui/resonite_ore.png";
        this.pages.add(intro);
        InfoPage coil = new InfoPage();
        coil.title = "research.strangematter.resonite.coil.title";
        coil.content = "research.strangematter.resonite.coil.content";
        coil.hasRecipes = true;
        coil.hasScreenshots = false;
        coil.recipeName = "strangematter:resonant_coil";
        this.pages.add(coil);
        InfoPage circuit = new InfoPage();
        circuit.title = "research.strangematter.resonite.circuit.title";
        circuit.content = "research.strangematter.resonite.circuit.content";
        circuit.hasRecipes = true;
        circuit.hasScreenshots = false;
        circuit.recipeName = "strangematter:resonant_circuit";
        this.pages.add(circuit);
    }

    private void initializeResonantEnergyPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.resonant_energy.intro.title";
        intro.content = "research.strangematter.resonant_energy.intro.content";
        intro.hasRecipes = false;
        intro.hasScreenshots = false;
        intro.recipeName = null;
        intro.screenshotPath = null;
        this.pages.add(intro);
        InfoPage burner = new InfoPage();
        burner.title = "research.strangematter.resonant_energy.burner.title";
        burner.content = "research.strangematter.resonant_energy.burner.content";
        burner.hasRecipes = true;
        burner.hasScreenshots = false;
        burner.recipeName = "strangematter:resonant_burner";
        this.pages.add(burner);
    }

    private void initializeRealityForgePages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.reality_forge.intro.title";
        intro.content = "research.strangematter.reality_forge.intro.content";
        intro.hasRecipes = true;
        intro.hasScreenshots = false;
        intro.recipeName = "strangematter:reality_forge";
        this.pages.add(intro);
        InfoPage usage = new InfoPage();
        usage.title = "research.strangematter.reality_forge.usage.title";
        usage.content = "research.strangematter.reality_forge.usage.content";
        usage.hasRecipes = false;
        usage.hasScreenshots = true;
        usage.screenshotPath = "strangematter:textures/ui/reality_forge.png";
        this.pages.add(usage);
    }

    private void initializeResonanceCondenserPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.resonance_condenser.intro.title";
        intro.content = "research.strangematter.resonance_condenser.intro.content";
        intro.hasRecipes = true;
        intro.hasScreenshots = false;
        intro.recipeName = "strangematter:resonance_condenser";
        intro.isRealityForgeRecipe = true;
        this.pages.add(intro);
        InfoPage mechanics = new InfoPage();
        mechanics.title = "research.strangematter.resonance_condenser.mechanics.title";
        mechanics.content = "research.strangematter.resonance_condenser.mechanics.content";
        mechanics.hasRecipes = false;
        mechanics.hasScreenshots = true;
        mechanics.screenshotPath = "strangematter:textures/ui/resonance_condenser.png";
        this.pages.add(mechanics);
    }

    private void initializeContainmentBasicsPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.containment_basics.intro.title";
        intro.content = "research.strangematter.containment_basics.intro.content";
        intro.hasRecipes = true;
        intro.hasScreenshots = false;
        intro.recipeName = "strangematter:echo_vacuum";
        intro.isRealityForgeRecipe = true;
        this.pages.add(intro);
        InfoPage capsule = new InfoPage();
        capsule.title = "research.strangematter.containment_basics.capsule.title";
        capsule.content = "research.strangematter.containment_basics.capsule.content";
        capsule.hasRecipes = true;
        capsule.hasScreenshots = false;
        capsule.recipeName = "strangematter:containment_capsule";
        capsule.isRealityForgeRecipe = true;
        this.pages.add(capsule);
    }

    private void initializeEchoformImprinterPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.echoform_imprinter.intro.title";
        intro.content = "research.strangematter.echoform_imprinter.intro.content";
        intro.hasRecipes = true;
        intro.hasScreenshots = false;
        intro.recipeName = "strangematter:echoform_imprinter";
        intro.isRealityForgeRecipe = true;
        this.pages.add(intro);
        InfoPage usage = new InfoPage();
        usage.title = "research.strangematter.echoform_imprinter.usage.title";
        usage.content = "research.strangematter.echoform_imprinter.usage.content";
        usage.hasRecipes = false;
        usage.hasScreenshots = false;
        usage.recipeName = null;
        usage.screenshotPath = null;
        this.pages.add(usage);
        InfoPage theory = new InfoPage();
        theory.title = "research.strangematter.echoform_imprinter.theory.title";
        theory.content = "research.strangematter.echoform_imprinter.theory.content";
        theory.hasRecipes = false;
        theory.hasScreenshots = false;
        theory.recipeName = null;
        theory.screenshotPath = null;
        this.pages.add(theory);
    }

    private void initializeWarpGunPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.warp_gun.intro.title";
        intro.content = "research.strangematter.warp_gun.intro.content";
        intro.hasRecipes = true;
        intro.hasScreenshots = false;
        intro.recipeName = "strangematter:warp_gun";
        intro.isRealityForgeRecipe = true;
        this.pages.add(intro);
        InfoPage mechanics = new InfoPage();
        mechanics.title = "research.strangematter.warp_gun.mechanics.title";
        mechanics.content = "research.strangematter.warp_gun.mechanics.content";
        mechanics.hasRecipes = false;
        mechanics.hasScreenshots = false;
        this.pages.add(mechanics);
    }

    private void initializeGravitonHammerPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.graviton_hammer.intro.title";
        intro.content = "research.strangematter.graviton_hammer.intro.content";
        intro.hasRecipes = true;
        intro.hasScreenshots = false;
        intro.recipeName = "strangematter:graviton_hammer";
        intro.isRealityForgeRecipe = true;
        this.pages.add(intro);
        InfoPage mechanics = new InfoPage();
        mechanics.title = "research.strangematter.graviton_hammer.mechanics.title";
        mechanics.content = "research.strangematter.graviton_hammer.mechanics.content";
        mechanics.hasRecipes = false;
        mechanics.hasScreenshots = false;
        mechanics.recipeName = null;
        mechanics.screenshotPath = null;
        this.pages.add(mechanics);
    }

    private void initializeChronoBlisterPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.chrono_blister.intro.title";
        intro.content = "research.strangematter.chrono_blister.intro.content";
        intro.hasRecipes = true;
        intro.hasScreenshots = false;
        intro.recipeName = "strangematter:chrono_blister";
        intro.isRealityForgeRecipe = true;
        this.pages.add(intro);
        InfoPage mechanics = new InfoPage();
        mechanics.title = "research.strangematter.chrono_blister.mechanics.title";
        mechanics.content = "research.strangematter.chrono_blister.mechanics.content";
        mechanics.hasRecipes = false;
        mechanics.hasScreenshots = false;
        this.pages.add(mechanics);
    }

    private void initializeStasisProjectorPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.stasis_projector.intro.title";
        intro.content = "research.strangematter.stasis_projector.intro.content";
        intro.hasRecipes = true;
        intro.hasScreenshots = false;
        intro.recipeName = "strangematter:stasis_projector";
        intro.isRealityForgeRecipe = true;
        this.pages.add(intro);
        InfoPage mechanics = new InfoPage();
        mechanics.title = "research.strangematter.stasis_projector.mechanics.title";
        mechanics.content = "research.strangematter.stasis_projector.mechanics.content";
        mechanics.hasRecipes = false;
        mechanics.hasScreenshots = false;
        mechanics.recipeName = null;
        mechanics.screenshotPath = null;
        this.pages.add(mechanics);
        InfoPage applications = new InfoPage();
        applications.title = "research.strangematter.stasis_projector.applications.title";
        applications.content = "research.strangematter.stasis_projector.applications.content";
        applications.hasRecipes = false;
        applications.hasScreenshots = false;
        applications.recipeName = null;
        applications.screenshotPath = null;
        this.pages.add(applications);
    }

    private void initializeRiftStabilizerPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.rift_stabilizer.intro.title";
        intro.content = "research.strangematter.rift_stabilizer.intro.content";
        intro.hasRecipes = true;
        intro.hasScreenshots = false;
        intro.recipeName = "strangematter:rift_stabilizer";
        intro.isRealityForgeRecipe = true;
        this.pages.add(intro);
        InfoPage mechanics = new InfoPage();
        mechanics.title = "research.strangematter.rift_stabilizer.mechanics.title";
        mechanics.content = "research.strangematter.rift_stabilizer.mechanics.content";
        mechanics.hasRecipes = false;
        mechanics.hasScreenshots = false;
        mechanics.recipeName = null;
        mechanics.screenshotPath = null;
        this.pages.add(mechanics);
        InfoPage usage = new InfoPage();
        usage.title = "research.strangematter.rift_stabilizer.usage.title";
        usage.content = "research.strangematter.rift_stabilizer.usage.content";
        usage.hasRecipes = false;
        usage.hasScreenshots = false;
        usage.recipeName = null;
        usage.screenshotPath = null;
        this.pages.add(usage);
    }

    private void initializeGravityAnomaliesPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.gravity_anomalies.title";
        intro.content = "research.strangematter.gravity_anomalies.content";
        intro.hasRecipes = false;
        intro.hasScreenshots = true;
        intro.screenshotPath = "strangematter:textures/ui/gravity_anomaly.png";
        this.pages.add(intro);
    }

    private void initializeTemporalAnomaliesPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.temporal_anomalies.title";
        intro.content = "research.strangematter.temporal_anomalies.content";
        intro.hasRecipes = false;
        intro.hasScreenshots = true;
        intro.screenshotPath = "strangematter:textures/ui/temporal_bloom.png";
        this.pages.add(intro);
    }

    private void initializeSpatialAnomaliesPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.spatial_anomalies.title";
        intro.content = "research.strangematter.spatial_anomalies.content";
        intro.hasRecipes = false;
        intro.hasScreenshots = true;
        intro.screenshotPath = "strangematter:textures/ui/warp_gate_anomaly.png";
        this.pages.add(intro);
    }

    private void initializeEnergyAnomaliesPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.energy_anomalies.title";
        intro.content = "research.strangematter.energy_anomalies.content";
        intro.hasRecipes = false;
        intro.hasScreenshots = true;
        intro.screenshotPath = "strangematter:textures/ui/energetic_rift.png";
        this.pages.add(intro);
    }

    private void initializeShadowAnomaliesPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.shadow_anomalies.title";
        intro.content = "research.strangematter.shadow_anomalies.content";
        intro.hasRecipes = false;
        intro.hasScreenshots = true;
        intro.screenshotPath = "strangematter:textures/ui/echoing_shadow.png";
        this.pages.add(intro);
    }

    private void initializeCognitiveAnomaliesPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.cognitive_anomalies.title";
        intro.content = "research.strangematter.cognitive_anomalies.content";
        intro.hasRecipes = false;
        intro.hasScreenshots = true;
        intro.screenshotPath = "strangematter:textures/ui/thoughtwell.png";
        this.pages.add(intro);
    }

    private void initializeLevitationPadPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.levitation_pad.intro.title";
        intro.content = "research.strangematter.levitation_pad.intro.content";
        intro.hasRecipes = true;
        intro.hasScreenshots = false;
        intro.recipeName = "strangematter:levitation_pad";
        intro.isRealityForgeRecipe = true;
        this.pages.add(intro);
        InfoPage mechanics = new InfoPage();
        mechanics.title = "research.strangematter.levitation_pad.mechanics.title";
        mechanics.content = "research.strangematter.levitation_pad.mechanics.content";
        mechanics.hasRecipes = false;
        mechanics.hasScreenshots = false;
        this.pages.add(mechanics);
    }

    private void initializeHoverboardPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.hoverboard.intro.title";
        intro.content = "research.strangematter.hoverboard.intro.content";
        intro.hasRecipes = true;
        intro.hasScreenshots = false;
        intro.recipeName = "strangematter:hoverboard";
        intro.isRealityForgeRecipe = true;
        this.pages.add(intro);
    }

    private void initializeTinfoilHatPages() {
        InfoPage intro = new InfoPage();
        intro.title = "research.strangematter.tinfoil_hat.intro.title";
        intro.content = "research.strangematter.tinfoil_hat.intro.content";
        intro.hasRecipes = false;
        intro.hasScreenshots = false;
        this.pages.add(intro);
        InfoPage recipe = new InfoPage();
        recipe.title = "research.strangematter.tinfoil_hat.recipe.title";
        recipe.content = "research.strangematter.tinfoil_hat.recipe.content";
        recipe.hasRecipes = true;
        recipe.hasScreenshots = false;
        recipe.recipeName = "strangematter:tinfoil_hat";
        recipe.isRealityForgeRecipe = false;
        this.pages.add(recipe);
    }

    private void initializeDefaultPages() {
        InfoPage basicInfo = new InfoPage();
        basicInfo.title = "Overview";
        basicInfo.content = this.node.getDisplayDescription().getString();
        basicInfo.hasRecipes = this.hasRecipes();
        basicInfo.hasScreenshots = this.hasScreenshots();
        this.pages.add(basicInfo);
        if (this.hasRecipes()) {
            InfoPage recipes = new InfoPage();
            recipes.title = "Recipes";
            recipes.content = "Crafting recipes and construction details.";
            recipes.hasRecipes = true;
            recipes.hasScreenshots = false;
            this.pages.add(recipes);
        }
        if (this.hasScreenshots()) {
            InfoPage screenshots = new InfoPage();
            screenshots.title = "Examples";
            screenshots.content = "Visual examples and usage demonstrations.";
            screenshots.hasRecipes = false;
            screenshots.hasScreenshots = false;
            this.pages.add(screenshots);
        }
    }

    private boolean hasRecipes() {
        return this.node.getId().equals("foundation") || this.node.getId().equals("basic_scanner");
    }

    private boolean hasScreenshots() {
        return this.node.getId().equals("gravity_control") || this.node.getId().equals("temporal_stability");
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiX = (this.f_96543_ - 320) / 2;
        this.guiY = (this.f_96544_ - 240) / 2;
        this.prevButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.strangematter.info_page.previous"), button -> this.previousPage()).m_252987_(this.guiX - 50, this.guiY + 240 - 30, 40, 20).m_253136_();
        this.nextButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.strangematter.info_page.next"), button -> this.nextPage()).m_252987_(this.guiX + 320 + 10, this.guiY + 240 - 30, 40, 20).m_253136_();
        this.closeButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.strangematter.info_page.close"), button -> this.m_7379_()).m_252987_(this.guiX + 320 - 30, this.guiY + 10, 20, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.prevButton);
        this.m_142416_((GuiEventListener)this.nextButton);
        this.m_142416_((GuiEventListener)this.closeButton);
        this.updateButtonStates();
    }

    private void previousPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.updateButtonStates();
        }
    }

    private void nextPage() {
        if (this.currentPage < this.pages.size() - 1) {
            ++this.currentPage;
            this.updateButtonStates();
        }
    }

    private void updateButtonStates() {
        this.prevButton.f_93623_ = this.currentPage > 0;
        this.nextButton.f_93623_ = this.currentPage < this.pages.size() - 1;
    }

    public void m_7379_() {
        if (this.parentScreen instanceof ResearchTabletScreen) {
            ((ResearchTabletScreen)this.parentScreen).restoreDragPosition();
        }
        this.f_96541_.m_91152_(this.parentScreen);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        this.tooltipSlots.clear();
        guiGraphics.m_280509_(this.guiX, this.guiY, this.guiX + 320, this.guiY + 240, -13882324);
        guiGraphics.m_280637_(this.guiX, this.guiY, 320, 240, -11184811);
        if (this.currentPage < this.pages.size()) {
            InfoPage page = this.pages.get(this.currentPage);
            this.renderPage(guiGraphics, page);
        }
        MutableComponent pageText = Component.m_237115_((String)"gui.strangematter.info_page.page").m_130946_(" ").m_7220_((Component)Component.m_237113_((String)String.valueOf(this.currentPage + 1))).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"gui.strangematter.info_page.of")).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)String.valueOf(this.pages.size())));
        guiGraphics.m_280653_(this.f_96547_, (Component)pageText, this.guiX + 160, this.guiY + 240 - 25, 0xFFFFFF);
        for (TooltipSlot slot : this.tooltipSlots) {
            int absoluteSlotX = slot.x;
            int absoluteSlotY = slot.y;
            if (mouseX < absoluteSlotX || mouseX >= absoluteSlotX + slot.size || mouseY < absoluteSlotY || mouseY >= absoluteSlotY + slot.size) continue;
            guiGraphics.m_280153_(this.f_96547_, slot.stack, mouseX, mouseY);
            break;
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderPage(GuiGraphics guiGraphics, InfoPage page) {
        MutableComponent titleComponent = Component.m_237115_((String)page.title);
        guiGraphics.m_280653_(this.f_96547_, (Component)titleComponent, this.guiX + 160, this.guiY + 20, 0xFFFFFF);
        if (page.hasRecipes || page.hasScreenshots) {
            this.renderTwoColumnLayout(guiGraphics, page);
        } else {
            this.renderSingleColumnLayout(guiGraphics, page);
        }
    }

    private void renderTwoColumnLayout(GuiGraphics guiGraphics, InfoPage page) {
        int contentY = this.guiY + 50;
        int contentHeight = 140;
        int leftColumnX = this.guiX + 20;
        int leftColumnWidth = 130;
        int rightColumnX = this.guiX + 20 + leftColumnWidth + 20;
        int rightColumnWidth = 130;
        guiGraphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)page.content), leftColumnX, contentY, leftColumnWidth, 0xCCCCCC);
        if (page.hasRecipes) {
            this.renderRecipes(guiGraphics, rightColumnX, contentY, rightColumnWidth);
        } else if (page.hasScreenshots) {
            this.renderScreenshots(guiGraphics, rightColumnX, contentY, rightColumnWidth);
        }
    }

    private void renderSingleColumnLayout(GuiGraphics guiGraphics, InfoPage page) {
        int contentX = this.guiX + 20;
        int contentY = this.guiY + 50;
        int contentWidth = 280;
        guiGraphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)page.content), contentX, contentY, contentWidth, 0xCCCCCC);
        if (page.hasScreenshots) {
            int textHeight = this.f_96547_.m_239133_((FormattedText)Component.m_237115_((String)page.content), contentWidth);
            this.renderScreenshots(guiGraphics, contentX, contentY + textHeight + 20, contentWidth);
        }
    }

    private void renderRecipes(GuiGraphics guiGraphics, int x, int y, int width) {
        if (this.currentPage < this.pages.size()) {
            InfoPage page = this.pages.get(this.currentPage);
            if (page.hasRecipes && page.recipeName != null) {
                if (page.isRealityForgeRecipe) {
                    this.renderRealityForgeRecipe(guiGraphics, x, y, page);
                } else {
                    guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.strangematter.info_page.crafting_recipe"), x, y, 0xFFFFFF);
                    int recipeX = x + 20;
                    int recipeY = y += 15;
                    int slotSize = 18;
                    for (int row = 0; row < 3; ++row) {
                        for (int col = 0; col < 3; ++col) {
                            int slotX = recipeX + col * slotSize;
                            int slotY = recipeY + row * slotSize;
                            guiGraphics.m_280509_(slotX, slotY, slotX + slotSize, slotY + slotSize, -12566464);
                            guiGraphics.m_280637_(slotX, slotY, slotSize, slotSize, -8355712);
                        }
                    }
                    if (page.recipeName != null) {
                        this.drawRecipeInGrid(guiGraphics, page.recipeName, recipeX, recipeY, slotSize);
                    }
                    guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.strangematter.info_page.required_materials"), x, y += 70, -22016);
                    y += 15;
                    List<String> uniqueIngredients = this.getUniqueIngredients(page.recipeName);
                    for (String ingredientName : uniqueIngredients) {
                        guiGraphics.m_280488_(this.f_96547_, "\u2022 " + ingredientName, x + 10, y, 0xCCCCCC);
                        y += 12;
                    }
                }
            }
        }
    }

    private void renderRealityForgeRecipe(GuiGraphics guiGraphics, int x, int y, InfoPage page) {
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.strangematter.info_page.reality_forge_recipe"), x, y, 0xFFFFFF);
        y += 15;
        if (page.recipeName == null) {
            return;
        }
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null) {
            guiGraphics.m_280488_(this.f_96547_, "Loading...", x, y, -10066330);
            return;
        }
        Object fullRecipeName = page.recipeName.contains(":") ? page.recipeName : "strangematter:" + page.recipeName;
        ResourceLocation resultItemId = ResourceLocation.parse((String)fullRecipeName);
        RealityForgeRecipe recipe = RealityForgeRecipeRegistry.findRecipeByResult(resultItemId, (Level)this.f_96541_.f_91073_);
        if (recipe == null) {
            guiGraphics.m_280488_(this.f_96547_, "Recipe not found: " + page.recipeName, x, y, -10066330);
            return;
        }
        this.renderCraftingGridWithTooltips(guiGraphics, x, y, recipe);
        int resultX = x + 100;
        int resultY = y + 20;
        this.renderResultSlotWithTooltip(guiGraphics, resultX, resultY, recipe.m_8043_(null));
        this.renderShardRequirementsWithTooltips(guiGraphics, x, y + 80, recipe);
    }

    private void renderCraftingGridWithTooltips(GuiGraphics guiGraphics, int x, int y, RealityForgeRecipe recipe) {
        int slotSize = 18;
        int gridStartX = x;
        int gridStartY = y;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                ItemStack[] matchingStacks;
                Ingredient ingredient;
                int slotX = gridStartX + col * slotSize;
                int slotY = gridStartY + row * slotSize;
                guiGraphics.m_280509_(slotX, slotY, slotX + slotSize, slotY + slotSize, -12566464);
                guiGraphics.m_280637_(slotX, slotY, slotSize, slotSize, -8355712);
                int slotIndex = row * 3 + col;
                if (slotIndex >= recipe.m_7527_().size() || (ingredient = (Ingredient)recipe.m_7527_().get(slotIndex)) == Ingredient.f_43901_ || (matchingStacks = ingredient.m_43908_()).length <= 0) continue;
                if (matchingStacks.length > 1) {
                    long currentTime = System.currentTimeMillis();
                    int cycleIndex = (int)(currentTime / 1000L % (long)matchingStacks.length);
                    ItemStack displayStack = matchingStacks[cycleIndex];
                    guiGraphics.m_280480_(displayStack, slotX + 1, slotY + 1);
                    this.renderItemTooltip(guiGraphics, slotX, slotY, slotSize, displayStack);
                    continue;
                }
                ItemStack displayStack = matchingStacks[0];
                guiGraphics.m_280480_(displayStack, slotX + 1, slotY + 1);
                this.renderItemTooltip(guiGraphics, slotX, slotY, slotSize, displayStack);
            }
        }
    }

    private void renderResultSlotWithTooltip(GuiGraphics guiGraphics, int x, int y, ItemStack result) {
        int slotSize = 18;
        guiGraphics.m_280509_(x, y, x + slotSize, y + slotSize, -12566464);
        guiGraphics.m_280637_(x, y, slotSize, slotSize, -8355712);
        if (!result.m_41619_()) {
            guiGraphics.m_280480_(result, x + 1, y + 1);
            this.renderItemTooltip(guiGraphics, x, y, slotSize, result);
        }
    }

    private void renderShardRequirementsWithTooltips(GuiGraphics guiGraphics, int x, int y, RealityForgeRecipe recipe) {
        Map<String, Integer> shardRequirements = recipe.getShardRequirements();
        if (shardRequirements.isEmpty()) {
            return;
        }
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.strangematter.info_page.required_shards"), x, y, -22016);
        y += 15;
        HashMap<String, Item> shardTypeToItem = new HashMap<String, Item>();
        shardTypeToItem.put("gravitic", (Item)StrangeMatterMod.GRAVITIC_SHARD.get());
        shardTypeToItem.put("gravity", (Item)StrangeMatterMod.GRAVITIC_SHARD.get());
        shardTypeToItem.put("energetic", (Item)StrangeMatterMod.ENERGETIC_SHARD.get());
        shardTypeToItem.put("spatial", (Item)StrangeMatterMod.SPATIAL_SHARD.get());
        shardTypeToItem.put("chrono", (Item)StrangeMatterMod.CHRONO_SHARD.get());
        shardTypeToItem.put("temporal", (Item)StrangeMatterMod.CHRONO_SHARD.get());
        shardTypeToItem.put("shade", (Item)StrangeMatterMod.SHADE_SHARD.get());
        shardTypeToItem.put("shadow", (Item)StrangeMatterMod.SHADE_SHARD.get());
        shardTypeToItem.put("insight", (Item)StrangeMatterMod.INSIGHT_SHARD.get());
        shardTypeToItem.put("cognitive", (Item)StrangeMatterMod.INSIGHT_SHARD.get());
        int shardX = x;
        int shardY = y;
        int shardSpacing = 20;
        int shardSize = 16;
        for (Map.Entry<String, Integer> entry : shardRequirements.entrySet()) {
            String shardType = entry.getKey();
            int count = entry.getValue();
            Item shardItem = (Item)shardTypeToItem.get(shardType);
            if (shardItem == null) continue;
            ItemStack shardStack = new ItemStack((ItemLike)shardItem);
            shardStack.m_41764_(count);
            guiGraphics.m_280480_(shardStack, shardX, shardY);
            String countText = count + "x";
            int textX = shardX + shardSize + 2;
            Objects.requireNonNull(this.f_96547_);
            int textY = shardY + (shardSize - 9) / 2;
            guiGraphics.m_280488_(this.f_96547_, countText, textX, textY, 0xFFFFFF);
            this.renderItemTooltip(guiGraphics, shardX, shardY, shardSize, shardStack);
            shardX += shardSpacing + this.f_96547_.m_92895_(countText);
        }
    }

    private void renderItemTooltip(GuiGraphics guiGraphics, int x, int y, int size, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        this.tooltipSlots.add(new TooltipSlot(x, y, size, stack));
    }

    private void drawRecipeInGrid(GuiGraphics guiGraphics, String recipeName, int gridX, int gridY, int slotSize) {
        Recipe<?> recipe = this.findRecipe(recipeName);
        if (recipe == null) {
            this.drawEmptyRecipeGrid(guiGraphics, gridX, gridY, slotSize);
            return;
        }
        if (recipe instanceof CraftingRecipe) {
            CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
            this.drawCraftingRecipe(guiGraphics, craftingRecipe, gridX, gridY, slotSize);
        } else {
            this.drawEmptyRecipeGrid(guiGraphics, gridX, gridY, slotSize);
        }
    }

    private List<CraftingRecipe> findRecipesForItem(String recipeName) {
        Item item;
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        RecipeManager recipeManager = this.f_96541_.f_91073_.m_7465_();
        Object fullRecipeName = recipeName.contains(":") ? recipeName : "strangematter:" + recipeName;
        ResourceLocation itemId = ResourceLocation.parse((String)fullRecipeName);
        Optional itemRegistry = this.f_96541_.f_91073_.m_9598_().m_6632_(Registries.f_256913_);
        if (itemRegistry.isPresent() && (item = (Item)((Registry)itemRegistry.get()).m_7745_(itemId)) != null) {
            List allCraftingRecipes = recipeManager.m_44013_(RecipeType.f_44107_);
            for (CraftingRecipe candidateRecipe : allCraftingRecipes) {
                CraftingRecipe craftingRecipe;
                ItemStack result;
                if (!(candidateRecipe instanceof CraftingRecipe) || (result = (craftingRecipe = candidateRecipe).m_8043_(this.f_96541_.f_91073_.m_9598_())).m_41619_() || result.m_41720_() != item) continue;
                recipes.add(craftingRecipe);
            }
        }
        return recipes;
    }

    private Recipe<?> findRecipe(String recipeName) {
        List<CraftingRecipe> recipes = this.findRecipesForItem(recipeName);
        if (recipes.isEmpty()) {
            return null;
        }
        if (recipes.size() == 1) {
            return (Recipe)recipes.get(0);
        }
        long currentTime = System.currentTimeMillis();
        int cycleIndex = (int)(currentTime / 3000L % (long)recipes.size());
        return (Recipe)recipes.get(cycleIndex);
    }

    private void drawCraftingRecipe(GuiGraphics guiGraphics, CraftingRecipe recipe, int gridX, int gridY, int slotSize) {
        NonNullList ingredients = recipe.m_7527_();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                ItemStack[] stacks;
                Ingredient ingredient;
                int slotIndex = row * 3 + col;
                int slotX = gridX + col * slotSize;
                int slotY = gridY + row * slotSize;
                guiGraphics.m_280509_(slotX, slotY, slotX + slotSize, slotY + slotSize, -12566464);
                guiGraphics.m_280637_(slotX, slotY, slotSize, slotSize, -8355712);
                if (slotIndex >= ingredients.size() || (ingredient = (Ingredient)ingredients.get(slotIndex)).m_43947_() || (stacks = ingredient.m_43908_()).length <= 0) continue;
                if (stacks.length > 1) {
                    long currentTime = System.currentTimeMillis();
                    int cycleIndex = (int)(currentTime / 1000L % (long)stacks.length);
                    ItemStack displayStack = stacks[cycleIndex];
                    guiGraphics.m_280480_(displayStack, slotX + 1, slotY + 1);
                    this.renderItemTooltip(guiGraphics, slotX, slotY, slotSize, displayStack);
                    continue;
                }
                ItemStack displayStack = stacks[0];
                guiGraphics.m_280480_(displayStack, slotX + 1, slotY + 1);
                this.renderItemTooltip(guiGraphics, slotX, slotY, slotSize, displayStack);
            }
        }
        ItemStack resultStack = recipe.m_8043_(this.f_96541_.f_91073_.m_9598_());
        int resultX = gridX + 3 * slotSize + 10;
        int resultY = gridY + slotSize;
        guiGraphics.m_280509_(resultX, resultY, resultX + slotSize, resultY + slotSize, -12566464);
        guiGraphics.m_280637_(resultX, resultY, slotSize, slotSize, -8355712);
        guiGraphics.m_280480_(resultStack, resultX + 1, resultY + 1);
        this.renderItemTooltip(guiGraphics, resultX, resultY, slotSize, resultStack);
    }

    private void drawEmptyRecipeGrid(GuiGraphics guiGraphics, int gridX, int gridY, int slotSize) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                int slotX = gridX + col * slotSize;
                int slotY = gridY + row * slotSize;
                guiGraphics.m_280509_(slotX, slotY, slotX + slotSize, slotY + slotSize, -12566464);
                guiGraphics.m_280637_(slotX, slotY, slotSize, slotSize, -8355712);
            }
        }
    }

    private List<String> getUniqueIngredients(String recipeName) {
        ArrayList<String> uniqueIngredients = new ArrayList<String>();
        Recipe<?> recipe = this.findRecipe(recipeName);
        if (recipe instanceof CraftingRecipe) {
            CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
            NonNullList ingredients = craftingRecipe.m_7527_();
            for (Ingredient ingredient : ingredients) {
                ItemStack[] stacks;
                if (ingredient.m_43947_() || (stacks = ingredient.m_43908_()).length <= 0) continue;
                if (stacks.length > 1) {
                    boolean isAnomalyShards = false;
                    for (ItemStack stack : stacks) {
                        String itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString();
                        if (!itemId.contains("shard")) continue;
                        isAnomalyShards = true;
                        break;
                    }
                    if (isAnomalyShards) {
                        if (uniqueIngredients.contains("Any Anomaly Shard")) continue;
                        uniqueIngredients.add("Any Anomaly Shard");
                        continue;
                    }
                    ItemStack firstStack = stacks[0];
                    String localizedName = firstStack.m_41786_().getString();
                    if (uniqueIngredients.contains(localizedName + " (or similar)")) continue;
                    uniqueIngredients.add(localizedName + " (or similar)");
                    continue;
                }
                ItemStack stack = stacks[0];
                String localizedName = stack.m_41786_().getString();
                if (uniqueIngredients.contains(localizedName)) continue;
                uniqueIngredients.add(localizedName);
            }
        }
        return uniqueIngredients;
    }

    private void drawTextureInSlot(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        guiGraphics.m_280163_(texture, x + 1, y + 1, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    private String getItemDisplayName(String itemId) {
        return "item." + itemId.replace(":", ".");
    }

    private void renderScreenshots(GuiGraphics guiGraphics, int x, int y, int width) {
        if (this.currentPage < this.pages.size()) {
            InfoPage page = this.pages.get(this.currentPage);
            if (page.hasScreenshots && page.screenshotPath != null) {
                int screenshotWidth = 120;
                int screenshotHeight = 80;
                guiGraphics.m_280509_(x, y, x + screenshotWidth, y + screenshotHeight, -14671840);
                try {
                    ResourceLocation screenshotTexture = ResourceLocation.parse((String)page.screenshotPath);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)screenshotTexture);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    guiGraphics.m_280163_(screenshotTexture, x, y, 0.0f, 0.0f, screenshotWidth, screenshotHeight, screenshotWidth, screenshotHeight);
                }
                catch (Exception e) {
                    guiGraphics.m_280137_(this.f_96547_, "Screenshot", x + screenshotWidth / 2, y + screenshotHeight / 2 - 5, 0x888888);
                    guiGraphics.m_280137_(this.f_96547_, "Not Found", x + screenshotWidth / 2, y + screenshotHeight / 2 + 5, 0x888888);
                }
                guiGraphics.m_280637_(x, y, screenshotWidth, screenshotHeight, -11184811);
                guiGraphics.m_280488_(this.f_96547_, this.getScreenshotCaption(page.screenshotPath), x, y += screenshotHeight + 10, 0xAAAAAA);
            }
        }
    }

    private String getScreenshotCaption(String screenshotPath) {
        if (screenshotPath == null) {
            return Component.m_237115_((String)"gui.strangematter.info_page.screenshot.default").getString();
        }
        String filename = screenshotPath.substring(screenshotPath.lastIndexOf(47) + 1);
        String filenameWithoutExt = filename.replace(".png", "");
        String translationKey = "gui.strangematter.info_page.screenshot." + filenameWithoutExt;
        MutableComponent caption = Component.m_237115_((String)translationKey);
        if (caption.getString().equals(translationKey)) {
            return Component.m_237110_((String)"gui.strangematter.info_page.screenshot.fallback", (Object[])new Object[]{filenameWithoutExt.replace("_", " ")}).getString();
        }
        return caption.getString();
    }

    private static class InfoPage {
        String title;
        String content;
        boolean hasRecipes;
        boolean hasScreenshots;
        String[] recipeItems;
        String recipeName;
        String screenshotPath;
        boolean isRealityForgeRecipe = false;
        List<Item> realityForgeShards = List.of();

        private InfoPage() {
        }
    }

    private static class TooltipSlot {
        final int x;
        final int y;
        final int size;
        final ItemStack stack;

        TooltipSlot(int x, int y, int size, ItemStack stack) {
            this.x = x;
            this.y = y;
            this.size = size;
            this.stack = stack;
        }
    }
}

