/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client.screen;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.block.ResearchMachineBlockEntity;
import com.hexvane.strangematter.client.screen.ResearchNodeInfoScreen;
import com.hexvane.strangematter.client.screen.components.InstabilityGauge;
import com.hexvane.strangematter.client.screen.minigames.CognitionMinigame;
import com.hexvane.strangematter.client.screen.minigames.EnergyMinigame;
import com.hexvane.strangematter.client.screen.minigames.GravityMinigame;
import com.hexvane.strangematter.client.screen.minigames.ResearchMinigame;
import com.hexvane.strangematter.client.screen.minigames.ShadowMinigame;
import com.hexvane.strangematter.client.screen.minigames.SpaceMinigame;
import com.hexvane.strangematter.client.screen.minigames.TimeMinigame;
import com.hexvane.strangematter.network.MinigameStatePacket;
import com.hexvane.strangematter.network.NetworkHandler;
import com.hexvane.strangematter.network.RequestResearchMachineStatePacket;
import com.hexvane.strangematter.network.ResearchCompletionPacket;
import com.hexvane.strangematter.research.ResearchNode;
import com.hexvane.strangematter.research.ResearchNodeRegistry;
import com.hexvane.strangematter.research.ResearchType;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ResearchMachineScreen
extends Screen {
    private static final int GUI_WIDTH = 320;
    private static final int GUI_HEIGHT = 240;
    private static final int BORDER_THICKNESS = 4;
    private static final ResourceLocation RUNIC_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/runic_background.png");
    private static final int BACKGROUND_TEXTURE_WIDTH = 191;
    private static final int BACKGROUND_TEXTURE_HEIGHT = 193;
    private static final int PURPLE_BORDER_COLOR = -11523215;
    private static final int BUTTON_HOVER_COLOR = -14250345;
    private static final int BUTTON_CLICK_COLOR = -15045773;
    private static final int BUTTON_TEXT_COLOR = -12728377;
    private static final ResourceLocation BUTTON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/button.png");
    private static final ResourceLocation MINIGAME_PANEL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/minigame_panel.png");
    private static final int MINIGAME_PANEL_WIDTH = 55;
    private static final int MINIGAME_PANEL_HEIGHT = 81;
    private final ResearchMachineBlockEntity blockEntity;
    private int guiX;
    private int guiY;
    private InstabilityGauge instabilityGauge;
    private Map<ResearchType, ResearchMinigame> minigames = new HashMap<ResearchType, ResearchMinigame>();
    private Map<ResearchType, Integer> panelPositions = new HashMap<ResearchType, Integer>();
    private int tickCounter = 0;
    private boolean completionPacketSent = false;
    private boolean idleSoundPlaying = false;
    private int helpButtonX;
    private int helpButtonY;
    private int exitButtonX;
    private int exitButtonY;
    private boolean helpButtonHovered = false;
    private boolean exitButtonHovered = false;
    private boolean helpButtonPressed = false;
    private boolean exitButtonPressed = false;

    public ResearchMachineScreen(BlockEntity blockEntity) {
        super((Component)Component.m_237115_((String)"gui.strangematter.research_machine.title"));
        this.blockEntity = (ResearchMachineBlockEntity)blockEntity;
        this.initializeMinigames();
    }

    public void handleStateSync(ResearchMachineBlockEntity.MachineState state, String researchId, Set<ResearchType> activeTypes, float instabilityLevel, int researchTicks) {
        if (this.instabilityGauge != null) {
            this.instabilityGauge.setFillLevel(instabilityLevel);
        }
        boolean isResearching = state == ResearchMachineBlockEntity.MachineState.RESEARCHING;
        for (Map.Entry<ResearchType, ResearchMinigame> entry : this.minigames.entrySet()) {
            ResearchType type = entry.getKey();
            ResearchMinigame minigame = entry.getValue();
            if (isResearching && activeTypes.contains((Object)type)) {
                if (minigame.isActive()) continue;
                minigame.activate();
                continue;
            }
            if (!minigame.isActive()) continue;
            minigame.deactivate();
        }
        this.tickCounter = researchTicks;
        if (this.f_96541_ != null) {
            this.f_96541_.execute(() -> this.refreshGuiState());
        }
    }

    private void refreshGuiState() {
        if (this.blockEntity == null) {
            return;
        }
        if (this.instabilityGauge != null) {
            this.instabilityGauge.setFillLevel(this.blockEntity.getInstabilityLevel());
        }
        boolean isResearching = this.blockEntity.getCurrentState() == ResearchMachineBlockEntity.MachineState.RESEARCHING;
        for (Map.Entry<ResearchType, ResearchMinigame> entry : this.minigames.entrySet()) {
            ResearchType type = entry.getKey();
            ResearchMinigame minigame = entry.getValue();
            if (isResearching && this.blockEntity.getActiveResearchTypes().contains((Object)type)) {
                if (minigame.isActive()) continue;
                minigame.activate();
                continue;
            }
            if (!minigame.isActive()) continue;
            minigame.deactivate();
        }
        this.tickCounter = this.blockEntity.getResearchTicks();
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.blockEntity != null) {
            RequestResearchMachineStatePacket packet = new RequestResearchMachineStatePacket(this.blockEntity.m_58899_());
            NetworkHandler.INSTANCE.sendToServer((Object)packet);
        }
        if (this.blockEntity != null && this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            UUID playerId = this.f_96541_.f_91074_.m_20148_();
            if (this.blockEntity.isPlayerLocked(playerId)) {
                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237115_((String)"gui.strangematter.research_machine.locked"), true);
                this.m_7379_();
                return;
            }
            this.blockEntity.lockToPlayer(playerId);
        }
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.RESEARCH_MACHINE_OPEN.get(), 0.8f, 1.0f);
        }
        this.guiX = (this.f_96543_ - 320) / 2;
        this.guiY = (this.f_96544_ - 240) / 2;
        int gaugeX = this.guiX + 320 - 55;
        int gaugeY = this.guiY + 50;
        this.instabilityGauge = new InstabilityGauge(gaugeX, gaugeY);
        this.helpButtonX = this.guiX + 320 - 100;
        this.helpButtonY = this.guiY + 240 - 20;
        this.exitButtonX = this.guiX + 320 - 50;
        this.exitButtonY = this.guiY + 240 - 20;
        this.initializePanelPositions();
        this.restoreMinigameState();
        if (this.blockEntity != null && this.blockEntity.getCurrentState() == ResearchMachineBlockEntity.MachineState.RESEARCHING) {
            for (ResearchType type : this.blockEntity.getActiveResearchTypes()) {
                ResearchMinigame minigame = this.minigames.get((Object)type);
                if (minigame == null || minigame.isActive()) continue;
                minigame.activate();
            }
        }
    }

    private void initializeMinigames() {
        for (ResearchType type : ResearchType.values()) {
            this.minigames.put(type, this.createPlaceholderMinigame(type));
        }
    }

    private void initializePanelPositions() {
        int startX = this.guiX + 20;
        int startY = this.guiY + 60;
        int spacing = 8;
        ResearchType[] types = ResearchType.values();
        for (int i = 0; i < types.length; ++i) {
            int col = i / 2;
            int row = i % 2;
            int panelX = startX + col * (55 + spacing);
            int panelY = startY + row * (81 + spacing) + (row == 0 ? -5 : 0);
            this.panelPositions.put(types[i], panelX << 16 | panelY);
        }
    }

    private ResearchMinigame createPlaceholderMinigame(ResearchType type) {
        if (type == ResearchType.ENERGY) {
            return new EnergyMinigame();
        }
        if (type == ResearchType.GRAVITY) {
            return new GravityMinigame();
        }
        if (type == ResearchType.TIME) {
            return new TimeMinigame();
        }
        if (type == ResearchType.SPACE) {
            return new SpaceMinigame();
        }
        if (type == ResearchType.SHADOW) {
            return new ShadowMinigame();
        }
        if (type == ResearchType.COGNITION) {
            return new CognitionMinigame();
        }
        return new ResearchMinigame(type){

            @Override
            protected void onActivate() {
            }

            @Override
            protected void onDeactivate() {
            }

            @Override
            protected void updateMinigame() {
            }

            @Override
            protected void renderActive(GuiGraphics guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY) {
                guiGraphics.m_280137_(((ResearchMachineScreen)ResearchMachineScreen.this).f_96541_.f_91062_, "ACTIVE", x + width / 2, y + height / 2, this.getState() == ResearchMinigame.MinigameState.STABLE ? 65280 : 0xFF0000);
            }

            @Override
            protected void renderInactive(GuiGraphics guiGraphics, int x, int y, int width, int height) {
            }

            @Override
            protected boolean handleClick(int mouseX, int mouseY, int button, int panelX, int panelY, int panelWidth, int panelHeight) {
                if (button == 0) {
                    this.setState(this.getState() == ResearchMinigame.MinigameState.STABLE ? ResearchMinigame.MinigameState.UNSTABLE : ResearchMinigame.MinigameState.STABLE);
                    return true;
                }
                return false;
            }
        };
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        this.renderGuiBackground(guiGraphics);
        this.renderBorder(guiGraphics);
        this.renderMinigamePanels(guiGraphics, mouseX, mouseY, partialTick);
        this.renderCenterContent(guiGraphics, mouseX, mouseY);
        if (this.instabilityGauge != null) {
            this.instabilityGauge.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        this.renderButtons(guiGraphics, mouseX, mouseY);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderGuiBackground(GuiGraphics guiGraphics) {
        int tilesX = 2;
        int tilesY = 2;
        for (int x = 0; x < tilesX; ++x) {
            for (int y = 0; y < tilesY; ++y) {
                int sourceWidth = Math.min(191, 320 - x * 191);
                int sourceHeight = Math.min(193, 240 - y * 193);
                guiGraphics.m_280163_(RUNIC_BACKGROUND, this.guiX + x * 191, this.guiY + y * 193, 0.0f, 0.0f, sourceWidth, sourceHeight, 191, 193);
            }
        }
    }

    private void renderMinigamePanels(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.instabilityGauge != null) {
            this.instabilityGauge.update();
        }
        for (Map.Entry<ResearchType, ResearchMinigame> entry : this.minigames.entrySet()) {
            ResearchType type = entry.getKey();
            ResearchMinigame minigame = entry.getValue();
            Integer packedPosition = this.panelPositions.get((Object)type);
            if (packedPosition == null) continue;
            int panelX = packedPosition >> 16 & 0xFFFF;
            int panelY = packedPosition & 0xFFFF;
            minigame.tick();
            if (minigame instanceof EnergyMinigame) {
                EnergyMinigame energyMinigame = (EnergyMinigame)minigame;
                energyMinigame.updateHoverStates(mouseX, mouseY, panelX, panelY, 55, 81);
            } else if (minigame instanceof ShadowMinigame) {
                ShadowMinigame shadowMinigame = (ShadowMinigame)minigame;
                shadowMinigame.updateHoverStates(mouseX, mouseY, panelX, panelY, 55, 81);
            } else if (minigame instanceof CognitionMinigame) {
                CognitionMinigame cognitionMinigame = (CognitionMinigame)minigame;
                cognitionMinigame.updateHoverStates(mouseX, mouseY, panelX, panelY, 55, 81);
            }
            guiGraphics.m_280163_(MINIGAME_PANEL_TEXTURE, panelX, panelY, 0.0f, 0.0f, 55, 81, 55, 81);
            minigame.render(guiGraphics, panelX, panelY, 55, 81, mouseX, mouseY);
        }
    }

    private void renderCenterContent(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ResearchMachineBlockEntity.MachineState state = this.blockEntity.getCurrentState();
        int centerX = this.guiX + 160;
        int topY = this.guiY + 15;
        switch (state) {
            case IDLE: {
                guiGraphics.m_280653_(this.f_96541_.f_91062_, (Component)Component.m_237115_((String)"gui.strangematter.research_machine.insert_notes"), centerX, topY, 0xFFFFFF);
                break;
            }
            case READY: {
                int buttonWidth = 100;
                int buttonHeight = 20;
                int buttonX = centerX - buttonWidth / 2;
                int buttonY = topY;
                boolean buttonHovered = mouseX >= buttonX && mouseX < buttonX + buttonWidth && mouseY >= buttonY && mouseY < buttonY + buttonHeight;
                int buttonColor = buttonHovered ? -14250345 : -1;
                guiGraphics.m_280509_(buttonX, buttonY, buttonX + buttonWidth, buttonY + buttonHeight, buttonColor);
                guiGraphics.m_280653_(this.f_96541_.f_91062_, (Component)Component.m_237115_((String)"gui.strangematter.research_machine.begin_research"), centerX, topY + 6, -12728377);
                break;
            }
            case RESEARCHING: {
                guiGraphics.m_280653_(this.f_96541_.f_91062_, (Component)Component.m_237115_((String)"gui.strangematter.research_machine.researching"), centerX, topY, 0xFFFFFF);
                break;
            }
            case COMPLETED: {
                guiGraphics.m_280653_(this.f_96541_.f_91062_, (Component)Component.m_237115_((String)"gui.strangematter.research_machine.completed"), centerX, topY, 65280);
                break;
            }
            case FAILED: {
                guiGraphics.m_280653_(this.f_96541_.f_91062_, (Component)Component.m_237115_((String)"gui.strangematter.research_machine.failed"), centerX, topY, 0xFF0000);
            }
        }
    }

    private void renderBorder(GuiGraphics guiGraphics) {
        guiGraphics.m_280509_(this.guiX - 4, this.guiY - 4, this.guiX + 320 + 4, this.guiY, -11523215);
        guiGraphics.m_280509_(this.guiX - 4, this.guiY + 240, this.guiX + 320 + 4, this.guiY + 240 + 4, -11523215);
        guiGraphics.m_280509_(this.guiX - 4, this.guiY - 4, this.guiX, this.guiY + 240 + 4, -11523215);
        guiGraphics.m_280509_(this.guiX + 320, this.guiY - 4, this.guiX + 320 + 4, this.guiY + 240 + 4, -11523215);
    }

    private void renderButtons(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.updateButtonHoverStates(mouseX, mouseY);
        this.renderButton(guiGraphics, this.helpButtonX, this.helpButtonY, "HELP", this.helpButtonHovered, this.helpButtonPressed);
        this.renderButton(guiGraphics, this.exitButtonX, this.exitButtonY, "EXIT", this.exitButtonHovered, this.exitButtonPressed);
    }

    private void updateButtonHoverStates(int mouseX, int mouseY) {
        this.helpButtonHovered = mouseX >= this.helpButtonX && mouseX < this.helpButtonX + 48 && mouseY >= this.helpButtonY && mouseY < this.helpButtonY + 16;
        boolean bl = this.exitButtonHovered = mouseX >= this.exitButtonX && mouseX < this.exitButtonX + 48 && mouseY >= this.exitButtonY && mouseY < this.exitButtonY + 16;
        if (this.helpButtonHovered) {
            System.out.println("Help button hovered! Mouse: " + mouseX + "," + mouseY + " Button: " + this.helpButtonX + "," + this.helpButtonY);
        }
    }

    private void renderButton(GuiGraphics guiGraphics, int x, int y, String text, boolean hovered, boolean pressed) {
        int buttonColor = -1;
        if (pressed) {
            buttonColor = -15045773;
        } else if (hovered) {
            buttonColor = -14250345;
        }
        guiGraphics.m_280246_((float)(buttonColor >> 16 & 0xFF) / 255.0f, (float)(buttonColor >> 8 & 0xFF) / 255.0f, (float)(buttonColor & 0xFF) / 255.0f, 1.0f);
        guiGraphics.m_280163_(BUTTON_TEXTURE, x, y, 0.0f, 0.0f, 48, 16, 48, 16);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        int textWidth = this.f_96541_.f_91062_.m_92895_(text);
        int textX = x + (48 - textWidth) / 2;
        int textY = y + 4;
        guiGraphics.m_280488_(this.f_96541_.f_91062_, text, textX, textY, -12728377);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            for (Map.Entry<ResearchType, ResearchMinigame> entry : this.minigames.entrySet()) {
                int panelY;
                int panelX;
                ResearchType type = entry.getKey();
                ResearchMinigame minigame = entry.getValue();
                Integer packedPosition = this.panelPositions.get((Object)type);
                if (packedPosition == null || !minigame.mouseClicked(mouseX, mouseY, button, panelX = packedPosition >> 16 & 0xFFFF, panelY = packedPosition & 0xFFFF, 55, 81)) continue;
                return true;
            }
            if (this.blockEntity.getCurrentState() == ResearchMachineBlockEntity.MachineState.READY) {
                int centerX = this.guiX + 160;
                int topY = this.guiY + 15;
                int buttonWidth = 100;
                int buttonHeight = 20;
                int buttonX = centerX - buttonWidth / 2;
                int buttonY = topY;
                if (mouseX >= (double)buttonX && mouseX < (double)(buttonX + buttonWidth) && mouseY >= (double)buttonY && mouseY < (double)(buttonY + buttonHeight)) {
                    this.blockEntity.beginResearch();
                    if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                        this.f_96541_.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.RESEARCH_MACHINE_BEGIN_RESEARCH.get(), 0.8f, 1.0f);
                    }
                    this.startIdleSound();
                    for (ResearchType type : this.blockEntity.getActiveResearchTypes()) {
                        ResearchMinigame minigame = this.minigames.get((Object)type);
                        if (minigame == null) continue;
                        minigame.activate();
                    }
                    this.completionPacketSent = false;
                    return true;
                }
            }
            if (this.helpButtonHovered) {
                this.helpButtonPressed = true;
                ResearchNodeRegistry.initializeDefaultNodes();
                ResearchNode researchNode = ResearchNodeRegistry.getNode("research");
                if (researchNode != null) {
                    this.f_96541_.m_91152_((Screen)new ResearchNodeInfoScreen(researchNode, this, 2));
                }
                return true;
            }
            if (this.exitButtonHovered) {
                this.exitButtonPressed = true;
                this.m_7379_();
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void startIdleSound() {
        if (!this.idleSoundPlaying && this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.idleSoundPlaying = true;
            this.f_96541_.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.RESEARCH_MACHINE_IDLE_LOOP.get(), 0.3f, 1.0f);
        }
    }

    private void stopIdleSound() {
        if (this.idleSoundPlaying && this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.idleSoundPlaying = false;
            this.f_96541_.f_91074_.m_5496_((SoundEvent)StrangeMatterSounds.RESEARCH_MACHINE_IDLE_LOOP.get(), 0.0f, 1.0f);
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0) {
            for (Map.Entry<ResearchType, ResearchMinigame> entry : this.minigames.entrySet()) {
                ResearchType type = entry.getKey();
                ResearchMinigame minigame = entry.getValue();
                Integer packedPosition = this.panelPositions.get((Object)type);
                if (packedPosition == null) continue;
                int panelX = packedPosition >> 16 & 0xFFFF;
                int panelY = packedPosition & 0xFFFF;
                if (!(minigame instanceof GravityMinigame)) continue;
                GravityMinigame gravityMinigame = (GravityMinigame)minigame;
                gravityMinigame.handleMouseDrag((int)mouseX, (int)mouseY, panelX, panelY, 55, 81);
            }
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.helpButtonPressed = false;
            this.exitButtonPressed = false;
            for (Map.Entry<ResearchType, ResearchMinigame> entry : this.minigames.entrySet()) {
                ResearchType type = entry.getKey();
                ResearchMinigame minigame = entry.getValue();
                Integer packedPosition = this.panelPositions.get((Object)type);
                if (packedPosition == null) continue;
                int panelX = packedPosition >> 16 & 0xFFFF;
                int panelY = packedPosition & 0xFFFF;
                if (!(minigame instanceof GravityMinigame)) continue;
                GravityMinigame gravityMinigame = (GravityMinigame)minigame;
                gravityMinigame.handleMouseRelease((int)mouseX, (int)mouseY, panelX, panelY, 55, 81, button);
            }
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        return false;
    }

    public void m_86600_() {
        super.m_86600_();
        ++this.tickCounter;
        for (ResearchMinigame minigame : this.minigames.values()) {
            minigame.tick();
        }
        if (this.blockEntity.getCurrentState() == ResearchMachineBlockEntity.MachineState.RESEARCHING) {
            HashMap<ResearchType, Boolean> minigameStates = new HashMap<ResearchType, Boolean>();
            for (Map.Entry<ResearchType, ResearchMinigame> entry : this.minigames.entrySet()) {
                ResearchMinigame minigame = entry.getValue();
                if (!minigame.isActive()) continue;
                minigameStates.put(entry.getKey(), minigame.isStable());
            }
            this.updateInstabilityLevel(minigameStates);
            if (this.instabilityGauge != null) {
                this.instabilityGauge.setFillLevel(this.blockEntity.getInstabilityLevel());
            }
        }
        if (this.tickCounter % 10 == 0) {
            // empty if block
        }
    }

    private void updateInstabilityLevel(Map<ResearchType, Boolean> minigameStates) {
        boolean allStable = true;
        boolean anyUnstable = false;
        for (ResearchType type : this.blockEntity.getActiveResearchTypes()) {
            Boolean isStable = minigameStates.get((Object)type);
            if (isStable != null) {
                if (isStable.booleanValue()) continue;
                anyUnstable = true;
                continue;
            }
            allStable = false;
        }
        float oldInstability = this.blockEntity.getInstabilityLevel();
        if (allStable && !anyUnstable) {
            float decreaseRate = (float)Config.instabilityDecreaseRate;
            this.blockEntity.setClientInstabilityLevel(Math.max(0.0f, oldInstability - decreaseRate));
        } else if (anyUnstable) {
            int activeMinigameCount = this.blockEntity.getActiveResearchTypes().size();
            float baseIncreaseRate = (float)Config.instabilityBaseIncreaseRate;
            float actualIncreaseRate = activeMinigameCount > 0 ? baseIncreaseRate / (float)activeMinigameCount : baseIncreaseRate;
            this.blockEntity.setClientInstabilityLevel(Math.min(1.0f, oldInstability + actualIncreaseRate));
        }
        float currentInstability = this.blockEntity.getInstabilityLevel();
        if (currentInstability <= 0.05f && !this.completionPacketSent) {
            this.stopIdleSound();
            this.sendResearchCompletionToServer(true);
            this.completionPacketSent = true;
            for (ResearchMinigame minigame : this.minigames.values()) {
                if (!minigame.isActive()) continue;
                minigame.deactivate();
            }
            this.forceClose();
        } else if (currentInstability >= 0.95f && !this.completionPacketSent) {
            this.stopIdleSound();
            this.sendResearchCompletionToServer(false);
            this.completionPacketSent = true;
            for (ResearchMinigame minigame : this.minigames.values()) {
                if (!minigame.isActive()) continue;
                minigame.deactivate();
            }
            this.forceClose();
        }
    }

    private void sendResearchCompletionToServer(boolean success) {
        ResearchCompletionPacket packet = new ResearchCompletionPacket(this.blockEntity.m_58899_(), success);
        NetworkHandler.INSTANCE.sendToServer((Object)packet);
    }

    public void m_7379_() {
        if (this.blockEntity != null) {
            this.saveMinigameState();
            this.blockEntity.unlockPlayer();
        }
        this.stopIdleSound();
        super.m_7379_();
    }

    private void forceClose() {
        this.stopIdleSound();
        super.m_7379_();
    }

    private void saveMinigameState() {
        if (this.blockEntity == null) {
            return;
        }
        HashMap<ResearchType, Map<String, Object>> minigameStates = new HashMap<ResearchType, Map<String, Object>>();
        for (Map.Entry<ResearchType, ResearchMinigame> entry : this.minigames.entrySet()) {
            ResearchType type = entry.getKey();
            ResearchMinigame minigame = entry.getValue();
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("isActive", minigame.isActive());
            state.put("state", minigame.getState().toString());
            if (minigame instanceof EnergyMinigame) {
                EnergyMinigame energyMinigame = (EnergyMinigame)minigame;
                state.put("amplitudeDialActive", energyMinigame.isAmplitudeDialActive());
                state.put("periodDialActive", energyMinigame.isPeriodDialActive());
                state.put("currentAmplitude", energyMinigame.getCurrentAmplitude());
                state.put("currentPeriod", energyMinigame.getCurrentPeriod());
                state.put("targetAmplitude", energyMinigame.getTargetAmplitude());
                state.put("targetPeriod", energyMinigame.getTargetPeriod());
            } else if (minigame instanceof GravityMinigame) {
                GravityMinigame gravityMinigame = (GravityMinigame)minigame;
                state.put("sliderActive", gravityMinigame.isSliderActive());
                state.put("sliderValue", gravityMinigame.getSliderValue());
                state.put("targetGravity", gravityMinigame.getTargetGravity());
                state.put("cubePosition", gravityMinigame.getCubePosition());
                state.put("cubeVelocity", gravityMinigame.getCubeVelocity());
                state.put("isInEquilibrium", gravityMinigame.isInEquilibrium());
                state.put("equilibriumTicks", gravityMinigame.getEquilibriumTicks());
                state.put("driftTicks", gravityMinigame.getDriftTicks());
                state.put("isDrifting", gravityMinigame.isDrifting());
                state.put("needsNewTarget", gravityMinigame.getNeedsNewTarget());
            }
            minigameStates.put(type, state);
        }
        MinigameStatePacket packet = new MinigameStatePacket(this.blockEntity.m_58899_(), minigameStates);
        NetworkHandler.INSTANCE.sendToServer((Object)packet);
    }

    private void restoreMinigameState() {
        if (this.blockEntity == null) {
            return;
        }
        Map<ResearchType, Map<String, Object>> savedStates = this.blockEntity.getMinigameStates();
        if (savedStates == null || savedStates.isEmpty()) {
            return;
        }
        for (Map.Entry<ResearchType, Map<String, Object>> entry : savedStates.entrySet()) {
            ResearchType type = entry.getKey();
            Map<String, Object> state = entry.getValue();
            ResearchMinigame minigame = this.minigames.get((Object)type);
            if (minigame == null || state == null) continue;
            boolean wasActive = (Boolean)state.getOrDefault("isActive", false);
            if (wasActive) {
                minigame.activate();
            }
            if (minigame instanceof EnergyMinigame) {
                EnergyMinigame energyMinigame = (EnergyMinigame)minigame;
                energyMinigame.setAmplitudeDialActive((Boolean)state.getOrDefault("amplitudeDialActive", false));
                energyMinigame.setPeriodDialActive((Boolean)state.getOrDefault("periodDialActive", false));
                energyMinigame.setCurrentAmplitude((Double)state.getOrDefault("currentAmplitude", 1.0));
                energyMinigame.setCurrentPeriod((Double)state.getOrDefault("currentPeriod", 1.0));
                energyMinigame.setTargetAmplitude((Double)state.getOrDefault("targetAmplitude", 1.0));
                energyMinigame.setTargetPeriod((Double)state.getOrDefault("targetPeriod", 1.0));
                continue;
            }
            if (!(minigame instanceof GravityMinigame)) continue;
            GravityMinigame gravityMinigame = (GravityMinigame)minigame;
            gravityMinigame.setSliderActive((Boolean)state.getOrDefault("sliderActive", false));
            gravityMinigame.setSliderValue((Integer)state.getOrDefault("sliderValue", 0));
            gravityMinigame.setTargetGravity((Integer)state.getOrDefault("targetGravity", 0));
            gravityMinigame.setCubePosition((Double)state.getOrDefault("cubePosition", 0.5));
            gravityMinigame.setCubeVelocity((Double)state.getOrDefault("cubeVelocity", 0.0));
            gravityMinigame.setInEquilibrium((Boolean)state.getOrDefault("isInEquilibrium", false));
            gravityMinigame.setEquilibriumTicks((Integer)state.getOrDefault("equilibriumTicks", 0));
            gravityMinigame.setDriftTicks((Integer)state.getOrDefault("driftTicks", 0));
            gravityMinigame.setDrifting((Boolean)state.getOrDefault("isDrifting", false));
            gravityMinigame.setNeedsNewTarget((Boolean)state.getOrDefault("needsNewTarget", false));
        }
    }
}

