/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client.screen;

import com.hexvane.strangematter.client.screen.BaseMachineScreen;
import com.hexvane.strangematter.menu.RealityForgeMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class RealityForgeScreen
extends BaseMachineScreen<RealityForgeMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/gui/reality_forge.png");
    private static final ResourceLocation EJECT_BUTTON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/eject_button.png");
    private static final int SHADOW_COLOR = -7908656;
    private static final int GRAVITY_COLOR = -2665675;
    private static final int ENERGY_COLOR = -12927512;
    private static final int COGNITION_COLOR = -11221669;
    private static final int TIME_COLOR = -1657544;
    private static final int SPACE_COLOR = -12744483;
    private int animationTick = 0;
    private boolean ejectButtonHovered = false;
    private boolean ejectButtonPressed = false;

    public RealityForgeScreen(RealityForgeMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title, GUI_TEXTURE);
        this.f_97726_ = 176;
        this.f_97727_ = 148;
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTick, mouseX, mouseY);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.renderSpinningShards(guiGraphics, x + 130, y + 37, partialTick);
        this.renderEjectButton(guiGraphics, x + 41, y + 44, mouseX, mouseY);
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        this.renderMachineLabels(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void renderMachineLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    private void renderSpinningShards(GuiGraphics guiGraphics, int centerX, int centerY, float partialTick) {
        Map<String, Integer> storedShards = ((RealityForgeMenu)this.menu).getStoredShards();
        List<String> shardOrder = ((RealityForgeMenu)this.menu).getShardOrder();
        int synchronizedShardCount = 0;
        if (((RealityForgeMenu)this.menu).getDataAccess() != null) {
            synchronizedShardCount = ((RealityForgeMenu)this.menu).getDataAccess().m_6413_(8);
        }
        if (synchronizedShardCount == 0) {
            return;
        }
        float time = ((float)this.animationTick + partialTick) * 0.1f;
        int radius = 25;
        int craftTicks = 0;
        boolean isCrafting = false;
        if (((RealityForgeMenu)this.menu).getDataAccess() != null) {
            isCrafting = ((RealityForgeMenu)this.menu).getDataAccess().m_6413_(9) == 1;
            craftTicks = ((RealityForgeMenu)this.menu).getDataAccess().m_6413_(10);
        }
        if (isCrafting && craftTicks >= 100) {
            return;
        }
        int coalesceProgress = isCrafting ? craftTicks * 100 / 100 : 0;
        boolean isCoalescing = isCrafting && craftTicks > 0;
        ArrayList<String> allShards = new ArrayList<String>();
        for (String shardType : shardOrder) {
            int count = storedShards.getOrDefault(shardType, 0);
            for (int i = 0; i < count; ++i) {
                allShards.add(shardType);
            }
        }
        for (int i = 0; i < allShards.size(); ++i) {
            int shardY;
            int shardX;
            String shardType;
            shardType = (String)allShards.get(i);
            float angle = time + (float)i * 2.0f * (float)Math.PI / (float)Math.max(allShards.size(), 1);
            if (isCoalescing) {
                float coalesceFactor = (float)coalesceProgress / 100.0f;
                float currentRadius = (float)radius * (1.0f - coalesceFactor);
                shardX = centerX + (int)(Math.cos(angle) * (double)currentRadius);
                shardY = centerY + (int)(Math.sin(angle) * (double)currentRadius);
            } else {
                shardX = centerX + (int)(Math.cos(angle) * (double)radius);
                shardY = centerY + (int)(Math.sin(angle) * (double)radius);
            }
            this.renderShard(guiGraphics, shardX, shardY, shardType);
            this.renderParticleTrail(guiGraphics, shardX, shardY, shardType, angle, time);
        }
    }

    private void renderShard(GuiGraphics guiGraphics, int x, int y, String shardType) {
        ResourceLocation shardTexture = this.getShardTexture(shardType);
        guiGraphics.m_280163_(shardTexture, x - 8, y - 8, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    private void renderParticleTrail(GuiGraphics guiGraphics, int x, int y, String shardType, float angle, float time) {
        int color = this.getShardColor(shardType);
        for (int i = 1; i <= 5; ++i) {
            float trailAngle = angle - (float)i * 0.2f;
            float trailRadius = 25 - i * 3;
            int trailX = x + (int)(Math.cos(trailAngle) * (double)trailRadius) - (int)(Math.cos(angle) * 25.0);
            int trailY = y + (int)(Math.sin(trailAngle) * (double)trailRadius) - (int)(Math.sin(angle) * 25.0);
            int alpha = 255 - i * 40;
            guiGraphics.m_280509_(trailX - 2, trailY - 2, trailX + 2, trailY + 2, alpha << 24 | color & 0xFFFFFF);
        }
    }

    private ResourceLocation getShardTexture(String shardType) {
        return switch (shardType) {
            case "energetic" -> ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/item/energetic_shard.png");
            case "gravitic" -> ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/item/gravitic_shard.png");
            case "chrono" -> ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/item/chrono_shard.png");
            case "spatial" -> ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/item/spatial_shard.png");
            case "shade" -> ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/item/shade_shard.png");
            case "insight" -> ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/item/insight_shard.png");
            default -> ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/item/energetic_shard.png");
        };
    }

    private int getShardColor(String shardType) {
        return switch (shardType) {
            case "energetic" -> -12927512;
            case "gravitic" -> -2665675;
            case "chrono" -> -1657544;
            case "spatial" -> -12744483;
            case "shade" -> -7908656;
            case "insight" -> -11221669;
            default -> -12927512;
        };
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    private void renderEjectButton(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        boolean hovered;
        this.ejectButtonHovered = hovered = mouseX >= x && mouseX < x + 8 && mouseY >= y && mouseY < y + 8;
        boolean isCrafting = ((RealityForgeMenu)this.menu).isCrafting();
        guiGraphics.m_280163_(EJECT_BUTTON_TEXTURE, x, y, 0.0f, 0.0f, 8, 8, 8, 8);
        if (isCrafting) {
            guiGraphics.m_280509_(x, y, x + 8, y + 8, Integer.MIN_VALUE);
        } else if (hovered) {
            guiGraphics.m_280509_(x, y, x + 8, y + 8, -2130706433);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int guiX = (this.f_96543_ - this.f_97726_) / 2;
            int guiY = (this.f_96544_ - this.f_97727_) / 2;
            int buttonX = guiX + 41;
            int buttonY = guiY + 44;
            if (mouseX >= (double)buttonX && mouseX < (double)(buttonX + 8) && mouseY >= (double)buttonY && mouseY < (double)(buttonY + 8)) {
                if (((RealityForgeMenu)this.menu).isCrafting()) {
                    return true;
                }
                ((RealityForgeMenu)this.menu).ejectShards();
                this.ejectButtonPressed = true;
                if (((RealityForgeMenu)this.menu).getBlockEntity() != null) {
                    ((RealityForgeMenu)this.menu).getBlockEntity().clearShardsForEject();
                }
                return true;
            }
        }
        boolean result = super.m_6375_(mouseX, mouseY, button);
        return result;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.ejectButtonPressed = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void m_181908_() {
        super.m_181908_();
        ++this.animationTick;
    }
}

