/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client.screen;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ProgressBarRenderer {
    private static final int PROGRESS_BAR_WIDTH = 32;
    private static final int PROGRESS_BAR_HEIGHT = 16;

    public static void renderProgressBar(GuiGraphics guiGraphics, int x, int y, int progressLevel, int maxProgressLevel, ResourceLocation texture) {
        if (maxProgressLevel > 0) {
            int fillHeight;
            float progressPercentage = (float)progressLevel / (float)maxProgressLevel;
            guiGraphics.m_280588_(x, y, x + 16, y + 16);
            guiGraphics.m_280163_(texture, x, y, 0.0f, 0.0f, 32, 16, 32, 16);
            guiGraphics.m_280618_();
            if (progressPercentage > 0.0f && (fillHeight = (int)(16.0f * progressPercentage)) > 0) {
                guiGraphics.m_280588_(x, y + (16 - fillHeight), x + 16, y + 16);
                guiGraphics.m_280163_(texture, x, y, 16.0f, 0.0f, 32, 16, 32, 16);
                guiGraphics.m_280618_();
            }
        }
    }

    public static boolean isMouseOverProgressBar(int mouseX, int mouseY, int x, int y) {
        return mouseX >= x && mouseX < x + 32 && mouseY >= y && mouseY < y + 16;
    }

    public static Component getProgressBarTooltip(int progressLevel, int maxProgressLevel) {
        return Component.m_237110_((String)"gui.strangematter.progress", (Object[])new Object[]{progressLevel, maxProgressLevel});
    }
}

