/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client.screen;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class EnergyBarRenderer {
    private static final ResourceLocation ENERGY_BAR_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/energy_bar_background.png");
    private static final ResourceLocation ENERGY_BAR_FILL = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/ui/energy_bar_fill.png");
    private static final int ENERGY_BAR_WIDTH = 160;
    private static final int ENERGY_BAR_HEIGHT = 16;
    private static final int ENERGY_FILL_PADDING_LEFT = 21;
    private static final int ENERGY_FILL_PADDING_RIGHT = 2;
    private static final int ENERGY_FILL_PADDING_TOP = 4;
    private static final int ENERGY_FILL_PADDING_BOTTOM = 5;

    public static void renderEnergyBar(GuiGraphics guiGraphics, int x, int y, int energyStored, int maxEnergyStored) {
        float energyPercentage;
        int availableWidth;
        int fillWidth;
        guiGraphics.m_280163_(ENERGY_BAR_BACKGROUND, x, y, 0.0f, 0.0f, 160, 16, 160, 16);
        if (maxEnergyStored > 0 && (fillWidth = (int)((float)(availableWidth = 135) * (energyPercentage = (float)energyStored / (float)maxEnergyStored))) > 0) {
            int fillX = x + 21;
            int fillY = y + 4;
            int fillHeight = 7;
            guiGraphics.m_280588_(fillX, fillY, fillX + fillWidth, fillY + fillHeight);
            guiGraphics.m_280163_(ENERGY_BAR_FILL, fillX, fillY, 0.0f, 0.0f, 151, 16, 151, 16);
            guiGraphics.m_280618_();
        }
    }

    public static boolean isMouseOverEnergyBar(int mouseX, int mouseY, int x, int y) {
        return mouseX >= x && mouseX < x + 160 && mouseY >= y && mouseY < y + 16;
    }

    public static Component getEnergyBarTooltip(int energyStored, int maxEnergyStored) {
        return Component.m_237110_((String)"gui.strangematter.resonance_energy", (Object[])new Object[]{energyStored, maxEnergyStored});
    }

    public static int getEnergyBarWidth() {
        return 160;
    }

    public static int getEnergyBarHeight() {
        return 16;
    }
}

