/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client.screen;

import com.hexvane.strangematter.client.screen.EnergyBarRenderer;
import com.hexvane.strangematter.client.screen.ProgressBarRenderer;
import com.hexvane.strangematter.menu.BaseMachineMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;

public abstract class BaseMachineScreen<T extends BaseMachineMenu>
extends AbstractContainerScreen<T> {
    protected final T menu;
    protected final ResourceLocation texture;

    public BaseMachineScreen(T menu, Inventory playerInventory, Component title, ResourceLocation texture) {
        super(menu, playerInventory, title);
        this.menu = menu;
        this.texture = texture;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
        this.f_97730_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_169604_)) / 2;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280163_(this.texture, x, y, 0.0f, 0.0f, this.f_97726_, this.f_97727_, this.f_97726_, this.f_97727_);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 2538938, false);
        this.renderMachineLabels(guiGraphics, mouseX, mouseY);
    }

    protected abstract void renderMachineLabels(GuiGraphics var1, int var2, int var3);

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected Container getMachineInventory() {
        return ((BaseMachineMenu)((Object)this.menu)).getMachineInventory();
    }

    protected void renderEnergyBar(GuiGraphics guiGraphics, int x, int y, int energyStored, int maxEnergyStored) {
        EnergyBarRenderer.renderEnergyBar(guiGraphics, x, y, energyStored, maxEnergyStored);
    }

    protected boolean renderEnergyBarTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y, int energyStored, int maxEnergyStored) {
        if (EnergyBarRenderer.isMouseOverEnergyBar(mouseX, mouseY, x, y)) {
            Component tooltip = EnergyBarRenderer.getEnergyBarTooltip(energyStored, maxEnergyStored);
            guiGraphics.m_280557_(this.f_96547_, tooltip, mouseX, mouseY);
            return true;
        }
        return false;
    }

    protected void renderProgressBar(GuiGraphics guiGraphics, int x, int y, int progressLevel, int maxProgressLevel, ResourceLocation texture) {
        ProgressBarRenderer.renderProgressBar(guiGraphics, x, y, progressLevel, maxProgressLevel, texture);
    }

    protected boolean renderProgressBarTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y, int progressLevel, int maxProgressLevel, Component tooltipOverride) {
        if (ProgressBarRenderer.isMouseOverProgressBar(mouseX, mouseY, x, y)) {
            Component tooltip = tooltipOverride != null ? tooltipOverride : ProgressBarRenderer.getProgressBarTooltip(progressLevel, maxProgressLevel);
            guiGraphics.m_280557_(this.f_96547_, tooltip, mouseX, mouseY);
            return true;
        }
        return false;
    }
}

